/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.recorder.mp3;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.zlw.main.recorderlib.recorder.RecordConfig;
import com.zlw.main.recorderlib.utils.FileUtils;
import com.zlw.main.recorderlib.utils.Logger;
import java.io.IOException;

public class Mp3Utils {
    private static final String TAG = Mp3Utils.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDuration(String mp3FilePath) {
        if (!FileUtils.isFileExists(mp3FilePath)) {
            return 0L;
        }
        if (!mp3FilePath.endsWith(RecordConfig.RecordFormat.MP3.getExtension())) {
            return 0L;
        }
        MediaExtractor mex = null;
        try {
            long duration;
            mex = new MediaExtractor();
            mex.setDataSource(mp3FilePath);
            MediaFormat mf = mex.getTrackFormat(0);
            long l = duration = mf.getLong("durationUs") / 1000L;
            return l;
        }
        catch (IOException e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
        }
        finally {
            if (mex != null) {
                mex.release();
            }
        }
        return 0L;
    }
}

