/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.recorder.mp3;

import com.zlw.main.recorderlib.recorder.RecordConfig;
import com.zlw.main.recorderlib.recorder.RecordService;
import com.zlw.main.recorderlib.recorder.mp3.Mp3Encoder;
import com.zlw.main.recorderlib.utils.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Mp3EncodeThread
extends Thread {
    private static final String TAG = Mp3EncodeThread.class.getSimpleName();
    private List<ChangeBuffer> cacheBufferList = Collections.synchronizedList(new LinkedList());
    private File file;
    private FileOutputStream os;
    private byte[] mp3Buffer;
    private EncordFinishListener encordFinishListener;
    private volatile boolean isOver = false;
    private volatile boolean start = true;

    public Mp3EncodeThread(File file, int bufferSize) {
        this.file = file;
        this.mp3Buffer = new byte[(int)(7200.0 + (double)(bufferSize * 2) * 1.25)];
        RecordConfig currentConfig = RecordService.getCurrentConfig();
        int sampleRate = currentConfig.getSampleRate();
        Logger.w(TAG, "in_sampleRate:%s\uff0cgetChannelCount:%s \uff0cout_sampleRate\uff1a%s \u4f4d\u5bbd\uff1a %s,", sampleRate, currentConfig.getChannelCount(), sampleRate, currentConfig.getRealEncoding());
        Mp3Encoder.init(sampleRate, currentConfig.getChannelCount(), sampleRate, currentConfig.getRealEncoding());
    }

    @Override
    public void run() {
        try {
            this.os = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
            return;
        }
        while (this.start) {
            ChangeBuffer next = this.next();
            Logger.v(TAG, "\u5904\u7406\u6570\u636e\uff1a%s", next == null ? "null" : Integer.valueOf(next.getReadSize()));
            this.lameData(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeBuffer(ChangeBuffer changeBuffer) {
        if (changeBuffer != null) {
            this.cacheBufferList.add(changeBuffer);
            Mp3EncodeThread mp3EncodeThread = this;
            synchronized (mp3EncodeThread) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSafe(EncordFinishListener encordFinishListener) {
        this.encordFinishListener = encordFinishListener;
        this.isOver = true;
        Mp3EncodeThread mp3EncodeThread = this;
        synchronized (mp3EncodeThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeBuffer next() {
        while (this.cacheBufferList == null || this.cacheBufferList.size() == 0) {
            try {
                if (this.isOver) {
                    this.finish();
                }
                Mp3EncodeThread mp3EncodeThread = this;
                synchronized (mp3EncodeThread) {
                    this.wait();
                }
            }
            catch (Exception e) {
                Logger.e(e, TAG, e.getMessage(), new Object[0]);
            }
        }
        return this.cacheBufferList.remove(0);
    }

    private void lameData(ChangeBuffer changeBuffer) {
        if (changeBuffer == null) {
            return;
        }
        short[] buffer = changeBuffer.getData();
        int readSize = changeBuffer.getReadSize();
        if (readSize > 0) {
            int encodedSize = Mp3Encoder.encode(buffer, buffer, readSize, this.mp3Buffer);
            if (encodedSize < 0) {
                Logger.e(TAG, "Lame encoded size: " + encodedSize, new Object[0]);
            }
            try {
                this.os.write(this.mp3Buffer, 0, encodedSize);
            }
            catch (IOException e) {
                Logger.e(e, TAG, "Unable to write to file", new Object[0]);
            }
        }
    }

    private void finish() {
        this.start = false;
        int flushResult = Mp3Encoder.flush(this.mp3Buffer);
        if (flushResult > 0) {
            try {
                this.os.write(this.mp3Buffer, 0, flushResult);
                this.os.close();
            }
            catch (IOException e) {
                Logger.e(TAG, e.getMessage(), new Object[0]);
            }
        }
        Logger.d(TAG, "\u8f6c\u6362\u7ed3\u675f :%s", this.file.length());
        if (this.encordFinishListener != null) {
            this.encordFinishListener.onFinish();
        }
    }

    public static interface EncordFinishListener {
        public void onFinish();
    }

    public static class ChangeBuffer {
        private short[] rawData;
        private int readSize;

        public ChangeBuffer(short[] rawData, int readSize) {
            this.rawData = (short[])rawData.clone();
            this.readSize = readSize;
        }

        short[] getData() {
            return this.rawData;
        }

        int getReadSize() {
            return this.readSize;
        }
    }
}

