/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.recorder;

import android.media.AudioRecord;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import com.zlw.main.recorderlib.recorder.RecordConfig;
import com.zlw.main.recorderlib.recorder.listener.RecordDataListener;
import com.zlw.main.recorderlib.recorder.listener.RecordFftDataListener;
import com.zlw.main.recorderlib.recorder.listener.RecordResultListener;
import com.zlw.main.recorderlib.recorder.listener.RecordSoundSizeListener;
import com.zlw.main.recorderlib.recorder.listener.RecordStateListener;
import com.zlw.main.recorderlib.recorder.mp3.Mp3EncodeThread;
import com.zlw.main.recorderlib.recorder.wav.WavUtils;
import com.zlw.main.recorderlib.utils.ByteUtils;
import com.zlw.main.recorderlib.utils.FileUtils;
import com.zlw.main.recorderlib.utils.Logger;
import fftlib.FftFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RecordHelper {
    private static final String TAG = RecordHelper.class.getSimpleName();
    private static volatile RecordHelper instance;
    private volatile RecordState state = RecordState.IDLE;
    private static final int RECORD_AUDIO_BUFFER_TIMES = 1;
    private RecordStateListener recordStateListener;
    private RecordDataListener recordDataListener;
    private RecordSoundSizeListener recordSoundSizeListener;
    private RecordResultListener recordResultListener;
    private RecordFftDataListener recordFftDataListener;
    private RecordConfig currentConfig;
    private AudioRecordThread audioRecordThread;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private File resultFile = null;
    private File tmpFile = null;
    private List<File> files = new ArrayList<File>();
    private Mp3EncodeThread mp3EncodeThread;
    private FftFactory fftFactory = new FftFactory(FftFactory.Level.Original);

    private RecordHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RecordHelper getInstance() {
        if (instance != null) return instance;
        Class<RecordHelper> clazz = RecordHelper.class;
        synchronized (RecordHelper.class) {
            if (instance != null) return instance;
            instance = new RecordHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    RecordState getState() {
        return this.state;
    }

    void setRecordStateListener(RecordStateListener recordStateListener) {
        this.recordStateListener = recordStateListener;
    }

    void setRecordDataListener(RecordDataListener recordDataListener) {
        this.recordDataListener = recordDataListener;
    }

    void setRecordSoundSizeListener(RecordSoundSizeListener recordSoundSizeListener) {
        this.recordSoundSizeListener = recordSoundSizeListener;
    }

    void setRecordResultListener(RecordResultListener recordResultListener) {
        this.recordResultListener = recordResultListener;
    }

    public void setRecordFftDataListener(RecordFftDataListener recordFftDataListener) {
        this.recordFftDataListener = recordFftDataListener;
    }

    public void start(String filePath, RecordConfig config) {
        this.currentConfig = config;
        if (this.state != RecordState.IDLE && this.state != RecordState.STOP) {
            Logger.e(TAG, "\u72b6\u6001\u5f02\u5e38\u5f53\u524d\u72b6\u6001\uff1a %s", this.state.name());
            return;
        }
        this.resultFile = new File(filePath);
        String tempFilePath = this.getTempFilePath();
        Logger.d(TAG, "----------------\u5f00\u59cb\u5f55\u5236 %s------------------------", this.currentConfig.getFormat().name());
        Logger.d(TAG, "\u53c2\u6570\uff1a %s", this.currentConfig.toString());
        Logger.i(TAG, "pcm\u7f13\u5b58 tmpFile: %s", tempFilePath);
        Logger.i(TAG, "\u5f55\u97f3\u6587\u4ef6 resultFile: %s", filePath);
        this.tmpFile = new File(tempFilePath);
        this.audioRecordThread = new AudioRecordThread();
        this.audioRecordThread.start();
    }

    public void stop() {
        if (this.state == RecordState.IDLE) {
            Logger.e(TAG, "\u72b6\u6001\u5f02\u5e38\u5f53\u524d\u72b6\u6001\uff1a %s", this.state.name());
            return;
        }
        if (this.state == RecordState.PAUSE) {
            this.makeFile();
            this.state = RecordState.IDLE;
            this.notifyState();
            this.stopMp3Encoded();
        } else {
            this.state = RecordState.STOP;
            this.notifyState();
        }
    }

    void pause() {
        if (this.state != RecordState.RECORDING) {
            Logger.e(TAG, "\u72b6\u6001\u5f02\u5e38\u5f53\u524d\u72b6\u6001\uff1a %s", this.state.name());
            return;
        }
        this.state = RecordState.PAUSE;
        this.notifyState();
    }

    void resume() {
        if (this.state != RecordState.PAUSE) {
            Logger.e(TAG, "\u72b6\u6001\u5f02\u5e38\u5f53\u524d\u72b6\u6001\uff1a %s", this.state.name());
            return;
        }
        String tempFilePath = this.getTempFilePath();
        Logger.i(TAG, "tmpPCM File: %s", tempFilePath);
        this.tmpFile = new File(tempFilePath);
        this.audioRecordThread = new AudioRecordThread();
        this.audioRecordThread.start();
    }

    private void notifyState() {
        if (this.recordStateListener == null) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                RecordHelper.this.recordStateListener.onStateChange(RecordHelper.this.state);
            }
        });
        if ((this.state == RecordState.STOP || this.state == RecordState.PAUSE) && this.recordSoundSizeListener != null) {
            this.recordSoundSizeListener.onSoundSize(0);
        }
    }

    private void notifyFinish() {
        Logger.d(TAG, "\u5f55\u97f3\u7ed3\u675f file: %s", this.resultFile.getAbsolutePath());
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RecordHelper.this.recordStateListener != null) {
                    RecordHelper.this.recordStateListener.onStateChange(RecordState.FINISH);
                }
                if (RecordHelper.this.recordResultListener != null) {
                    RecordHelper.this.recordResultListener.onResult(RecordHelper.this.resultFile);
                }
            }
        });
    }

    private void notifyError(final String error) {
        if (this.recordStateListener == null) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                RecordHelper.this.recordStateListener.onError(error);
            }
        });
    }

    private void notifyData(final byte[] data) {
        if (this.recordDataListener == null && this.recordSoundSizeListener == null && this.recordFftDataListener == null) {
            return;
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                byte[] fftData;
                if (RecordHelper.this.recordDataListener != null) {
                    RecordHelper.this.recordDataListener.onData(data);
                }
                if ((RecordHelper.this.recordFftDataListener != null || RecordHelper.this.recordSoundSizeListener != null) && (fftData = RecordHelper.this.fftFactory.makeFftData(data)) != null) {
                    if (RecordHelper.this.recordSoundSizeListener != null) {
                        RecordHelper.this.recordSoundSizeListener.onSoundSize(RecordHelper.this.getDb(fftData));
                    }
                    if (RecordHelper.this.recordFftDataListener != null) {
                        RecordHelper.this.recordFftDataListener.onFftData(fftData);
                    }
                }
            }
        });
    }

    private int getDb(byte[] data) {
        int offsetStart;
        double sum = 0.0;
        int length = Math.min(data.length, 128);
        for (int i = offsetStart = 0; i < length; ++i) {
            sum += (double)(data[i] * data[i]);
        }
        double ave = sum / (double)(length - offsetStart);
        return (int)(Math.log10(ave) * 20.0);
    }

    private void initMp3EncoderThread(int bufferSize) {
        try {
            this.mp3EncodeThread = new Mp3EncodeThread(this.resultFile, bufferSize);
            this.mp3EncodeThread.start();
        }
        catch (Exception e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
        }
    }

    private void stopMp3Encoded() {
        if (this.mp3EncodeThread != null) {
            this.mp3EncodeThread.stopSafe(new Mp3EncodeThread.EncordFinishListener(){

                @Override
                public void onFinish() {
                    RecordHelper.this.notifyFinish();
                    RecordHelper.this.mp3EncodeThread = null;
                }
            });
        } else {
            Logger.e(TAG, "mp3EncodeThread is null, \u4ee3\u7801\u4e1a\u52a1\u6d41\u7a0b\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01\uff01 ", new Object[0]);
        }
    }

    private void makeFile() {
        switch (this.currentConfig.getFormat()) {
            case MP3: {
                return;
            }
            case WAV: {
                this.mergePcmFile();
                this.makeWav();
                break;
            }
            case PCM: {
                this.mergePcmFile();
                break;
            }
        }
        this.notifyFinish();
        Logger.i(TAG, "\u5f55\u97f3\u5b8c\u6210\uff01 path: %s \uff1b \u5927\u5c0f\uff1a%s", this.resultFile.getAbsoluteFile(), this.resultFile.length());
    }

    private void makeWav() {
        if (!FileUtils.isFile(this.resultFile) || this.resultFile.length() == 0L) {
            return;
        }
        byte[] header = WavUtils.generateWavFileHeader((int)this.resultFile.length(), this.currentConfig.getSampleRate(), this.currentConfig.getChannelCount(), this.currentConfig.getEncoding());
        WavUtils.writeHeader(this.resultFile, header);
    }

    private void mergePcmFile() {
        boolean mergeSuccess = this.mergePcmFiles(this.resultFile, this.files);
        if (!mergeSuccess) {
            this.notifyError("\u5408\u5e76\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergePcmFiles(File recordFile, List<File> files) {
        if (recordFile == null || files == null || files.size() <= 0) {
            return false;
        }
        FileOutputStream fos = null;
        FilterOutputStream outputStream = null;
        byte[] buffer = new byte[1024];
        try {
            fos = new FileOutputStream(recordFile);
            outputStream = new BufferedOutputStream(fos);
            for (int i = 0; i < files.size(); ++i) {
                int readCount;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(files.get(i)));
                while ((readCount = inputStream.read(buffer)) > 0) {
                    ((BufferedOutputStream)outputStream).write(buffer, 0, readCount);
                }
                inputStream.close();
            }
        }
        catch (Exception e) {
            Logger.e(e, TAG, e.getMessage(), new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < files.size(); ++i) {
            files.get(i).delete();
        }
        files.clear();
        return true;
    }

    private String getTempFilePath() {
        String fileDir = String.format(Locale.getDefault(), "%s/Record/", Environment.getExternalStorageDirectory().getAbsolutePath());
        if (!FileUtils.createOrExistsDir(fileDir)) {
            Logger.e(TAG, "\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a%s", fileDir);
        }
        String fileName = String.format(Locale.getDefault(), "record_tmp_%s", FileUtils.getNowString(new SimpleDateFormat("yyyyMMdd_HH_mm_ss", Locale.SIMPLIFIED_CHINESE)));
        return String.format(Locale.getDefault(), "%s%s.pcm", fileDir, fileName);
    }

    public static enum RecordState {
        IDLE,
        RECORDING,
        PAUSE,
        STOP,
        FINISH;

    }

    private class AudioRecordThread
    extends Thread {
        private AudioRecord audioRecord;
        private int bufferSize;

        AudioRecordThread() {
            this.bufferSize = AudioRecord.getMinBufferSize((int)RecordHelper.this.currentConfig.getSampleRate(), (int)RecordHelper.this.currentConfig.getChannelConfig(), (int)RecordHelper.this.currentConfig.getEncodingConfig()) * 1;
            Logger.d(TAG, "record buffer size = %s", this.bufferSize);
            this.audioRecord = new AudioRecord(1, RecordHelper.this.currentConfig.getSampleRate(), RecordHelper.this.currentConfig.getChannelConfig(), RecordHelper.this.currentConfig.getEncodingConfig(), this.bufferSize);
            if (RecordHelper.this.currentConfig.getFormat() == RecordConfig.RecordFormat.MP3) {
                if (RecordHelper.this.mp3EncodeThread == null) {
                    RecordHelper.this.initMp3EncoderThread(this.bufferSize);
                } else {
                    Logger.e(TAG, "mp3EncodeThread != null, \u8bf7\u68c0\u67e5\u4ee3\u7801", new Object[0]);
                }
            }
        }

        @Override
        public void run() {
            super.run();
            switch (RecordHelper.this.currentConfig.getFormat()) {
                case MP3: {
                    this.startMp3Recorder();
                    break;
                }
                default: {
                    this.startPcmRecorder();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startPcmRecorder() {
            RecordHelper.this.state = RecordState.RECORDING;
            RecordHelper.this.notifyState();
            Logger.d(TAG, "\u5f00\u59cb\u5f55\u5236 Pcm", new Object[0]);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(RecordHelper.this.tmpFile);
                this.audioRecord.startRecording();
                byte[] byteBuffer = new byte[this.bufferSize];
                while (RecordHelper.this.state == RecordState.RECORDING) {
                    int end = this.audioRecord.read(byteBuffer, 0, byteBuffer.length);
                    RecordHelper.this.notifyData(byteBuffer);
                    fos.write(byteBuffer, 0, end);
                    fos.flush();
                }
                this.audioRecord.stop();
                RecordHelper.this.files.add(RecordHelper.this.tmpFile);
                if (RecordHelper.this.state == RecordState.STOP) {
                    RecordHelper.this.makeFile();
                } else {
                    Logger.i(TAG, "\u6682\u505c\uff01", new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.e(e, TAG, e.getMessage(), new Object[0]);
                RecordHelper.this.notifyError("\u5f55\u97f3\u5931\u8d25");
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (RecordHelper.this.state != RecordState.PAUSE) {
                RecordHelper.this.state = RecordState.IDLE;
                RecordHelper.this.notifyState();
                Logger.d(TAG, "\u5f55\u97f3\u7ed3\u675f", new Object[0]);
            }
        }

        private void startMp3Recorder() {
            RecordHelper.this.state = RecordState.RECORDING;
            RecordHelper.this.notifyState();
            try {
                this.audioRecord.startRecording();
                short[] byteBuffer = new short[this.bufferSize];
                while (RecordHelper.this.state == RecordState.RECORDING) {
                    int end = this.audioRecord.read(byteBuffer, 0, byteBuffer.length);
                    if (RecordHelper.this.mp3EncodeThread != null) {
                        RecordHelper.this.mp3EncodeThread.addChangeBuffer(new Mp3EncodeThread.ChangeBuffer(byteBuffer, end));
                    }
                    RecordHelper.this.notifyData(ByteUtils.toBytes(byteBuffer));
                }
                this.audioRecord.stop();
            }
            catch (Exception e) {
                Logger.e(e, TAG, e.getMessage(), new Object[0]);
                RecordHelper.this.notifyError("\u5f55\u97f3\u5931\u8d25");
            }
            if (RecordHelper.this.state != RecordState.PAUSE) {
                RecordHelper.this.state = RecordState.IDLE;
                RecordHelper.this.notifyState();
                RecordHelper.this.stopMp3Encoded();
            } else {
                Logger.d(TAG, "\u6682\u505c", new Object[0]);
            }
        }
    }
}

