/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib.recorder;

import android.os.Environment;
import java.io.Serializable;
import java.util.Locale;

public class RecordConfig
implements Serializable {
    private RecordFormat format = RecordFormat.WAV;
    private int channelConfig = 16;
    private int encodingConfig = 2;
    private int sampleRate = 16000;
    private String recordDir = String.format(Locale.getDefault(), "%s/Record/", Environment.getExternalStorageDirectory().getAbsolutePath());

    public RecordConfig() {
    }

    public RecordConfig(RecordFormat format) {
        this.format = format;
    }

    public RecordConfig(RecordFormat format, int channelConfig, int encodingConfig, int sampleRate) {
        this.format = format;
        this.channelConfig = channelConfig;
        this.encodingConfig = encodingConfig;
        this.sampleRate = sampleRate;
    }

    public String getRecordDir() {
        return this.recordDir;
    }

    public void setRecordDir(String recordDir) {
        this.recordDir = recordDir;
    }

    public int getEncoding() {
        if (this.format == RecordFormat.MP3) {
            return 16;
        }
        if (this.encodingConfig == 3) {
            return 8;
        }
        if (this.encodingConfig == 2) {
            return 16;
        }
        return 0;
    }

    public int getRealEncoding() {
        if (this.encodingConfig == 3) {
            return 8;
        }
        if (this.encodingConfig == 2) {
            return 16;
        }
        return 0;
    }

    public int getChannelCount() {
        if (this.channelConfig == 16) {
            return 1;
        }
        if (this.channelConfig == 12) {
            return 2;
        }
        return 0;
    }

    public RecordFormat getFormat() {
        return this.format;
    }

    public RecordConfig setFormat(RecordFormat format) {
        this.format = format;
        return this;
    }

    public int getChannelConfig() {
        return this.channelConfig;
    }

    public RecordConfig setChannelConfig(int channelConfig) {
        this.channelConfig = channelConfig;
        return this;
    }

    public int getEncodingConfig() {
        if (this.format == RecordFormat.MP3) {
            return 2;
        }
        return this.encodingConfig;
    }

    public RecordConfig setEncodingConfig(int encodingConfig) {
        this.encodingConfig = encodingConfig;
        return this;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public RecordConfig setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
        return this;
    }

    public String toString() {
        return String.format(Locale.getDefault(), "\u5f55\u5236\u683c\u5f0f\uff1a %s,\u91c7\u6837\u7387\uff1a%sHz,\u4f4d\u5bbd\uff1a%s bit,\u58f0\u9053\u6570\uff1a%s", new Object[]{this.format, this.sampleRate, this.getEncoding(), this.getChannelCount()});
    }

    public static enum RecordFormat {
        MP3(".mp3"),
        WAV(".wav"),
        PCM(".pcm");

        private String extension;

        public String getExtension() {
            return this.extension;
        }

        private RecordFormat(String extension) {
            this.extension = extension;
        }
    }
}

