/*
 * Decompiled with CFR 0.152.
 */
package com.zlw.main.recorderlib;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import com.zlw.main.recorderlib.recorder.RecordConfig;
import com.zlw.main.recorderlib.recorder.RecordHelper;
import com.zlw.main.recorderlib.recorder.RecordService;
import com.zlw.main.recorderlib.recorder.listener.RecordDataListener;
import com.zlw.main.recorderlib.recorder.listener.RecordFftDataListener;
import com.zlw.main.recorderlib.recorder.listener.RecordResultListener;
import com.zlw.main.recorderlib.recorder.listener.RecordSoundSizeListener;
import com.zlw.main.recorderlib.recorder.listener.RecordStateListener;
import com.zlw.main.recorderlib.utils.Logger;

public class RecordManager {
    private static final String TAG = RecordManager.class.getSimpleName();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile RecordManager instance;
    private Application context;

    private RecordManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RecordManager getInstance() {
        if (instance != null) return instance;
        Class<RecordManager> clazz = RecordManager.class;
        synchronized (RecordManager.class) {
            if (instance != null) return instance;
            instance = new RecordManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Application application, boolean showLog) {
        this.context = application;
        Logger.IsDebug = showLog;
    }

    public void start() {
        if (this.context == null) {
            Logger.e(TAG, "\u672a\u8fdb\u884c\u521d\u59cb\u5316", new Object[0]);
            return;
        }
        Logger.i(TAG, "start...", new Object[0]);
        RecordService.startRecording((Context)this.context);
    }

    public void stop() {
        if (this.context == null) {
            return;
        }
        RecordService.stopRecording((Context)this.context);
    }

    public void resume() {
        if (this.context == null) {
            return;
        }
        RecordService.resumeRecording((Context)this.context);
    }

    public void pause() {
        if (this.context == null) {
            return;
        }
        RecordService.pauseRecording((Context)this.context);
    }

    public void setRecordStateListener(RecordStateListener listener) {
        RecordService.setRecordStateListener(listener);
    }

    public void setRecordDataListener(RecordDataListener listener) {
        RecordService.setRecordDataListener(listener);
    }

    public void setRecordFftDataListener(RecordFftDataListener recordFftDataListener) {
        RecordService.setRecordFftDataListener(recordFftDataListener);
    }

    public void setRecordResultListener(RecordResultListener listener) {
        RecordService.setRecordResultListener(listener);
    }

    public void setRecordSoundSizeListener(RecordSoundSizeListener listener) {
        RecordService.setRecordSoundSizeListener(listener);
    }

    public boolean changeFormat(RecordConfig.RecordFormat recordFormat) {
        return RecordService.changeFormat(recordFormat);
    }

    public boolean changeRecordConfig(RecordConfig recordConfig) {
        return RecordService.changeRecordConfig(recordConfig);
    }

    public RecordConfig getRecordConfig() {
        return RecordService.getRecordConfig();
    }

    public void changeRecordDir(String recordDir) {
        RecordService.changeRecordDir(recordDir);
    }

    public RecordHelper.RecordState getState() {
        return RecordService.getState();
    }
}

