/*
 * Decompiled with CFR 0.152.
 */
package com.socks.library;

import android.text.TextUtils;
import android.util.Log;
import com.socks.library.FileHelper;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KLog {
    private static boolean IS_SHOW_LOG = true;
    private static final String DEFAULT_MESSAGE = "execute";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int JSON_INDENT = 4;
    private static final int V = 1;
    private static final int D = 2;
    private static final int I = 3;
    private static final int W = 4;
    private static final int E = 5;
    private static final int A = 6;
    private static final int JSON = 7;

    public static void init(boolean isShowLog) {
        IS_SHOW_LOG = isShowLog;
    }

    public static void v() {
        KLog.printLog(1, null, DEFAULT_MESSAGE);
    }

    public static void v(Object msg) {
        KLog.printLog(1, null, msg);
    }

    public static void v(String tag, String msg) {
        KLog.printLog(1, tag, msg);
    }

    public static void d() {
        KLog.printLog(2, null, DEFAULT_MESSAGE);
    }

    public static void d(Object msg) {
        KLog.printLog(2, null, msg);
    }

    public static void d(String tag, Object msg) {
        KLog.printLog(2, tag, msg);
    }

    public static void i() {
        KLog.printLog(3, null, DEFAULT_MESSAGE);
    }

    public static void i(Object msg) {
        KLog.printLog(3, null, msg);
    }

    public static void i(String tag, Object msg) {
        KLog.printLog(3, tag, msg);
    }

    public static void w() {
        KLog.printLog(4, null, DEFAULT_MESSAGE);
    }

    public static void w(Object msg) {
        KLog.printLog(4, null, msg);
    }

    public static void w(String tag, Object msg) {
        KLog.printLog(4, tag, msg);
    }

    public static void e() {
        KLog.printLog(5, null, DEFAULT_MESSAGE);
    }

    public static void e(Object msg) {
        KLog.printLog(5, null, msg);
    }

    public static void e(String tag, Object msg) {
        KLog.printLog(5, tag, msg);
    }

    public static void a() {
        KLog.printLog(6, null, DEFAULT_MESSAGE);
    }

    public static void a(Object msg) {
        KLog.printLog(6, null, msg);
    }

    public static void a(String tag, Object msg) {
        KLog.printLog(6, tag, msg);
    }

    public static void json(String jsonFormat) {
        KLog.printLog(7, null, jsonFormat);
    }

    public static void json(String tag, String jsonFormat) {
        KLog.printLog(7, tag, jsonFormat);
    }

    public static void file(File targetDirectory, Object msg) {
        KLog.printFile(null, targetDirectory, null, msg);
    }

    public static void file(String tag, File targetDirectory, Object msg) {
        KLog.printFile(tag, targetDirectory, null, msg);
    }

    public static void file(String tag, File targetDirectory, String fileName, Object msg) {
        KLog.printFile(tag, targetDirectory, fileName, msg);
    }

    private static void printLog(int type, String tagStr, Object objectMsg) {
        String msg;
        if (!IS_SHOW_LOG) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        String tag = tagStr == null ? className : tagStr;
        String methodNameShort = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodNameShort).append(" ] ");
        String string = msg = objectMsg == null ? "Log with null Object" : objectMsg.toString();
        if (msg != null && type != 7) {
            stringBuilder.append(msg);
        }
        String logStr = stringBuilder.toString();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                KLog.printDefault(type, tag, logStr);
                break;
            }
            case 7: {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    Log.e((String)tag, (String)"Empty or Null json content");
                    return;
                }
                KLog.printJson(tag, msg, logStr);
            }
        }
    }

    private static void printDefault(int type, String tag, String logStr) {
        switch (type) {
            case 1: {
                Log.v((String)tag, (String)logStr);
                break;
            }
            case 2: {
                Log.d((String)tag, (String)logStr);
                break;
            }
            case 3: {
                Log.i((String)tag, (String)logStr);
                break;
            }
            case 4: {
                Log.w((String)tag, (String)logStr);
                break;
            }
            case 5: {
                Log.e((String)tag, (String)logStr);
                break;
            }
            case 6: {
                Log.wtf((String)tag, (String)logStr);
            }
        }
    }

    private static void printJson(String tag, String msg, String logStr) {
        String[] lines;
        String message = null;
        try {
            if (msg.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(msg);
                message = jsonObject.toString(4);
            } else if (msg.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(msg);
                message = jsonArray.toString(4);
            }
        }
        catch (JSONException e) {
            KLog.e(tag, e.getCause().getMessage() + "\n" + msg);
            return;
        }
        KLog.printLine(tag, true);
        message = logStr + LINE_SEPARATOR + message;
        for (String line : lines = message.split(LINE_SEPARATOR)) {
            Log.d((String)tag, (String)("\u2551 " + line));
        }
        KLog.printLine(tag, false);
    }

    private static void printFile(String tag, File targetDirectory, String fileName, Object objectMsg) {
        if (!IS_SHOW_LOG) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int index = 4;
        String className = stackTrace[index].getFileName();
        String methodName = stackTrace[index].getMethodName();
        int lineNumber = stackTrace[index].getLineNumber();
        tag = tag == null ? className : tag;
        String methodNameShort = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ (").append(className).append(":").append(lineNumber).append(")#").append(methodNameShort).append(" ] ");
        String msg = objectMsg == null ? "Log with null Object" : objectMsg.toString();
        String headString = stringBuilder.toString();
        if (msg != null) {
            msg = headString + msg;
        }
        String string = fileName = fileName == null ? FileHelper.getFileName() : fileName;
        if (FileHelper.save(targetDirectory, fileName, msg)) {
            Log.d((String)tag, (String)(headString + " save log success ! location is >>>" + targetDirectory.getAbsolutePath() + "/" + fileName));
        } else {
            Log.e((String)tag, (String)(headString + "save log fails !"));
        }
    }

    private static void printLine(String tag, boolean isTop) {
        if (isTop) {
            Log.d((String)tag, (String)"\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        } else {
            Log.d((String)tag, (String)"\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }
    }
}

