/*
 * Decompiled with CFR 0.152.
 */
package com.zlm.libs.register.utils;

import android.text.TextUtils;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    public static final int MD5_TYPE_IO = 0;
    public static final int MD5_TYPE_NIO = 1;
    public static final String SHA224 = "sha-224";
    public static final String SHA256 = "sha-256";
    public static final String SHA384 = "sha-384";
    public static final String SHA512 = "sha-512";
    public static final int RSA_PUBLIC_ENCRYPT = 0;
    public static final int RSA_PUBLIC_DECRYPT = 1;
    public static final int RSA_PRIVATE_ENCRYPT = 2;
    public static final int RSA_PRIVATE_DECRYPT = 3;

    private EncryptUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    private static String a(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() == 1) {
                string = '0' + string;
            }
            stringBuilder.append(string.toUpperCase());
        }
        return stringBuilder.toString();
    }

    private static byte[] a(String string) {
        if (string.length() < 1) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            int n = Integer.parseInt(string.substring(i * 2, i * 2 + 1), 16);
            int n2 = Integer.parseInt(string.substring(i * 2 + 1, i * 2 + 2), 16);
            byArray[i] = (byte)(n * 16 + n2);
        }
        return byArray;
    }

    public static String md5(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest((string + string2).getBytes());
            String string3 = "";
            for (byte by : byArray) {
                String string4 = Integer.toHexString(by & 0xFF);
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                string3 = string3 + string4;
            }
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    public static String md5(String string) {
        return TextUtils.isEmpty((CharSequence)string) ? "" : EncryptUtils.md5(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(File file, int n) {
        if (file == null || !file.isFile() || !file.exists()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        String string = "";
        byte[] byArray = new byte[8192];
        try {
            fileInputStream = new FileInputStream(file);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest();
            if (n == 0) {
                int n2;
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    messageDigest.update(byArray, 0, n2);
                }
            } else {
                MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                messageDigest.update(mappedByteBuffer);
            }
            for (Object object : (MappedByteBuffer)byArray2) {
                String string2 = Integer.toHexString(object & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = string + string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string;
    }

    public static String md5(String string, int n) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String string2 = EncryptUtils.md5(string);
        for (int i = 0; i < n; ++i) {
            string2 = EncryptUtils.md5(string2);
        }
        return string2;
    }

    public static String base64EncodeStr(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return Base64.encodeToString((byte[])string.getBytes(), (int)0);
    }

    public static String base64DecodedStr(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return new String(Base64.decode((String)string, (int)0));
    }

    public static String base64EncodeFile(File file) {
        if (null == file) {
            return "";
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return Base64.encodeToString((byte[])byArray, (int)0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static File base64DecodedFile(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        File file = new File(string);
        try {
            byte[] byArray = Base64.decode((byte[])string2.getBytes(), (int)0);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public static String aes(String string, String string2, int n) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "Crypto");
            secureRandom.setSeed(string2.getBytes());
            keyGenerator.init(128, secureRandom);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] byArray = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(n, secretKeySpec);
            if (n == 1) {
                byte[] byArray2 = string.getBytes("utf-8");
                return EncryptUtils.a(cipher.doFinal(byArray2));
            }
            byte[] byArray3 = EncryptUtils.a(string);
            return new String(cipher.doFinal(byArray3));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String des(String string, String string2, int n) {
        try {
            SecureRandom secureRandom = new SecureRandom();
            DESKeySpec dESKeySpec = new DESKeySpec(string2.getBytes());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(n, (Key)secretKeyFactory.generateSecret(dESKeySpec), secureRandom);
            if (n == 1) {
                byte[] byArray = string.getBytes("utf-8");
                return EncryptUtils.a(cipher.doFinal(byArray));
            }
            byte[] byArray = EncryptUtils.a(string);
            return new String(cipher.doFinal(byArray));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String sha(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = SHA256;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            byte[] byArray = messageDigest.digest(string.getBytes());
            String string3 = "";
            for (byte by : byArray) {
                String string4 = Integer.toHexString(by & 0xFF);
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                string3 = string3 + string4;
            }
            return string3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    public static Map<String, Object> getKeyPair() {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("RSAPublicKey", rSAPublicKey);
        hashMap.put("RSAPrivateKey", rSAPrivateKey);
        return hashMap;
    }

    public static String getKey(Map<String, Object> map, boolean bl) {
        Key key = (Key)map.get(bl ? "RSAPublicKey" : "RSAPrivateKey");
        return new String(Base64.encode((byte[])key.getEncoded(), (int)0));
    }

    public static String sign(byte[] byArray, String string) {
        byte[] byArray2 = Base64.decode((byte[])string.getBytes(), (int)0);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(privateKey);
        signature.update(byArray);
        return new String(Base64.encode((byte[])signature.sign(), (int)0));
    }

    public static boolean verify(byte[] byArray, String string, String string2) {
        byte[] byArray2 = Base64.decode((byte[])string.getBytes(), (int)0);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(Base64.decode((byte[])string2.getBytes(), (int)0));
    }

    public static byte[] rsa(byte[] byArray, String string, int n) {
        Key key;
        Object object;
        byte[] byArray2 = Base64.decode((String)string, (int)0);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
        if (n == 0 || n == 1) {
            object = new X509EncodedKeySpec(byArray2);
            key = keyFactory.generatePublic((KeySpec)object);
        } else {
            object = new PKCS8EncodedKeySpec(byArray2);
            key = keyFactory.generatePrivate((KeySpec)object);
        }
        object = Cipher.getInstance(keyFactory.getAlgorithm());
        int n2 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        if (n == 0 || n == 2) {
            ((Cipher)object).init(1, key);
            while (n2 - n3 > 0) {
                byte[] byArray3 = ((Cipher)object).doFinal(byArray, n3, n2 - n3 > 117 ? 117 : n2 - n3);
                byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                n3 = ++n4 * 117;
            }
        } else {
            ((Cipher)object).init(2, key);
            while (n2 - n3 > 0) {
                byte[] byArray4 = n2 - n3 > 128 ? ((Cipher)object).doFinal(byArray, n3, 128) : ((Cipher)object).doFinal(byArray, n3, n2 - n3);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                n3 = ++n4 * 128;
            }
        }
        byte[] byArray5 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray5;
    }
}

