/*
 * Decompiled with CFR 0.152.
 */
package com.zlm.libs.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;

public class RotateLayout
extends LinearLayout {
    public static final int ALL = -1;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    private final int OPEN = 0;
    private final int CLOSE = 1;
    private final int MOVE = 2;
    private int mDragStatus = 1;
    private int mDragType = -1;
    private int mTouchSlop;
    private float mLastInterceptX = 0.0f;
    private float mLastInterceptY = 0.0f;
    private VelocityTracker mVelocityTracker;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private int mDuration = 300;
    private ValueAnimator mValueAnimator;
    private LinearLayout mRotateLayout;
    private float mCloseFlagDegree = 40.0f;
    private float mClosedDegree = 85.0f;
    private float mMinFlagDegree = 0.2f;
    private float mCurDegree = this.mClosedDegree;
    private float mPivotX = 0.0f;
    private float mPivotY = 0.0f;
    private LayoutInflater mLayoutInflater;
    public static final int CONTENTVIEWTYPE_LINEARLAYOUT = 0;
    public static final int CONTENTVIEWTYPE_RELATIVELAYOUT = 1;
    private List<View> mIgnoreHorizontalViews;
    private List<View> mIgnoreViews;
    private RotateLayoutListener mRotateLayoutListener;
    private RotateAnimatorListener mRotateAnimatorListener;

    public RotateLayout(Context context) {
        super(context);
        this.init(context);
    }

    public RotateLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int mScreensWidth = display.getWidth();
        int mScreensHeigh = display.getHeight();
        this.mPivotX = (float)mScreensWidth * 0.5f;
        this.mPivotY = 1.5f * (float)mScreensHeigh;
        this.setOrientation(1);
        this.setBackgroundColor(0);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                RotateLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                RotateLayout.this.open();
            }
        });
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 0 && this.getChildCount() < 2) {
            this.mRotateLayout = (LinearLayout)this.getChildAt(0);
        } else {
            this.mRotateLayout = new LinearLayout(this.getContext());
            this.mRotateLayout.setOrientation(1);
            this.mRotateLayout.setBackgroundColor(-1);
            this.removeAllViews();
            this.addView((View)this.mRotateLayout, -1, -1);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mRotateLayout != null) {
            this.invalidateLayout(this.mCurDegree);
        }
    }

    private void invalidateLayout(float degree) {
        this.mCurDegree = degree;
        this.mRotateLayout.setPivotX(this.mPivotX);
        this.mRotateLayout.setPivotY(this.mPivotY);
        if (Math.abs(degree) < this.mMinFlagDegree) {
            this.mRotateLayout.setRotation(0.0f);
        } else {
            this.mRotateLayout.setRotation(degree);
        }
        this.invalidate();
        if (this.mRotateAnimatorListener != null) {
            this.mRotateAnimatorListener.rotateUpdate(this.mPivotX, this.mPivotY, this.mRotateLayout.getRotation());
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.mRotateLayout == null) {
            super.onInterceptTouchEvent(event);
        }
        boolean intercepted = false;
        float curX = event.getX();
        float curY = event.getY();
        int actionId = event.getAction();
        switch (actionId) {
            case 0: {
                this.mLastInterceptX = curX;
                this.mLastInterceptY = curY;
                break;
            }
            case 2: {
                int deltaX = (int)(this.mLastInterceptX - curX);
                int deltaY = (int)(this.mLastInterceptY - curY);
                if (Math.abs(deltaX) <= this.mTouchSlop || Math.abs(deltaY) >= this.mTouchSlop || this.isInIgnoreHorizontalView(event) || this.isInIgnoreView(event)) break;
                intercepted = true;
                break;
            }
        }
        return intercepted;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mRotateLayout == null) {
            super.onTouchEvent(event);
        }
        this.obtainVelocityTracker(event);
        float curX = event.getX();
        float curY = event.getY();
        int actionId = event.getAction();
        switch (actionId) {
            case 0: {
                this.mLastInterceptX = curX;
                this.mLastInterceptY = curY;
                break;
            }
            case 2: {
                float curW;
                float curH;
                float curDegree;
                int deltaX = (int)(this.mLastInterceptX - curX);
                int deltaY = (int)(this.mLastInterceptY - curY);
                if (this.mDragStatus != 2 && (Math.abs(deltaX) <= this.mTouchSlop || Math.abs(deltaY) >= this.mTouchSlop || this.isInIgnoreHorizontalView(event) || this.isInIgnoreView(event)) || this.mDragStatus != 2 && this.mDragType != -1 && (deltaX >= 0 || this.mDragType != 0) && (deltaX <= 0 || this.mDragType != 1)) break;
                float lastH = this.mPivotY - this.mLastInterceptY;
                float lastW = this.mPivotX - this.mLastInterceptX;
                float lastDegree = (float)Math.toDegrees(Math.atan(lastH / lastW));
                if (lastDegree < 0.0f) {
                    lastDegree += 180.0f;
                }
                if ((curDegree = (float)Math.toDegrees(Math.atan((curH = this.mPivotY - curY) / (curW = this.mPivotX - curX)))) < 0.0f) {
                    curDegree += 180.0f;
                }
                float degree = curDegree - lastDegree;
                this.invalidateLayout(degree);
                this.setDragStatus(2);
                break;
            }
            default: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int xVelocity = (int)velocityTracker.getXVelocity();
                int oldDragStatus = this.mDragStatus;
                this.setDragStatus(0);
                if ((Math.abs(xVelocity) > this.mMinimumVelocity && xVelocity > 0 || this.mCurDegree > this.mCloseFlagDegree) && (this.mDragType == 0 || this.mDragType == -1) && oldDragStatus == 2) {
                    this.setDragStatus(1);
                    this.rotateValueAnimator(this.mCurDegree, this.mClosedDegree);
                } else if ((Math.abs(xVelocity) > this.mMinimumVelocity && xVelocity < 0 || this.mCurDegree < -this.mCloseFlagDegree) && (this.mDragType == 1 || this.mDragType == -1) && oldDragStatus == 2) {
                    this.setDragStatus(1);
                    this.rotateValueAnimator(this.mCurDegree, -this.mClosedDegree);
                } else {
                    this.rotateValueAnimator(this.mCurDegree, 0.0f);
                }
                this.releaseVelocityTracker();
            }
        }
        return true;
    }

    public void open() {
        if (this.mDragStatus == 0) {
            return;
        }
        this.setDragStatus(0);
        if (this.mRotateLayout != null) {
            this.rotateValueAnimator(this.mCurDegree, 0.0f);
        }
    }

    public void closeView() {
        if (this.mDragStatus == 1) {
            return;
        }
        this.setDragStatus(1);
        if (this.mRotateLayout != null) {
            if (this.mDragType == 0 || this.mDragType == -1) {
                this.rotateValueAnimator(this.mCurDegree, this.mClosedDegree);
            } else {
                this.rotateValueAnimator(this.mCurDegree, -this.mClosedDegree);
            }
        }
    }

    private void rotateValueAnimator(float fromDegree, float toDegree) {
        if (this.mValueAnimator != null && this.mValueAnimator.isRunning()) {
            this.mValueAnimator.cancel();
            this.mValueAnimator = null;
        }
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{fromDegree, toDegree});
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Number number = (Number)animation.getAnimatedValue();
                RotateLayout.this.invalidateLayout(number.floatValue());
            }
        });
        this.mValueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (RotateLayout.this.mRotateLayoutListener != null && RotateLayout.this.mDragStatus == 1) {
                    RotateLayout.this.mRotateLayoutListener.finishActivity();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }
        });
        this.mValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mValueAnimator.setDuration((long)this.mDuration);
        this.mValueAnimator.start();
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setDragStatus(int dragStatus) {
        this.mDragStatus = dragStatus;
    }

    private boolean isInIgnoreHorizontalView(MotionEvent event) {
        return this.isInView(this.mIgnoreHorizontalViews, event);
    }

    private boolean isInIgnoreView(MotionEvent event) {
        return this.isInView(this.mIgnoreViews, event);
    }

    private boolean isInView(List<View> views, MotionEvent event) {
        if (views == null || views.size() == 0) {
            return false;
        }
        for (int i = 0; i < views.size(); ++i) {
            View view = views.get(i);
            Rect rect = new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            if (!rect.contains((int)event.getX(), (int)event.getY())) continue;
            return true;
        }
        return false;
    }

    public void addIgnoreHorizontalView(View ignoreView) {
        if (this.mIgnoreHorizontalViews == null) {
            this.mIgnoreHorizontalViews = new ArrayList<View>();
        }
        if (!this.mIgnoreHorizontalViews.contains(ignoreView)) {
            this.mIgnoreHorizontalViews.add(ignoreView);
        }
    }

    public void addIgnoreView(View ignoreView) {
        if (this.mIgnoreViews == null) {
            this.mIgnoreViews = new ArrayList<View>();
        }
        if (!this.mIgnoreViews.contains(ignoreView)) {
            this.mIgnoreViews.add(ignoreView);
        }
    }

    public void setContentView(int resourceId) {
        View contentView = this.mLayoutInflater.inflate(resourceId, null);
        this.setContentView(contentView, 0);
    }

    public void setContentView(int resourceId, int contentViewType) {
        View contentView = this.mLayoutInflater.inflate(resourceId, null);
        this.setContentView(contentView, contentViewType);
    }

    public void setContentView(View contentView, int contentViewType) {
        if (contentViewType == 0) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            this.mRotateLayout.addView(contentView, (ViewGroup.LayoutParams)layoutParams);
        } else if (contentViewType == 1) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.mRotateLayout.addView(contentView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setDragType(int dragType) {
        this.mDragType = dragType;
    }

    public LinearLayout getRotateLayout() {
        return this.mRotateLayout;
    }

    public void setRotateLayoutListener(RotateLayoutListener rotateLayoutListener) {
        this.mRotateLayoutListener = rotateLayoutListener;
    }

    public void setRotateAnimatorListener(RotateAnimatorListener mRotateAnimatorListener) {
        this.mRotateAnimatorListener = mRotateAnimatorListener;
    }

    public static interface RotateAnimatorListener {
        public void rotateUpdate(float var1, float var2, float var3);
    }

    public static interface RotateLayoutListener {
        public void finishActivity();
    }
}

