/*
 * Decompiled with CFR 0.152.
 */
package com.github.flycat.spi.impl.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.exception.NacosException;
import com.github.flycat.context.ApplicationConfiguration;
import com.github.flycat.spi.SpiService;
import com.github.flycat.spi.config.ConfigException;
import com.github.flycat.spi.config.ConfigService;
import com.github.flycat.spi.impl.config.NacosUtils;
import java.util.concurrent.Callable;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named
public class NacosConfigService
implements ConfigService,
SpiService {
    private com.alibaba.nacos.api.config.ConfigService configService;
    private final ApplicationConfiguration applicationConfiguration;

    public NacosConfigService(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
        this.createConfigService();
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public NacosConfigService(com.alibaba.nacos.api.config.ConfigService configService, ApplicationConfiguration applicationConfiguration) {
        this.configService = configService;
        this.applicationConfiguration = applicationConfiguration;
    }

    public String getConfig(String dataId) throws ConfigException {
        return this.getConfig(dataId, "DEFAULT_GROUP", 3000L);
    }

    public String getConfig(String dataId, long timeoutMs) throws ConfigException {
        return this.getConfig(dataId, "DEFAULT_GROUP", timeoutMs);
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws ConfigException {
        try {
            return this.configService.getConfig(dataId, group, timeoutMs);
        }
        catch (NacosException e) {
            throw new ConfigException("Unable to get config from nacos", (Throwable)e);
        }
    }

    public <T> T getJsonConfig(String dataId, Class<T> type) throws ConfigException {
        String config = this.getConfig(dataId);
        return (T)this.checkException(() -> JSON.parseObject((String)config, (Class)type));
    }

    private <T> T checkException(Callable<T> callable) throws ConfigException {
        try {
            return callable.call();
        }
        catch (Throwable throwable) {
            throw new ConfigException(throwable);
        }
    }

    public <T> T getJsonConfig(String dataId, String name, Class<T> type) throws ConfigException {
        String config = this.getConfig(dataId);
        return (T)this.checkException(() -> {
            JSONObject jsonObject = JSON.parseObject((String)config);
            return jsonObject.getObject(name, type);
        });
    }

    public void createConfigService() {
        String addr = this.getString("flycat.nacos.config.server-addr");
        this.configService = NacosUtils.createConfigService(addr);
    }
}

