/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.logback.elasticsearch.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.internetitem.logback.elasticsearch.config.Settings;
import org.slf4j.LoggerFactory;

public class ErrorReporter
extends ContextAwareBase {
    private Settings settings;

    public ErrorReporter(Settings settings, Context context) {
        this.setContext(context);
        this.settings = settings;
    }

    public void logError(String message, Throwable e) {
        String loggerName = this.settings.getErrorLoggerName();
        if (loggerName != null) {
            LoggerFactory.getLogger((String)loggerName).error(message, e);
        }
        this.addError(message, e);
    }

    public void logWarning(String message) {
        String loggerName = this.settings.getErrorLoggerName();
        if (loggerName != null) {
            LoggerFactory.getLogger((String)loggerName).warn(message);
        }
        this.addWarn(message);
    }

    public void logInfo(String message) {
        String loggerName = this.settings.getErrorLoggerName();
        if (loggerName != null) {
            LoggerFactory.getLogger((String)loggerName).info(message);
        }
        this.addInfo(message);
    }
}

