/*
 * Decompiled with CFR 0.152.
 */
package com.github.zeng1990java.retrofit2.adapter.bolts;

import bolts.Task;
import bolts.TaskCompletionSource;
import com.github.zeng1990java.retrofit2.adapter.bolts.HttpException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class BoltsCallAdapterFactory
extends CallAdapter.Factory {
    private Executor executor;

    public static BoltsCallAdapterFactory create() {
        return new BoltsCallAdapterFactory(null);
    }

    public static BoltsCallAdapterFactory createWithExecutor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor == null");
        }
        return new BoltsCallAdapterFactory(executor);
    }

    private BoltsCallAdapterFactory(Executor executor) {
        this.executor = executor;
    }

    public CallAdapter<?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (BoltsCallAdapterFactory.getRawType((Type)returnType) != Task.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Task return type must be parameterized as Task<Foo> or Task<? extends Foo>");
        }
        Type innerType = BoltsCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (BoltsCallAdapterFactory.getRawType((Type)innerType) != Response.class) {
            return new BodyCallAdapter(this.executor, innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = BoltsCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResponseCallAdapter(this.executor, responseType);
    }

    private static class ResponseCallAdapter
    implements CallAdapter<Task<?>> {
        private final Executor executor;
        private final Type responseType;

        ResponseCallAdapter(Executor executor, Type responseType) {
            this.executor = executor;
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public <R> Task<?> adapt(final Call<R> call) {
            final TaskCompletionSource tcs = new TaskCompletionSource();
            if (this.executor != null) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Response response = call.execute();
                            ResponseCallAdapter.this.setResponseResult(response, tcs);
                        }
                        catch (IOException e) {
                            tcs.setError((Exception)e);
                        }
                    }
                });
            } else {
                call.enqueue(new Callback<R>(){

                    public void onResponse(Call<R> call, Response<R> response) {
                        ResponseCallAdapter.this.setResponseResult(response, tcs);
                    }

                    public void onFailure(Call<R> call, Throwable t) {
                        tcs.setError(new Exception(t));
                    }
                });
            }
            return tcs.getTask();
        }

        private <R> void setResponseResult(Response<R> response, TaskCompletionSource<Response<R>> tcs) {
            try {
                tcs.setResult(response);
            }
            catch (CancellationException e) {
                tcs.setCancelled();
            }
            catch (Exception e) {
                tcs.setError(e);
            }
        }
    }

    private static class BodyCallAdapter
    implements CallAdapter<Task<?>> {
        private Executor executor;
        private final Type responseType;

        BodyCallAdapter(Executor executor, Type responseType) {
            this.executor = executor;
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public <R> Task<?> adapt(final Call<R> call) {
            final TaskCompletionSource tcs = new TaskCompletionSource();
            if (this.executor != null) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Response response = call.execute();
                            BodyCallAdapter.this.setResponseResult(response, tcs);
                        }
                        catch (IOException e) {
                            tcs.setError((Exception)e);
                        }
                    }
                });
            } else {
                call.enqueue(new Callback<R>(){

                    public void onResponse(Call<R> call, Response<R> response) {
                        BodyCallAdapter.this.setResponseResult(response, tcs);
                    }

                    public void onFailure(Call<R> call, Throwable t) {
                        tcs.setError(new Exception(t));
                    }
                });
            }
            return tcs.getTask();
        }

        private <R> void setResponseResult(Response<R> response, TaskCompletionSource<R> tcs) {
            try {
                if (response.isSuccessful()) {
                    tcs.setResult(response.body());
                } else {
                    tcs.setError((Exception)new HttpException(response));
                }
            }
            catch (CancellationException e) {
                tcs.setCancelled();
            }
            catch (Exception e) {
                tcs.setError(e);
            }
        }
    }
}

