/*
 * Decompiled with CFR 0.152.
 */
package ru.solodovnikov.rxlocationmanager;

import android.annotation.TargetApi;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import ru.solodovnikov.rxlocationmanager.LocationTime;
import ru.solodovnikov.rxlocationmanager.error.ElderLocationException;
import ru.solodovnikov.rxlocationmanager.error.ProviderDisabledException;
import rx.Emitter;
import rx.Observable;
import rx.Scheduler;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.functions.Func1;

public class RxLocationManager {
    private final LocationManager locationManager;
    private final Scheduler scheduler;

    public RxLocationManager(Context context) {
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.scheduler = AndroidSchedulers.mainThread();
    }

    RxLocationManager(LocationManager locationManager, Scheduler scheduler) {
        this.locationManager = locationManager;
        this.scheduler = scheduler;
    }

    public Observable<Location> getLastLocation(final @NonNull String provider, final @Nullable LocationTime howOldCanBe) {
        return Observable.fromCallable((Callable)new Callable<Location>(){

            @Override
            public Location call() throws Exception {
                return RxLocationManager.this.locationManager.getLastKnownLocation(provider);
            }
        }).compose((Observable.Transformer)new Observable.Transformer<Location, Location>(){

            public Observable<Location> call(Observable<Location> locationObservable) {
                Observable<Location> filterObservable = locationObservable.map((Func1)new Func1<Location, Location>(){

                    public Location call(Location location) {
                        if (location != null && !RxLocationManager.this.isLocationNotOld(location, howOldCanBe)) {
                            throw new ElderLocationException(location);
                        }
                        return location;
                    }
                });
                return howOldCanBe != null ? filterObservable : locationObservable;
            }
        }).compose(this.applySchedulers());
    }

    public Observable<Location> getLastLocation(@NonNull String provider) {
        return this.getLastLocation(provider, null);
    }

    public Observable<Location> requestLocation(@NonNull String provider, @Nullable LocationTime timeOut) {
        return this.requestLocation(provider, timeOut, true);
    }

    public Observable<Location> requestLocation(@NonNull String provider) {
        return this.requestLocation(provider, null);
    }

    Observable<Location> requestLocation(@NonNull String provider, final @Nullable LocationTime timeOut, boolean throwExceptionIfDisabled) {
        RxLocationListener locationListener = new RxLocationListener(this.locationManager, provider, throwExceptionIfDisabled);
        return Observable.create((Action1)locationListener, (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE).compose((Observable.Transformer)new Observable.Transformer<Location, Location>(){

            public Observable<Location> call(Observable<Location> locationObservable) {
                return timeOut != null ? locationObservable.timeout(timeOut.getValue(), timeOut.getTimeUnit()) : locationObservable;
            }
        }).compose(this.applySchedulers());
    }

    private Observable.Transformer<Location, Location> applySchedulers() {
        return new Observable.Transformer<Location, Location>(){

            public Observable<Location> call(Observable<Location> locationObservable) {
                return locationObservable.subscribeOn(RxLocationManager.this.scheduler).observeOn(RxLocationManager.this.scheduler);
            }
        };
    }

    private boolean isLocationNotOld(Location location, LocationTime howOldCanBe) {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.isLocationNotOld17(location, howOldCanBe);
        }
        return this.isLocationNotOldDefault(location, howOldCanBe);
    }

    @TargetApi(value=17)
    private boolean isLocationNotOld17(Location location, LocationTime howOldCanBe) {
        return SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos() < howOldCanBe.getTimeUnit().toNanos(howOldCanBe.getValue());
    }

    private boolean isLocationNotOldDefault(Location location, LocationTime howOldCanBe) {
        return System.currentTimeMillis() - location.getTime() < howOldCanBe.getTimeUnit().toMillis(howOldCanBe.getValue());
    }

    private static class RxLocationListener
    implements Action1<Emitter<Location>> {
        private final LocationManager locationManager;
        private final String provider;
        private final boolean throwExceptionIfDisabled;

        public RxLocationListener(LocationManager locationManager, String provider, boolean throwExceptionIfDisabled) {
            this.locationManager = locationManager;
            this.provider = provider;
            this.throwExceptionIfDisabled = throwExceptionIfDisabled;
        }

        public void call(final Emitter<Location> locationEmitter) {
            if (this.locationManager.isProviderEnabled(this.provider)) {
                final LocationListener locationListener = new LocationListener(){

                    public void onLocationChanged(Location location) {
                        locationEmitter.onNext((Object)location);
                        locationEmitter.onCompleted();
                    }

                    public void onStatusChanged(String provider, int status, Bundle extras) {
                    }

                    public void onProviderEnabled(String provider) {
                    }

                    public void onProviderDisabled(String provider) {
                        if (RxLocationListener.this.provider.equals(provider)) {
                            locationEmitter.onError((Throwable)new ProviderDisabledException(provider));
                        }
                    }
                };
                this.locationManager.requestSingleUpdate(this.provider, locationListener, null);
                locationEmitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        RxLocationListener.this.locationManager.removeUpdates(locationListener);
                    }
                });
            } else if (this.throwExceptionIfDisabled) {
                locationEmitter.onError((Throwable)new ProviderDisabledException(this.provider));
            } else {
                locationEmitter.onCompleted();
            }
        }
    }
}

