/*
 * Decompiled with CFR 0.152.
 */
package ru.solodovnikov.rxlocationmanager;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import ru.solodovnikov.rxlocationmanager.LocationTime;
import ru.solodovnikov.rxlocationmanager.RxLocationManager;
import ru.solodovnikov.rxlocationmanager.error.ElderLocationException;
import ru.solodovnikov.rxlocationmanager.error.ProviderDisabledException;
import rx.Observable;
import rx.Scheduler;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;

public class LocationRequestBuilder {
    private final List<Observable<Location>> observables = new ArrayList<Observable<Location>>();
    private final RxLocationManager rxLocationManager;
    private final Scheduler scheduler;
    private Location defaultLocation;
    private boolean returnDefaultLocationOnError = false;

    public LocationRequestBuilder(Context context) {
        this.rxLocationManager = new RxLocationManager(context);
        this.scheduler = AndroidSchedulers.mainThread();
    }

    LocationRequestBuilder(RxLocationManager rxLocationManager, Scheduler scheduler) {
        this.rxLocationManager = rxLocationManager;
        this.scheduler = scheduler;
    }

    public LocationRequestBuilder addRequestLocation(@NonNull String provider, @Nullable LocationTime timeOut, @Nullable Observable.Transformer<Location, Location> transformer) {
        Observable observable = this.rxLocationManager.requestLocation(provider, timeOut, false).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends Location>>(){

            public Observable<? extends Location> call(Throwable throwable) {
                if (throwable instanceof TimeoutException) {
                    return Observable.empty();
                }
                return Observable.error((Throwable)throwable);
            }
        });
        this.observables.add((Observable<Location>)(transformer != null ? observable.compose(transformer) : observable));
        return this;
    }

    public LocationRequestBuilder addRequestLocation(@NonNull String provider, @Nullable LocationTime timeOut) {
        return this.addRequestLocation(provider, timeOut, null);
    }

    public LocationRequestBuilder addRequestLocation(@NonNull String provider) {
        return this.addRequestLocation(provider, null);
    }

    public LocationRequestBuilder addLastLocation(@NonNull String provider, @Nullable LocationTime howOldCanBe, final boolean isNullValid, @Nullable Observable.Transformer<Location, Location> transformer) {
        Observable observable = this.rxLocationManager.getLastLocation(provider, howOldCanBe).filter((Func1)new Func1<Location, Boolean>(){

            public Boolean call(Location location) {
                if (!isNullValid && location == null) {
                    return false;
                }
                return true;
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends Location>>(){

            public Observable<? extends Location> call(Throwable throwable) {
                if (throwable instanceof ElderLocationException) {
                    return Observable.empty();
                }
                if (throwable instanceof ProviderDisabledException) {
                    return Observable.empty();
                }
                return Observable.error((Throwable)throwable);
            }
        });
        this.observables.add((Observable<Location>)(transformer != null ? observable.compose(transformer) : observable));
        return this;
    }

    public LocationRequestBuilder addLastLocation(@NonNull String provider, @Nullable LocationTime howOldCanBe, boolean isNullValid) {
        return this.addLastLocation(provider, howOldCanBe, isNullValid, null);
    }

    public LocationRequestBuilder addLastLocation(@NonNull String provider, boolean isNullValid) {
        return this.addLastLocation(provider, null, isNullValid);
    }

    public LocationRequestBuilder setDefaultLocation(@Nullable Location defaultLocation) {
        this.defaultLocation = defaultLocation;
        return this;
    }

    public LocationRequestBuilder setReturnDefaultLocationOnError(boolean returnDefaultLocationOnError) {
        this.returnDefaultLocationOnError = returnDefaultLocationOnError;
        return this;
    }

    @NonNull
    public Observable<Location> create() {
        Observable result = Observable.empty();
        for (Observable observable : this.observables) {
            if (result == null) {
                result = observable;
                continue;
            }
            result = result.concatWith(observable.compose((Observable.Transformer)new Observable.Transformer<Location, Location>(){

                public Observable<Location> call(Observable<Location> observable) {
                    return observable.onErrorResumeNext((Func1)new Func1<Throwable, Observable<? extends Location>>(){

                        public Observable<? extends Location> call(Throwable throwable) {
                            if (LocationRequestBuilder.this.returnDefaultLocationOnError) {
                                return Observable.empty();
                            }
                            return Observable.error((Throwable)throwable);
                        }
                    });
                }
            }));
        }
        return result.firstOrDefault((Object)this.defaultLocation).observeOn(this.scheduler);
    }
}

