/*
 * Decompiled with CFR 0.152.
 */
package ru.solodovnikov.rxlocationmanager;

import android.annotation.TargetApi;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ru.solodovnikov.rxlocationmanager.LocationTime;
import ru.solodovnikov.rxlocationmanager.error.ElderLocationException;
import ru.solodovnikov.rxlocationmanager.error.ProviderDisabledException;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;

public class RxLocationManager {
    private final LocationManager locationManager;

    public RxLocationManager(Context context) {
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    RxLocationManager(LocationManager locationManager) {
        this.locationManager = locationManager;
    }

    public Observable<Location> getLastLocation(final @NonNull String provider, final @Nullable LocationTime howOldCanBe) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Location>(){

            public void call(Subscriber<? super Location> subscriber) {
                subscriber.onNext((Object)RxLocationManager.this.locationManager.getLastKnownLocation(provider));
                subscriber.onCompleted();
            }
        }).compose((Observable.Transformer)new Observable.Transformer<Location, Location>(){

            public Observable<Location> call(Observable<Location> locationObservable) {
                Observable<Location> filterObservable = locationObservable.map((Func1)new Func1<Location, Location>(){

                    public Location call(Location location) {
                        if (location != null && !RxLocationManager.this.isLocationNotOld(location, howOldCanBe)) {
                            throw new ElderLocationException(location);
                        }
                        return location;
                    }
                });
                return howOldCanBe != null ? filterObservable : locationObservable;
            }
        }).compose(this.applySchedulers());
    }

    public Observable<Location> getLastLocation(@NonNull String provider) {
        return this.getLastLocation(provider, null);
    }

    public Observable<Location> requestLocation(@NonNull String provider, @Nullable LocationTime timeOut) {
        return this.requestLocation(provider, timeOut, true);
    }

    public Observable<Location> requestLocation(@NonNull String provider) {
        return this.requestLocation(provider, null);
    }

    Observable<Location> requestLocation(@NonNull String provider, final @Nullable LocationTime timeOut, boolean throwExceptionIfDisabled) {
        RxLocationListener locationListener = new RxLocationListener(this.locationManager, provider, throwExceptionIfDisabled);
        return Observable.create((Observable.OnSubscribe)locationListener).compose((Observable.Transformer)new Observable.Transformer<Location, Location>(){

            public Observable<Location> call(Observable<Location> locationObservable) {
                return timeOut != null ? locationObservable.timeout(timeOut.getValue(), timeOut.getTimeUnit()) : locationObservable;
            }
        }).compose(this.applySchedulers());
    }

    private Observable.Transformer<Location, Location> applySchedulers() {
        return new Observable.Transformer<Location, Location>(){

            public Observable<Location> call(Observable<Location> locationObservable) {
                return locationObservable.subscribeOn(AndroidSchedulers.mainThread());
            }
        };
    }

    private boolean isLocationNotOld(Location location, LocationTime howOldCanBe) {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.isLocationNotOld17(location, howOldCanBe);
        }
        return this.isLocationNotOldDefault(location, howOldCanBe);
    }

    @TargetApi(value=17)
    private boolean isLocationNotOld17(Location location, LocationTime howOldCanBe) {
        return SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos() < howOldCanBe.getTimeUnit().toNanos(howOldCanBe.getValue());
    }

    private boolean isLocationNotOldDefault(Location location, LocationTime howOldCanBe) {
        return System.currentTimeMillis() - location.getTime() < howOldCanBe.getTimeUnit().toMillis(howOldCanBe.getValue());
    }

    private static class RxLocationListener
    implements Observable.OnSubscribe<Location> {
        private final LocationManager locationManager;
        private final String provider;
        private final boolean throwExceptionIfDisabled;
        private LocationListener locationListener;

        public RxLocationListener(LocationManager locationManager, String provider, boolean throwExceptionIfDisabled) {
            this.locationManager = locationManager;
            this.provider = provider;
            this.throwExceptionIfDisabled = throwExceptionIfDisabled;
        }

        public void call(final Subscriber<? super Location> subscriber) {
            if (this.locationManager.isProviderEnabled(this.provider)) {
                this.locationListener = new LocationListener(){

                    public void onLocationChanged(Location location) {
                        if (subscriber != null && !subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)location);
                            subscriber.onCompleted();
                        }
                    }

                    public void onStatusChanged(String provider, int status, Bundle extras) {
                    }

                    public void onProviderEnabled(String provider) {
                    }

                    public void onProviderDisabled(String provider) {
                        if (RxLocationListener.this.provider.equals(provider)) {
                            subscriber.onError((Throwable)new ProviderDisabledException(provider));
                        }
                    }
                };
                this.locationManager.requestSingleUpdate(this.provider, this.locationListener, null);
                subscriber.add(new Subscription(){

                    public void unsubscribe() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.unsubscribe();
                        }
                        RxLocationListener.this.removeUpdates();
                    }

                    public boolean isUnsubscribed() {
                        return subscriber.isUnsubscribed();
                    }
                });
            } else if (this.throwExceptionIfDisabled) {
                subscriber.onError((Throwable)new ProviderDisabledException(this.provider));
            } else {
                subscriber.onCompleted();
            }
        }

        void removeUpdates() {
            if (this.locationListener != null) {
                this.locationManager.removeUpdates(this.locationListener);
            }
        }
    }
}

