/*
 * Decompiled with CFR 0.152.
 */
package com.zeeshan.material.multiselectionspinner;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.checkbox.MaterialCheckBox;
import com.google.android.material.textfield.TextInputEditText;
import com.zeeshan.material.multiselectionspinner.R;
import com.zeeshan.material.multiselectionspinner.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MultiSelectionSpinner
extends TextInputEditText {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private static final long POPUP_DISMISS_DELAY = 200L;
    private String mText = "";
    private int defaultHeight = 130;
    private int rightMargin = 10;
    private int POPUP_WINDOW_MAX_HEIGHT_DP = 300;
    private static final int LABEL_ALIGN_CENTER = 0;
    private static final int LABEL_ALIGN_LEFT = 1;
    private int labelAlignment = 0;
    private boolean showSearch = false;
    private PopupWindow popupWindow = null;
    private float SCALE_RATIO = 1.0f;
    private boolean isDisabled = false;
    private boolean sort = true;
    private boolean showClearSelection;
    private List<Object> originalList;
    private List<Object> mSelectedItems;
    private ItemsAdapter itemsAdapter = null;
    private OnItemSelectedListener mOnItemSelectedListener;
    View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!MultiSelectionSpinner.this.isDisabled) {
                MultiSelectionSpinner.this.showPopup();
            }
        }
    };

    public MultiSelectionSpinner(Context context) {
        super(context);
        this.init();
    }

    public MultiSelectionSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.initAttrbs(attrs);
    }

    public MultiSelectionSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initAttrbs(attrs);
    }

    private void initAttrbs(AttributeSet attrs) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.MultiSelectionSpinner, 0, 0);
        try {
            this.showSearch = a.getBoolean(R.styleable.MultiSelectionSpinner_showSearch, false);
            this.labelAlignment = a.getInt(R.styleable.MultiSelectionSpinner_label_alignment, 0);
            this.isDisabled = a.getBoolean(R.styleable.MultiSelectionSpinner_disabled, false);
            this.sort = a.getBoolean(R.styleable.MultiSelectionSpinner_sort, true);
            this.showClearSelection = a.getBoolean(R.styleable.MultiSelectionSpinner_clear_selection, true);
            this.SCALE_RATIO = a.getFloat(R.styleable.MultiSelectionSpinner_width_ratio, 1.0f);
        }
        finally {
            a.recycle();
        }
        this.POPUP_WINDOW_MAX_HEIGHT_DP = Utils.dpToPx(this.getContext(), 300);
    }

    private void init() {
        this.setCursorVisible(false);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        super.setOnClickListener(this.mClickListener);
    }

    public void setOnItemSelectedListener(@Nullable OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    public void setText(String text) {
        super.setText((CharSequence)text);
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public void setOnClickListener(View.OnClickListener l) {
    }

    public void setItems(List objects) {
        this.clear();
        this.originalList = objects;
        if (this.sort && this.originalList != null && this.originalList.size() > 0) {
            Collections.sort(this.originalList, new Comparator<Object>(){

                @Override
                public int compare(Object object1, Object object2) {
                    String str1 = object1.toString();
                    String str2 = object2.toString();
                    if (str1 == null && str2 == null) {
                        return 0;
                    }
                    if (str1 == null && str2 != null) {
                        return -1;
                    }
                    if (str1 != null && str2 == null) {
                        return 1;
                    }
                    return object1.toString().compareTo(object2.toString());
                }
            });
        }
    }

    public void clear() {
        this.mSelectedItems = null;
        this.setText("");
        if (this.originalList != null) {
            this.originalList = null;
        }
        if (this.itemsAdapter != null) {
            this.itemsAdapter = null;
        }
    }

    public List<Object> getSelectedItems() {
        return this.mSelectedItems;
    }

    public void setSelection(int position) {
        this.setSelection(position, false);
    }

    public void setSelection(int position, boolean withCallback) {
        if (this.originalList == null) {
            return;
        }
        if (position < 0) {
            this.setSelection("", withCallback);
            return;
        }
        if (position >= this.originalList.size()) {
            return;
        }
        this.setSelection(this.originalList.get(position), withCallback);
    }

    public void setSelection(Object item) {
        this.setSelection(item, false);
    }

    public void setSelection(Object item, boolean withCallback) {
        if (item == null || this.originalList == null) {
            this.mSelectedItems = null;
            this.setText("");
            if (withCallback && this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected((View)this, false, -1);
            }
        } else {
            if (this.mSelectedItems == null) {
                this.mSelectedItems = new ArrayList<Object>();
            }
            List<Object> tempItem = this.mSelectedItems;
            boolean isSelected = true;
            for (Object i : this.mSelectedItems) {
                if (!i.equals(item)) continue;
                tempItem.remove(i);
                isSelected = false;
                break;
            }
            this.mSelectedItems = tempItem;
            if (isSelected) {
                this.mSelectedItems.add(item);
            }
            int clickedItemPosition = -1;
            for (int i = 0; i < this.originalList.size(); ++i) {
                Object objj = this.originalList.get(i);
                if (!objj.equals(item)) continue;
                clickedItemPosition = i;
                break;
            }
            StringBuilder builder = new StringBuilder();
            if (this.mSelectedItems != null && this.mSelectedItems.size() > 0) {
                builder.append(this.mSelectedItems.get(0));
                if (this.mSelectedItems.size() > 1) {
                    for (int i = 1; i < this.mSelectedItems.size(); ++i) {
                        builder.append(", ").append(this.mSelectedItems.get(i));
                    }
                }
                this.setText(builder);
            } else {
                this.setText("");
            }
            if (withCallback && clickedItemPosition != -1 && this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected((View)this, isSelected, clickedItemPosition);
            }
        }
    }

    private List<Integer> getSelectedItemsPosition() {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        block0: for (int i = 0; i < this.originalList.size(); ++i) {
            Object objj = this.originalList.get(i);
            for (int j = 0; j < this.mSelectedItems.size(); ++j) {
                Object slectedObj = this.mSelectedItems.get(j);
                if (!objj.equals(slectedObj)) continue;
                positions.add(i);
                continue block0;
            }
        }
        return positions;
    }

    private void showPopup() {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.popup_menu, null);
        RecyclerView mRecyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        this.itemsAdapter = new ItemsAdapter(this.originalList == null ? new ArrayList() : this.originalList, this.mOnItemSelectedListener);
        mRecyclerView.setAdapter((RecyclerView.Adapter)this.itemsAdapter);
        final EditText searchBox = (EditText)view.findViewById(R.id.search_field);
        if (this.showSearch) {
            searchBox.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    MultiSelectionSpinner.this.itemsAdapter.getFilter().filter((CharSequence)searchBox.getText().toString());
                }

                public void afterTextChanged(Editable s) {
                }
            });
        } else {
            searchBox.setVisibility(8);
        }
        final View clearSelection = view.findViewById(R.id.clear_selection);
        if (this.showClearSelection && this.mSelectedItems != null && this.mSelectedItems.size() > 0) {
            clearSelection.setVisibility(0);
            clearSelection.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MultiSelectionSpinner.this.mSelectedItems == null) {
                        MultiSelectionSpinner.this.setText("");
                        clearSelection.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                MultiSelectionSpinner.this.popupWindow.dismiss();
                            }
                        }, 200L);
                        return;
                    }
                    MultiSelectionSpinner.this.mSelectedItems = null;
                    MultiSelectionSpinner.this.setText("");
                    clearSelection.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MultiSelectionSpinner.this.popupWindow.dismiss();
                        }
                    }, 200L);
                    if (MultiSelectionSpinner.this.mOnItemSelectedListener != null) {
                        MultiSelectionSpinner.this.mOnItemSelectedListener.onSelectionCleared();
                    }
                }
            });
        } else {
            clearSelection.setVisibility(8);
        }
        this.popupWindow = new PopupWindow(view, (int)((float)this.getWidth() * this.SCALE_RATIO), this.POPUP_WINDOW_MAX_HEIGHT_DP);
        this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setFocusable(true);
        this.popupWindow.setClippingEnabled(true);
        this.popupWindow.update();
        this.popupWindow.showAsDropDown((View)this, 0, 0);
    }

    public void setPopupHeight(int height) {
        this.POPUP_WINDOW_MAX_HEIGHT_DP = height;
    }

    public int spToPx(float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public void setDisabled(boolean flag) {
        this.isDisabled = flag;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public List<Object> getItems() {
        return this.originalList;
    }

    public class ItemsAdapter
    extends RecyclerView.Adapter<ItemViewHolder>
    implements Filterable {
        List<Object> filteredList = new ArrayList<Object>();
        OnItemSelectedListener menuItemClickListener;
        private Filter mFilter;

        public ItemsAdapter(List<Object> objects, OnItemSelectedListener listener) {
            this.filteredList.addAll(objects);
            this.menuItemClickListener = listener;
            this.mFilter = new SearchFilter(this);
        }

        public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = View.inflate((Context)parent.getContext(), (int)R.layout.multi_popup_menu_item, null);
            RecyclerView.LayoutParams lp = new RecyclerView.LayoutParams(-1, -2);
            view.setLayoutParams((ViewGroup.LayoutParams)lp);
            return new ItemViewHolder(view);
        }

        public void onBindViewHolder(ItemViewHolder holder, int position) {
            holder.mTextView.setText((CharSequence)this.filteredList.get(position).toString());
            if (MultiSelectionSpinner.this.mSelectedItems != null) {
                boolean isSelected = false;
                for (Object selectedItem : MultiSelectionSpinner.this.mSelectedItems) {
                    if (!selectedItem.equals(this.filteredList.get(position))) continue;
                    isSelected = true;
                    break;
                }
                int[][] states = new int[][]{{16842910}, {-16842910}, {-16842912}, {16842919}};
                if (isSelected) {
                    if (ContextCompat.getColor((Context)MultiSelectionSpinner.this.getContext(), (int)R.color.colorAccent) != 0) {
                        holder.mTextView.setTextColor(ContextCompat.getColor((Context)MultiSelectionSpinner.this.getContext(), (int)R.color.colorAccent));
                        int colorValue = ContextCompat.getColor((Context)MultiSelectionSpinner.this.getContext(), (int)R.color.colorAccent);
                        int[] colors = new int[]{colorValue, colorValue, colorValue, colorValue};
                        ColorStateList myList = new ColorStateList((int[][])states, colors);
                        holder.checkBox.setButtonTintList(myList);
                    } else {
                        holder.mTextView.setTextColor(ContextCompat.getColor((Context)MultiSelectionSpinner.this.getContext(), (int)R.color.colorPrimary));
                        int colorValue = ContextCompat.getColor((Context)MultiSelectionSpinner.this.getContext(), (int)R.color.colorPrimary);
                        int[] colors = new int[]{colorValue, colorValue, colorValue, colorValue};
                        ColorStateList myList = new ColorStateList((int[][])states, colors);
                        holder.checkBox.setButtonTintList(myList);
                    }
                } else {
                    holder.mTextView.setTextColor(-16777216);
                    int[] colors = new int[]{-16777216, -16777216, -16777216, -16777216};
                    ColorStateList myList = new ColorStateList((int[][])states, colors);
                    holder.checkBox.setButtonTintList(myList);
                }
                holder.checkBox.setChecked(isSelected);
            }
        }

        public int getItemCount() {
            return this.filteredList == null ? 0 : this.filteredList.size();
        }

        public Filter getFilter() {
            return this.mFilter;
        }

        public void setList(List<Object> list) {
            this.filteredList = list;
        }

        public void addItem(Object obj) {
            if (this.filteredList == null) {
                this.filteredList = new ArrayList<Object>();
            }
            this.filteredList.add(obj);
            this.notifyDataSetChanged();
        }

        public void addItem(Object obj, int position) {
            if (this.filteredList == null) {
                this.filteredList = new ArrayList<Object>();
            }
            this.filteredList.add(position, obj);
            this.notifyDataSetChanged();
        }

        public List<Object> getList() {
            return this.filteredList;
        }

        public void clear() {
            if (this.filteredList != null) {
                this.filteredList.clear();
                this.notifyDataSetChanged();
            }
        }

        public class SearchFilter
        extends Filter {
            ItemsAdapter mAdapter;

            public SearchFilter(ItemsAdapter adapter) {
                this.mAdapter = adapter;
            }

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                ArrayList values = new ArrayList();
                Filter.FilterResults results = new Filter.FilterResults();
                if (constraint.length() == 0) {
                    values.addAll(MultiSelectionSpinner.this.originalList);
                } else {
                    for (Object item : MultiSelectionSpinner.this.originalList) {
                        if (!item.toString().toLowerCase().contains(constraint.toString().toLowerCase())) continue;
                        values.add(item);
                    }
                }
                results.values = values;
                results.count = values.size();
                return results;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                this.mAdapter.setList((List)results.values);
                this.mAdapter.notifyDataSetChanged();
            }
        }

        public class ItemViewHolder
        extends RecyclerView.ViewHolder {
            View parent;
            TextView mTextView;
            MaterialCheckBox checkBox;

            public ItemViewHolder(View itemView) {
                super(itemView);
                this.parent = itemView;
                this.mTextView = (TextView)this.parent.findViewById(R.id.popup_item_title);
                this.checkBox = (MaterialCheckBox)this.parent.findViewById(R.id.popup_item_checked);
                if (MultiSelectionSpinner.this.labelAlignment != 0 && MultiSelectionSpinner.this.labelAlignment == 1) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                    params.addRule(15, -1);
                    params.addRule(9);
                    params.leftMargin = Utils.dpToPx(MultiSelectionSpinner.this.getContext(), 5);
                    this.mTextView.setLayoutParams((ViewGroup.LayoutParams)params);
                }
                this.checkBox.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ItemViewHolder.this.parent.performClick();
                        ItemsAdapter.this.notifyDataSetChanged();
                    }
                });
                this.parent.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ItemViewHolder.this.onSelectionChange();
                        ItemsAdapter.this.notifyDataSetChanged();
                    }
                });
            }

            private void onSelectionChange() {
                MultiSelectionSpinner.this.setSelection(MultiSelectionSpinner.this.originalList.indexOf(ItemsAdapter.this.filteredList.get(this.getAdapterPosition())), true);
            }
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(View var1, boolean var2, int var3);

        public void onSelectionCleared();
    }
}

