/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import androidx.annotation.StyleRes;
import androidx.appcompat.R;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.AppCompatPopupWindow;
import androidx.core.widget.PopupWindowCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.github.zawadz88.materialpopupmenu.R;
import com.github.zawadz88.materialpopupmenu.internal.PopupMenuAdapter;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010 \u001a\u00020\u0005H\u0002J\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u0010/\u001a\u00020\"2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u000101J\u0010\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020)H\u0002J\u0006\u00104\u001a\u00020\"R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Landroidx/appcompat/widget/MaterialRecyclerViewPopupWindow;", "", "context", "Landroid/content/Context;", "dropDownGravity", "", "defStyleRes", "(Landroid/content/Context;II)V", "value", "Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;", "adapter", "getAdapter$material_popup_menu_release", "()Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;", "setAdapter$material_popup_menu_release", "(Lcom/github/zawadz88/materialpopupmenu/internal/PopupMenuAdapter;)V", "anchorView", "Landroid/view/View;", "getAnchorView$material_popup_menu_release", "()Landroid/view/View;", "setAnchorView$material_popup_menu_release", "(Landroid/view/View;)V", "contextThemeWrapper", "dropDownHorizontalOffset", "dropDownVerticalOffset", "dropDownWidth", "popup", "Landroid/widget/PopupWindow;", "popupMaxWidth", "popupMinWidth", "popupWidthUnit", "tempRect", "Landroid/graphics/Rect;", "buildDropDown", "dismiss", "", "generateDefaultLayoutParams", "Landroidx/recyclerview/widget/RecyclerView$LayoutParams;", "getMaxAvailableHeight", "anchor", "yOffset", "ignoreBottomDecorations", "", "measureHeightOfChildrenCompat", "maxHeight", "measureIndividualMenuWidth", "setContentWidth", "width", "setOnDismissListener", "listener", "Lkotlin/Function0;", "setPopupClipToScreenEnabled", "clip", "show", "Companion", "material-popup-menu_release"})
@SuppressLint(value={"PrivateResource,RestrictedApi"})
public final class MaterialRecyclerViewPopupWindow {
    @Nullable
    private View anchorView;
    @Nullable
    private PopupMenuAdapter adapter;
    private int dropDownWidth;
    private int dropDownVerticalOffset;
    private int dropDownHorizontalOffset;
    private final Rect tempRect;
    private final PopupWindow popup;
    private final int popupMaxWidth;
    private final int popupMinWidth;
    private final int popupWidthUnit;
    private final Context contextThemeWrapper;
    private int dropDownGravity;
    private static final String TAG = "MaterialRVPopupWindow";
    private static Method sClipToWindowEnabledMethod;
    private static Method sGetMaxAvailableHeightMethod;
    public static final Companion Companion;

    @Nullable
    public final View getAnchorView$material_popup_menu_release() {
        return this.anchorView;
    }

    public final void setAnchorView$material_popup_menu_release(@Nullable View view) {
        this.anchorView = view;
    }

    @Nullable
    public final PopupMenuAdapter getAdapter$material_popup_menu_release() {
        return this.adapter;
    }

    public final void setAdapter$material_popup_menu_release(@Nullable PopupMenuAdapter value) {
        MaterialRecyclerViewPopupWindow materialRecyclerViewPopupWindow = this;
        MaterialRecyclerViewPopupWindow materialRecyclerViewPopupWindow2 = this;
        if (value == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PopupMenuAdapter popupMenuAdapter = value;
        materialRecyclerViewPopupWindow2.setContentWidth(materialRecyclerViewPopupWindow.measureIndividualMenuWidth(popupMenuAdapter));
        this.adapter = value;
    }

    private final void setContentWidth(int width) {
        int n;
        Drawable popupBackground = this.popup.getBackground();
        if (popupBackground != null) {
            popupBackground.getPadding(this.tempRect);
            n = this.tempRect.left + this.tempRect.right + width;
        } else {
            n = width;
        }
        this.dropDownWidth = n;
    }

    public final void show() {
        View view = this.anchorView;
        if (view == null) {
            String string = "Anchor view must be set!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int height = this.buildDropDown();
        PopupWindowCompat.setWindowLayoutType((PopupWindow)this.popup, (int)1002);
        int widthSpec = this.dropDownWidth;
        if (this.popup.isShowing()) {
            this.popup.setOutsideTouchable(true);
            this.popup.update(this.anchorView, this.dropDownHorizontalOffset, this.dropDownVerticalOffset, widthSpec, height < 0 ? -1 : height);
        } else {
            this.popup.setWidth(widthSpec);
            this.popup.setHeight(height);
            this.setPopupClipToScreenEnabled(true);
            this.popup.setOutsideTouchable(true);
            View view2 = this.anchorView;
            if (view2 == null) {
                Intrinsics.throwNpe();
            }
            PopupWindowCompat.showAsDropDown((PopupWindow)this.popup, (View)view2, (int)this.dropDownHorizontalOffset, (int)this.dropDownVerticalOffset, (int)this.dropDownGravity);
        }
    }

    public final void dismiss() {
        this.popup.dismiss();
        this.popup.setContentView((View)null);
    }

    public final void setOnDismissListener(@Nullable Function0<Unit> listener) {
        if (listener != null) {
            this.popup.setOnDismissListener(new PopupWindow.OnDismissListener(listener){
                final /* synthetic */ Function0 $listener;

                public final void onDismiss() {
                    this.$listener.invoke();
                }
                {
                    this.$listener = function0;
                }
            });
        } else {
            this.popup.setOnDismissListener(null);
        }
    }

    private final int buildDropDown() {
        int maxHeight;
        int listContent;
        int padding;
        int otherHeights = 0;
        View view = View.inflate((Context)this.contextThemeWrapper, (int)R.layout.mpm_popup_menu, null);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView");
        }
        RecyclerView dropDownList = (RecyclerView)view;
        dropDownList.setAdapter((RecyclerView.Adapter)this.adapter);
        dropDownList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.contextThemeWrapper));
        dropDownList.setFocusable(true);
        dropDownList.setFocusableInTouchMode(true);
        this.popup.setContentView((View)dropDownList);
        Drawable background = this.popup.getBackground();
        if (background != null) {
            background.getPadding(this.tempRect);
            padding = this.tempRect.top + this.tempRect.bottom;
            this.dropDownVerticalOffset -= this.tempRect.top;
        } else {
            this.tempRect.setEmpty();
            padding = 0;
        }
        if ((this.dropDownGravity & 0x50) == 80) {
            View view2 = this.anchorView;
            if (view2 == null) {
                Intrinsics.throwNpe();
            }
            this.dropDownVerticalOffset += view2.getHeight();
        }
        boolean ignoreBottomDecorations = this.popup.getInputMethodMode() == 2;
        View view3 = this.anchorView;
        if (view3 == null) {
            Intrinsics.throwNpe();
        }
        if ((listContent = this.measureHeightOfChildrenCompat((maxHeight = this.getMaxAvailableHeight(view3, this.dropDownVerticalOffset, ignoreBottomDecorations)) - otherHeights)) > 0) {
            int listPadding = dropDownList.getPaddingTop() + dropDownList.getPaddingBottom();
            otherHeights += padding + listPadding;
        }
        return listContent + otherHeights;
    }

    /*
     * WARNING - void declaration
     */
    private final int measureHeightOfChildrenCompat(int maxHeight) {
        FrameLayout parent = new FrameLayout(this.contextThemeWrapper);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int returnedHeight = 0;
        PopupMenuAdapter popupMenuAdapter = this.adapter;
        int count = popupMenuAdapter != null ? popupMenuAdapter.getItemCount() : 0;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            View itemView;
            void i;
            PopupMenuAdapter popupMenuAdapter2 = this.adapter;
            if (popupMenuAdapter2 == null) {
                Intrinsics.throwNpe();
            }
            int positionType = popupMenuAdapter2.getItemViewType((int)i);
            PopupMenuAdapter popupMenuAdapter3 = this.adapter;
            if (popupMenuAdapter3 == null) {
                Intrinsics.throwNpe();
            }
            RecyclerView.ViewHolder vh = popupMenuAdapter3.createViewHolder((ViewGroup)parent, positionType);
            PopupMenuAdapter popupMenuAdapter4 = this.adapter;
            if (popupMenuAdapter4 == null) {
                Intrinsics.throwNpe();
            }
            popupMenuAdapter4.bindViewHolder(vh, (int)i);
            View view = itemView = vh.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            ViewGroup.LayoutParams childLp = view.getLayoutParams();
            if (childLp == null) {
                childLp = (ViewGroup.LayoutParams)this.generateDefaultLayoutParams();
                itemView.setLayoutParams(childLp);
            }
            int heightMeasureSpec = childLp.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)childLp.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            if ((returnedHeight += itemView.getMeasuredHeight()) >= maxHeight) {
                return maxHeight;
            }
            ++i;
        }
        return returnedHeight;
    }

    private final RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-1, -2);
    }

    private final void setPopupClipToScreenEnabled(boolean clip) {
        block2: {
            Method method;
            Method method2 = sClipToWindowEnabledMethod;
            if (method2 == null) break block2;
            Method it = method = method2;
            try {
                Object object = it.invoke((Object)this.popup, clip);
            }
            catch (Exception e) {
                Integer n = Log.i((String)TAG, (String)"Could not call setClipToScreenEnabled() on PopupWindow. Oh well.");
            }
        }
    }

    private final int getMaxAvailableHeight(View anchor, int yOffset, boolean ignoreBottomDecorations) {
        Method method = sGetMaxAvailableHeightMethod;
        if (method != null) {
            Method method2;
            Method it = method2 = method;
            try {
                Object object = it.invoke((Object)this.popup, anchor, yOffset, ignoreBottomDecorations);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                return (Integer)object;
            }
            catch (Exception e) {
                int n = Log.i((String)TAG, (String)"Could not call getMaxAvailableHeightMethod(View, int, boolean) on PopupWindow. Using the public version.");
            }
        }
        return this.popup.getMaxAvailableHeight(anchor, yOffset);
    }

    /*
     * WARNING - void declaration
     */
    private final int measureIndividualMenuWidth(PopupMenuAdapter adapter2) {
        adapter2.setupIndices();
        FrameLayout parent = new FrameLayout(this.contextThemeWrapper);
        int menuWidth = this.popupMinWidth;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter2.getItemCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            int positionType = adapter2.getItemViewType((int)i);
            RecyclerView.ViewHolder vh = adapter2.createViewHolder((ViewGroup)parent, positionType);
            adapter2.bindViewHolder(vh, (int)i);
            View itemView = vh.itemView;
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            View view = itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
            int itemWidth = view.getMeasuredWidth();
            if (itemWidth >= this.popupMaxWidth) {
                return this.popupMaxWidth;
            }
            if (itemWidth > menuWidth) {
                menuWidth = itemWidth;
            }
            ++i;
        }
        menuWidth = (int)Math.ceil((double)menuWidth / (double)this.popupWidthUnit) * this.popupWidthUnit;
        return menuWidth;
    }

    public MaterialRecyclerViewPopupWindow(@NotNull Context context, int dropDownGravity, @StyleRes int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.dropDownGravity = dropDownGravity;
        this.dropDownWidth = -2;
        this.tempRect = new Rect();
        this.contextThemeWrapper = (Context)new ContextThemeWrapper(context, null);
        this.contextThemeWrapper.setTheme(defStyleRes);
        this.popup = (PopupWindow)new AppCompatPopupWindow(this.contextThemeWrapper, null, 0, defStyleRes);
        ((AppCompatPopupWindow)this.popup).setInputMethodMode(1);
        ((AppCompatPopupWindow)this.popup).setFocusable(true);
        this.popupMaxWidth = ((ContextThemeWrapper)this.contextThemeWrapper).getResources().getDimensionPixelSize(R.dimen.mpm_popup_menu_max_width);
        this.popupMinWidth = ((ContextThemeWrapper)this.contextThemeWrapper).getResources().getDimensionPixelSize(R.dimen.mpm_popup_menu_min_width);
        this.popupWidthUnit = ((ContextThemeWrapper)this.contextThemeWrapper).getResources().getDimensionPixelSize(R.dimen.mpm_popup_menu_width_unit);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.ListPopupWindow, 0, defStyleRes);
        this.dropDownHorizontalOffset = a.getDimensionPixelOffset(R.styleable.ListPopupWindow_android_dropDownHorizontalOffset, 0);
        this.dropDownVerticalOffset = a.getDimensionPixelOffset(R.styleable.ListPopupWindow_android_dropDownVerticalOffset, 0);
        a.recycle();
    }

    static {
        Companion = new Companion(null);
        try {
            sClipToWindowEnabledMethod = PopupWindow.class.getDeclaredMethod("setClipToScreenEnabled", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            Log.i((String)TAG, (String)"Could not find method setClipToScreenEnabled() on PopupWindow. Oh well.");
        }
        try {
            sGetMaxAvailableHeightMethod = PopupWindow.class.getDeclaredMethod("getMaxAvailableHeight", View.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            Log.i((String)TAG, (String)"Could not find method getMaxAvailableHeight(View, int, boolean) on PopupWindow. Oh well.");
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/appcompat/widget/MaterialRecyclerViewPopupWindow$Companion;", "", "()V", "TAG", "", "sClipToWindowEnabledMethod", "Ljava/lang/reflect/Method;", "sGetMaxAvailableHeightMethod", "material-popup-menu_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

