/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.io;

import com.zakgof.tools.io.ISimpleSerializer;
import com.zakgof.tools.io.SimpleInputStream;
import com.zakgof.tools.io.SimpleOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

public class SimpleEnumSetSerializer<T extends Enum<T>>
implements ISimpleSerializer<EnumSet<T>> {
    private Class<T> clazz;

    public SimpleEnumSetSerializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void write(SimpleOutputStream out, EnumSet<T> val) throws IOException {
        out.write(val.size());
        for (Enum t : val) {
            out.write(t.ordinal());
        }
    }

    @Override
    public EnumSet<T> read(SimpleInputStream in) throws IOException {
        int len = in.readInt();
        ArrayList<Enum> l = new ArrayList<Enum>(len);
        for (int i = 0; i < len; ++i) {
            l.add(((Enum[])this.clazz.getEnumConstants())[in.readInt()]);
        }
        return EnumSet.copyOf(l);
    }
}

