/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.io;

import com.zakgof.tools.generic.IFunction2;
import com.zakgof.tools.generic.IFunction3;
import com.zakgof.tools.generic.IFunction4;
import com.zakgof.tools.generic.Pair;
import com.zakgof.tools.io.ISimpleSerializer;
import com.zakgof.tools.io.SimpleCollectionSerializer;
import com.zakgof.tools.io.SimpleInputStream;
import com.zakgof.tools.io.SimpleIntegerSerializer;
import com.zakgof.tools.io.SimpleOutputStream;
import com.zakgof.tools.io.SimpleStringSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Serializers {
    public static <K, V> ISimpleSerializer<Pair<K, V>> pair(ISimpleSerializer<K> keyser, ISimpleSerializer<V> valser) {
        return Serializers.fields(Pair::first, Pair::second, keyser, valser, Pair::create);
    }

    public static <A, E> ISimpleSerializer<A> collection(final Function<A, Collection<E>> writer, final Function<Collection<E>, A> reader, final ISimpleSerializer<E> elementSerializer) {
        return new ISimpleSerializer<A>(){

            @Override
            public void write(SimpleOutputStream out, A val) throws IOException {
                Collection elements = (Collection)writer.apply(val);
                out.write(elements.size());
                for (Object element : elements) {
                    elementSerializer.write(out, element);
                }
            }

            @Override
            public A read(SimpleInputStream in) throws IOException {
                int length = in.readInt();
                ArrayList elements = new ArrayList();
                for (int i = 0; i < length; ++i) {
                    Object element = elementSerializer.read(in);
                    elements.add(element);
                }
                return reader.apply(elements);
            }
        };
    }

    public static <A, F1> ISimpleSerializer<A> fields(final Function<A, F1> getter1, final ISimpleSerializer<F1> serializer1, final Function<F1, A> constructor) {
        return new ISimpleSerializer<A>(){

            @Override
            public void write(SimpleOutputStream out, A val) throws IOException {
                serializer1.write(out, getter1.apply(val));
            }

            @Override
            public A read(SimpleInputStream in) throws IOException {
                Object field1 = serializer1.read(in);
                return constructor.apply(field1);
            }
        };
    }

    public static <A, F1, F2> ISimpleSerializer<A> fields(final Function<A, F1> getter1, final Function<A, F2> getter2, final ISimpleSerializer<F1> serializer1, final ISimpleSerializer<F2> serializer2, final IFunction2<F1, F2, A> constructor) {
        return new ISimpleSerializer<A>(){

            @Override
            public void write(SimpleOutputStream out, A val) throws IOException {
                serializer1.write(out, getter1.apply(val));
                serializer2.write(out, getter2.apply(val));
            }

            @Override
            public A read(SimpleInputStream in) throws IOException {
                Object field1 = serializer1.read(in);
                Object field2 = serializer2.read(in);
                return constructor.get(field1, field2);
            }
        };
    }

    public static <A, F1, F2, F3> ISimpleSerializer<A> fields(final Function<A, F1> getter1, final Function<A, F2> getter2, final Function<A, F3> getter3, final ISimpleSerializer<F1> serializer1, final ISimpleSerializer<F2> serializer2, final ISimpleSerializer<F3> serializer3, final IFunction3<F1, F2, F3, A> constructor) {
        return new ISimpleSerializer<A>(){

            @Override
            public void write(SimpleOutputStream out, A val) throws IOException {
                serializer1.write(out, getter1.apply(val));
                serializer2.write(out, getter2.apply(val));
                serializer3.write(out, getter3.apply(val));
            }

            @Override
            public A read(SimpleInputStream in) throws IOException {
                Object field1 = serializer1.read(in);
                Object field2 = serializer2.read(in);
                Object field3 = serializer3.read(in);
                return constructor.get(field1, field2, field3);
            }
        };
    }

    public static <A, F1, F2, F3, F4> ISimpleSerializer<A> fields(final Function<A, F1> getter1, final Function<A, F2> getter2, final Function<A, F3> getter3, final Function<A, F4> getter4, final ISimpleSerializer<F1> serializer1, final ISimpleSerializer<F2> serializer2, final ISimpleSerializer<F3> serializer3, final ISimpleSerializer<F4> serializer4, final IFunction4<F1, F2, F3, F4, A> constructor) {
        return new ISimpleSerializer<A>(){

            @Override
            public void write(SimpleOutputStream out, A val) throws IOException {
                serializer1.write(out, getter1.apply(val));
                serializer2.write(out, getter2.apply(val));
                serializer3.write(out, getter3.apply(val));
                serializer4.write(out, getter4.apply(val));
            }

            @Override
            public A read(SimpleInputStream in) throws IOException {
                Object field1 = serializer1.read(in);
                Object field2 = serializer2.read(in);
                Object field3 = serializer3.read(in);
                Object field4 = serializer4.read(in);
                return constructor.get(field1, field2, field3, field4);
            }
        };
    }

    public static <T> ISimpleSerializer<Collection<T>> collection(ISimpleSerializer<T> elementSerializer) {
        return new SimpleCollectionSerializer(elementSerializer);
    }

    public static <T> PolymorhSerializedBuilder<T> polymorph() {
        return new PolymorhSerializedBuilder();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private List<Pair<Function<T, ?>, ISimpleSerializer<?>>> list = new ArrayList();

        public <F> Builder<T> getter(Function<T, ? extends F> getter, ISimpleSerializer<? extends F> serializer) {
            this.list.add(Pair.create(getter, serializer));
            return this;
        }

        public Builder<T> intGetter(Function<T, Integer> getter) {
            return this.getter(getter, SimpleIntegerSerializer.INSTANCE);
        }

        public Builder<T> stringGetter(Function<T, String> getter) {
            return this.getter(getter, SimpleStringSerializer.INSTANCE);
        }

        public ISimpleSerializer<T> constructor(final Function<Object[], T> constructor) {
            return new ISimpleSerializer<T>(){

                @Override
                public void write(SimpleOutputStream out, T val) throws IOException {
                    for (Pair entry : list) {
                        Object field = ((Function)entry.first()).apply(val);
                        ((ISimpleSerializer)entry.second()).write(out, field);
                    }
                }

                @Override
                public T read(SimpleInputStream in) throws IOException {
                    Object[] args = new Object[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        args[i] = ((ISimpleSerializer)((Pair)list.get(i)).second()).read(in);
                    }
                    return constructor.apply(args);
                }
            };
        }
    }

    public static class PolymorhSerializedBuilder<T> {
        private Map<String, ISimpleSerializer<? extends T>> map = new HashMap<String, ISimpleSerializer<? extends T>>();

        public <I extends T> PolymorhSerializedBuilder<T> impl(Class<I> implClass, ISimpleSerializer<? extends T> implSerializer) {
            this.map.put(implClass.getName(), implSerializer);
            return this;
        }

        public ISimpleSerializer<T> done() {
            return new ISimpleSerializer<T>(){

                @Override
                public void write(SimpleOutputStream out, T val) throws IOException {
                    Class<?> implClass = val.getClass();
                    String classname = implClass.getName();
                    out.write(classname);
                    ISimpleSerializer serializer = (ISimpleSerializer)map.get(implClass.getName());
                    serializer.write(out, val);
                }

                @Override
                public T read(SimpleInputStream in) throws IOException {
                    String className = in.readString();
                    return ((ISimpleSerializer)map.get(className)).read(in);
                }
            };
        }
    }
}

