/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;

public class Utils {
    private static final String[] RU_SHORT_WEEKDAYS = new String[]{"\u041f\u043d", "\u0412\u0442", "\u0421\u0440", "\u0427\u0442", "\u041f\u0442", "\u0421\u0431", "\u0412\u0441"};

    public static String rudate(LocalDate date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String string = formatter.format(date);
        return string;
    }

    public static String rutime(LocalTime time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        String string = formatter.format(time);
        return string;
    }

    public static String rushortweek(LocalDate date) {
        int d = date.get(ChronoField.DAY_OF_WEEK) - 1;
        return RU_SHORT_WEEKDAYS[d];
    }

    public static String rudate(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        String string = formatter.format(dateTime);
        return string;
    }

    public static String shorten(String orig, int limit) {
        if (orig.length() < limit) {
            return orig;
        }
        return orig.substring(0, limit - 3) + "...";
    }

    public static String fixfloat(float value, int digits) {
        return String.format(String.format("%%.%df", digits), Float.valueOf(value));
    }

    public static String weight(float value) {
        if (value == 0.0f) {
            return "?";
        }
        if (Math.abs((double)value - Math.floor(value)) < 0.01) {
            return String.format("%.0f", Math.floor(value));
        }
        return String.format("%.1f", Float.valueOf(value));
    }

    public static Float parseFloat(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(s.replace(',', '.')));
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    public static LocalDate parseDate(String date) {
        try {
            return LocalDate.parse(date, DateTimeFormatter.ofPattern("d.MM.yyyy"));
        }
        catch (Exception e) {
            return null;
        }
    }
}

