/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class CacheMap<K, V> {
    private final Map<K, V> cache = new HashMap();
    private final Queue<K> usage = new LinkedList<K>();
    private final int maxSize;

    public CacheMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
        this.usage.remove(key);
        this.usage.add(key);
        while (this.cache.size() > this.maxSize) {
            K expired = this.usage.poll();
            this.cache.remove(expired);
        }
    }

    public V get(K key) {
        this.usage.remove(key);
        this.usage.add(key);
        return this.cache.get(key);
    }
}

