/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.serialize;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.zakgof.serialize.ClassStructure;
import com.zakgof.serialize.IFixer;
import com.zakgof.serialize.ISerializer;
import com.zakgof.serialize.IUpgrader;
import com.zakgof.serialize.ZeSerializerException;
import com.zakgof.tools.io.ISimpleSerializer;
import com.zakgof.tools.io.SimpleBooleanSerializer;
import com.zakgof.tools.io.SimpleByteArraySerializer;
import com.zakgof.tools.io.SimpleByteSerializer;
import com.zakgof.tools.io.SimpleClassSerializer;
import com.zakgof.tools.io.SimpleDateSerializer;
import com.zakgof.tools.io.SimpleDoubleSerializer;
import com.zakgof.tools.io.SimpleFloatSerializer;
import com.zakgof.tools.io.SimpleInputStream;
import com.zakgof.tools.io.SimpleIntegerSerializer;
import com.zakgof.tools.io.SimpleLongSerializer;
import com.zakgof.tools.io.SimpleOutputStream;
import com.zakgof.tools.io.SimpleShortSerializer;
import com.zakgof.tools.io.SimpleStringSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ZeSerializer
implements ISerializer {
    private Map<Wrap, Integer> knownObjects = new HashMap<Wrap, Integer>();
    private List<Object> knownObjectList = new ArrayList<Object>();
    private IUpgrader upgrader;
    private static final Objenesis objenesis = new ObjenesisStd();
    private boolean upgradeHappened;
    private final FieldSerializer fieldSerializer = new FieldSerializer();
    private final ArraySerializer arraySerializer = new ArraySerializer();
    private final PojoSerializer pojoSerializer = new PojoSerializer();
    private static final Map<Class<?>, ISimpleSerializer<?>> serializers = new HashMap();
    private static final Map<Class<?>, ICompositeSerializer<?>> compositeSerializers = new HashMap();
    private static final BiMap<String, Byte> classes = HashBiMap.create();

    @Override
    public <T> byte[] serialize(T object, Class<T> clazz) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            this.serialize(object, baos, clazz);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ZeSerializerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void serialize(T object, OutputStream os, Class<T> clazz) throws IOException {
        try {
            SimpleOutputStream sos = new SimpleOutputStream(os);
            this.fieldSerializer.write(object, clazz, sos);
        }
        finally {
            this.knownObjectList.clear();
            this.knownObjects.clear();
        }
    }

    @Override
    public <T> T deserialize(InputStream is, Class<T> clazz) {
        try {
            this.upgradeHappened = false;
            SimpleInputStream sis = new SimpleInputStream(is);
            Object object = this.fieldSerializer.read(sis, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.knownObjectList.clear();
            this.knownObjects.clear();
        }
    }

    @Override
    public void setUpgrader(IUpgrader upgrader) {
        this.upgrader = upgrader;
    }

    public boolean wasUpgraded() {
        return this.upgradeHappened;
    }

    public static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] declaredFields = type.getDeclaredFields();
        Arrays.sort(declaredFields, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            fields.add(field);
        }
        if (type.getSuperclass() != null) {
            fields.addAll(ZeSerializer.getAllFields(type.getSuperclass()));
        }
        return fields;
    }

    public static Field findSerializableField(Class<? extends Object> clazz, String name, Class<?> fieldType) {
        block3: {
            try {
                Field field = clazz.getDeclaredField(name);
                if ((field.getModifiers() & 0x88) == 0 && fieldType.equals(field.getType())) {
                    return field;
                }
            }
            catch (NoSuchFieldException e) {
                Class<? extends Object> parent = clazz.getSuperclass();
                if (parent == null) break block3;
                return ZeSerializer.findSerializableField(parent, name, fieldType);
            }
        }
        return null;
    }

    private <T> T instantiate(Class<T> clazz) throws ReflectiveOperationException, SecurityException {
        T instance = this.createObject(clazz);
        if (!clazz.isPrimitive()) {
            this.rememberObject(instance);
        }
        return instance;
    }

    private void rememberObject(Object instance) {
        if (!this.knownObjects.containsKey(new Wrap(instance))) {
            this.knownObjectList.add(instance);
            this.knownObjects.put(new Wrap(instance), this.knownObjectList.size() - 1);
        }
    }

    private <T> T createObject(Class<T> clazz) throws ReflectiveOperationException, SecurityException {
        if (objenesis != null) {
            return (T)objenesis.getInstantiatorOf(clazz).newInstance();
        }
        return clazz.newInstance();
    }

    private static Object instantiateUsingNoArgCtor(Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> noArgConsructor = clazz.getDeclaredConstructor(new Class[0]);
        noArgConsructor.setAccessible(true);
        return noArgConsructor.newInstance(new Object[0]);
    }

    private static Class<?> parseClassName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ZeSerializerException("Cannot find class " + className);
        }
    }

    @Override
    public List<Field> getFields(Class<?> clazz) {
        return ZeSerializer.getAllFields(clazz);
    }

    static {
        serializers.put(Byte.TYPE, SimpleByteSerializer.INSTANCE);
        serializers.put(Short.TYPE, SimpleShortSerializer.INSTANCE);
        serializers.put(Integer.TYPE, SimpleIntegerSerializer.INSTANCE);
        serializers.put(Long.TYPE, SimpleLongSerializer.INSTANCE);
        serializers.put(Float.TYPE, SimpleFloatSerializer.INSTANCE);
        serializers.put(Double.TYPE, SimpleDoubleSerializer.INSTANCE);
        serializers.put(Boolean.TYPE, SimpleBooleanSerializer.INSTANCE);
        serializers.put(Byte.class, SimpleByteSerializer.INSTANCE);
        serializers.put(Short.class, SimpleShortSerializer.INSTANCE);
        serializers.put(Integer.class, SimpleIntegerSerializer.INSTANCE);
        serializers.put(Long.class, SimpleLongSerializer.INSTANCE);
        serializers.put(Float.class, SimpleFloatSerializer.INSTANCE);
        serializers.put(Double.class, SimpleDoubleSerializer.INSTANCE);
        serializers.put(Boolean.class, SimpleBooleanSerializer.INSTANCE);
        serializers.put(String.class, SimpleStringSerializer.INSTANCE);
        serializers.put(Date.class, SimpleDateSerializer.INSTANCE);
        serializers.put(byte[].class, SimpleByteArraySerializer.INSTANCE);
        serializers.put(Class.class, SimpleClassSerializer.INSTANCE);
        compositeSerializers.put(HashMap.class, new MapSerializer<HashMap>(HashMap::new));
        compositeSerializers.put(LinkedHashMap.class, new MapSerializer<LinkedHashMap>(LinkedHashMap::new));
        compositeSerializers.put(ArrayList.class, new CollectionSerializer());
        compositeSerializers.put(HashSet.class, new CollectionSerializer());
        classes.put((Object)"java.util.HashMap", (Object)1);
        classes.put((Object)"java.util.ArrayList", (Object)2);
        classes.put((Object)"java.util.RegularEnumSet", (Object)3);
        classes.put((Object)"java.util.LinkedList", (Object)4);
        classes.put((Object)"java.util.HashSet", (Object)5);
        classes.put((Object)"java.util.TreeMap", (Object)6);
        classes.put((Object)"java.util.TreeSet", (Object)7);
    }

    private class EnumSerializer<T extends Enum<T>> {
        private Class<T> clazz;

        public EnumSerializer(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void write(SimpleOutputStream out, T val) throws IOException {
            out.write(((Enum)val).ordinal());
        }

        public T read(SimpleInputStream in, byte classVersion) throws IOException {
            if (ZeSerializer.this.upgrader != null && ZeSerializer.this.upgrader.getCurrentVersionOf(this.clazz) != classVersion) {
                ClassStructure cs = ZeSerializer.this.upgrader.getStructureFor(this.clazz, classVersion);
                if (cs == null) {
                    throw new ZeSerializerException("Upgrader cannot provide " + this.clazz.getName() + " ver." + classVersion);
                }
                String name = cs.getEnumLabel(in.readInt());
                return Enum.valueOf(this.clazz, name);
            }
            return (T)((Enum[])this.clazz.getEnumConstants())[in.readInt()];
        }
    }

    private static class Wrap {
        private Object object;

        public Wrap(Object object) {
            this.object = object;
        }

        public int hashCode() {
            return System.identityHashCode(this.object) + 5;
        }

        public boolean equals(Object that) {
            return this.object == ((Wrap)that).object;
        }
    }

    private static class CollectionSerializer<T extends Collection>
    implements ICompositeSerializer<T> {
        private CollectionSerializer() {
        }

        @Override
        public void write(T val, Class<? extends T> clazz, SimpleOutputStream sos, IFieldSerializer fieldSerializer) throws IOException {
            sos.write(val.size());
            long classesNum = (int)Stream.of(val).filter(o -> o != null).map(Object::getClass).distinct().count();
            if (classesNum < (long)(val.size() - 2)) {
                sos.write((byte)1);
                List classes = val.stream().filter(o -> o != null).map(Object::getClass).distinct().collect(Collectors.toList());
                Map<Class, Integer> map = IntStream.range(0, classes.size()).boxed().collect(Collectors.toMap(classes::get, i -> i));
                sos.write(classes.size());
                for (Class cl : classes) {
                    sos.write(cl.getName());
                }
                for (Object element : val) {
                    sos.write(map.get(element.getClass()));
                    fieldSerializer.write(element, element.getClass(), sos);
                }
            } else {
                sos.write((byte)2);
                for (Object element : val) {
                    fieldSerializer.write(element, Object.class, sos);
                }
            }
        }

        @Override
        public T read(SimpleInputStream sis, Class<? extends T> clazz, IFieldSerializer fieldSerializer, Consumer<Object> rememberer) throws IOException {
            Collection instance = null;
            try {
                instance = (Collection)ZeSerializer.instantiateUsingNoArgCtor(clazz);
                rememberer.accept(instance);
            }
            catch (ReflectiveOperationException e) {
                throw new ZeSerializerException(e);
            }
            int len = sis.readInt();
            byte type = sis.readByte();
            if (type == 2) {
                for (int i = 0; i < len; ++i) {
                    Object value = fieldSerializer.read(sis, Object.class);
                    instance.add(value);
                }
            } else if (type == 1) {
                int i;
                int classesCount = sis.readInt();
                Class[] classes = new Class[classesCount];
                for (i = 0; i < classesCount; ++i) {
                    classes[i] = ZeSerializer.parseClassName(sis.readString());
                }
                for (i = 0; i < len; ++i) {
                    int classIndex = sis.readInt();
                    Class clazzz = classes[classIndex];
                    Object value = fieldSerializer.read(sis, clazzz);
                    instance.add(value);
                }
            } else {
                throw new ZeSerializerException("Wrong collection encoding type " + type);
            }
            return (T)instance;
        }
    }

    private static class MapSerializer<T extends Map>
    implements ICompositeSerializer<T> {
        private Supplier<T> factory;

        MapSerializer(Supplier<T> factory) {
            this.factory = factory;
        }

        @Override
        public void write(T object, Class<? extends T> clazz, SimpleOutputStream sos, IFieldSerializer fieldSerializer) throws IOException {
            sos.write(object.size());
            Set entrySet = object.entrySet();
            for (Map.Entry e : entrySet) {
                fieldSerializer.write(e.getKey(), Object.class, sos);
                fieldSerializer.write(e.getValue(), Object.class, sos);
            }
        }

        @Override
        public T read(SimpleInputStream sis, Class<? extends T> clazz, IFieldSerializer fieldSerializer, Consumer<Object> rememberer) throws IOException {
            Map hm = (Map)this.factory.get();
            rememberer.accept(hm);
            int len = sis.readInt();
            for (int i = 0; i < len; ++i) {
                Object key = fieldSerializer.read(sis, Object.class);
                Object value = fieldSerializer.read(sis, Object.class);
                hm.put(key, value);
            }
            return (T)hm;
        }
    }

    private class FieldSerializer
    implements IFieldSerializer {
        private FieldSerializer() {
        }

        @Override
        public void write(Object object, Class<?> clazz, SimpleOutputStream sos) throws IOException {
            if (!clazz.isPrimitive() && !this.writeHeader(object, clazz, sos)) {
                return;
            }
            Class<?> actualClazz = object.getClass();
            if (!clazz.isPrimitive()) {
                ZeSerializer.this.rememberObject(object);
            }
            if (actualClazz.isEnum()) {
                new EnumSerializer(actualClazz).write(sos, (Enum)object);
                return;
            }
            ICompositeSerializer compositeSerializer = (ICompositeSerializer)compositeSerializers.get(actualClazz);
            if (compositeSerializer != null) {
                compositeSerializer.write(object, actualClazz, sos, ZeSerializer.this.fieldSerializer);
                return;
            }
            ISimpleSerializer contentSerializer = (ISimpleSerializer)serializers.get(actualClazz);
            if (contentSerializer != null) {
                contentSerializer.write(sos, object);
            } else if (actualClazz.getComponentType() != null) {
                ZeSerializer.this.arraySerializer.write(object, actualClazz, sos);
            } else {
                ZeSerializer.this.pojoSerializer.write(object, actualClazz, sos);
            }
        }

        @Override
        public Object read(SimpleInputStream sis, Class<?> clazz) throws IOException {
            Class realClazz = clazz;
            byte classVersion = 0;
            if (!clazz.isPrimitive()) {
                byte hdr = sis.readByte();
                if (hdr == 0) {
                    return null;
                }
                if (hdr == 3) {
                    int objid = sis.readInt();
                    Object val = ZeSerializer.this.knownObjectList.get(objid);
                    return val;
                }
                if (hdr != 1) {
                    if (hdr == 5) {
                        classVersion = sis.readByte();
                    } else if (hdr == 4) {
                        byte index = sis.readByte();
                        String className = (String)classes.inverse().get((Object)index);
                        if (className == null) {
                            throw new ZeSerializerException("Unknown class id: " + index);
                        }
                        realClazz = ZeSerializer.parseClassName(className);
                    } else if (hdr == 2) {
                        String className = sis.readString();
                        realClazz = ZeSerializer.parseClassName(className);
                    } else if (hdr == 6) {
                        String className = sis.readString();
                        realClazz = ZeSerializer.parseClassName(className);
                        classVersion = sis.readByte();
                    } else {
                        throw new ZeSerializerException("Parsing error: invalid header value: " + hdr + " when parsing class " + clazz.getName());
                    }
                }
            }
            Object object = this.readObject(sis, realClazz, classVersion);
            if (!realClazz.isPrimitive()) {
                ZeSerializer.this.rememberObject(object);
            }
            return object;
        }

        private Object readObject(SimpleInputStream sis, Class<?> realClazz, byte classVersion) throws IOException {
            if (realClazz.isEnum()) {
                return new EnumSerializer(realClazz).read(sis, classVersion);
            }
            ICompositeSerializer compositeSerializer = (ICompositeSerializer)compositeSerializers.get(realClazz);
            if (compositeSerializer != null) {
                return compositeSerializer.read(sis, realClazz, ZeSerializer.this.fieldSerializer, x$0 -> ZeSerializer.this.rememberObject(x$0));
            }
            ISimpleSerializer contentSerializer = (ISimpleSerializer)serializers.get(realClazz);
            if (contentSerializer != null) {
                return contentSerializer.read(sis);
            }
            if (realClazz.getComponentType() != null) {
                return ZeSerializer.this.arraySerializer.read(sis, realClazz);
            }
            return ZeSerializer.this.pojoSerializer.read(sis, realClazz, classVersion);
        }

        private boolean writeHeader(Object val, Class<?> clazz, SimpleOutputStream sos) throws IOException {
            byte version;
            if (val == null) {
                sos.write((byte)0);
                return false;
            }
            Integer objId = (Integer)ZeSerializer.this.knownObjects.get(new Wrap(val));
            if (objId != null) {
                sos.write((byte)3);
                sos.write(objId);
                return false;
            }
            byte by = version = ZeSerializer.this.upgrader == null ? (byte)0 : ZeSerializer.this.upgrader.getCurrentVersionOf(val.getClass());
            if (val.getClass() == clazz) {
                sos.write(version == 0 ? (byte)1 : 5);
                if (version != 0) {
                    sos.write(version);
                }
            } else {
                String clname = val.getClass().getName();
                Byte index = (Byte)classes.get((Object)clname);
                if (index == null) {
                    sos.write(version == 0 ? (byte)2 : 6);
                    sos.write(clname);
                    if (version != 0) {
                        sos.write(version);
                    }
                } else {
                    sos.write((byte)4);
                    sos.write(index);
                }
            }
            return true;
        }
    }

    private class ArraySerializer {
        private ArraySerializer() {
        }

        public void write(Object object, Class<?> clazz, SimpleOutputStream sos) throws IOException {
            int length = Array.getLength(object);
            sos.write(length);
            for (int i = 0; i < length; ++i) {
                Object val = Array.get(object, i);
                ZeSerializer.this.fieldSerializer.write(val, clazz.getComponentType(), sos);
            }
        }

        public Object read(SimpleInputStream sis, Class<?> clazz) throws IOException {
            int length = sis.readInt();
            if (length < 0) {
                throw new RuntimeException("Invalid array length");
            }
            Class<?> componentType = clazz.getComponentType();
            Object instance = Array.newInstance(componentType, length);
            ZeSerializer.this.rememberObject(instance);
            for (int i = 0; i < length; ++i) {
                Object read = ZeSerializer.this.fieldSerializer.read(sis, componentType);
                Array.set(instance, i, read);
            }
            return instance;
        }
    }

    private class PojoSerializer {
        private PojoSerializer() {
        }

        public void write(Object object, Class<? extends Object> clazz, SimpleOutputStream sos) throws IOException {
            try {
                for (Field field : ZeSerializer.getAllFields(clazz)) {
                    if ((field.getModifiers() & 0x88) != 0) continue;
                    field.setAccessible(true);
                    ZeSerializer.this.fieldSerializer.write(field.get(object), field.getType(), sos);
                }
            }
            catch (IllegalAccessException e) {
                throw new ZeSerializerException(e);
            }
        }

        public <T> T read(SimpleInputStream sis, Class<T> clazz, byte classVersion) throws IOException {
            try {
                Object object = ZeSerializer.this.instantiate(clazz);
                if (ZeSerializer.this.upgrader != null && ZeSerializer.this.upgrader.getCurrentVersionOf(clazz) != classVersion) {
                    ClassStructure cs = ZeSerializer.this.upgrader.getStructureFor(clazz, classVersion);
                    if (cs == null) {
                        throw new ZeSerializerException("Upgrader cannot provide " + clazz.getName() + " ver." + classVersion);
                    }
                    Map<String, Class<?>> fields = cs.getFields();
                    HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                    for (Map.Entry<String, Class<?>> entry : fields.entrySet()) {
                        String name = entry.getKey();
                        Class<?> type = entry.getValue();
                        Object fieldValue = ZeSerializer.this.fieldSerializer.read(sis, type);
                        fieldValues.put(name, fieldValue);
                        Field field = ZeSerializer.findSerializableField(clazz, name, type);
                        if (field == null) continue;
                        field.setAccessible(true);
                        field.set(object, fieldValue);
                    }
                    ZeSerializer.this.upgradeHappened = true;
                    IFixer<Object> fixer = ZeSerializer.this.upgrader.getFixerFor(clazz);
                    if (fixer != null) {
                        return (T)fixer.fix(object, fieldValues);
                    }
                    return (T)object;
                }
                for (Field field : ZeSerializer.getAllFields(clazz)) {
                    field.setAccessible(true);
                    Object value = ZeSerializer.this.fieldSerializer.read(sis, field.getType());
                    field.set(object, value);
                }
                return (T)object;
            }
            catch (Exception e) {
                throw new ZeSerializerException(e);
            }
        }
    }

    private static interface ICompositeSerializer<T> {
        public void write(T var1, Class<? extends T> var2, SimpleOutputStream var3, IFieldSerializer var4) throws IOException;

        public T read(SimpleInputStream var1, Class<? extends T> var2, IFieldSerializer var3, Consumer<Object> var4) throws IOException;
    }

    private static interface IFieldSerializer {
        public void write(Object var1, Class<?> var2, SimpleOutputStream var3) throws IOException;

        public Object read(SimpleInputStream var1, Class<?> var2) throws IOException;
    }
}

