/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.expr.LexerException;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Lexer {
    Lexer() {
    }

    Stream<Token> tokenize(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (!input.isEmpty()) {
            boolean matched = false;
            for (Token.Type tokenType : Token.Type.values()) {
                Matcher matcher = tokenType.pattern.matcher(input);
                if (!matcher.find()) continue;
                matched = true;
                input = matcher.replaceFirst("");
                if (tokenType == Token.Type.WHITESPACE) break;
                tokens.add(new Token(tokenType, matcher.group()));
                break;
            }
            if (matched) continue;
            throw new LexerException(input);
        }
        return new Stream<Token>(tokens.toArray(new Token[tokens.size()]));
    }

    static class Token {
        final Type type;
        final String lexeme;

        Token(Type type, String lexeme) {
            this.type = type;
            this.lexeme = lexeme == null ? "" : lexeme;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            return this.type.equals(token.type) && this.lexeme.equals(token.lexeme);
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + this.type.hashCode();
            hash = 71 * hash + this.lexeme.hashCode();
            return hash;
        }

        public String toString() {
            return this.type.name() + "(" + this.lexeme + ")";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type implements Stream.ElementType<Token>
        {
            NUMERIC("0|[1-9][0-9]*"),
            DOT("\\."),
            HYPHEN("-"),
            EQUAL("="),
            NOT_EQUAL("!="),
            GREATER(">(?!=)"),
            GREATER_EQUAL(">="),
            LESS("<(?!=)"),
            LESS_EQUAL("<="),
            TILDE("~"),
            STAR("\\*"),
            AND("&"),
            OR("\\|"),
            NOT("!(?!=)"),
            LEFT_PAREN("\\("),
            RIGHT_PAREN("\\)"),
            WHITESPACE("\\s+"),
            EOL("?!"){

                public boolean isMatchedBy(Token token) {
                    return token == null;
                }
            };

            final Pattern pattern;

            private Type(String regexp) {
                this.pattern = Pattern.compile("^(" + regexp + ")");
            }

            public String toString() {
                return this.name() + "(" + this.pattern + ")";
            }

            @Override
            public boolean isMatchedBy(Token token) {
                if (token == null) {
                    return false;
                }
                return this == token.type;
            }
        }
    }
}

