/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.And;
import com.github.zafarkhaja.semver.expr.Equal;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.Greater;
import com.github.zafarkhaja.semver.expr.GreaterOrEqual;
import com.github.zafarkhaja.semver.expr.Less;
import com.github.zafarkhaja.semver.expr.LessOrEqual;
import com.github.zafarkhaja.semver.expr.Lexer;
import com.github.zafarkhaja.semver.expr.Not;
import com.github.zafarkhaja.semver.expr.NotEqual;
import com.github.zafarkhaja.semver.expr.Or;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.EnumSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionParser
implements Parser<Expression> {
    private final Lexer lexer;
    private Stream<Lexer.Token> tokens;

    ExpressionParser(Lexer lexer) {
        this.lexer = lexer;
    }

    public static Parser<Expression> newInstance() {
        return new ExpressionParser(new Lexer());
    }

    @Override
    public Expression parse(String input) {
        this.tokens = this.lexer.tokenize(input);
        return this.parseSemVerExpression();
    }

    private Expression parseSemVerExpression() {
        Expression expr;
        if (this.tokens.positiveLookahead(Lexer.Token.Type.NOT)) {
            this.tokens.consume();
            this.tokens.consume(Lexer.Token.Type.LEFT_PAREN);
            expr = new Not(this.parseSemVerExpression());
            this.tokens.consume(Lexer.Token.Type.RIGHT_PAREN);
        } else if (this.tokens.positiveLookahead(Lexer.Token.Type.LEFT_PAREN)) {
            this.tokens.consume(Lexer.Token.Type.LEFT_PAREN);
            expr = this.parseSemVerExpression();
            this.tokens.consume(Lexer.Token.Type.RIGHT_PAREN);
        } else {
            expr = this.parseExpression();
        }
        return this.parseBooleanExpression(expr);
    }

    private Expression parseBooleanExpression(Expression expr) {
        if (this.tokens.positiveLookahead(Lexer.Token.Type.AND)) {
            this.tokens.consume();
            expr = new And(expr, this.parseSemVerExpression());
        } else if (this.tokens.positiveLookahead(Lexer.Token.Type.OR)) {
            this.tokens.consume();
            expr = new Or(expr, this.parseSemVerExpression());
        }
        return expr;
    }

    private Expression parseExpression() {
        if (this.tokens.positiveLookahead(Lexer.Token.Type.TILDE)) {
            return this.parseTildeExpression();
        }
        if (this.isVersionExpression()) {
            return this.parseVersionExpression();
        }
        if (this.isRangeExpression()) {
            return this.parseRangeExpression();
        }
        return this.parseComparisonExpression();
    }

    private Expression parseComparisonExpression() {
        Expression expr;
        Lexer.Token token = this.tokens.lookahead();
        switch (token.type) {
            case EQUAL: {
                this.tokens.consume();
                expr = new Equal(this.parseVersion());
                break;
            }
            case NOT_EQUAL: {
                this.tokens.consume();
                expr = new NotEqual(this.parseVersion());
                break;
            }
            case GREATER: {
                this.tokens.consume();
                expr = new Greater(this.parseVersion());
                break;
            }
            case GREATER_EQUAL: {
                this.tokens.consume();
                expr = new GreaterOrEqual(this.parseVersion());
                break;
            }
            case LESS: {
                this.tokens.consume();
                expr = new Less(this.parseVersion());
                break;
            }
            case LESS_EQUAL: {
                this.tokens.consume();
                expr = new LessOrEqual(this.parseVersion());
                break;
            }
            default: {
                expr = new Equal(this.parseVersion());
            }
        }
        return expr;
    }

    private Expression parseTildeExpression() {
        this.tokens.consume(Lexer.Token.Type.TILDE);
        int major = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(Lexer.Token.Type.DOT)) {
            return new GreaterOrEqual(this.versionOf(major, 0, 0));
        }
        this.tokens.consume(Lexer.Token.Type.DOT);
        int minor = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        if (!this.tokens.positiveLookahead(Lexer.Token.Type.DOT)) {
            return new And(new GreaterOrEqual(this.versionOf(major, minor, 0)), new Less(this.versionOf(major + 1, 0, 0)));
        }
        this.tokens.consume(Lexer.Token.Type.DOT);
        int patch = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        return new And(new GreaterOrEqual(this.versionOf(major, minor, patch)), new Less(this.versionOf(major, minor + 1, 0)));
    }

    private boolean isVersionExpression() {
        return this.isVersionFollowedBy(Lexer.Token.Type.STAR);
    }

    private Expression parseVersionExpression() {
        int major = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        this.tokens.consume(Lexer.Token.Type.DOT);
        if (this.tokens.positiveLookahead(Lexer.Token.Type.STAR)) {
            this.tokens.consume();
            return new And(new GreaterOrEqual(this.versionOf(major, 0, 0)), new Less(this.versionOf(major + 1, 0, 0)));
        }
        int minor = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        this.tokens.consume(Lexer.Token.Type.DOT);
        this.tokens.consume(Lexer.Token.Type.STAR);
        return new And(new GreaterOrEqual(this.versionOf(major, minor, 0)), new Less(this.versionOf(major, minor + 1, 0)));
    }

    private boolean isRangeExpression() {
        return this.isVersionFollowedBy(Lexer.Token.Type.HYPHEN);
    }

    private Expression parseRangeExpression() {
        GreaterOrEqual ge = new GreaterOrEqual(this.parseVersion());
        this.tokens.consume(Lexer.Token.Type.HYPHEN);
        LessOrEqual le = new LessOrEqual(this.parseVersion());
        return new And(ge, le);
    }

    private Version parseVersion() {
        int major = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        int minor = 0;
        if (this.tokens.positiveLookahead(Lexer.Token.Type.DOT)) {
            this.tokens.consume();
            minor = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        }
        int patch = 0;
        if (this.tokens.positiveLookahead(Lexer.Token.Type.DOT)) {
            this.tokens.consume();
            patch = this.intOf(this.tokens.consume(new Stream.ElementType[]{Lexer.Token.Type.NUMERIC}).lexeme);
        }
        return this.versionOf(major, minor, patch);
    }

    private boolean isVersionFollowedBy(Stream.ElementType<Lexer.Token> type) {
        EnumSet<Lexer.Token.Type> expected = EnumSet.of(Lexer.Token.Type.NUMERIC, Lexer.Token.Type.DOT);
        Iterator<Lexer.Token> it = this.tokens.iterator();
        Lexer.Token lookahead = null;
        while (it.hasNext()) {
            lookahead = it.next();
            if (expected.contains(lookahead.type)) continue;
            break;
        }
        return type.isMatchedBy(lookahead);
    }

    private Version versionOf(int major, int minor, int patch) {
        return Version.forIntegers(major, minor, patch);
    }

    private int intOf(String value) {
        return Integer.parseInt(value);
    }
}

