/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.sequence;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AutoSequence {
    @Autowired
    public RedisTemplate redisTemplate;
    public static AutoSequence autoSequence;

    public static AutoSequence init() {
        if (autoSequence == null) {
            autoSequence = new AutoSequence();
        }
        return autoSequence;
    }

    public Object get(String key) {
        if (StrUtil.isEmpty((CharSequence)key)) {
            return null;
        }
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public String put(Object value) {
        String sequence = this.getSequence();
        this.redisTemplate.opsForValue().set((Object)sequence, value);
        return sequence;
    }

    public String put(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
        return key;
    }

    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public String getSequence() {
        return SecureUtil.md5((String)(UUID.randomUUID().toString() + System.currentTimeMillis()));
    }
}

