/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullJoin;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullJoin.class)
public class AutoFullJoinService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullJoinService.class);
    public final String pattern = "(?!\\{)([^\\{\\}]+)(?=\\})";

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            AutoFullJoin fieldAnnotation;
            if (annotation instanceof AutoFullJoin && (fieldAnnotation = field.getAnnotation(AutoFullJoin.class)) != null) {
                field.setAccessible(true);
                String value = fieldAnnotation.value();
                Matcher matcher = Pattern.compile("(?!\\{)([^\\{\\}]+)(?=\\})").matcher(value);
                while (matcher.find()) {
                    String key = matcher.group(1);
                    Object param = this.findFieldValue(fields, key, obj);
                    value = value.replace("{" + key + "}", param != null ? param.toString() : "");
                }
                field.set(obj, value);
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145\u5b57\u7b26\u8fde\u63a5\u5931\u8d25,{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

