/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.suke.zhjg.common.autofull.config.ApplicationContextRegister;
import com.suke.zhjg.common.autofull.config.AutoConfig;
import com.suke.zhjg.common.autofull.handler.Handler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoFullHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullHandler.class);
    private static Handler handler;

    public static <T> IPage<T> full(IPage<T> iPage) {
        if (CollUtil.isNotEmpty((Collection)iPage.getRecords())) {
            iPage.getRecords().forEach(obj -> BeanUtil.copyProperties((Object)obj, (Object)AutoFullHandler.handler(obj, null, 1), (String[])new String[0]));
        }
        return iPage;
    }

    public static <T> IPage<T> full(IPage<T> iPage, String sequence) {
        if (CollUtil.isNotEmpty((Collection)iPage.getRecords())) {
            iPage.getRecords().forEach(obj -> BeanUtil.copyProperties((Object)obj, (Object)AutoFullHandler.handler(obj, sequence, 1), (String[])new String[0]));
        }
        return iPage;
    }

    public static <T> IPage<T> full(IPage<T> iPage, String sequence, int level) {
        if (CollUtil.isNotEmpty((Collection)iPage.getRecords())) {
            iPage.getRecords().forEach(obj -> BeanUtil.copyProperties((Object)obj, (Object)AutoFullHandler.handler(obj, sequence, level), (String[])new String[0]));
        }
        return iPage;
    }

    public static <T> List<T> full(List<T> list) {
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(obj -> BeanUtil.copyProperties((Object)obj, (Object)AutoFullHandler.handler(obj, null, 1), (String[])new String[0]));
        }
        return list;
    }

    public static <T> List<T> full(List<T> list, String sequence) {
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(obj -> BeanUtil.copyProperties((Object)obj, (Object)AutoFullHandler.handler(obj, sequence, 1), (String[])new String[0]));
        }
        return list;
    }

    public static <T> List<T> full(List<T> list, String sequence, int level) {
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(obj -> BeanUtil.copyProperties((Object)obj, (Object)AutoFullHandler.handler(obj, sequence, level), (String[])new String[0]));
        }
        return list;
    }

    public static <T> T full(T entity) {
        if (ObjectUtil.isNotNull(entity)) {
            BeanUtil.copyProperties(entity, (Object)AutoFullHandler.handler(entity, null, 1), (String[])new String[0]);
        }
        return entity;
    }

    public static <T> T full(T entity, String sequence) {
        if (ObjectUtil.isNotNull(entity)) {
            BeanUtil.copyProperties(entity, (Object)AutoFullHandler.handler(entity, sequence, 1), (String[])new String[0]);
        }
        return entity;
    }

    public static <T> T full(T entity, String sequence, int level) {
        if (ObjectUtil.isNotNull(entity)) {
            BeanUtil.copyProperties(entity, (Object)AutoFullHandler.handler(entity, sequence, level), (String[])new String[0]);
        }
        return entity;
    }

    protected static Object handler(Object obj, String sequence, int level) {
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
                    AutoConfig autoConfig = (AutoConfig)ApplicationContextRegister.getApplicationContext().getBean(AutoConfig.class);
                    if (ObjectUtil.isNotNull((Object)autoConfig)) {
                        handler = (Handler)autoConfig.findBean(annotation);
                    }
                    if (handler == null) continue;
                    handler.result(annotation, fields, field, obj, sequence, level);
                }
            }
        }
        return obj;
    }

    private AutoFullHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

