/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.cache;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suke.zhjg.common.autofull.config.ApplicationContextRegister;
import com.suke.zhjg.common.autofull.entity.ConfigProperties;
import com.suke.zhjg.common.autofull.util.SQLTableUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public final class AutoFullRedisCache {
    private static final Logger log = LoggerFactory.getLogger(AutoFullRedisCache.class);
    private static final int expireTime = 10080;

    private static RedisTemplate getRedisTemplate() {
        RedisTemplate redisTemplate = (RedisTemplate)ApplicationContextRegister.getApplicationContext().getBean("redisTemplate");
        return redisTemplate;
    }

    public static StringRedisTemplate getStringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)ApplicationContextRegister.getApplicationContext().getBean("stringRedisTemplate");
        return stringRedisTemplate;
    }

    public static ConfigProperties getConfigProperties() {
        return (ConfigProperties)ApplicationContextRegister.getApplicationContext().getBean(ConfigProperties.class);
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = (ObjectMapper)ApplicationContextRegister.getApplicationContext().getBean(ObjectMapper.class);
        return objectMapper;
    }

    private static String getKey(String sql, Object param) {
        String paramStr = "";
        if (ObjectUtil.isNotNull((Object)param)) {
            try {
                paramStr = AutoFullRedisCache.getObjectMapper().writeValueAsString(param);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return "autofull:" + SecureUtil.md5((String)(sql + paramStr));
    }

    public static <T> List<T> getList(String ID, String sql, Object param, T t) {
        String key = AutoFullRedisCache.getKey(sql, param);
        Object data = AutoFullRedisCache.getRedisTemplate().opsForValue().get((Object)key);
        if (ObjectUtil.isNotNull((Object)data)) {
            if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
                log.info("ID:{},\u53d6\u7f13\u5b58\u6570\u636e,key:{}", (Object)ID, (Object)key);
            }
            return (List)data;
        }
        return null;
    }

    public static String getStringData(String ID, String sql, Object param) {
        String key = AutoFullRedisCache.getKey(sql, param);
        Object data = AutoFullRedisCache.getRedisTemplate().opsForValue().get((Object)key);
        if (ObjectUtil.isNotNull((Object)data)) {
            if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
                log.info("ID:{},\u53d6\u7f13\u5b58\u6570\u636e,key:{}", (Object)ID, (Object)key);
            }
            return (String)data;
        }
        return null;
    }

    public static void setData(String ID, String sql, Object param, Object data) {
        if (ObjectUtil.isNull((Object)data)) {
            return;
        }
        List<String> tableName = SQLTableUtil.getSelectTableName(sql);
        String key = AutoFullRedisCache.getKey(sql, param);
        RedisTemplate redisTemplate = AutoFullRedisCache.getRedisTemplate();
        ValueOperations valueOperations = redisTemplate.opsForValue();
        tableName.forEach(name -> {
            String tableKey = "autofull:" + name + key;
            if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
                log.info("ID:{},\u4fdd\u5b58\u7f13\u5b58key\uff1a{}", (Object)ID, (Object)tableKey);
            }
            valueOperations.set((Object)tableKey, (Object)key, 10080L, TimeUnit.MINUTES);
        });
        valueOperations.set((Object)key, data, 10080L, TimeUnit.MINUTES);
        if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
            log.info("ID:{},\u4fdd\u5b58\u7f13\u5b58key\uff1a{}", (Object)ID, (Object)key);
        }
    }

    public static void deleteData(String ID, String tableName) {
        RedisTemplate redisTemplate = AutoFullRedisCache.getRedisTemplate();
        StringRedisTemplate stringRedisTemplate = AutoFullRedisCache.getStringRedisTemplate();
        Set keys = stringRedisTemplate.keys((Object)("*" + tableName + "*"));
        if (CollUtil.isNotEmpty((Collection)keys)) {
            List<String> list = keys.stream().collect(Collectors.toList());
            list.forEach(key -> {
                Object keyData = redisTemplate.opsForValue().get(key);
                if (ObjectUtil.isNotNull((Object)keyData)) {
                    redisTemplate.delete(keyData);
                    if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
                        log.info("ID:{},\u5220\u9664\u7f13\u5b58keyData\uff1a{}", (Object)ID, keyData);
                    }
                }
                stringRedisTemplate.delete(key);
                if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
                    log.info("ID:{},\u5220\u9664\u7f13\u5b58keyData\uff1a{}", (Object)ID, key);
                }
            });
        }
    }

    public static void deleteAll() {
        StringRedisTemplate stringRedisTemplate = AutoFullRedisCache.getStringRedisTemplate();
        Set keys = stringRedisTemplate.keys((Object)"autofull:*");
        keys.forEach(key -> {
            if (AutoFullRedisCache.getConfigProperties().isShowLog()) {
                log.info("\u5220\u9664\u7f13\u5b58\u6570\u636e,key:{}", key);
            }
            stringRedisTemplate.delete(key);
        });
    }

    private AutoFullRedisCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

