/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer.drawer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.media.SoundPool;
import android.os.Build;
import android.text.BoringLayout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.ImageView;
import com.opensource.svgaplayer.IClickAreaListener;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGASoundManager;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.drawer.SGVADrawer;
import com.opensource.svgaplayer.entities.SVGAAudioEntity;
import com.opensource.svgaplayer.entities.SVGAPathEntity;
import com.opensource.svgaplayer.entities.SVGAVideoShapeEntity;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u000267B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010%\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010&\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010'\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u000e2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0002J\"\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020 2\u0010\u0010-\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00010.H\u0002J\"\u0010/\u001a\u00020\t2\u0006\u0010,\u001a\u00020 2\u0010\u0010-\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00010.H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020*H\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*H\u0002R\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer;", "Lcom/opensource/svgaplayer/drawer/SGVADrawer;", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "(Lcom/opensource/svgaplayer/SVGAVideoEntity;Lcom/opensource/svgaplayer/SVGADynamicEntity;)V", "beginIndexList", "", "", "[Ljava/lang/Boolean;", "drawTextCache", "Ljava/util/HashMap;", "", "Landroid/graphics/Bitmap;", "Lkotlin/collections/HashMap;", "getDynamicItem", "()Lcom/opensource/svgaplayer/SVGADynamicEntity;", "endIndexList", "matrixScaleTempValues", "", "pathCache", "Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$PathCache;", "sharedValues", "Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$ShareValues;", "drawDynamic", "", "sprite", "Lcom/opensource/svgaplayer/drawer/SGVADrawer$SVGADrawerSprite;", "canvas", "Landroid/graphics/Canvas;", "frameIndex", "", "drawFrame", "scaleType", "Landroid/widget/ImageView$ScaleType;", "drawImage", "drawShape", "drawSprite", "drawTextOnBitmap", "drawingBitmap", "frameMatrix", "Landroid/graphics/Matrix;", "isMatteBegin", "spriteIndex", "sprites", "", "isMatteEnd", "matrixScale", "", "matrix", "playAudio", "shareFrameMatrix", "transform", "PathCache", "ShareValues", "com.opensource.svgaplayer"})
public final class SVGACanvasDrawer
extends SGVADrawer {
    private final ShareValues sharedValues;
    private final HashMap<String, Bitmap> drawTextCache;
    private final PathCache pathCache;
    private Boolean[] beginIndexList;
    private Boolean[] endIndexList;
    private final float[] matrixScaleTempValues;
    @NotNull
    private final SVGADynamicEntity dynamicItem;

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawFrame(@NotNull Canvas canvas, int frameIndex, @NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.drawFrame(canvas, frameIndex, scaleType);
        this.playAudio(frameIndex);
        this.pathCache.onSizeChanged(canvas);
        List<SGVADrawer.SVGADrawerSprite> sprites = this.requestFrameSprites$com_opensource_svgaplayer(frameIndex);
        Collection collection = sprites;
        boolean bl = false;
        if (collection.size() <= 0) {
            return;
        }
        bl = false;
        Map matteSprites = new LinkedHashMap();
        int saveID = -1;
        this.beginIndexList = null;
        this.endIndexList = null;
        boolean hasMatteLayer = false;
        String string = sprites.get(0).getImageKey();
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            if (StringsKt.endsWith$default((String)it, (String)".matte", (boolean)false, (int)2, null)) {
                hasMatteLayer = true;
            }
        }
        Iterable $this$forEachIndexed$iv = sprites;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object it;
            Object object;
            boolean bl5;
            void svgaDrawerSprite;
            int n = index$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            SGVADrawer.SVGADrawerSprite sVGADrawerSprite = (SGVADrawer.SVGADrawerSprite)item$iv;
            int index = n2;
            boolean bl7 = false;
            if (svgaDrawerSprite.getImageKey() != null) {
                boolean bl8 = false;
                bl5 = false;
                it = object;
                boolean bl9 = false;
                if (!hasMatteLayer || Build.VERSION.SDK_INT < 21) {
                    this.drawSprite((SGVADrawer.SVGADrawerSprite)svgaDrawerSprite, canvas, frameIndex);
                    continue;
                }
                if (StringsKt.endsWith$default((String)it, (String)".matte", (boolean)false, (int)2, null)) {
                    matteSprites.put(it, svgaDrawerSprite);
                    continue;
                }
            }
            if (this.isMatteBegin(index, sprites)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    saveID = canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null);
                } else {
                    canvas.save();
                }
            }
            this.drawSprite((SGVADrawer.SVGADrawerSprite)svgaDrawerSprite, canvas, frameIndex);
            if (!this.isMatteEnd(index, sprites)) continue;
            object = matteSprites;
            String string3 = svgaDrawerSprite.getMatteKey();
            bl5 = false;
            SGVADrawer.SVGADrawerSprite sVGADrawerSprite2 = (SGVADrawer.SVGADrawerSprite)object.get(string3);
            if (sVGADrawerSprite2 == null) continue;
            object = sVGADrawerSprite2;
            boolean bl10 = false;
            bl5 = false;
            it = object;
            boolean bl11 = false;
            this.drawSprite((SGVADrawer.SVGADrawerSprite)it, this.sharedValues.shareMatteCanvas(canvas.getWidth(), canvas.getHeight()), frameIndex);
            canvas.drawBitmap(this.sharedValues.sharedMatteBitmap(), 0.0f, 0.0f, this.sharedValues.shareMattePaint());
            if (saveID != -1) {
                canvas.restoreToCount(saveID);
                continue;
            }
            canvas.restore();
        }
        this.releaseFrameSprites$com_opensource_svgaplayer(sprites);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMatteBegin(int spriteIndex, List<SGVADrawer.SVGADrawerSprite> sprites) {
        if (this.beginIndexList == null) {
            Collection collection = sprites;
            boolean bl = false;
            int n = collection.size();
            Boolean[] booleanArray = new Boolean[n];
            int n2 = 0;
            while (n2 < n) {
                Boolean bl2;
                int n3 = n2;
                int n4 = n2++;
                Boolean[] booleanArray2 = booleanArray;
                boolean bl3 = false;
                booleanArray2[n4] = bl2 = Boolean.valueOf(false);
            }
            Boolean[] boolArray = booleanArray;
            Iterable $this$forEachIndexed$iv = sprites;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                SGVADrawer.SVGADrawerSprite sVGADrawerSprite;
                String it;
                String string;
                boolean bl4;
                boolean bl5;
                void svgaDrawerSprite;
                int n5 = index$iv++;
                boolean bl6 = false;
                if (n5 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n6 = n5;
                SGVADrawer.SVGADrawerSprite sVGADrawerSprite2 = (SGVADrawer.SVGADrawerSprite)item$iv;
                int index = n6;
                boolean bl7 = false;
                if (svgaDrawerSprite.getImageKey() != null) {
                    bl5 = false;
                    bl4 = false;
                    it = string;
                    boolean bl8 = false;
                    if (StringsKt.endsWith$default((String)it, (String)".matte", (boolean)false, (int)2, null)) continue;
                }
                if (svgaDrawerSprite.getMatteKey() == null) continue;
                bl5 = false;
                bl4 = false;
                it = string;
                boolean bl9 = false;
                if (it.length() <= 0) continue;
                if (sprites.get(index - 1) == null) continue;
                boolean bl10 = false;
                boolean bl11 = false;
                SGVADrawer.SVGADrawerSprite lastSprite = sVGADrawerSprite;
                boolean bl12 = false;
                CharSequence charSequence = lastSprite.getMatteKey();
                boolean bl13 = false;
                boolean bl14 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    boolArray[index] = true;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)lastSprite.getMatteKey(), (Object)svgaDrawerSprite.getMatteKey()) ^ true)) continue;
                boolArray[index] = true;
            }
            this.beginIndexList = boolArray;
        }
        Object object = this.beginIndexList;
        return this.beginIndexList != null && (object = object[spriteIndex]) != null ? (Boolean)object : false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMatteEnd(int spriteIndex, List<SGVADrawer.SVGADrawerSprite> sprites) {
        if (this.endIndexList == null) {
            Collection collection = sprites;
            boolean bl = false;
            int n = collection.size();
            Boolean[] booleanArray = new Boolean[n];
            int n2 = 0;
            while (n2 < n) {
                Boolean bl2;
                int n3 = n2;
                int n4 = n2++;
                Boolean[] booleanArray2 = booleanArray;
                boolean bl3 = false;
                booleanArray2[n4] = bl2 = Boolean.valueOf(false);
            }
            Boolean[] boolArray = booleanArray;
            Iterable $this$forEachIndexed$iv = sprites;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String it;
                String string;
                boolean bl4;
                boolean bl5;
                void svgaDrawerSprite;
                int n5 = index$iv++;
                boolean bl6 = false;
                if (n5 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n6 = n5;
                SGVADrawer.SVGADrawerSprite sVGADrawerSprite = (SGVADrawer.SVGADrawerSprite)item$iv;
                int index = n6;
                boolean bl7 = false;
                if (svgaDrawerSprite.getImageKey() != null) {
                    bl5 = false;
                    bl4 = false;
                    it = string;
                    boolean bl8 = false;
                    if (StringsKt.endsWith$default((String)it, (String)".matte", (boolean)false, (int)2, null)) continue;
                }
                if (svgaDrawerSprite.getMatteKey() == null) continue;
                bl5 = false;
                bl4 = false;
                it = string;
                boolean bl9 = false;
                if (it.length() <= 0) continue;
                Object object = sprites;
                int n7 = index;
                boolean bl10 = false;
                int n8 = object.size();
                if (n7 == n8 - 1) {
                    boolArray[index] = true;
                    continue;
                }
                SGVADrawer.SVGADrawerSprite sVGADrawerSprite2 = sprites.get(index + 1);
                if (sVGADrawerSprite2 == null) continue;
                object = sVGADrawerSprite2;
                bl10 = false;
                boolean bl11 = false;
                Object nextSprite = object;
                boolean bl12 = false;
                CharSequence charSequence = ((SGVADrawer.SVGADrawerSprite)nextSprite).getMatteKey();
                boolean bl13 = false;
                boolean bl14 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    boolArray[index] = true;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)((SGVADrawer.SVGADrawerSprite)nextSprite).getMatteKey(), (Object)svgaDrawerSprite.getMatteKey()) ^ true)) continue;
                boolArray[index] = true;
            }
            this.endIndexList = boolArray;
        }
        Object object = this.endIndexList;
        return this.endIndexList != null && (object = object[spriteIndex]) != null ? (Boolean)object : false;
    }

    private final void playAudio(int frameIndex) {
        Iterable $this$forEach$iv = this.getVideoItem().getAudioList$com_opensource_svgaplayer();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer n;
            boolean bl;
            boolean bl2;
            SVGAAudioEntity audio = (SVGAAudioEntity)element$iv;
            boolean bl3 = false;
            if (audio.getStartFrame() == frameIndex) {
                if (SVGASoundManager.INSTANCE.isInit$com_opensource_svgaplayer()) {
                    if (audio.getSoundID() != null) {
                        bl2 = false;
                        bl = false;
                        int soundID = ((Number)n).intValue();
                        boolean bl4 = false;
                        audio.setPlayID(SVGASoundManager.INSTANCE.play$com_opensource_svgaplayer(soundID));
                    }
                } else if (this.getVideoItem().getSoundPool$com_opensource_svgaplayer() != null) {
                    bl2 = false;
                    bl = false;
                    Integer soundPool = n;
                    boolean bl5 = false;
                    if (audio.getSoundID() != null) {
                        Integer n2;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        int soundID = ((Number)n2).intValue();
                        boolean bl8 = false;
                        audio.setPlayID(soundPool.play(soundID, 1.0f, 1.0f, 1, 0, 1.0f));
                    }
                }
            }
            if (audio.getEndFrame() > frameIndex) continue;
            if (audio.getPlayID() != null) {
                bl2 = false;
                bl = false;
                int it = ((Number)n).intValue();
                boolean bl9 = false;
                if (SVGASoundManager.INSTANCE.isInit$com_opensource_svgaplayer()) {
                    SVGASoundManager.INSTANCE.stop$com_opensource_svgaplayer(it);
                } else {
                    SoundPool soundPool = this.getVideoItem().getSoundPool$com_opensource_svgaplayer();
                    if (soundPool != null) {
                        soundPool.stop(it);
                    }
                }
            }
            audio.setPlayID(null);
        }
    }

    private final Matrix shareFrameMatrix(Matrix transform) {
        Matrix matrix = this.sharedValues.sharedMatrix();
        matrix.postScale(this.getScaleInfo().getScaleFx(), this.getScaleInfo().getScaleFy());
        matrix.postTranslate(this.getScaleInfo().getTranFx(), this.getScaleInfo().getTranFy());
        matrix.preConcat(transform);
        return matrix;
    }

    private final void drawSprite(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        this.drawImage(sprite, canvas);
        this.drawShape(sprite, canvas);
        this.drawDynamic(sprite, canvas, frameIndex);
    }

    private final void drawImage(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        Bitmap bitmap;
        String bitmapKey;
        String string;
        String string2 = sprite.getImageKey();
        if (string2 == null) {
            return;
        }
        String imageKey = string2;
        boolean isHidden = Intrinsics.areEqual((Object)this.dynamicItem.getDynamicHidden$com_opensource_svgaplayer().get(imageKey), (Object)true);
        if (isHidden) {
            return;
        }
        if (StringsKt.endsWith$default((String)imageKey, (String)".matte", (boolean)false, (int)2, null)) {
            String string3 = imageKey;
            int n = 0;
            int n2 = imageKey.length() - 6;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = bitmapKey = imageKey;
        }
        if ((bitmap = this.dynamicItem.getDynamicImage$com_opensource_svgaplayer().get(bitmapKey)) == null) {
            bitmap = this.getVideoItem().getImageMap$com_opensource_svgaplayer().get(bitmapKey);
        }
        if (bitmap == null) {
            return;
        }
        Bitmap drawingBitmap = bitmap;
        Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
        Paint paint = this.sharedValues.sharedPaint();
        paint.setAntiAlias(this.getVideoItem().getAntiAlias());
        paint.setFilterBitmap(this.getVideoItem().getAntiAlias());
        paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
        if (sprite.getFrameEntity().getMaskPath() != null) {
            SVGAPathEntity sVGAPathEntity = sprite.getFrameEntity().getMaskPath();
            if (sVGAPathEntity == null) {
                return;
            }
            SVGAPathEntity maskPath = sVGAPathEntity;
            canvas.save();
            Path path = this.sharedValues.sharedPath();
            maskPath.buildPath(path);
            path.transform(frameMatrix);
            canvas.clipPath(path);
            frameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getHeight() / (double)drawingBitmap.getHeight()));
            if (!drawingBitmap.isRecycled()) {
                canvas.drawBitmap(drawingBitmap, frameMatrix, paint);
            }
            canvas.restore();
        } else {
            frameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getHeight() / (double)drawingBitmap.getHeight()));
            if (!drawingBitmap.isRecycled()) {
                canvas.drawBitmap(drawingBitmap, frameMatrix, paint);
            }
        }
        HashMap<String, IClickAreaListener> hashMap = this.dynamicItem.getDynamicIClickArea$com_opensource_svgaplayer();
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, IClickAreaListener> it = hashMap;
        boolean bl3 = false;
        IClickAreaListener iClickAreaListener = it.get(imageKey);
        if (iClickAreaListener != null) {
            IClickAreaListener iClickAreaListener2 = iClickAreaListener;
            boolean bl4 = false;
            boolean bl5 = false;
            IClickAreaListener listener = iClickAreaListener2;
            boolean bl6 = false;
            float[] matrixArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            frameMatrix.getValues(matrixArray);
            listener.onResponseArea(imageKey, (int)matrixArray[2], (int)matrixArray[5], (int)((float)drawingBitmap.getWidth() * matrixArray[0] + matrixArray[2]), (int)((float)drawingBitmap.getHeight() * matrixArray[4] + matrixArray[5]));
        }
        this.drawTextOnBitmap(canvas, drawingBitmap, sprite, frameMatrix);
    }

    private final void drawTextOnBitmap(Canvas canvas, Bitmap drawingBitmap, SGVADrawer.SVGADrawerSprite sprite, Matrix frameMatrix) {
        block23: {
            boolean bl;
            TextPaint it;
            String it2;
            boolean bl2;
            boolean bl3;
            TextPaint textPaint;
            boolean bl4;
            boolean bl5;
            String string;
            if (this.dynamicItem.isTextDirty$com_opensource_svgaplayer()) {
                this.drawTextCache.clear();
                this.dynamicItem.setTextDirty$com_opensource_svgaplayer(false);
            }
            String string2 = sprite.getImageKey();
            if (string2 == null) {
                return;
            }
            String imageKey = string2;
            Bitmap textBitmap = null;
            String string3 = this.dynamicItem.getDynamicText$com_opensource_svgaplayer().get(imageKey);
            if (string3 != null) {
                string = string3;
                bl5 = false;
                bl4 = false;
                String drawingText = string;
                boolean bl6 = false;
                TextPaint textPaint2 = this.dynamicItem.getDynamicTextPaint$com_opensource_svgaplayer().get(imageKey);
                if (textPaint2 != null) {
                    boolean bl7;
                    textPaint = textPaint2;
                    bl3 = false;
                    bl2 = false;
                    TextPaint drawingTextPaint = textPaint;
                    boolean bl8 = false;
                    Bitmap bitmap = this.drawTextCache.get(imageKey);
                    if (bitmap != null) {
                        Bitmap bitmap2 = bitmap;
                        bl7 = false;
                        boolean bl9 = false;
                        Bitmap it3 = bitmap2;
                        boolean bl10 = false;
                        textBitmap = it3;
                    } else {
                        boolean bl11 = false;
                        bl7 = false;
                        boolean bl12 = false;
                        textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Rect drawRect = new Rect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                        Canvas textCanvas = new Canvas(textBitmap);
                        TextPaint textPaint3 = drawingTextPaint;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint3, (String)"drawingTextPaint");
                        textPaint3.setAntiAlias(true);
                        Paint.FontMetrics fontMetrics = drawingTextPaint.getFontMetrics();
                        float top = fontMetrics.top;
                        float bottom = fontMetrics.bottom;
                        float baseLineY = (float)drawRect.centerY() - top / (float)2 - bottom / (float)2;
                        textCanvas.drawText(drawingText, (float)drawRect.centerX(), baseLineY, (Paint)drawingTextPaint);
                        Bitmap bitmap3 = textBitmap;
                        if (bitmap3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                        }
                        this.drawTextCache.put(imageKey, bitmap3);
                    }
                }
            }
            BoringLayout boringLayout = this.dynamicItem.getDynamicBoringLayoutText$com_opensource_svgaplayer().get(imageKey);
            if (boringLayout != null) {
                string = boringLayout;
                bl5 = false;
                bl4 = false;
                it2 = string;
                boolean bl13 = false;
                Bitmap bitmap = this.drawTextCache.get(imageKey);
                if (bitmap != null) {
                    textPaint = bitmap;
                    bl3 = false;
                    bl2 = false;
                    it = textPaint;
                    boolean bl14 = false;
                    textBitmap = it;
                } else {
                    boolean bl15 = false;
                    bl3 = false;
                    bl = false;
                    String string4 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                    TextPaint textPaint4 = string4.getPaint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textPaint4, (String)"it.paint");
                    textPaint4.setAntiAlias(true);
                    textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas textCanvas = new Canvas(textBitmap);
                    textCanvas.translate(0.0f, (float)((drawingBitmap.getHeight() - it2.getHeight()) / 2));
                    it2.draw(textCanvas);
                    Bitmap bitmap4 = textBitmap;
                    if (bitmap4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                    }
                    this.drawTextCache.put(imageKey, bitmap4);
                }
            }
            StaticLayout staticLayout = this.dynamicItem.getDynamicStaticLayoutText$com_opensource_svgaplayer().get(imageKey);
            if (staticLayout != null) {
                string = staticLayout;
                bl5 = false;
                bl4 = false;
                it2 = string;
                boolean bl16 = false;
                Bitmap bitmap = this.drawTextCache.get(imageKey);
                if (bitmap != null) {
                    Bitmap bitmap5 = bitmap;
                    bl3 = false;
                    bl = false;
                    it = bitmap5;
                    boolean bl17 = false;
                    textBitmap = it;
                } else {
                    StaticLayout staticLayout2;
                    boolean bl18 = false;
                    bl3 = false;
                    boolean bl19 = false;
                    String string5 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it");
                    TextPaint textPaint5 = string5.getPaint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textPaint5, (String)"it.paint");
                    textPaint5.setAntiAlias(true);
                    if (Build.VERSION.SDK_INT >= 23) {
                        int field22;
                        try {
                            Field field22;
                            Field field = field22 = StaticLayout.class.getDeclaredField("mMaximumVisibleLineCount");
                            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"field");
                            field.setAccessible(true);
                            field22 = field22.getInt(it2);
                        }
                        catch (Exception e) {
                            field22 = Integer.MAX_VALUE;
                        }
                        int lineMax = field22;
                        staticLayout2 = StaticLayout.Builder.obtain((CharSequence)it2.getText(), (int)0, (int)it2.getText().length(), (TextPaint)it2.getPaint(), (int)drawingBitmap.getWidth()).setAlignment(it2.getAlignment()).setMaxLines(lineMax).setEllipsize(TextUtils.TruncateAt.END).build();
                    } else {
                        staticLayout2 = new StaticLayout(it2.getText(), 0, it2.getText().length(), it2.getPaint(), drawingBitmap.getWidth(), it2.getAlignment(), it2.getSpacingMultiplier(), it2.getSpacingAdd(), false);
                    }
                    StaticLayout layout = staticLayout2;
                    textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas textCanvas = new Canvas(textBitmap);
                    int n = drawingBitmap.getHeight();
                    StaticLayout staticLayout3 = layout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)staticLayout3, (String)"layout");
                    textCanvas.translate(0.0f, (float)((n - staticLayout3.getHeight()) / 2));
                    layout.draw(textCanvas);
                    Bitmap bitmap6 = textBitmap;
                    if (bitmap6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                    }
                    this.drawTextCache.put(imageKey, bitmap6);
                }
            }
            Bitmap bitmap = textBitmap;
            if (bitmap == null) break block23;
            string = bitmap;
            bl5 = false;
            bl4 = false;
            String textBitmap2 = string;
            boolean bl20 = false;
            Paint paint = this.sharedValues.sharedPaint();
            paint.setAntiAlias(this.getVideoItem().getAntiAlias());
            paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPathEntity sVGAPathEntity = sprite.getFrameEntity().getMaskPath();
                if (sVGAPathEntity == null) {
                } else {
                    SVGAPathEntity maskPath = sVGAPathEntity;
                    canvas.save();
                    canvas.concat(frameMatrix);
                    canvas.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                    BitmapShader bitmapShader = new BitmapShader((Bitmap)textBitmap2, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    paint.setShader((Shader)bitmapShader);
                    Path path = this.sharedValues.sharedPath();
                    maskPath.buildPath(path);
                    canvas.drawPath(path, paint);
                    canvas.restore();
                }
            } else {
                paint.setFilterBitmap(this.getVideoItem().getAntiAlias());
                canvas.drawBitmap((Bitmap)textBitmap2, frameMatrix, paint);
            }
        }
    }

    private final void drawShape(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
        Iterable $this$forEach$iv = sprite.getFrameEntity().getShapes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            Object object3;
            Path path2;
            boolean bl;
            boolean bl2;
            int alpha;
            boolean bl3;
            boolean bl4;
            Path path;
            SVGAVideoShapeEntity shape = (SVGAVideoShapeEntity)element$iv;
            boolean bl5 = false;
            shape.buildPath();
            if (shape.getShapePath() == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            Path it = path;
            boolean bl8 = false;
            Paint paint = this.sharedValues.sharedPaint();
            paint.reset();
            paint.setAntiAlias(this.getVideoItem().getAntiAlias());
            paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            Path path3 = this.sharedValues.sharedPath();
            path3.reset();
            path3.addPath(this.pathCache.buildPath(shape));
            Matrix shapeMatrix = this.sharedValues.sharedMatrix2();
            shapeMatrix.reset();
            if (shape.getTransform() != null) {
                Matrix matrix;
                bl4 = false;
                bl3 = false;
                Matrix it2 = matrix;
                boolean bl9 = false;
                shapeMatrix.postConcat(it2);
            }
            shapeMatrix.postConcat(frameMatrix);
            path3.transform(shapeMatrix);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null) {
                int n = styles.getFill();
                bl4 = false;
                bl3 = false;
                int it3 = n;
                boolean bl10 = false;
                if (it3 != 0) {
                    paint.setStyle(Paint.Style.FILL);
                    paint.setColor(it3);
                    alpha = Math.min(255, Math.max(0, (int)(sprite.getFrameEntity().getAlpha() * (double)255)));
                    if (alpha != 255) {
                        paint.setAlpha(alpha);
                    }
                    if (sprite.getFrameEntity().getMaskPath() != null) {
                        canvas.save();
                    }
                    if (sprite.getFrameEntity().getMaskPath() != null) {
                        SVGAPathEntity sVGAPathEntity;
                        bl2 = false;
                        bl = false;
                        SVGAPathEntity maskPath = sVGAPathEntity;
                        boolean bl11 = false;
                        path2 = this.sharedValues.sharedPath2();
                        maskPath.buildPath(path2);
                        path2.transform(frameMatrix);
                        canvas.clipPath(path2);
                    }
                    canvas.drawPath(path3, paint);
                    if (sprite.getFrameEntity().getMaskPath() != null) {
                        canvas.restore();
                    }
                }
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 == null) continue;
            float f = styles2.getStrokeWidth();
            bl4 = false;
            bl3 = false;
            float it4 = f;
            boolean bl12 = false;
            if (!(it4 > 0.0f)) continue;
            paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            paint.setStyle(Paint.Style.STROKE);
            SVGAVideoShapeEntity.Styles styles3 = shape.getStyles();
            if (styles3 != null) {
                alpha = styles3.getStroke();
                boolean bl13 = false;
                bl2 = false;
                int it5 = alpha;
                boolean bl14 = false;
                paint.setColor(it5);
                int alpha2 = Math.min(255, Math.max(0, (int)(sprite.getFrameEntity().getAlpha() * (double)255)));
                if (alpha2 != 255) {
                    paint.setAlpha(alpha2);
                }
            }
            float scale = this.matrixScale(frameMatrix);
            SVGAVideoShapeEntity.Styles styles4 = shape.getStyles();
            if (styles4 != null) {
                float f2 = styles4.getStrokeWidth();
                bl2 = false;
                bl = false;
                float it6 = f2;
                boolean bl15 = false;
                paint.setStrokeWidth(it6 * scale);
            }
            if ((object3 = shape.getStyles()) != null && (object3 = ((SVGAVideoShapeEntity.Styles)object3).getLineCap()) != null) {
                Object object4 = object3;
                bl2 = false;
                bl = false;
                Object it7 = object4;
                boolean bl16 = false;
                if (StringsKt.equals((String)it7, (String)"butt", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.BUTT);
                } else if (StringsKt.equals((String)it7, (String)"round", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.ROUND);
                } else if (StringsKt.equals((String)it7, (String)"square", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
            if ((object2 = shape.getStyles()) != null && (object2 = ((SVGAVideoShapeEntity.Styles)object2).getLineJoin()) != null) {
                Object object5 = object2;
                bl2 = false;
                bl = false;
                Object it8 = object5;
                boolean bl17 = false;
                if (StringsKt.equals((String)it8, (String)"miter", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.MITER);
                } else if (StringsKt.equals((String)it8, (String)"round", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.ROUND);
                } else if (StringsKt.equals((String)it8, (String)"bevel", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
            SVGAVideoShapeEntity.Styles styles5 = shape.getStyles();
            if (styles5 != null) {
                int n = styles5.getMiterLimit();
                bl2 = false;
                bl = false;
                int it9 = n;
                boolean bl18 = false;
                paint.setStrokeMiter((float)it9 * scale);
            }
            if ((object = shape.getStyles()) != null) {
                float[] fArray = ((SVGAVideoShapeEntity.Styles)object).getLineDash();
                object = fArray;
                if (fArray != null) {
                    Object object6 = object;
                    bl2 = false;
                    bl = false;
                    Object it10 = object6;
                    boolean bl19 = false;
                    if (((Object)it10).length == 3 && (it10[0] > 0.0f || it10[1] > 0.0f)) {
                        paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{(it10[0] < 1.0f ? 1.0f : (float)it10[0]) * scale, (it10[1] < 0.1f ? 0.1f : (float)it10[1]) * scale}, (float)(it10[2] * scale)));
                    }
                }
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                canvas.save();
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPathEntity sVGAPathEntity;
                bl2 = false;
                bl = false;
                SVGAPathEntity maskPath = sVGAPathEntity;
                boolean bl20 = false;
                path2 = this.sharedValues.sharedPath2();
                maskPath.buildPath(path2);
                path2.transform(frameMatrix);
                canvas.clipPath(path2);
            }
            canvas.drawPath(path3, paint);
            if (sprite.getFrameEntity().getMaskPath() == null) continue;
            canvas.restore();
        }
    }

    private final float matrixScale(Matrix matrix) {
        matrix.getValues(this.matrixScaleTempValues);
        if (this.matrixScaleTempValues[0] == 0.0f) {
            return 0.0f;
        }
        double A = this.matrixScaleTempValues[0];
        double D = this.matrixScaleTempValues[4];
        double B = this.matrixScaleTempValues[3];
        double C = this.matrixScaleTempValues[1];
        if (A * D == B * C) {
            return 0.0f;
        }
        double scaleX = Math.sqrt(A * A + B * B);
        double skew = (A /= scaleX) * C + (B /= scaleX) * D;
        double scaleY = Math.sqrt((C -= A * skew) * C + (D -= B * skew) * D);
        C /= scaleY;
        D /= scaleY;
        skew /= scaleY;
        if (A * D < B * C) {
            scaleX = -scaleX;
        }
        return this.getScaleInfo().getRatioX() ? Math.abs((float)scaleX) : Math.abs((float)scaleY);
    }

    private final void drawDynamic(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        block2: {
            Matrix frameMatrix;
            Function2<Canvas, Integer, Boolean> it;
            boolean bl;
            boolean bl2;
            Function2<Canvas, Integer, Boolean> function2;
            String string = sprite.getImageKey();
            if (string == null) {
                return;
            }
            String imageKey = string;
            Function2<Canvas, Integer, Boolean> function22 = this.dynamicItem.getDynamicDrawer$com_opensource_svgaplayer().get(imageKey);
            if (function22 != null) {
                function2 = function22;
                bl2 = false;
                bl = false;
                it = function2;
                boolean bl3 = false;
                frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
                canvas.save();
                canvas.concat(frameMatrix);
                it.invoke((Object)canvas, (Object)frameIndex);
                canvas.restore();
            }
            Function4<Canvas, Integer, Integer, Integer, Boolean> function4 = this.dynamicItem.getDynamicDrawerSized$com_opensource_svgaplayer().get(imageKey);
            if (function4 == null) break block2;
            function2 = function4;
            bl2 = false;
            bl = false;
            it = function2;
            boolean bl4 = false;
            frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
            canvas.save();
            canvas.concat(frameMatrix);
            it.invoke((Object)canvas, (Object)frameIndex, (Object)((int)sprite.getFrameEntity().getLayout().getWidth()), (Object)((int)sprite.getFrameEntity().getLayout().getHeight()));
            canvas.restore();
        }
    }

    @NotNull
    public final SVGADynamicEntity getDynamicItem() {
        return this.dynamicItem;
    }

    public SVGACanvasDrawer(@NotNull SVGAVideoEntity videoItem, @NotNull SVGADynamicEntity dynamicItem) {
        Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
        Intrinsics.checkParameterIsNotNull((Object)dynamicItem, (String)"dynamicItem");
        super(videoItem);
        this.dynamicItem = dynamicItem;
        this.sharedValues = new ShareValues();
        SVGACanvasDrawer sVGACanvasDrawer = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        sVGACanvasDrawer.drawTextCache = hashMap;
        this.pathCache = new PathCache();
        this.matrixScaleTempValues = new float[16];
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$ShareValues;", "", "()V", "shareMatteCanvas", "Landroid/graphics/Canvas;", "shareMattePaint", "Landroid/graphics/Paint;", "sharedMatrix", "Landroid/graphics/Matrix;", "sharedMatrix2", "sharedMatteBitmap", "Landroid/graphics/Bitmap;", "sharedPaint", "sharedPath", "Landroid/graphics/Path;", "sharedPath2", "width", "", "height", "com.opensource.svgaplayer"})
    public static final class ShareValues {
        private final Paint sharedPaint = new Paint();
        private final Path sharedPath = new Path();
        private final Path sharedPath2 = new Path();
        private final Matrix sharedMatrix = new Matrix();
        private final Matrix sharedMatrix2 = new Matrix();
        private final Paint shareMattePaint = new Paint();
        private Canvas shareMatteCanvas;
        private Bitmap sharedMatteBitmap;

        @NotNull
        public final Paint sharedPaint() {
            this.sharedPaint.reset();
            return this.sharedPaint;
        }

        @NotNull
        public final Path sharedPath() {
            this.sharedPath.reset();
            return this.sharedPath;
        }

        @NotNull
        public final Path sharedPath2() {
            this.sharedPath2.reset();
            return this.sharedPath2;
        }

        @NotNull
        public final Matrix sharedMatrix() {
            this.sharedMatrix.reset();
            return this.sharedMatrix;
        }

        @NotNull
        public final Matrix sharedMatrix2() {
            this.sharedMatrix2.reset();
            return this.sharedMatrix2;
        }

        @NotNull
        public final Paint shareMattePaint() {
            this.shareMattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            return this.shareMattePaint;
        }

        @NotNull
        public final Bitmap sharedMatteBitmap() {
            Bitmap bitmap = this.sharedMatteBitmap;
            if (bitmap == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
            }
            return bitmap;
        }

        @NotNull
        public final Canvas shareMatteCanvas(int width, int height) {
            if (this.shareMatteCanvas == null) {
                this.sharedMatteBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            }
            return new Canvas(this.sharedMatteBitmap);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$PathCache;", "", "()V", "cache", "Ljava/util/HashMap;", "Lcom/opensource/svgaplayer/entities/SVGAVideoShapeEntity;", "Landroid/graphics/Path;", "Lkotlin/collections/HashMap;", "canvasHeight", "", "canvasWidth", "buildPath", "shape", "onSizeChanged", "", "canvas", "Landroid/graphics/Canvas;", "com.opensource.svgaplayer"})
    public static final class PathCache {
        private int canvasWidth;
        private int canvasHeight;
        private final HashMap<SVGAVideoShapeEntity, Path> cache = new HashMap();

        public final void onSizeChanged(@NotNull Canvas canvas) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            if (this.canvasWidth != canvas.getWidth() || this.canvasHeight != canvas.getHeight()) {
                this.cache.clear();
            }
            this.canvasWidth = canvas.getWidth();
            this.canvasHeight = canvas.getHeight();
        }

        @NotNull
        public final Path buildPath(@NotNull SVGAVideoShapeEntity shape) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            if (!this.cache.containsKey(shape)) {
                Path path = new Path();
                path.set(shape.getShapePath());
                ((Map)this.cache).put(shape, path);
            }
            Path path = this.cache.get(shape);
            if (path == null) {
                Intrinsics.throwNpe();
            }
            return path;
        }
    }
}

