/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.media.AudioAttributes;
import android.media.SoundPool;
import android.os.Build;
import com.opensource.svgaplayer.SVGASoundManager;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.entities.SVGAAudioEntity;
import com.opensource.svgaplayer.utils.log.LogUtils;
import java.io.FileDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bJ\r\u0010\u0014\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0015J9\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020\u0013J\u0015\u0010%\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b&J\u001a\u0010'\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u0015\u0010*\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b+J\u0015\u0010,\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\bH\u0000\u00a2\u0006\u0002\b-R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/opensource/svgaplayer/SVGASoundManager;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "soundCallBackMap", "", "", "Lcom/opensource/svgaplayer/SVGASoundManager$SVGASoundCallBack;", "soundPool", "Landroid/media/SoundPool;", "volume", "", "checkInit", "", "getSoundPool", "maxStreams", "init", "", "isInit", "isInit$com_opensource_svgaplayer", "load", "callBack", "fd", "Ljava/io/FileDescriptor;", "offset", "", "length", "priority", "load$com_opensource_svgaplayer", "pause", "soundId", "pause$com_opensource_svgaplayer", "play", "play$com_opensource_svgaplayer", "release", "resume", "resume$com_opensource_svgaplayer", "setVolume", "entity", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "stop", "stop$com_opensource_svgaplayer", "unload", "unload$com_opensource_svgaplayer", "SVGASoundCallBack", "com.opensource.svgaplayer"})
public final class SVGASoundManager {
    private static final String TAG;
    private static SoundPool soundPool;
    private static final Map<Integer, SVGASoundCallBack> soundCallBackMap;
    private static float volume;
    public static final SVGASoundManager INSTANCE;

    public final void init() {
        this.init(20);
    }

    public final void init(int maxStreams) {
        block1: {
            String string = TAG;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
            LogUtils.INSTANCE.debug(string, "**************** init **************** " + maxStreams);
            if (soundPool != null) {
                return;
            }
            SoundPool soundPool = SVGASoundManager.soundPool = this.getSoundPool(maxStreams);
            if (soundPool == null) break block1;
            soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)init.1.INSTANCE);
        }
    }

    public final void release() {
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "**************** release ****************");
        Map<Integer, SVGASoundCallBack> map = soundCallBackMap;
        boolean bl = false;
        if (!map.isEmpty()) {
            soundCallBackMap.clear();
        }
    }

    public final void setVolume(float volume, @Nullable SVGAVideoEntity entity) {
        if (!this.checkInit()) {
            return;
        }
        if (volume < 0.0f || volume > 1.0f) {
            String string = TAG;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
            LogUtils.INSTANCE.error(string, "The volume level is in the range of 0 to 1 ");
            return;
        }
        if (entity == null) {
            SVGASoundManager.volume = volume;
            for (Map.Entry<Integer, SVGASoundCallBack> e : soundCallBackMap.entrySet()) {
                e.getValue().onVolumeChange(volume);
            }
            return;
        }
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            return;
        }
        SoundPool soundPool2 = soundPool;
        Iterable $this$forEach$iv = entity.getAudioList$com_opensource_svgaplayer();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SVGAAudioEntity audio = (SVGAAudioEntity)element$iv;
            boolean bl = false;
            Integer n = audio.getPlayID();
            if (n == null) {
                return;
            }
            int streamId = n;
            soundPool2.setVolume(streamId, volume, volume);
        }
    }

    public static /* synthetic */ void setVolume$default(SVGASoundManager sVGASoundManager, float f, SVGAVideoEntity sVGAVideoEntity, int n, Object object) {
        if ((n & 2) != 0) {
            sVGAVideoEntity = null;
        }
        sVGASoundManager.setVolume(f, sVGAVideoEntity);
    }

    public final boolean isInit$com_opensource_svgaplayer() {
        return soundPool != null;
    }

    private final boolean checkInit() {
        boolean isInit = this.isInit$com_opensource_svgaplayer();
        if (!isInit) {
            String string = TAG;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
            LogUtils.INSTANCE.error(string, "soundPool is null, you need call init() !!!");
        }
        return isInit;
    }

    private final SoundPool getSoundPool(int maxStreams) {
        SoundPool soundPool;
        if (Build.VERSION.SDK_INT >= 21) {
            AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).build();
            soundPool = new SoundPool.Builder().setAudioAttributes(attributes).setMaxStreams(maxStreams).build();
        } else {
            soundPool = new SoundPool(maxStreams, 3, 0);
        }
        return soundPool;
    }

    public final int load$com_opensource_svgaplayer(@Nullable SVGASoundCallBack callBack, @Nullable FileDescriptor fd, long offset, long length, int priority) {
        if (!this.checkInit()) {
            return -1;
        }
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            Intrinsics.throwNpe();
        }
        int soundId = soundPool.load(fd, offset, length, priority);
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "load soundId=" + soundId + " callBack=" + callBack);
        if (callBack != null && !soundCallBackMap.containsKey(soundId)) {
            soundCallBackMap.put(soundId, callBack);
        }
        return soundId;
    }

    public final void unload$com_opensource_svgaplayer(int soundId) {
        if (!this.checkInit()) {
            return;
        }
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "unload soundId=" + soundId);
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            Intrinsics.throwNpe();
        }
        soundPool.unload(soundId);
        soundCallBackMap.remove(soundId);
    }

    public final int play$com_opensource_svgaplayer(int soundId) {
        if (!this.checkInit()) {
            return -1;
        }
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "play soundId=" + soundId);
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            Intrinsics.throwNpe();
        }
        return soundPool.play(soundId, volume, volume, 1, 0, 1.0f);
    }

    public final void stop$com_opensource_svgaplayer(int soundId) {
        if (!this.checkInit()) {
            return;
        }
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "stop soundId=" + soundId);
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            Intrinsics.throwNpe();
        }
        soundPool.stop(soundId);
    }

    public final void resume$com_opensource_svgaplayer(int soundId) {
        if (!this.checkInit()) {
            return;
        }
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "stop soundId=" + soundId);
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            Intrinsics.throwNpe();
        }
        soundPool.resume(soundId);
    }

    public final void pause$com_opensource_svgaplayer(int soundId) {
        if (!this.checkInit()) {
            return;
        }
        String string = TAG;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TAG");
        LogUtils.INSTANCE.debug(string, "pause soundId=" + soundId);
        SoundPool soundPool = SVGASoundManager.soundPool;
        if (soundPool == null) {
            Intrinsics.throwNpe();
        }
        soundPool.pause(soundId);
    }

    private SVGASoundManager() {
    }

    static {
        SVGASoundManager sVGASoundManager;
        INSTANCE = sVGASoundManager = new SVGASoundManager();
        TAG = SVGASoundManager.class.getSimpleName();
        boolean bl = false;
        soundCallBackMap = new LinkedHashMap();
        volume = 1.0f;
    }

    public static final /* synthetic */ String access$getTAG$p(SVGASoundManager $this) {
        SVGASoundManager sVGASoundManager = $this;
        return TAG;
    }

    public static final /* synthetic */ Map access$getSoundCallBackMap$p(SVGASoundManager $this) {
        SVGASoundManager sVGASoundManager = $this;
        return soundCallBackMap;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lcom/opensource/svgaplayer/SVGASoundManager$SVGASoundCallBack;", "", "onComplete", "", "onVolumeChange", "value", "", "com.opensource.svgaplayer"})
    public static interface SVGASoundCallBack {
        public void onVolumeChange(float var1);

        public void onComplete();
    }
}

