/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.content.Context;
import com.opensource.svgaplayer.SVGACache;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.utils.log.LogUtils;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJ\u0010\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/opensource/svgaplayer/SVGACache;", "", "()V", "TAG", "", "cacheDir", "getCacheDir", "()Ljava/lang/String;", "type", "Lcom/opensource/svgaplayer/SVGACache$Type;", "buildAudioFile", "Ljava/io/File;", "audio", "buildCacheDir", "cacheKey", "buildCacheKey", "url", "Ljava/net/URL;", "str", "buildSvgaFile", "clearCache", "", "clearDir", "path", "clearDir$com_opensource_svgaplayer", "isCached", "", "isDefaultCache", "isInitialized", "onCreate", "context", "Landroid/content/Context;", "Type", "com.opensource.svgaplayer"})
public final class SVGACache {
    private static final String TAG = "SVGACache";
    private static Type type;
    private static String cacheDir;
    public static final SVGACache INSTANCE;

    private final String getCacheDir() {
        File dir;
        if (Intrinsics.areEqual((Object)cacheDir, (Object)"/") ^ true && !(dir = new File(cacheDir)).exists()) {
            dir.mkdirs();
        }
        return cacheDir;
    }

    public final void onCreate(@Nullable Context context) {
        this.onCreate(context, Type.DEFAULT);
    }

    public final void onCreate(@Nullable Context context, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (this.isInitialized()) {
            return;
        }
        if (context == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        File file = context.getCacheDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
        cacheDir = stringBuilder.append(file.getAbsolutePath()).append("/svga/").toString();
        File file2 = new File(this.getCacheDir());
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        File file3 = !it.exists() ? file2 : null;
        if (file3 != null) {
            file3.mkdirs();
        }
        SVGACache.type = type;
    }

    public final void clearCache() {
        if (!this.isInitialized()) {
            LogUtils.INSTANCE.error(TAG, "SVGACache is not init!");
            return;
        }
        SVGAParser.Companion.getThreadPoolExecutor$com_opensource_svgaplayer().execute(clearCache.1.INSTANCE);
    }

    public final void clearDir$com_opensource_svgaplayer(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            File dir;
            File file = dir = new File(path);
            boolean bl = false;
            boolean bl2 = false;
            File it = file;
            boolean bl3 = false;
            File file2 = it.exists() ? file : null;
            if (file2 != null) {
                file = file2;
                bl = false;
                bl2 = false;
                File parentDir = file;
                boolean bl4 = false;
                File[] fileArray = parentDir.listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    File[] fileArray2 = $this$forEach$iv;
                    int n = fileArray2.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file3 = element$iv = fileArray2[i];
                        boolean bl5 = false;
                        if (!file3.exists()) continue;
                        File file4 = file3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file");
                        if (file4.isDirectory()) {
                            String string = file3.getAbsolutePath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
                            INSTANCE.clearDir$com_opensource_svgaplayer(string);
                        }
                        file3.delete();
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtils.INSTANCE.error(TAG, "Clear svga cache path: " + path + " fail", e);
        }
    }

    public final boolean isInitialized() {
        return Intrinsics.areEqual((Object)"/", (Object)this.getCacheDir()) ^ true && new File(this.getCacheDir()).exists();
    }

    public final boolean isDefaultCache() {
        return type == Type.DEFAULT;
    }

    public final boolean isCached(@NotNull String cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        return (this.isDefaultCache() ? this.buildCacheDir(cacheKey) : this.buildSvgaFile(cacheKey)).exists();
    }

    @NotNull
    public final String buildCacheKey(@NotNull String str) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = str;
        Object object2 = "UTF-8";
        Object object3 = messageDigest;
        boolean bl = false;
        Charset charset = Charset.forName((String)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object2 = object = charset;
        bl = false;
        byte[] byArray = string.getBytes((Charset)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        ((MessageDigest)object3).update((byte[])object);
        byte[] digest = messageDigest.digest();
        String sb = "";
        for (byte b : digest) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{b};
            object3 = new StringBuilder().append(sb);
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            sb = ((StringBuilder)object3).append((String)object).toString();
        }
        return sb;
    }

    @NotNull
    public final String buildCacheKey(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String string = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
        return this.buildCacheKey(string);
    }

    @NotNull
    public final File buildCacheDir(@NotNull String cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        return new File(this.getCacheDir() + cacheKey + '/');
    }

    @NotNull
    public final File buildSvgaFile(@NotNull String cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        return new File(this.getCacheDir() + cacheKey + ".svga");
    }

    @NotNull
    public final File buildAudioFile(@NotNull String audio) {
        Intrinsics.checkParameterIsNotNull((Object)audio, (String)"audio");
        return new File(this.getCacheDir() + audio + ".mp3");
    }

    private SVGACache() {
    }

    static {
        SVGACache sVGACache;
        INSTANCE = sVGACache = new SVGACache();
        type = Type.DEFAULT;
        cacheDir = "/";
    }

    public static final /* synthetic */ String access$getCacheDir$p(SVGACache $this) {
        return $this.getCacheDir();
    }

    public static final /* synthetic */ void access$setCacheDir$p(SVGACache $this, String string) {
        SVGACache sVGACache = $this;
        cacheDir = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/opensource/svgaplayer/SVGACache$Type;", "", "(Ljava/lang/String;I)V", "DEFAULT", "FILE", "com.opensource.svgaplayer"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type DEFAULT;
        public static final /* enum */ Type FILE;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[2];
            Type[] typeArray2 = typeArray;
            typeArray[0] = DEFAULT = new Type();
            typeArray[1] = FILE = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

