/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.content.Context;
import android.net.http.HttpResponseCache;
import android.os.Handler;
import android.os.Looper;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAParserKt;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.proto.MovieEntity;
import com.opensource.svgaplayer.utils.log.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 62\u00020\u0001:\u0003678B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001a\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J*\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010 \u001a\u00020!J \u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u001a\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u001a\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010/\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0007J\u001a\u0010/\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\u001a\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\u0012\u00101\u001a\u0004\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\rJ\u0018\u00105\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/opensource/svgaplayer/SVGAParser;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "fileDownloader", "Lcom/opensource/svgaplayer/SVGAParser$FileDownloader;", "getFileDownloader", "()Lcom/opensource/svgaplayer/SVGAParser$FileDownloader;", "setFileDownloader", "(Lcom/opensource/svgaplayer/SVGAParser$FileDownloader;)V", "mContext", "mFrameHeight", "", "mFrameWidth", "buildCacheDir", "Ljava/io/File;", "cacheKey", "", "buildCacheKey", "url", "Ljava/net/URL;", "str", "decodeFromAssets", "", "name", "callback", "Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "decodeFromCacheKey", "decodeFromInputStream", "inputStream", "Ljava/io/InputStream;", "closeInputStream", "", "decodeFromURL", "Lkotlin/Function0;", "inflate", "", "byteArray", "init", "invokeCompleteCallback", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "invokeErrorCallback", "e", "Ljava/lang/Exception;", "isCached", "parse", "assetsName", "readAsBytes", "setFrameSize", "frameWidth", "frameHeight", "unzip", "Companion", "FileDownloader", "ParseCompletion", "com.opensource.svgaplayer"})
public final class SVGAParser {
    private Context mContext;
    private volatile int mFrameWidth;
    private volatile int mFrameHeight;
    @NotNull
    private FileDownloader fileDownloader;
    private static final String TAG = "SVGAParser";
    private static final AtomicInteger threadNum;
    private static SVGAParser mShareParser;
    private static ExecutorService threadPoolExecutor;
    public static final Companion Companion;

    @NotNull
    public final FileDownloader getFileDownloader() {
        return this.fileDownloader;
    }

    public final void setFileDownloader(@NotNull FileDownloader fileDownloader) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloader, (String)"<set-?>");
        this.fileDownloader = fileDownloader;
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mContext = context.getApplicationContext();
    }

    public final void setFrameSize(int frameWidth, int frameHeight) {
        this.mFrameWidth = frameWidth;
        this.mFrameHeight = frameHeight;
    }

    public final void decodeFromAssets(@NotNull String name, @Nullable ParseCompletion callback) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.mContext == null) {
            LogUtils.INSTANCE.error(TAG, "\u5728\u914d\u7f6e SVGAParser context \u524d, \u65e0\u6cd5\u89e3\u6790 SVGA \u6587\u4ef6\u3002");
            return;
        }
        try {
            LogUtils.INSTANCE.info(TAG, "================ decode from assets ================");
            threadPoolExecutor.execute(new Runnable(this, name, callback){
                final /* synthetic */ SVGAParser this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ ParseCompletion $callback;

                public final void run() {
                    block0: {
                        Object object;
                        Object object2 = SVGAParser.access$getMContext$p(this.this$0);
                        if (object2 == null || (object2 = object2.getAssets()) == null || (object2 = object2.open(this.$name)) == null) break block0;
                        Object it = object = object2;
                        this.this$0.decodeFromInputStream((InputStream)it, SVGAParser.access$buildCacheKey(this.this$0, "file:///assets/" + this.$name), this.$callback, true);
                    }
                }
                {
                    this.this$0 = sVGAParser;
                    this.$name = string;
                    this.$callback = parseCompletion;
                }
            });
        }
        catch (Exception e) {
            this.invokeErrorCallback(e, callback);
        }
    }

    @Nullable
    public final Function0<Unit> decodeFromURL(@NotNull URL url, @Nullable ParseCompletion callback) {
        Function0<Unit> function0;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (this.mContext == null) {
            LogUtils.INSTANCE.error(TAG, "\u5728\u914d\u7f6e SVGAParser context \u524d, \u65e0\u6cd5\u89e3\u6790 SVGA \u6587\u4ef6\u3002");
            return null;
        }
        LogUtils.INSTANCE.info(TAG, "================ decode from url ================");
        if (this.isCached(this.buildCacheKey(url))) {
            LogUtils.INSTANCE.info(TAG, "this url cached");
            threadPoolExecutor.execute(new Runnable(this, url, callback){
                final /* synthetic */ SVGAParser this$0;
                final /* synthetic */ URL $url;
                final /* synthetic */ ParseCompletion $callback;

                public final void run() {
                    SVGAParser.access$decodeFromCacheKey(this.this$0, SVGAParser.access$buildCacheKey(this.this$0, this.$url), this.$callback);
                }
                {
                    this.this$0 = sVGAParser;
                    this.$url = uRL;
                    this.$callback = parseCompletion;
                }
            });
            function0 = null;
        } else {
            LogUtils.INSTANCE.info(TAG, "no cached, prepare to download");
            function0 = this.fileDownloader.resume(url, (Function1<? super InputStream, Unit>)((Function1)new Function1<InputStream, Unit>(this, url, callback){
                final /* synthetic */ SVGAParser this$0;
                final /* synthetic */ URL $url;
                final /* synthetic */ ParseCompletion $callback;

                public final void invoke(@NotNull InputStream it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    SVGAParser.decodeFromInputStream$default(this.this$0, it, SVGAParser.access$buildCacheKey(this.this$0, this.$url), this.$callback, false, 8, null);
                }
                {
                    this.this$0 = sVGAParser;
                    this.$url = uRL;
                    this.$callback = parseCompletion;
                    super(1);
                }
            }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this, callback){
                final /* synthetic */ SVGAParser this$0;
                final /* synthetic */ ParseCompletion $callback;

                public final void invoke(@NotNull Exception it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    SVGAParser.access$invokeErrorCallback(this.this$0, it, this.$callback);
                }
                {
                    this.this$0 = sVGAParser;
                    this.$callback = parseCompletion;
                    super(1);
                }
            }));
        }
        return function0;
    }

    public final void decodeFromInputStream(@NotNull InputStream inputStream, @NotNull String cacheKey, @Nullable ParseCompletion callback, boolean closeInputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        if (this.mContext == null) {
            LogUtils.INSTANCE.error(TAG, "\u5728\u914d\u7f6e SVGAParser context \u524d, \u65e0\u6cd5\u89e3\u6790 SVGA \u6587\u4ef6\u3002");
            return;
        }
        LogUtils.INSTANCE.info(TAG, "================ decode from input stream ================");
        threadPoolExecutor.execute(new Runnable(this, inputStream, cacheKey, callback, closeInputStream){
            final /* synthetic */ SVGAParser this$0;
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ String $cacheKey;
            final /* synthetic */ ParseCompletion $callback;
            final /* synthetic */ boolean $closeInputStream;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                block21: {
                    try {
                        byte[] byArray = SVGAParser.access$readAsBytes(this.this$0, this.$inputStream);
                        if (byArray != null) {
                            byte[] byArray2 = byArray;
                            byte[] bytes = byArray2;
                            if (bytes.length > 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4) {
                                LogUtils.INSTANCE.info("SVGAParser", "decode from zip file");
                                if (!SVGAParser.access$buildCacheDir(this.this$0, this.$cacheKey).exists() || SVGAParserKt.access$isUnzipping$p()) {
                                    Integer n = SVGAParserKt.access$getFileLock$p();
                                    synchronized (n) {
                                        Object object;
                                        if (!SVGAParser.access$buildCacheDir(this.this$0, this.$cacheKey).exists()) {
                                            SVGAParserKt.access$setUnzipping$p(true);
                                            LogUtils.INSTANCE.info("SVGAParser", "no cached, prepare to unzip");
                                            Closeable closeable = new ByteArrayInputStream(bytes);
                                            object = null;
                                            try {
                                                ByteArrayInputStream it = (ByteArrayInputStream)closeable;
                                                SVGAParser.access$unzip(this.this$0, it, this.$cacheKey);
                                                SVGAParserKt.access$setUnzipping$p(false);
                                                LogUtils.INSTANCE.info("SVGAParser", "unzip success");
                                                it = Unit.INSTANCE;
                                            }
                                            catch (Throwable it) {
                                                object = it;
                                                throw it;
                                            }
                                            finally {
                                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                                            }
                                        }
                                        object = Unit.INSTANCE;
                                    }
                                }
                                SVGAParser.access$decodeFromCacheKey(this.this$0, this.$cacheKey, this.$callback);
                                break block21;
                            }
                            LogUtils.INSTANCE.info("SVGAParser", "decode from input stream, inflate start");
                            byte[] byArray3 = SVGAParser.access$inflate(this.this$0, bytes);
                            if (byArray3 != null) {
                                byte[] byArray4;
                                byte[] it = byArray4 = byArray3;
                                Object object = MovieEntity.ADAPTER.decode(it);
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"MovieEntity.ADAPTER.decode(it)");
                                SVGAVideoEntity videoItem = new SVGAVideoEntity((MovieEntity)((Object)object), new File(this.$cacheKey), SVGAParser.access$getMFrameWidth$p(this.this$0), SVGAParser.access$getMFrameHeight$p(this.this$0));
                                videoItem.prepare$com_opensource_svgaplayer((Function0<Unit>)((Function0)new Function0<Unit>(videoItem, this){
                                    final /* synthetic */ SVGAVideoEntity $videoItem;
                                    final /* synthetic */ decodeFromInputStream.1 this$0;
                                    {
                                        this.$videoItem = sVGAVideoEntity;
                                        this.this$0 = var2_2;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        LogUtils.INSTANCE.info("SVGAParser", "decode from input stream, inflate end");
                                        SVGAParser.access$invokeCompleteCallback(this.this$0.this$0, this.$videoItem, this.this$0.$callback);
                                    }
                                }));
                            } else {
                                LogUtils.INSTANCE.error("SVGAParser", "inflate(bytes) cause exception");
                            }
                            break block21;
                        }
                        LogUtils.INSTANCE.error("SVGAParser", "readAsBytes(inputStream) cause exception");
                    }
                    catch (Exception e) {
                        SVGAParser.access$invokeErrorCallback(this.this$0, e, this.$callback);
                    }
                    finally {
                        if (this.$closeInputStream) {
                            this.$inputStream.close();
                        }
                    }
                }
            }
            {
                this.this$0 = sVGAParser;
                this.$inputStream = inputStream;
                this.$cacheKey = string;
                this.$callback = parseCompletion;
                this.$closeInputStream = bl;
            }
        });
    }

    public static /* synthetic */ void decodeFromInputStream$default(SVGAParser sVGAParser, InputStream inputStream, String string, ParseCompletion parseCompletion, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        sVGAParser.decodeFromInputStream(inputStream, string, parseCompletion, bl);
    }

    @Deprecated(message="This method has been deprecated from 2.4.0.", replaceWith=@ReplaceWith(imports={}, expression="this.decodeFromAssets(assetsName, callback)"))
    public final void parse(@NotNull String assetsName, @Nullable ParseCompletion callback) {
        Intrinsics.checkParameterIsNotNull((Object)assetsName, (String)"assetsName");
        this.decodeFromAssets(assetsName, callback);
    }

    @Deprecated(message="This method has been deprecated from 2.4.0.", replaceWith=@ReplaceWith(imports={}, expression="this.decodeFromURL(url, callback)"))
    public final void parse(@NotNull URL url, @Nullable ParseCompletion callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.decodeFromURL(url, callback);
    }

    @Deprecated(message="This method has been deprecated from 2.4.0.", replaceWith=@ReplaceWith(imports={}, expression="this.decodeFromInputStream(inputStream, cacheKey, callback, closeInputStream)"))
    public final void parse(@NotNull InputStream inputStream, @NotNull String cacheKey, @Nullable ParseCompletion callback, boolean closeInputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        this.decodeFromInputStream(inputStream, cacheKey, callback, closeInputStream);
    }

    @Deprecated(message="This method has been deprecated from 2.4.0.", replaceWith=@ReplaceWith(imports={}, expression="this.decodeFromInputStream(inputStream, cacheKey, callback, closeInputStream)"))
    public static /* synthetic */ void parse$default(SVGAParser sVGAParser, InputStream inputStream, String string, ParseCompletion parseCompletion, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        sVGAParser.parse(inputStream, string, parseCompletion, bl);
    }

    private final void invokeCompleteCallback(SVGAVideoEntity videoItem, ParseCompletion callback) {
        new Handler(Looper.getMainLooper()).post(new Runnable(callback, videoItem){
            final /* synthetic */ ParseCompletion $callback;
            final /* synthetic */ SVGAVideoEntity $videoItem;

            public final void run() {
                block0: {
                    LogUtils.INSTANCE.info("SVGAParser", "================ parser complete ================");
                    ParseCompletion parseCompletion = this.$callback;
                    if (parseCompletion == null) break block0;
                    parseCompletion.onComplete(this.$videoItem);
                }
            }
            {
                this.$callback = parseCompletion;
                this.$videoItem = sVGAVideoEntity;
            }
        });
    }

    private final void invokeErrorCallback(Exception e, ParseCompletion callback) {
        e.printStackTrace();
        LogUtils.INSTANCE.error(TAG, "================ parser error ================");
        LogUtils.INSTANCE.error(TAG, "error", e);
        new Handler(Looper.getMainLooper()).post(new Runnable(callback){
            final /* synthetic */ ParseCompletion $callback;

            public final void run() {
                block0: {
                    ParseCompletion parseCompletion = this.$callback;
                    if (parseCompletion == null) break block0;
                    parseCompletion.onError();
                }
            }
            {
                this.$callback = parseCompletion;
            }
        });
    }

    private final boolean isCached(String cacheKey) {
        return this.buildCacheDir(cacheKey).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void decodeFromCacheKey(String cacheKey, ParseCompletion callback) {
        block25: {
            LogUtils.INSTANCE.info(TAG, "================ decode from cache ================");
            LogUtils.INSTANCE.debug(TAG, "decodeFromCacheKey called with cacheKey : " + cacheKey);
            if (this.mContext == null) {
                LogUtils.INSTANCE.error(TAG, "\u5728\u914d\u7f6e SVGAParser context \u524d, \u65e0\u6cd5\u89e3\u6790 SVGA \u6587\u4ef6\u3002");
                return;
            }
            try {
                Throwable throwable;
                File file;
                Object object = this.mContext;
                File cacheDir = new File((object != null && (object = object.getCacheDir()) != null ? ((File)object).getAbsolutePath() : null) + "/" + cacheKey + "/");
                File it = file = new File(cacheDir, "movie.binary");
                File file2 = it.isFile() ? file : null;
                if (file2 != null) {
                    File binaryFile = file = file2;
                    try {
                        LogUtils.INSTANCE.info(TAG, "binary change to entity");
                        Closeable $i$a$1$takeIf = new FileInputStream(binaryFile);
                        throwable = null;
                        try {
                            FileInputStream it2 = (FileInputStream)$i$a$1$takeIf;
                            LogUtils.INSTANCE.info(TAG, "binary change to entity success");
                            Object object2 = MovieEntity.ADAPTER.decode((InputStream)it2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"MovieEntity.ADAPTER.decode(it)");
                            this.invokeCompleteCallback(new SVGAVideoEntity((MovieEntity)((Object)object2), cacheDir, this.mFrameWidth, this.mFrameHeight), callback);
                            it2 = Unit.INSTANCE;
                        }
                        catch (Throwable it2) {
                            throwable = it2;
                            throw it2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$i$a$1$takeIf, (Throwable)throwable);
                        }
                    }
                    catch (Exception e) {
                        LogUtils.INSTANCE.error(TAG, "binary change to entity fail", e);
                        cacheDir.delete();
                        binaryFile.delete();
                        throw (Throwable)e;
                    }
                }
                it = file = new File(cacheDir, "movie.spec");
                File file3 = it.isFile() ? file : null;
                if (file3 == null) break block25;
                File jsonFile = file = file3;
                try {
                    LogUtils.INSTANCE.info(TAG, "spec change to entity");
                    Closeable $i$a$3$takeIf = new FileInputStream(jsonFile);
                    throwable = null;
                    try {
                        FileInputStream fileInputStream = (FileInputStream)$i$a$3$takeIf;
                        Closeable closeable = new ByteArrayOutputStream();
                        Throwable throwable2 = null;
                        try {
                            JSONObject jSONObject;
                            String string;
                            int size;
                            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
                            byte[] buffer = new byte[2048];
                            while ((size = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                                byteArrayOutputStream.write(buffer, 0, size);
                            }
                            String it3 = string = byteArrayOutputStream.toString();
                            JSONObject it4 = jSONObject = new JSONObject(it3);
                            LogUtils.INSTANCE.info(TAG, "spec change to entity success");
                            this.invokeCompleteCallback(new SVGAVideoEntity(it4, cacheDir, this.mFrameWidth, this.mFrameHeight), callback);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$i$a$3$takeIf, (Throwable)throwable);
                    }
                }
                catch (Exception e) {
                    LogUtils.INSTANCE.error(TAG, "spec change to entity fail", e);
                    cacheDir.delete();
                    jsonFile.delete();
                    throw (Throwable)e;
                }
            }
            catch (Exception e) {
                this.invokeErrorCallback(e, callback);
            }
        }
    }

    private final String buildCacheKey(String str) {
        Object object;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = str;
        Object object2 = "UTF-8";
        Object object3 = messageDigest;
        Charset charset = Charset.forName((String)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object2 = object = charset;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        ((MessageDigest)object3).update((byte[])object);
        byte[] digest = messageDigest.digest();
        String sb = "";
        for (byte b : digest) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%02x";
            Object[] objectArray = new Object[]{b};
            object3 = new StringBuilder().append(sb);
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            sb = ((StringBuilder)object3).append((String)object).toString();
        }
        return sb;
    }

    private final String buildCacheKey(URL url) {
        String string = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
        return this.buildCacheKey(string);
    }

    private final File buildCacheDir(String cacheKey) {
        Object object = this.mContext;
        return new File((object != null && (object = object.getCacheDir()) != null ? ((File)object).getAbsolutePath() : null) + "/" + cacheKey + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] readAsBytes(InputStream inputStream) {
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            int count;
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
            byte[] byteArray = new byte[2048];
            while ((count = inputStream.read(byteArray, 0, 2048)) > 0) {
                byteArrayOutputStream.write(byteArray, 0, count);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] inflate(byte[] byteArray) {
        Inflater inflater = new Inflater();
        inflater.setInput(byteArray, 0, byteArray.length);
        byte[] inflatedBytes = new byte[2048];
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            int count;
            ByteArrayOutputStream inflatedOutputStream = (ByteArrayOutputStream)closeable;
            while ((count = inflater.inflate(inflatedBytes, 0, 2048)) > 0) {
                inflatedOutputStream.write(inflatedBytes, 0, count);
            }
            inflater.end();
            byte[] byArray = inflatedOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unzip(InputStream inputStream, String cacheKey) {
        LogUtils.INSTANCE.info(TAG, "================ unzip prepare ================");
        File cacheDir = this.buildCacheDir(cacheKey);
        cacheDir.mkdirs();
        try {
            Closeable closeable = new BufferedInputStream(inputStream);
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)closeable;
                Closeable closeable2 = new ZipInputStream(it);
                Throwable throwable2 = null;
                try {
                    ZipInputStream zipInputStream = (ZipInputStream)closeable2;
                    while (zipInputStream.getNextEntry() != null) {
                        ZipEntry zipItem;
                        String string = zipItem.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zipItem.name");
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"../", (boolean)false, (int)2, null)) continue;
                        String string2 = zipItem.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"zipItem.name");
                        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"/", (boolean)false, (int)2, null)) continue;
                        File file = new File(cacheDir, zipItem.getName());
                        Closeable closeable3 = new FileOutputStream(file);
                        Throwable throwable3 = null;
                        try {
                            int readBytes;
                            FileOutputStream fileOutputStream = (FileOutputStream)closeable3;
                            byte[] buff = new byte[2048];
                            while ((readBytes = zipInputStream.read(buff)) > 0) {
                                fileOutputStream.write(buff, 0, readBytes);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        LogUtils.INSTANCE.error(TAG, "================ unzip complete ================");
                        zipInputStream.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LogUtils.INSTANCE.error(TAG, "================ unzip error ================");
            LogUtils.INSTANCE.error(TAG, "error", e);
            cacheDir.delete();
            throw (Throwable)e;
        }
    }

    public SVGAParser(@Nullable Context context) {
        Context context2 = context;
        this.mContext = context2 != null ? context2.getApplicationContext() : null;
        this.fileDownloader = new FileDownloader();
    }

    static {
        Companion = new Companion(null);
        threadNum = new AtomicInteger(0);
        mShareParser = new SVGAParser(null);
        threadPoolExecutor = Executors.newCachedThreadPool(Companion.threadPoolExecutor.1.INSTANCE);
    }

    @Nullable
    public static final /* synthetic */ Context access$getMContext$p(SVGAParser $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(SVGAParser $this, @Nullable Context context) {
        $this.mContext = context;
    }

    @NotNull
    public static final /* synthetic */ String access$buildCacheKey(SVGAParser $this, @NotNull String str) {
        return $this.buildCacheKey(str);
    }

    public static final /* synthetic */ void access$decodeFromCacheKey(SVGAParser $this, @NotNull String cacheKey, @Nullable ParseCompletion callback) {
        $this.decodeFromCacheKey(cacheKey, callback);
    }

    @NotNull
    public static final /* synthetic */ String access$buildCacheKey(SVGAParser $this, @NotNull URL url) {
        return $this.buildCacheKey(url);
    }

    public static final /* synthetic */ void access$invokeErrorCallback(SVGAParser $this, @NotNull Exception e, @Nullable ParseCompletion callback) {
        $this.invokeErrorCallback(e, callback);
    }

    @Nullable
    public static final /* synthetic */ byte[] access$readAsBytes(SVGAParser $this, @NotNull InputStream inputStream) {
        return $this.readAsBytes(inputStream);
    }

    @NotNull
    public static final /* synthetic */ File access$buildCacheDir(SVGAParser $this, @NotNull String cacheKey) {
        return $this.buildCacheDir(cacheKey);
    }

    public static final /* synthetic */ void access$unzip(SVGAParser $this, @NotNull InputStream inputStream, @NotNull String cacheKey) {
        $this.unzip(inputStream, cacheKey);
    }

    @Nullable
    public static final /* synthetic */ byte[] access$inflate(SVGAParser $this, @NotNull byte[] byteArray) {
        return $this.inflate(byteArray);
    }

    public static final /* synthetic */ int access$getMFrameWidth$p(SVGAParser $this) {
        return $this.mFrameWidth;
    }

    public static final /* synthetic */ void access$setMFrameWidth$p(SVGAParser $this, int n) {
        $this.mFrameWidth = n;
    }

    public static final /* synthetic */ int access$getMFrameHeight$p(SVGAParser $this) {
        return $this.mFrameHeight;
    }

    public static final /* synthetic */ void access$setMFrameHeight$p(SVGAParser $this, int n) {
        $this.mFrameHeight = n;
    }

    public static final /* synthetic */ void access$invokeCompleteCallback(SVGAParser $this, @NotNull SVGAVideoEntity videoItem, @Nullable ParseCompletion callback) {
        $this.invokeCompleteCallback(videoItem, callback);
    }

    public static final /* synthetic */ void access$setMShareParser$cp(@NotNull SVGAParser sVGAParser) {
        mShareParser = sVGAParser;
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getThreadNum$cp() {
        return threadNum;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "", "onComplete", "", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "onError", "com.opensource.svgaplayer"})
    public static interface ParseCompletion {
        public void onComplete(@NotNull SVGAVideoEntity var1);

        public void onError();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J`\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000b0\u000f2%\u0010\u0014\u001a!\u0012\u0017\u0012\u00150\u0015j\u0002`\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/opensource/svgaplayer/SVGAParser$FileDownloader;", "", "()V", "noCache", "", "getNoCache", "()Z", "setNoCache", "(Z)V", "resume", "Lkotlin/Function0;", "", "url", "Ljava/net/URL;", "complete", "Lkotlin/Function1;", "Ljava/io/InputStream;", "Lkotlin/ParameterName;", "name", "inputStream", "failure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "com.opensource.svgaplayer"})
    public static class FileDownloader {
        private boolean noCache;

        public final boolean getNoCache() {
            return this.noCache;
        }

        public final void setNoCache(boolean bl) {
            this.noCache = bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Function0<Unit> resume(@NotNull URL url, @NotNull Function1<? super InputStream, Unit> complete, @NotNull Function1<? super Exception, Unit> failure) {
            void cancelled;
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(complete, (String)"complete");
            Intrinsics.checkParameterIsNotNull(failure, (String)"failure");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            Function0 cancelBlock2 = (Function0)new Function0<Unit>((Ref.BooleanRef)cancelled){
                final /* synthetic */ Ref.BooleanRef $cancelled;

                public final void invoke() {
                    this.$cancelled.element = true;
                }
                {
                    this.$cancelled = booleanRef;
                    super(0);
                }
            };
            Companion.getThreadPoolExecutor$com_opensource_svgaplayer().execute(new Runnable(this, url, (Ref.BooleanRef)cancelled, complete, failure){
                final /* synthetic */ FileDownloader this$0;
                final /* synthetic */ URL $url;
                final /* synthetic */ Ref.BooleanRef $cancelled;
                final /* synthetic */ Function1 $complete;
                final /* synthetic */ Function1 $failure;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    block24: {
                        try {
                            HttpURLConnection httpURLConnection;
                            URLConnection uRLConnection;
                            LogUtils.INSTANCE.info("SVGAParser", "================ svga file download start ================");
                            if (HttpResponseCache.getInstalled() == null && !this.this$0.getNoCache()) {
                                LogUtils.INSTANCE.error("SVGAParser", "SVGAParser can not handle cache before install HttpResponseCache. see https://github.com/yyued/SVGAPlayer-Android#cache");
                                LogUtils.INSTANCE.error("SVGAParser", "\u5728\u914d\u7f6e HttpResponseCache \u524d SVGAParser \u65e0\u6cd5\u7f13\u5b58. \u67e5\u770b https://github.com/yyued/SVGAPlayer-Android#cache ");
                            }
                            if (!((uRLConnection = this.$url.openConnection()) instanceof HttpURLConnection)) {
                                uRLConnection = null;
                            }
                            HttpURLConnection httpURLConnection2 = (HttpURLConnection)uRLConnection;
                            if (httpURLConnection2 == null) break block24;
                            HttpURLConnection it = httpURLConnection = httpURLConnection2;
                            it.setConnectTimeout(20000);
                            it.setRequestMethod("GET");
                            it.connect();
                            Closeable closeable = it.getInputStream();
                            Throwable throwable = null;
                            try {
                                InputStream inputStream = (InputStream)closeable;
                                Closeable closeable2 = new ByteArrayOutputStream();
                                Throwable throwable2 = null;
                                try {
                                    ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable2;
                                    byte[] buffer = new byte[4096];
                                    while (true) {
                                        if (this.$cancelled.element) {
                                            LogUtils.INSTANCE.warn("SVGAParser", "================ svga file download canceled ================");
                                            break;
                                        }
                                        int count = inputStream.read(buffer, 0, 4096);
                                        if (count == -1) break;
                                        outputStream.write(buffer, 0, count);
                                    }
                                    if (this.$cancelled.element) {
                                        LogUtils.INSTANCE.warn("SVGAParser", "================ svga file download canceled ================");
                                        return;
                                    }
                                    Closeable closeable3 = new ByteArrayInputStream(outputStream.toByteArray());
                                    Throwable throwable3 = null;
                                    try {
                                        ByteArrayInputStream it2 = (ByteArrayInputStream)closeable3;
                                        LogUtils.INSTANCE.info("SVGAParser", "================ svga file download complete ================");
                                        this.$complete.invoke((Object)it2);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable5) {
                                    throwable2 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable6) {
                                throwable = throwable6;
                                throw throwable6;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        catch (Exception e) {
                            LogUtils.INSTANCE.error("SVGAParser", "================ svga file download fail ================");
                            LogUtils.INSTANCE.error("SVGAParser", "error: " + e.getMessage());
                            e.printStackTrace();
                            this.$failure.invoke((Object)e);
                        }
                    }
                }
                {
                    this.this$0 = fileDownloader;
                    this.$url = uRL;
                    this.$cancelled = booleanRef;
                    this.$complete = function1;
                    this.$failure = function12;
                }
            });
            return cancelBlock2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/opensource/svgaplayer/SVGAParser$Companion;", "", "()V", "TAG", "", "mShareParser", "Lcom/opensource/svgaplayer/SVGAParser;", "threadNum", "Ljava/util/concurrent/atomic/AtomicInteger;", "threadPoolExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getThreadPoolExecutor$com_opensource_svgaplayer", "()Ljava/util/concurrent/ExecutorService;", "setThreadPoolExecutor$com_opensource_svgaplayer", "(Ljava/util/concurrent/ExecutorService;)V", "setThreadPoolExecutor", "", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "shareParser", "com.opensource.svgaplayer"})
    public static final class Companion {
        public final ExecutorService getThreadPoolExecutor$com_opensource_svgaplayer() {
            return threadPoolExecutor;
        }

        public final void setThreadPoolExecutor$com_opensource_svgaplayer(ExecutorService executorService) {
            threadPoolExecutor = executorService;
        }

        public final void setThreadPoolExecutor(@NotNull ThreadPoolExecutor executor) {
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            this.setThreadPoolExecutor$com_opensource_svgaplayer(executor);
        }

        @NotNull
        public final SVGAParser shareParser() {
            return mShareParser;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

