/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.opensource.svgaplayer.R;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAClickAreaListener;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.utils.SVGARange;
import com.opensource.svgaplayer.utils.log.LogUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001:\u0003[\\]B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00101\u001a\u000202H\u0002J\u0016\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000006H\u0002J\b\u00107\u001a\u000208H\u0002J\n\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010;\u001a\u0002022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010<\u001a\u0002022\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0012\u0010?\u001a\u0002022\b\u0010@\u001a\u0004\u0018\u00010&H\u0002J\b\u0010A\u001a\u000202H\u0014J\u0012\u0010B\u001a\u00020\u00122\b\u0010C\u001a\u0004\u0018\u00010DH\u0017J\u0010\u0010E\u001a\u0002022\u0006\u0010F\u001a\u00020\nH\u0002J\u0006\u0010G\u001a\u000202J\u001a\u0010H\u001a\u0002022\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020\u0012H\u0002J\u000e\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020/J\u0010\u0010N\u001a\u0002022\b\u0010O\u001a\u0004\u0018\u00010PJ\u001a\u0010N\u001a\u0002022\b\u0010O\u001a\u0004\u0018\u00010P2\b\u0010Q\u001a\u0004\u0018\u00010RJ\b\u0010S\u001a\u000202H\u0002J\u0006\u0010T\u001a\u000202J\u0010\u0010T\u001a\u0002022\u0006\u0010O\u001a\u00020PH\u0002J\u001a\u0010T\u001a\u0002022\b\u0010I\u001a\u0004\u0018\u00010J2\b\b\u0002\u0010K\u001a\u00020\u0012J\u0016\u0010U\u001a\u0002022\u0006\u0010V\u001a\u00020\u00072\u0006\u0010W\u001a\u00020\u0012J\u0016\u0010X\u001a\u0002022\u0006\u0010Y\u001a\u0002082\u0006\u0010W\u001a\u00020\u0012J\u0006\u0010Z\u001a\u000202J\u000e\u0010Z\u001a\u0002022\u0006\u00101\u001a\u00020\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/opensource/svgaplayer/SVGAImageView;", "Landroid/widget/ImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "callback", "Lcom/opensource/svgaplayer/SVGACallback;", "getCallback", "()Lcom/opensource/svgaplayer/SVGACallback;", "setCallback", "(Lcom/opensource/svgaplayer/SVGACallback;)V", "clearsAfterStop", "", "getClearsAfterStop", "()Z", "setClearsAfterStop", "(Z)V", "fillMode", "Lcom/opensource/svgaplayer/SVGAImageView$FillMode;", "getFillMode", "()Lcom/opensource/svgaplayer/SVGAImageView$FillMode;", "setFillMode", "(Lcom/opensource/svgaplayer/SVGAImageView$FillMode;)V", "<set-?>", "isAnimating", "setAnimating", "loops", "getLoops", "()I", "setLoops", "(I)V", "mAnimator", "Landroid/animation/ValueAnimator;", "mAnimatorListener", "Lcom/opensource/svgaplayer/SVGAImageView$AnimatorListener;", "mAnimatorUpdateListener", "Lcom/opensource/svgaplayer/SVGAImageView$AnimatorUpdateListener;", "mAntiAlias", "mAutoPlay", "mEndFrame", "mItemClickAreaListener", "Lcom/opensource/svgaplayer/SVGAClickAreaListener;", "mStartFrame", "clear", "", "createParseCompletion", "Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "ref", "Ljava/lang/ref/WeakReference;", "generateScale", "", "getSVGADrawable", "Lcom/opensource/svgaplayer/SVGADrawable;", "loadAttrs", "onAnimationEnd", "animation", "Landroid/animation/Animator;", "onAnimatorUpdate", "animator", "onDetachedFromWindow", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "parserSource", "source", "pauseAnimation", "play", "range", "Lcom/opensource/svgaplayer/utils/SVGARange;", "reverse", "setOnAnimKeyClickListener", "clickListener", "setVideoItem", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "setupDrawable", "startAnimation", "stepToFrame", "frame", "andPlay", "stepToPercentage", "percentage", "stopAnimation", "AnimatorListener", "AnimatorUpdateListener", "FillMode", "com.opensource.svgaplayer"})
public class SVGAImageView
extends ImageView {
    private final String TAG = "SVGAImageView";
    private boolean isAnimating;
    private int loops;
    private boolean clearsAfterStop;
    @NotNull
    private FillMode fillMode;
    @Nullable
    private SVGACallback callback;
    private ValueAnimator mAnimator;
    private SVGAClickAreaListener mItemClickAreaListener;
    private boolean mAntiAlias;
    private boolean mAutoPlay;
    private final AnimatorListener mAnimatorListener;
    private final AnimatorUpdateListener mAnimatorUpdateListener;
    private int mStartFrame;
    private int mEndFrame;
    private HashMap _$_findViewCache;

    public final boolean isAnimating() {
        return this.isAnimating;
    }

    private final void setAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    public final int getLoops() {
        return this.loops;
    }

    public final void setLoops(int n) {
        this.loops = n;
    }

    public final boolean getClearsAfterStop() {
        return this.clearsAfterStop;
    }

    public final void setClearsAfterStop(boolean bl) {
        this.clearsAfterStop = bl;
    }

    @NotNull
    public final FillMode getFillMode() {
        return this.fillMode;
    }

    public final void setFillMode(@NotNull FillMode fillMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fillMode), (String)"<set-?>");
        this.fillMode = fillMode;
    }

    @Nullable
    public final SVGACallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable SVGACallback sVGACallback) {
        this.callback = sVGACallback;
    }

    private final void loadAttrs(AttributeSet attrs) {
        String it;
        String string;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SVGAImageView, 0, 0);
        this.loops = typedArray.getInt(R.styleable.SVGAImageView_loopCount, 0);
        this.clearsAfterStop = typedArray.getBoolean(R.styleable.SVGAImageView_clearsAfterStop, true);
        this.mAntiAlias = typedArray.getBoolean(R.styleable.SVGAImageView_antiAlias, true);
        this.mAutoPlay = typedArray.getBoolean(R.styleable.SVGAImageView_autoPlay, true);
        String string2 = typedArray.getString(R.styleable.SVGAImageView_fillMode);
        if (string2 != null) {
            string = string2;
            it = string;
            if (Intrinsics.areEqual((Object)it, (Object)"0")) {
                this.fillMode = FillMode.Backward;
            } else if (Intrinsics.areEqual((Object)it, (Object)"1")) {
                this.fillMode = FillMode.Forward;
            }
        }
        String string3 = typedArray.getString(R.styleable.SVGAImageView_source);
        if (string3 != null) {
            it = string = string3;
            this.parserSource(it);
        }
        typedArray.recycle();
    }

    private final void parserSource(String source) {
        WeakReference<SVGAImageView> refImgView = new WeakReference<SVGAImageView>(this);
        SVGAParser parser = new SVGAParser(this.getContext());
        if (StringsKt.startsWith$default((String)source, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)source, (String)"https://", (boolean)false, (int)2, null)) {
            parser.decodeFromURL(new URL(source), this.createParseCompletion(refImgView));
        } else {
            parser.decodeFromAssets(source, this.createParseCompletion(refImgView));
        }
    }

    private final SVGAParser.ParseCompletion createParseCompletion(WeakReference<SVGAImageView> ref) {
        return new SVGAParser.ParseCompletion(ref){
            final /* synthetic */ WeakReference $ref;

            public void onComplete(@NotNull SVGAVideoEntity videoItem) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
                    SVGAImageView sVGAImageView = (SVGAImageView)((Object)this.$ref.get());
                    if (sVGAImageView == null) break block0;
                    SVGAImageView.access$startAnimation(sVGAImageView, videoItem);
                }
            }

            public void onError() {
            }
            {
                this.$ref = $captured_local_variable$0;
            }
        };
    }

    private final void startAnimation(SVGAVideoEntity videoItem) {
        this.post(new Runnable(this, videoItem){
            final /* synthetic */ SVGAImageView this$0;
            final /* synthetic */ SVGAVideoEntity $videoItem;

            public final void run() {
                this.$videoItem.setAntiAlias(SVGAImageView.access$getMAntiAlias$p(this.this$0));
                this.this$0.setVideoItem(this.$videoItem);
                SVGADrawable sVGADrawable = SVGAImageView.access$getSVGADrawable(this.this$0);
                if (sVGADrawable != null) {
                    ImageView.ScaleType scaleType = this.this$0.getScaleType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)scaleType, (String)"scaleType");
                    sVGADrawable.setScaleType(scaleType);
                }
                if (SVGAImageView.access$getMAutoPlay$p(this.this$0)) {
                    this.this$0.startAnimation();
                }
            }
            {
                this.this$0 = sVGAImageView;
                this.$videoItem = sVGAVideoEntity;
            }
        });
    }

    public final void startAnimation() {
        this.startAnimation(null, false);
    }

    public final void startAnimation(@Nullable SVGARange range, boolean reverse) {
        this.stopAnimation(false);
        this.play(range, reverse);
    }

    public static /* synthetic */ void startAnimation$default(SVGAImageView sVGAImageView, SVGARange sVGARange, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAnimation");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        sVGAImageView.startAnimation(sVGARange, bl);
    }

    private final void play(SVGARange range, boolean reverse) {
        ValueAnimator animator;
        LogUtils.INSTANCE.info(this.TAG, "================ start animation ================");
        SVGADrawable sVGADrawable = this.getSVGADrawable();
        if (sVGADrawable == null) {
            return;
        }
        SVGADrawable drawable = sVGADrawable;
        this.setupDrawable();
        SVGARange sVGARange = range;
        this.mStartFrame = Math.max(0, sVGARange != null ? sVGARange.getLocation() : 0);
        SVGAVideoEntity videoItem = drawable.getVideoItem();
        SVGARange sVGARange2 = range;
        SVGARange sVGARange3 = range;
        this.mEndFrame = Math.min(videoItem.getFrames() - 1, (sVGARange2 != null ? sVGARange2.getLocation() : 0) + (sVGARange3 != null ? sVGARange3.getLength() : Integer.MAX_VALUE) - 1);
        ValueAnimator valueAnimator = animator = ValueAnimator.ofInt((int[])new int[]{this.mStartFrame, this.mEndFrame});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setDuration((long)((double)((this.mEndFrame - this.mStartFrame + 1) * (1000 / videoItem.getFPS())) / this.generateScale()));
        animator.setRepeatCount(this.loops <= 0 ? 99999 : this.loops - 1);
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mAnimatorUpdateListener);
        animator.addListener((Animator.AnimatorListener)this.mAnimatorListener);
        if (reverse) {
            animator.reverse();
        } else {
            animator.start();
        }
        this.mAnimator = animator;
    }

    private final void setupDrawable() {
        SVGADrawable sVGADrawable = this.getSVGADrawable();
        if (sVGADrawable == null) {
            return;
        }
        SVGADrawable drawable = sVGADrawable;
        drawable.setCleared$com_opensource_svgaplayer(false);
        ImageView.ScaleType scaleType = this.getScaleType();
        Intrinsics.checkExpressionValueIsNotNull((Object)scaleType, (String)"scaleType");
        drawable.setScaleType(scaleType);
    }

    private final SVGADrawable getSVGADrawable() {
        Drawable drawable = this.getDrawable();
        if (!(drawable instanceof SVGADrawable)) {
            drawable = null;
        }
        return (SVGADrawable)drawable;
    }

    private final double generateScale() {
        double scale = 1.0;
        try {
            Class<?> clazz = Class.forName("android.animation.ValueAnimator");
            if (clazz == null) {
                return scale;
            }
            Class<?> animatorClass = clazz;
            Field field = animatorClass.getDeclaredField("sDurationScale");
            if (field == null) {
                return scale;
            }
            Field field2 = field;
            field2.setAccessible(true);
            scale = field2.getFloat(animatorClass);
            if (scale == 0.0) {
                field2.setFloat(animatorClass, 1.0f);
                scale = 1.0;
                LogUtils.INSTANCE.info(this.TAG, "The animation duration scale has been reset to 1.0x, because you closed it on developer options.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scale;
    }

    private final void onAnimatorUpdate(ValueAnimator animator) {
        block2: {
            SVGADrawable sVGADrawable = this.getSVGADrawable();
            if (sVGADrawable == null) {
                return;
            }
            SVGADrawable drawable = sVGADrawable;
            ValueAnimator valueAnimator = animator;
            Object object = valueAnimator != null ? valueAnimator.getAnimatedValue() : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            drawable.setCurrentFrame$com_opensource_svgaplayer((Integer)object);
            double percentage = (double)(drawable.getCurrentFrame() + 1) / (double)drawable.getVideoItem().getFrames();
            SVGACallback sVGACallback = this.callback;
            if (sVGACallback == null) break block2;
            sVGACallback.onStep(drawable.getCurrentFrame(), percentage);
        }
    }

    private final void onAnimationEnd(Animator animation) {
        block7: {
            this.isAnimating = false;
            this.stopAnimation();
            SVGADrawable drawable = this.getSVGADrawable();
            if (!this.clearsAfterStop && drawable != null) {
                if (this.fillMode == FillMode.Backward) {
                    drawable.setCurrentFrame$com_opensource_svgaplayer(this.mStartFrame);
                } else if (this.fillMode == FillMode.Forward) {
                    drawable.setCurrentFrame$com_opensource_svgaplayer(this.mEndFrame);
                }
            }
            if (this.clearsAfterStop) {
                Animator animator = animation;
                if (animator == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.animation.ValueAnimator");
                }
                if (((ValueAnimator)animator).getRepeatCount() <= 0) {
                    this.clear();
                }
            }
            SVGACallback sVGACallback = this.callback;
            if (sVGACallback == null) break block7;
            sVGACallback.onFinished();
        }
    }

    private final void clear() {
        SVGADrawable sVGADrawable = this.getSVGADrawable();
        if (sVGADrawable != null) {
            sVGADrawable.setCleared$com_opensource_svgaplayer(true);
        }
        SVGADrawable sVGADrawable2 = this.getSVGADrawable();
        if (sVGADrawable2 != null) {
            sVGADrawable2.clear$com_opensource_svgaplayer();
        }
        this.setImageDrawable(null);
    }

    public final void pauseAnimation() {
        block0: {
            this.stopAnimation(false);
            SVGACallback sVGACallback = this.callback;
            if (sVGACallback == null) break block0;
            sVGACallback.onPause();
        }
    }

    public final void stopAnimation() {
        this.stopAnimation(this.clearsAfterStop);
    }

    public final void stopAnimation(boolean clear) {
        block3: {
            ValueAnimator valueAnimator = this.mAnimator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            ValueAnimator valueAnimator2 = this.mAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllListeners();
            }
            ValueAnimator valueAnimator3 = this.mAnimator;
            if (valueAnimator3 != null) {
                valueAnimator3.removeAllUpdateListeners();
            }
            SVGADrawable sVGADrawable = this.getSVGADrawable();
            if (sVGADrawable == null) break block3;
            sVGADrawable.setCleared$com_opensource_svgaplayer(clear);
        }
    }

    public final void setVideoItem(@Nullable SVGAVideoEntity videoItem) {
        this.setVideoItem(videoItem, new SVGADynamicEntity());
    }

    public final void setVideoItem(@Nullable SVGAVideoEntity videoItem, @Nullable SVGADynamicEntity dynamicItem) {
        if (videoItem == null) {
            this.setImageDrawable(null);
        } else {
            SVGADynamicEntity sVGADynamicEntity = dynamicItem;
            if (sVGADynamicEntity == null) {
                sVGADynamicEntity = new SVGADynamicEntity();
            }
            SVGADrawable drawable = new SVGADrawable(videoItem, sVGADynamicEntity);
            drawable.setCleared$com_opensource_svgaplayer(this.clearsAfterStop);
            this.setImageDrawable(drawable);
        }
    }

    public final void stepToFrame(int frame, boolean andPlay) {
        block2: {
            this.pauseAnimation();
            SVGADrawable sVGADrawable = this.getSVGADrawable();
            if (sVGADrawable == null) {
                return;
            }
            SVGADrawable drawable = sVGADrawable;
            drawable.setCurrentFrame$com_opensource_svgaplayer(frame);
            if (!andPlay) break block2;
            this.startAnimation();
            ValueAnimator valueAnimator = this.mAnimator;
            if (valueAnimator != null) {
                ValueAnimator valueAnimator2;
                ValueAnimator it = valueAnimator2 = valueAnimator;
                it.setCurrentPlayTime((long)(Math.max(0.0f, Math.min(1.0f, (float)frame / (float)drawable.getVideoItem().getFrames())) * (float)it.getDuration()));
            }
        }
    }

    public final void stepToPercentage(double percentage, boolean andPlay) {
        Drawable drawable = this.getDrawable();
        if (!(drawable instanceof SVGADrawable)) {
            drawable = null;
        }
        SVGADrawable sVGADrawable = (SVGADrawable)drawable;
        if (sVGADrawable == null) {
            return;
        }
        SVGADrawable drawable2 = sVGADrawable;
        int frame = (int)((double)drawable2.getVideoItem().getFrames() * percentage);
        if (frame >= drawable2.getVideoItem().getFrames() && frame > 0) {
            frame = drawable2.getVideoItem().getFrames() - 1;
        }
        this.stepToFrame(frame, andPlay);
    }

    public final void setOnAnimKeyClickListener(@NotNull SVGAClickAreaListener clickListener) {
        Intrinsics.checkParameterIsNotNull((Object)clickListener, (String)"clickListener");
        this.mItemClickAreaListener = clickListener;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        MotionEvent motionEvent = event;
        if (motionEvent == null || motionEvent.getAction() != 0) {
            return super.onTouchEvent(event);
        }
        SVGADrawable sVGADrawable = this.getSVGADrawable();
        if (sVGADrawable == null) {
            return false;
        }
        SVGADrawable drawable = sVGADrawable;
        Map map = drawable.getDynamicItem().getMClickMap$com_opensource_svgaplayer();
        for (Map.Entry entry : map.entrySet()) {
            Object object = entry;
            String key = (String)object.getKey();
            object = entry;
            int[] value = (int[])object.getValue();
            if (!(event.getX() >= (float)value[0]) || !(event.getX() <= (float)value[2]) || !(event.getY() >= (float)value[1]) || !(event.getY() <= (float)value[3])) continue;
            SVGAClickAreaListener sVGAClickAreaListener = this.mItemClickAreaListener;
            if (sVGAClickAreaListener == null) continue;
            Object it = object = sVGAClickAreaListener;
            it.onClick(key);
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation(true);
        this.clear();
    }

    @JvmOverloads
    public SVGAImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block1: {
            AttributeSet attributeSet;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            this.TAG = "SVGAImageView";
            this.clearsAfterStop = true;
            this.fillMode = FillMode.Forward;
            this.mAntiAlias = true;
            this.mAutoPlay = true;
            this.mAnimatorListener = new AnimatorListener(this);
            this.mAnimatorUpdateListener = new AnimatorUpdateListener(this);
            if (Build.VERSION.SDK_INT < 18) {
                this.setLayerType(1, null);
            }
            AttributeSet attributeSet2 = attrs;
            if (attributeSet2 == null) break block1;
            AttributeSet it = attributeSet = attributeSet2;
            this.loadAttrs(it);
        }
    }

    @JvmOverloads
    public /* synthetic */ SVGAImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SVGAImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SVGAImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$isAnimating$p(SVGAImageView $this) {
        return $this.isAnimating;
    }

    public static final /* synthetic */ void access$startAnimation(SVGAImageView $this, @NotNull SVGAVideoEntity videoItem) {
        $this.startAnimation(videoItem);
    }

    public static final /* synthetic */ boolean access$getMAntiAlias$p(SVGAImageView $this) {
        return $this.mAntiAlias;
    }

    public static final /* synthetic */ void access$setMAntiAlias$p(SVGAImageView $this, boolean bl) {
        $this.mAntiAlias = bl;
    }

    @Nullable
    public static final /* synthetic */ SVGADrawable access$getSVGADrawable(SVGAImageView $this) {
        return $this.getSVGADrawable();
    }

    public static final /* synthetic */ boolean access$getMAutoPlay$p(SVGAImageView $this) {
        return $this.mAutoPlay;
    }

    public static final /* synthetic */ void access$setMAutoPlay$p(SVGAImageView $this, boolean bl) {
        $this.mAutoPlay = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/opensource/svgaplayer/SVGAImageView$FillMode;", "", "(Ljava/lang/String;I)V", "Backward", "Forward", "com.opensource.svgaplayer"})
    public static final class FillMode
    extends Enum<FillMode> {
        public static final /* enum */ FillMode Backward;
        public static final /* enum */ FillMode Forward;
        private static final /* synthetic */ FillMode[] $VALUES;

        static {
            FillMode[] fillModeArray = new FillMode[2];
            FillMode[] fillModeArray2 = fillModeArray;
            fillModeArray[0] = Backward = new FillMode();
            fillModeArray[1] = Forward = new FillMode();
            $VALUES = fillModeArray;
        }

        public static FillMode[] values() {
            return (FillMode[])$VALUES.clone();
        }

        public static FillMode valueOf(String string) {
            return Enum.valueOf(FillMode.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/opensource/svgaplayer/SVGAImageView$AnimatorListener;", "Landroid/animation/Animator$AnimatorListener;", "view", "Lcom/opensource/svgaplayer/SVGAImageView;", "(Lcom/opensource/svgaplayer/SVGAImageView;)V", "weakReference", "Ljava/lang/ref/WeakReference;", "onAnimationCancel", "", "animation", "Landroid/animation/Animator;", "onAnimationEnd", "onAnimationRepeat", "onAnimationStart", "com.opensource.svgaplayer"})
    private static final class AnimatorListener
    implements Animator.AnimatorListener {
        private final WeakReference<SVGAImageView> weakReference;

        public void onAnimationRepeat(@Nullable Animator animation) {
            block0: {
                Object object = (SVGAImageView)((Object)this.weakReference.get());
                if (object == null || (object = object.getCallback()) == null) break block0;
                object.onRepeat();
            }
        }

        public void onAnimationEnd(@Nullable Animator animation) {
            block0: {
                SVGAImageView sVGAImageView = (SVGAImageView)((Object)this.weakReference.get());
                if (sVGAImageView == null) break block0;
                sVGAImageView.onAnimationEnd(animation);
            }
        }

        public void onAnimationCancel(@Nullable Animator animation) {
            block0: {
                SVGAImageView sVGAImageView = (SVGAImageView)((Object)this.weakReference.get());
                if (sVGAImageView == null) break block0;
                sVGAImageView.isAnimating = false;
            }
        }

        public void onAnimationStart(@Nullable Animator animation) {
            block0: {
                SVGAImageView sVGAImageView = (SVGAImageView)((Object)this.weakReference.get());
                if (sVGAImageView == null) break block0;
                sVGAImageView.isAnimating = true;
            }
        }

        public AnimatorListener(@NotNull SVGAImageView view) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            this.weakReference = new WeakReference<SVGAImageView>(view);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/opensource/svgaplayer/SVGAImageView$AnimatorUpdateListener;", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "view", "Lcom/opensource/svgaplayer/SVGAImageView;", "(Lcom/opensource/svgaplayer/SVGAImageView;)V", "weakReference", "Ljava/lang/ref/WeakReference;", "onAnimationUpdate", "", "animation", "Landroid/animation/ValueAnimator;", "com.opensource.svgaplayer"})
    private static final class AnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private final WeakReference<SVGAImageView> weakReference;

        public void onAnimationUpdate(@Nullable ValueAnimator animation) {
            block0: {
                SVGAImageView sVGAImageView = (SVGAImageView)((Object)this.weakReference.get());
                if (sVGAImageView == null) break block0;
                sVGAImageView.onAnimatorUpdate(animation);
            }
        }

        public AnimatorUpdateListener(@NotNull SVGAImageView view) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            this.weakReference = new WeakReference<SVGAImageView>(view);
        }
    }
}

