/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.media.SoundPool;
import android.os.Build;
import com.opensource.svgaplayer.bitmap.SVGABitmapByteArrayDecoder;
import com.opensource.svgaplayer.bitmap.SVGABitmapFileDecoder;
import com.opensource.svgaplayer.entities.SVGAAudioEntity;
import com.opensource.svgaplayer.entities.SVGAVideoSpriteEntity;
import com.opensource.svgaplayer.proto.AudioEntity;
import com.opensource.svgaplayer.proto.MovieEntity;
import com.opensource.svgaplayer.proto.MovieParams;
import com.opensource.svgaplayer.proto.SpriteEntity;
import com.opensource.svgaplayer.utils.SVGARect;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB'\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\r\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bGJ\u001a\u0010H\u001a\u0004\u0018\u00010(2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020'H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010(2\u0006\u0010K\u001a\u00020'H\u0002J$\u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020N2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00050&H\u0002J\u001c\u0010P\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00050&2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020J0&2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010R\u001a\u00020'2\u0006\u0010S\u001a\u00020'2\u0006\u0010T\u001a\u00020'H\u0002J\u0018\u0010U\u001a\n V*\u0004\u0018\u000106062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010W\u001a\u00020F2\u0006\u0010X\u001a\u00020\fH\u0002J\u0010\u0010W\u001a\u00020F2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001b\u0010Y\u001a\u00020F2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020F0[H\u0000\u00a2\u0006\u0002\b\\J\u0010\u0010]\u001a\u00020F2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010]\u001a\u00020F2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010^\u001a\u00020F2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020F0[H\u0002J\u0010\u0010`\u001a\u00020F2\u0006\u0010a\u001a\u00020\u0003H\u0002J\u0010\u0010b\u001a\u00020F2\u0006\u0010c\u001a\u00020dH\u0002J\u001e\u0010e\u001a\u00020F2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020F0[H\u0002R$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0012\"\u0004\b$\u0010\u0014R&\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00100\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R \u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001f\"\u0004\b>\u0010!R$\u0010@\u001a\u00020?2\u0006\u0010\u000f\u001a\u00020?@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006f"}, d2={"Lcom/opensource/svgaplayer/SVGAVideoEntity;", "", "json", "Lorg/json/JSONObject;", "cacheDir", "Ljava/io/File;", "(Lorg/json/JSONObject;Ljava/io/File;)V", "frameWidth", "", "frameHeight", "(Lorg/json/JSONObject;Ljava/io/File;II)V", "entity", "Lcom/opensource/svgaplayer/proto/MovieEntity;", "(Lcom/opensource/svgaplayer/proto/MovieEntity;Ljava/io/File;)V", "(Lcom/opensource/svgaplayer/proto/MovieEntity;Ljava/io/File;II)V", "<set-?>", "FPS", "getFPS", "()I", "setFPS", "(I)V", "antiAlias", "", "getAntiAlias", "()Z", "setAntiAlias", "(Z)V", "audioList", "", "Lcom/opensource/svgaplayer/entities/SVGAAudioEntity;", "getAudioList$com_opensource_svgaplayer", "()Ljava/util/List;", "setAudioList$com_opensource_svgaplayer", "(Ljava/util/List;)V", "frames", "getFrames", "setFrames", "imageMap", "Ljava/util/HashMap;", "", "Landroid/graphics/Bitmap;", "getImageMap$com_opensource_svgaplayer", "()Ljava/util/HashMap;", "setImageMap$com_opensource_svgaplayer", "(Ljava/util/HashMap;)V", "mCacheDir", "mFrameHeight", "mFrameWidth", "movieItem", "getMovieItem", "()Lcom/opensource/svgaplayer/proto/MovieEntity;", "setMovieItem", "(Lcom/opensource/svgaplayer/proto/MovieEntity;)V", "soundPool", "Landroid/media/SoundPool;", "getSoundPool$com_opensource_svgaplayer", "()Landroid/media/SoundPool;", "setSoundPool$com_opensource_svgaplayer", "(Landroid/media/SoundPool;)V", "spriteList", "Lcom/opensource/svgaplayer/entities/SVGAVideoSpriteEntity;", "getSpriteList$com_opensource_svgaplayer", "setSpriteList$com_opensource_svgaplayer", "Lcom/opensource/svgaplayer/utils/SVGARect;", "videoSize", "getVideoSize", "()Lcom/opensource/svgaplayer/utils/SVGARect;", "setVideoSize", "(Lcom/opensource/svgaplayer/utils/SVGARect;)V", "clear", "", "clear$com_opensource_svgaplayer", "createBitmap", "byteArray", "", "filePath", "createSvgaAudioEntity", "audio", "Lcom/opensource/svgaplayer/proto/AudioEntity;", "audiosFileMap", "generateAudioFileMap", "generateAudioMap", "generateBitmapFilePath", "imgName", "imgKey", "generateSoundPool", "kotlin.jvm.PlatformType", "parserImages", "obj", "prepare", "callback", "Lkotlin/Function0;", "prepare$com_opensource_svgaplayer", "resetSprites", "setupAudios", "completionBlock", "setupByJson", "movieObject", "setupByMovie", "movieParams", "Lcom/opensource/svgaplayer/proto/MovieParams;", "setupSoundPool", "com.opensource.svgaplayer"})
public final class SVGAVideoEntity {
    private boolean antiAlias;
    @Nullable
    private MovieEntity movieItem;
    @NotNull
    private SVGARect videoSize;
    private int FPS;
    private int frames;
    @NotNull
    private List<SVGAVideoSpriteEntity> spriteList;
    @NotNull
    private List<SVGAAudioEntity> audioList;
    @Nullable
    private SoundPool soundPool;
    @NotNull
    private HashMap<String, Bitmap> imageMap;
    private File mCacheDir;
    private int mFrameHeight;
    private int mFrameWidth;

    public final boolean getAntiAlias() {
        return this.antiAlias;
    }

    public final void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    @Nullable
    public final MovieEntity getMovieItem() {
        return this.movieItem;
    }

    public final void setMovieItem(@Nullable MovieEntity movieEntity) {
        this.movieItem = movieEntity;
    }

    @NotNull
    public final SVGARect getVideoSize() {
        return this.videoSize;
    }

    private final void setVideoSize(SVGARect sVGARect) {
        this.videoSize = sVGARect;
    }

    public final int getFPS() {
        return this.FPS;
    }

    private final void setFPS(int n) {
        this.FPS = n;
    }

    public final int getFrames() {
        return this.frames;
    }

    private final void setFrames(int n) {
        this.frames = n;
    }

    @NotNull
    public final List<SVGAVideoSpriteEntity> getSpriteList$com_opensource_svgaplayer() {
        return this.spriteList;
    }

    public final void setSpriteList$com_opensource_svgaplayer(@NotNull List<SVGAVideoSpriteEntity> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.spriteList = list;
    }

    @NotNull
    public final List<SVGAAudioEntity> getAudioList$com_opensource_svgaplayer() {
        return this.audioList;
    }

    public final void setAudioList$com_opensource_svgaplayer(@NotNull List<SVGAAudioEntity> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.audioList = list;
    }

    @Nullable
    public final SoundPool getSoundPool$com_opensource_svgaplayer() {
        return this.soundPool;
    }

    public final void setSoundPool$com_opensource_svgaplayer(@Nullable SoundPool soundPool) {
        this.soundPool = soundPool;
    }

    @NotNull
    public final HashMap<String, Bitmap> getImageMap$com_opensource_svgaplayer() {
        return this.imageMap;
    }

    public final void setImageMap$com_opensource_svgaplayer(@NotNull HashMap<String, Bitmap> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.imageMap = hashMap;
    }

    private final void setupByJson(JSONObject movieObject) {
        JSONObject jSONObject = movieObject.optJSONObject("viewBox");
        if (jSONObject != null) {
            JSONObject jSONObject2;
            JSONObject viewBoxObject = jSONObject2 = jSONObject;
            double width = viewBoxObject.optDouble("width", 0.0);
            double height = viewBoxObject.optDouble("height", 0.0);
            this.videoSize = new SVGARect(0.0, 0.0, width, height);
        }
        this.FPS = movieObject.optInt("fps", 20);
        this.frames = movieObject.optInt("frames", 0);
    }

    private final void setupByMovie(MovieParams movieParams) {
        Float f = movieParams.viewBoxWidth;
        double width = f != null ? f.floatValue() : 0.0f;
        Float f2 = movieParams.viewBoxHeight;
        double height = f2 != null ? f2.floatValue() : 0.0f;
        this.videoSize = new SVGARect(0.0, 0.0, width, height);
        Integer n = movieParams.fps;
        this.FPS = n != null ? n : 20;
        Integer n2 = movieParams.frames;
        this.frames = n2 != null ? n2 : 0;
    }

    public final void prepare$com_opensource_svgaplayer(@NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.movieItem == null) {
            callback.invoke();
        } else {
            MovieEntity movieEntity = this.movieItem;
            if (movieEntity == null) {
                Intrinsics.throwNpe();
            }
            this.setupAudios(movieEntity, (Function0<Unit>)((Function0)new Function0<Unit>(callback){
                final /* synthetic */ Function0 $callback;

                public final void invoke() {
                    this.$callback.invoke();
                }
                {
                    this.$callback = function0;
                    super(0);
                }
            }));
        }
    }

    private final void parserImages(JSONObject json) {
        Iterator $receiver$iv;
        Iterator iterator;
        JSONObject jSONObject = json.optJSONObject("images");
        if (jSONObject == null) {
            return;
        }
        JSONObject imgJson = jSONObject;
        Iterator iterator2 = imgJson.keys();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"imgJson.keys()");
        Iterator iterator3 = iterator = ($receiver$iv = iterator2);
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            String imgKey = (String)element$iv;
            String string = imgJson.get(imgKey).toString();
            String string2 = imgKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"imgKey");
            String filePath = this.generateBitmapFilePath(string, string2);
            CharSequence charSequence = filePath;
            if (charSequence.length() == 0) {
                return;
            }
            String bitmapKey = StringsKt.replace$default((String)imgKey, (String)".matte", (String)"", (boolean)false, (int)4, null);
            Bitmap bitmap = this.createBitmap(filePath);
            if (bitmap == null) continue;
            Map map = this.imageMap;
            Bitmap bitmap2 = bitmap;
            map.put(bitmapKey, bitmap2);
        }
    }

    private final String generateBitmapFilePath(String imgName, String imgKey) {
        String path = this.mCacheDir.getAbsolutePath() + "/" + imgName;
        String path1 = path + ".png";
        String path2 = this.mCacheDir.getAbsolutePath() + "/" + imgKey + ".png";
        return new File(path).exists() ? path : (new File(path1).exists() ? path1 : (new File(path2).exists() ? path2 : ""));
    }

    private final Bitmap createBitmap(String filePath) {
        return SVGABitmapFileDecoder.INSTANCE.decodeBitmapFrom(filePath, this.mFrameWidth, this.mFrameHeight);
    }

    private final void parserImages(MovieEntity obj) {
        Map<String, ByteString> map = obj.images;
        if (map != null && (map = map.entrySet()) != null) {
            Iterable $receiver$iv = (Iterable)((Object)map);
            for (Object element$iv : $receiver$iv) {
                List fileTag;
                Map.Entry entry = (Map.Entry)element$iv;
                byte[] byteArray = ((ByteString)entry.getValue()).toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteArray, (String)"byteArray");
                byte[] byArray = byteArray;
                if (byArray.length < 4 || ((Number)(fileTag = ArraysKt.slice((byte[])byteArray, (IntRange)new IntRange(0, 3))).get(0)).byteValue() == 73 && ((Number)fileTag.get(1)).byteValue() == 68 && ((Number)fileTag.get(2)).byteValue() == 51) continue;
                String string = ((ByteString)entry.getValue()).utf8();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.value.utf8()");
                Object k = entry.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"entry.key");
                String filePath = this.generateBitmapFilePath(string, (String)k);
                if (this.createBitmap(byteArray, filePath) != null) {
                    Object k2;
                    Bitmap bitmap;
                    Bitmap bitmap2 = bitmap;
                    Map map2 = this.imageMap;
                    Intrinsics.checkExpressionValueIsNotNull(entry.getKey(), (String)"entry.key");
                    Bitmap bitmap3 = bitmap2;
                    map2.put(k2, bitmap3);
                }
            }
        }
    }

    private final Bitmap createBitmap(byte[] byteArray, String filePath) {
        Bitmap bitmap = SVGABitmapByteArrayDecoder.INSTANCE.decodeBitmapFrom(byteArray, this.mFrameWidth, this.mFrameHeight);
        Bitmap bitmap2 = bitmap;
        if (bitmap2 == null) {
            bitmap2 = this.createBitmap(filePath);
        }
        return bitmap2;
    }

    /*
     * WARNING - void declaration
     */
    private final void resetSprites(JSONObject json) {
        List mutableList = new ArrayList();
        JSONArray jSONArray = json.optJSONArray("sprites");
        if (jSONArray != null) {
            JSONArray jSONArray2;
            JSONArray item = jSONArray2 = jSONArray;
            int n = 0;
            int n2 = item.length();
            while (n < n2) {
                void i;
                if (item.optJSONObject((int)i) != null) {
                    JSONObject jSONObject;
                    JSONObject entryJson = jSONObject;
                    mutableList.add(new SVGAVideoSpriteEntity(entryJson));
                }
                ++i;
            }
        }
        this.spriteList = CollectionsKt.toList((Iterable)mutableList);
    }

    /*
     * WARNING - void declaration
     */
    private final void resetSprites(MovieEntity entity) {
        List list;
        SVGAVideoEntity sVGAVideoEntity;
        SVGAVideoEntity sVGAVideoEntity2 = this;
        List<SpriteEntity> list2 = entity.sprites;
        if (list2 != null) {
            Collection<SVGAVideoSpriteEntity> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = list2;
            SVGAVideoEntity sVGAVideoEntity3 = sVGAVideoEntity2;
            void var3_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                SpriteEntity spriteEntity = (SpriteEntity)((Object)item$iv$iv);
                collection = destination$iv$iv;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                SVGAVideoSpriteEntity sVGAVideoSpriteEntity = new SVGAVideoSpriteEntity((SpriteEntity)v2);
                collection.add(sVGAVideoSpriteEntity);
            }
            collection = (List)destination$iv$iv;
            sVGAVideoEntity = sVGAVideoEntity3;
            list = collection;
        } else {
            SVGAVideoEntity sVGAVideoEntity4 = sVGAVideoEntity2;
            List list3 = CollectionsKt.emptyList();
            sVGAVideoEntity = sVGAVideoEntity4;
            list = list3;
        }
        sVGAVideoEntity.spriteList = list;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupAudios(MovieEntity entity, Function0<Unit> completionBlock) {
        Collection<SVGAAudioEntity> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        if (entity.audios == null || entity.audios.isEmpty()) {
            completionBlock.invoke();
            return;
        }
        this.setupSoundPool(entity, completionBlock);
        HashMap<String, File> audiosFileMap = this.generateAudioFileMap(entity);
        Iterable iterable = entity.audios;
        SVGAVideoEntity sVGAVideoEntity = this;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void audio;
            AudioEntity audioEntity = (AudioEntity)((Object)item$iv$iv);
            collection = destination$iv$iv;
            void v0 = audio;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"audio");
            SVGAAudioEntity sVGAAudioEntity = this.createSvgaAudioEntity((AudioEntity)v0, audiosFileMap);
            collection.add(sVGAAudioEntity);
        }
        collection = (List)destination$iv$iv;
        sVGAVideoEntity.audioList = collection;
    }

    private final SVGAAudioEntity createSvgaAudioEntity(AudioEntity audio, HashMap<String, File> audiosFileMap) {
        SVGAAudioEntity item;
        block1: {
            File file;
            item = new SVGAAudioEntity(audio);
            Integer n = audio.startTime;
            double startTime = n != null ? n : 0;
            Integer n2 = audio.totalTime;
            double totalTime = n2 != null ? n2 : 0;
            if ((int)totalTime == 0) {
                return item;
            }
            File file2 = audiosFileMap.get(audio.audioKey);
            if (file2 == null) break block1;
            File it = file = file2;
            FileInputStream fis = new FileInputStream(it);
            double length = fis.available();
            long offset = (long)(startTime / totalTime * length);
            SoundPool soundPool = this.soundPool;
            item.setSoundID(soundPool != null ? Integer.valueOf(soundPool.load(fis.getFD(), offset, (long)length, 1)) : null);
            fis.close();
        }
        return item;
    }

    private final HashMap<String, File> generateAudioFileMap(MovieEntity entity) {
        HashMap<String, byte[]> audiosDataMap = this.generateAudioMap(entity);
        HashMap<String, File> audiosFileMap = new HashMap<String, File>();
        Map map = audiosDataMap;
        if (map.size() > 0) {
            Map $receiver$iv;
            Map map2 = $receiver$iv = (Map)audiosDataMap;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                File file;
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                File tmpFile = File.createTempFile((String)it.getKey() + "_tmp", ".mp3");
                FileOutputStream fos = new FileOutputStream(tmpFile);
                fos.write((byte[])it.getValue());
                fos.flush();
                fos.close();
                Map map3 = audiosFileMap;
                Object k = it.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)tmpFile, (String)"tmpFile");
                map3.put(k, file);
            }
        }
        return audiosFileMap;
    }

    private final HashMap<String, byte[]> generateAudioMap(MovieEntity entity) {
        HashMap<String, byte[]> audiosDataMap = new HashMap<String, byte[]>();
        Map<String, ByteString> map = entity.images;
        if (map != null && (map = map.entrySet()) != null) {
            Iterable $receiver$iv = (Iterable)((Object)map);
            for (Object element$iv : $receiver$iv) {
                String string;
                List fileTag;
                Map.Entry it = (Map.Entry)element$iv;
                String imageKey = (String)it.getKey();
                byte[] byteArray = ((ByteString)it.getValue()).toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteArray, (String)"byteArray");
                byte[] byArray = byteArray;
                if (byArray.length < 4 || ((Number)(fileTag = ArraysKt.slice((byte[])byteArray, (IntRange)new IntRange(0, 3))).get(0)).byteValue() != 73 || ((Number)fileTag.get(1)).byteValue() != 68 || ((Number)fileTag.get(2)).byteValue() != 51) continue;
                Map map2 = audiosDataMap;
                Intrinsics.checkExpressionValueIsNotNull((Object)imageKey, (String)"imageKey");
                byte[] byArray2 = byteArray;
                map2.put(string, byArray2);
            }
        }
        return audiosDataMap;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupSoundPool(MovieEntity entity, Function0<Unit> completionBlock) {
        block0: {
            void soundLoaded;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            SoundPool soundPool = this.soundPool = this.generateSoundPool(entity);
            if (soundPool == null) break block0;
            soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener((Ref.IntRef)soundLoaded, entity, completionBlock){
                final /* synthetic */ Ref.IntRef $soundLoaded;
                final /* synthetic */ MovieEntity $entity;
                final /* synthetic */ Function0 $completionBlock;

                public final void onLoadComplete(SoundPool $noName_0, int $noName_1, int $noName_2) {
                    int n = this.$soundLoaded.element;
                    int n2 = this.$soundLoaded.element = n + 1;
                    List<AudioEntity> list = this.$entity.audios;
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"entity.audios");
                    Collection collection = list;
                    int n3 = n2;
                    int n4 = collection.size();
                    if (n3 >= n4) {
                        this.$completionBlock.invoke();
                    }
                }
                {
                    this.$soundLoaded = intRef;
                    this.$entity = movieEntity;
                    this.$completionBlock = function0;
                }
            });
        }
    }

    private final SoundPool generateSoundPool(MovieEntity entity) {
        SoundPool soundPool;
        if (Build.VERSION.SDK_INT >= 21) {
            AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).build();
            SoundPool.Builder builder = new SoundPool.Builder().setAudioAttributes(attributes);
            List<AudioEntity> list = entity.audios;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"entity.audios");
            Collection collection = list;
            int n = 12;
            SoundPool.Builder builder2 = builder;
            int n2 = collection.size();
            soundPool = builder2.setMaxStreams(RangesKt.coerceAtMost((int)n, (int)n2)).build();
        } else {
            List<AudioEntity> list = entity.audios;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"entity.audios");
            Collection collection = list;
            int n = 12;
            int n3 = collection.size();
            int n4 = 0;
            int n5 = 3;
            int n6 = RangesKt.coerceAtMost((int)n, (int)n3);
            soundPool = new SoundPool(n6, n5, n4);
        }
        return soundPool;
    }

    public final void clear$com_opensource_svgaplayer() {
        SoundPool soundPool = this.soundPool;
        if (soundPool != null) {
            soundPool.release();
        }
        this.soundPool = null;
        this.audioList = CollectionsKt.emptyList();
        this.spriteList = CollectionsKt.emptyList();
        this.imageMap.clear();
    }

    public SVGAVideoEntity(@NotNull JSONObject json, @NotNull File cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this(json, cacheDir, 0, 0);
    }

    public SVGAVideoEntity(@NotNull JSONObject json, @NotNull File cacheDir, int frameWidth, int frameHeight) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this.antiAlias = true;
        this.videoSize = new SVGARect(0.0, 0.0, 0.0, 0.0);
        this.FPS = 15;
        this.spriteList = CollectionsKt.emptyList();
        this.audioList = CollectionsKt.emptyList();
        this.imageMap = new HashMap();
        this.mFrameWidth = frameWidth;
        this.mFrameHeight = frameHeight;
        this.mCacheDir = cacheDir;
        JSONObject jSONObject = json.optJSONObject("movie");
        if (jSONObject == null) {
            return;
        }
        JSONObject movieJsonObject = jSONObject;
        this.setupByJson(movieJsonObject);
        try {
            this.parserImages(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        this.resetSprites(json);
    }

    public SVGAVideoEntity(@NotNull MovieEntity entity, @NotNull File cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this(entity, cacheDir, 0, 0);
    }

    public SVGAVideoEntity(@NotNull MovieEntity entity, @NotNull File cacheDir, int frameWidth, int frameHeight) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this.antiAlias = true;
        this.videoSize = new SVGARect(0.0, 0.0, 0.0, 0.0);
        this.FPS = 15;
        this.spriteList = CollectionsKt.emptyList();
        this.audioList = CollectionsKt.emptyList();
        this.imageMap = new HashMap();
        this.mFrameWidth = frameWidth;
        this.mFrameHeight = frameHeight;
        this.mCacheDir = cacheDir;
        this.movieItem = entity;
        MovieParams movieParams = entity.params;
        if (movieParams != null) {
            MovieParams movieParams2 = movieParams;
            SVGAVideoEntity sVGAVideoEntity = this;
            MovieParams p1 = movieParams2;
            sVGAVideoEntity.setupByMovie(p1);
        }
        try {
            this.parserImages(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        this.resetSprites(entity);
    }
}

