/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.opensource.svgaplayer.R;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAClickAreaListener;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAImageView$loadAttrs$;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.utils.SVGARange;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001FB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB+\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010-\u001a\u00020,H\u0014J\u0012\u0010.\u001a\u00020\u00162\b\u0010/\u001a\u0004\u0018\u000100H\u0017J\u0006\u00101\u001a\u00020,J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020*J\b\u00104\u001a\u00020,H\u0002J\u0010\u00105\u001a\u00020,2\b\u00106\u001a\u0004\u0018\u000107J\u001a\u00105\u001a\u00020,2\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000109J\u0006\u0010:\u001a\u00020,J\u001a\u0010:\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010<2\b\b\u0002\u0010=\u001a\u00020\u0016J\u0016\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u0016J\u0016\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020\u0016J\u0006\u0010D\u001a\u00020,J\u000e\u0010D\u001a\u00020,2\u0006\u0010E\u001a\u00020\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001aR\u001a\u0010$\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/opensource/svgaplayer/SVGAImageView;", "Landroid/widget/ImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "animator", "Landroid/animation/ValueAnimator;", "callback", "Lcom/opensource/svgaplayer/SVGACallback;", "getCallback", "()Lcom/opensource/svgaplayer/SVGACallback;", "setCallback", "(Lcom/opensource/svgaplayer/SVGACallback;)V", "clearsAfterStop", "", "getClearsAfterStop", "()Z", "setClearsAfterStop", "(Z)V", "fillMode", "Lcom/opensource/svgaplayer/SVGAImageView$FillMode;", "getFillMode", "()Lcom/opensource/svgaplayer/SVGAImageView$FillMode;", "setFillMode", "(Lcom/opensource/svgaplayer/SVGAImageView$FillMode;)V", "<set-?>", "isAnimating", "setAnimating", "loops", "getLoops", "()I", "setLoops", "(I)V", "mItemClickAreaListener", "Lcom/opensource/svgaplayer/SVGAClickAreaListener;", "loadAttrs", "", "onDetachedFromWindow", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pauseAnimation", "setOnAnimKeyClickListener", "clickListener", "setSoftwareLayerType", "setVideoItem", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "startAnimation", "range", "Lcom/opensource/svgaplayer/utils/SVGARange;", "reverse", "stepToFrame", "frame", "andPlay", "stepToPercentage", "percentage", "", "stopAnimation", "clear", "FillMode", "library_release"})
public class SVGAImageView
extends ImageView {
    private boolean isAnimating;
    private int loops;
    private boolean clearsAfterStop;
    @NotNull
    private FillMode fillMode;
    @Nullable
    private SVGACallback callback;
    private ValueAnimator animator;
    private SVGAClickAreaListener mItemClickAreaListener;
    private HashMap _$_findViewCache;

    public final boolean isAnimating() {
        return this.isAnimating;
    }

    private final void setAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    public final int getLoops() {
        return this.loops;
    }

    public final void setLoops(int n) {
        this.loops = n;
    }

    public final boolean getClearsAfterStop() {
        return this.clearsAfterStop;
    }

    public final void setClearsAfterStop(boolean bl) {
        this.clearsAfterStop = bl;
    }

    @NotNull
    public final FillMode getFillMode() {
        return this.fillMode;
    }

    public final void setFillMode(@NotNull FillMode fillMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fillMode), (String)"<set-?>");
        this.fillMode = fillMode;
    }

    @Nullable
    public final SVGACallback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable SVGACallback sVGACallback) {
        this.callback = sVGACallback;
    }

    private final void setSoftwareLayerType() {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
    }

    protected void onDetachedFromWindow() {
        block2: {
            super.onDetachedFromWindow();
            ValueAnimator valueAnimator = this.animator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            ValueAnimator valueAnimator2 = this.animator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllListeners();
            }
            ValueAnimator valueAnimator3 = this.animator;
            if (valueAnimator3 == null) break block2;
            valueAnimator3.removeAllUpdateListeners();
        }
    }

    private final void loadAttrs(AttributeSet attrs) {
        String it;
        String string;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SVGAImageView, 0, 0);
        this.loops = typedArray.getInt(R.styleable.SVGAImageView_loopCount, 0);
        this.clearsAfterStop = typedArray.getBoolean(R.styleable.SVGAImageView_clearsAfterStop, true);
        boolean antiAlias = typedArray.getBoolean(R.styleable.SVGAImageView_antiAlias, true);
        boolean autoPlay = typedArray.getBoolean(R.styleable.SVGAImageView_autoPlay, true);
        String string2 = typedArray.getString(R.styleable.SVGAImageView_fillMode);
        if (string2 != null) {
            string = string2;
            it = string;
            if (Intrinsics.areEqual((Object)it, (Object)"0")) {
                this.fillMode = FillMode.Backward;
            } else if (Intrinsics.areEqual((Object)it, (Object)"1")) {
                this.fillMode = FillMode.Forward;
            }
        }
        String string3 = typedArray.getString(R.styleable.SVGAImageView_source);
        if (string3 != null) {
            it = string = string3;
            Context context2 = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
            SVGAParser parser = new SVGAParser(context2);
            new Thread(new Runnable(it, parser, this, antiAlias, autoPlay){
                final /* synthetic */ String $it;
                final /* synthetic */ SVGAParser $parser;
                final /* synthetic */ SVGAImageView this$0;
                final /* synthetic */ boolean $antiAlias$inlined;
                final /* synthetic */ boolean $autoPlay$inlined;
                {
                    this.$it = string;
                    this.$parser = sVGAParser;
                    this.this$0 = sVGAImageView;
                    this.$antiAlias$inlined = bl;
                    this.$autoPlay$inlined = bl2;
                }

                public final void run() {
                    SVGAParser.ParseCompletion callback = new SVGAParser.ParseCompletion(this){
                        final /* synthetic */ loadAttrs$$inlined$let$lambda$1 this$0;
                        {
                            this.this$0 = $outer;
                        }

                        public void onComplete(@NotNull SVGAVideoEntity videoItem) {
                            Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
                            this.this$0.this$0.post(new Runnable(this, videoItem){
                                final /* synthetic */ loadAttrs$$inlined$let$lambda$1$1 this$0;
                                final /* synthetic */ SVGAVideoEntity $videoItem;
                                {
                                    this.this$0 = var1_1;
                                    this.$videoItem = sVGAVideoEntity;
                                }

                                public final void run() {
                                    this.$videoItem.setAntiAlias(this.this$0.this$0.$antiAlias$inlined);
                                    this.this$0.this$0.this$0.setVideoItem(this.$videoItem);
                                    Drawable drawable = this.this$0.this$0.this$0.getDrawable();
                                    if (!(drawable instanceof SVGADrawable)) {
                                        drawable = null;
                                    }
                                    SVGADrawable sVGADrawable = (SVGADrawable)drawable;
                                    if (sVGADrawable != null) {
                                        ImageView.ScaleType scaleType = this.this$0.this$0.this$0.getScaleType();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)scaleType, (String)"scaleType");
                                        sVGADrawable.setScaleType(scaleType);
                                    }
                                    if (this.this$0.this$0.$autoPlay$inlined) {
                                        this.this$0.this$0.this$0.startAnimation();
                                    }
                                }
                            });
                        }

                        public void onError() {
                        }
                    };
                    if (StringsKt.startsWith$default((String)this.$it, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.$it, (String)"https://", (boolean)false, (int)2, null)) {
                        this.$parser.parse(new URL(this.$it), callback);
                    } else {
                        this.$parser.parse(this.$it, callback);
                    }
                }
            }).start();
        }
        typedArray.recycle();
    }

    public final void startAnimation() {
        this.startAnimation(null, false);
    }

    public final void startAnimation(@Nullable SVGARange range, boolean reverse) {
        SVGAVideoEntity sVGAVideoEntity;
        this.stopAnimation(false);
        Drawable drawable = this.getDrawable();
        if (!(drawable instanceof SVGADrawable)) {
            drawable = null;
        }
        SVGADrawable sVGADrawable = (SVGADrawable)drawable;
        if (sVGADrawable == null) {
            return;
        }
        SVGADrawable drawable2 = sVGADrawable;
        drawable2.setCleared$library_release(false);
        ImageView.ScaleType scaleType = this.getScaleType();
        Intrinsics.checkExpressionValueIsNotNull((Object)scaleType, (String)"scaleType");
        drawable2.setScaleType(scaleType);
        SVGAVideoEntity it = sVGAVideoEntity = drawable2.getVideoItem();
        double durationScale = 1.0;
        SVGARange sVGARange = range;
        int startFrame = Math.max(0, sVGARange != null ? sVGARange.getLocation() : 0);
        SVGARange sVGARange2 = range;
        SVGARange sVGARange3 = range;
        int endFrame = Math.min(it.getFrames() - 1, (sVGARange2 != null ? sVGARange2.getLocation() : 0) + (sVGARange3 != null ? sVGARange3.getLength() : Integer.MAX_VALUE) - 1);
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{startFrame, endFrame});
        try {
            Class<?> animatorClass;
            Class<?> clazz = animatorClass = Class.forName("android.animation.ValueAnimator");
            if (clazz != null) {
                Class<?> clazz2;
                Class<?> it2 = clazz2 = clazz;
                Field field = it2.getDeclaredField("sDurationScale");
                if (field != null) {
                    float f;
                    Field field2;
                    Field it3 = field2 = field;
                    it3.setAccessible(true);
                    float it4 = f = it3.getFloat(animatorClass);
                    durationScale = it4;
                    if (durationScale == 0.0) {
                        it3.setFloat(animatorClass, 1.0f);
                        durationScale = 1.0;
                        Log.e((String)"SVGAPlayer", (String)"The animation duration scale has been reset to 1.0x, because you closed it on developer options.");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ValueAnimator valueAnimator = animator;
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setDuration((long)((double)((endFrame - startFrame + 1) * (1000 / it.getFPS())) / durationScale));
        animator.setRepeatCount(this.loops <= 0 ? 99999 : this.loops - 1);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(animator, this, range, drawable2, reverse){
            final /* synthetic */ ValueAnimator $animator;
            final /* synthetic */ SVGAImageView this$0;
            final /* synthetic */ SVGARange $range$inlined;
            final /* synthetic */ SVGADrawable $drawable$inlined;
            final /* synthetic */ boolean $reverse$inlined;
            {
                this.$animator = valueAnimator;
                this.this$0 = sVGAImageView;
                this.$range$inlined = sVGARange;
                this.$drawable$inlined = sVGADrawable;
                this.$reverse$inlined = bl;
            }

            public final void onAnimationUpdate(ValueAnimator it) {
                block1: {
                    ValueAnimator valueAnimator = this.$animator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.$drawable$inlined.setCurrentFrame$library_release((Integer)object);
                    SVGACallback sVGACallback = this.this$0.getCallback();
                    if (sVGACallback == null) break block1;
                    sVGACallback.onStep(this.$drawable$inlined.getCurrentFrame(), (double)(this.$drawable$inlined.getCurrentFrame() + 1) / (double)this.$drawable$inlined.getVideoItem().getFrames());
                }
            }
        });
        animator.addListener(new Animator.AnimatorListener(startFrame, endFrame, this, range, drawable2, reverse){
            final /* synthetic */ int $startFrame;
            final /* synthetic */ int $endFrame;
            final /* synthetic */ SVGAImageView this$0;
            final /* synthetic */ SVGARange $range$inlined;
            final /* synthetic */ SVGADrawable $drawable$inlined;
            final /* synthetic */ boolean $reverse$inlined;
            {
                this.$startFrame = $captured_local_variable$1;
                this.$endFrame = $captured_local_variable$2;
                this.this$0 = sVGAImageView;
                this.$range$inlined = sVGARange;
                this.$drawable$inlined = sVGADrawable;
                this.$reverse$inlined = bl;
            }

            public void onAnimationRepeat(@Nullable Animator animation) {
                block0: {
                    SVGACallback sVGACallback = this.this$0.getCallback();
                    if (sVGACallback == null) break block0;
                    sVGACallback.onRepeat();
                }
            }

            public void onAnimationEnd(@Nullable Animator animation) {
                block4: {
                    SVGAImageView.access$setAnimating$p(this.this$0, false);
                    this.this$0.stopAnimation();
                    if (!this.this$0.getClearsAfterStop()) {
                        if (this.this$0.getFillMode() == FillMode.Backward) {
                            this.$drawable$inlined.setCurrentFrame$library_release(this.$startFrame);
                        } else if (this.this$0.getFillMode() == FillMode.Forward) {
                            this.$drawable$inlined.setCurrentFrame$library_release(this.$endFrame);
                        }
                    }
                    SVGACallback sVGACallback = this.this$0.getCallback();
                    if (sVGACallback == null) break block4;
                    sVGACallback.onFinished();
                }
            }

            public void onAnimationCancel(@Nullable Animator animation) {
                SVGAImageView.access$setAnimating$p(this.this$0, false);
            }

            public void onAnimationStart(@Nullable Animator animation) {
                SVGAImageView.access$setAnimating$p(this.this$0, true);
            }
        });
        if (reverse) {
            animator.reverse();
        } else {
            animator.start();
        }
        this.animator = animator;
    }

    public static /* synthetic */ void startAnimation$default(SVGAImageView sVGAImageView, SVGARange sVGARange, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAnimation");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        sVGAImageView.startAnimation(sVGARange, bl);
    }

    public final void pauseAnimation() {
        block0: {
            this.stopAnimation(false);
            SVGACallback sVGACallback = this.callback;
            if (sVGACallback == null) break block0;
            sVGACallback.onPause();
        }
    }

    public final void stopAnimation() {
        this.stopAnimation(this.clearsAfterStop);
    }

    public final void stopAnimation(boolean clear) {
        block4: {
            SVGADrawable sVGADrawable;
            Drawable drawable;
            ValueAnimator valueAnimator = this.animator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            ValueAnimator valueAnimator2 = this.animator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllListeners();
            }
            ValueAnimator valueAnimator3 = this.animator;
            if (valueAnimator3 != null) {
                valueAnimator3.removeAllUpdateListeners();
            }
            if (!((drawable = this.getDrawable()) instanceof SVGADrawable)) {
                drawable = null;
            }
            SVGADrawable sVGADrawable2 = (SVGADrawable)drawable;
            if (sVGADrawable2 == null) break block4;
            SVGADrawable it = sVGADrawable = sVGADrawable2;
            it.setCleared$library_release(clear);
        }
    }

    public final void setVideoItem(@Nullable SVGAVideoEntity videoItem) {
        this.setVideoItem(videoItem, new SVGADynamicEntity());
    }

    public final void setVideoItem(@Nullable SVGAVideoEntity videoItem, @Nullable SVGADynamicEntity dynamicItem) {
        if (videoItem == null) {
            this.setImageDrawable(null);
            return;
        }
        SVGADynamicEntity sVGADynamicEntity = dynamicItem;
        if (sVGADynamicEntity == null) {
            sVGADynamicEntity = new SVGADynamicEntity();
        }
        SVGADrawable drawable = new SVGADrawable(videoItem, sVGADynamicEntity);
        drawable.setCleared$library_release(this.clearsAfterStop);
        this.setImageDrawable(drawable);
    }

    public final void stepToFrame(int frame, boolean andPlay) {
        block3: {
            this.pauseAnimation();
            Drawable drawable = this.getDrawable();
            if (!(drawable instanceof SVGADrawable)) {
                drawable = null;
            }
            SVGADrawable sVGADrawable = (SVGADrawable)drawable;
            if (sVGADrawable == null) {
                return;
            }
            SVGADrawable drawable2 = sVGADrawable;
            drawable2.setCurrentFrame$library_release(frame);
            if (!andPlay) break block3;
            this.startAnimation();
            ValueAnimator valueAnimator = this.animator;
            if (valueAnimator != null) {
                ValueAnimator valueAnimator2;
                ValueAnimator it = valueAnimator2 = valueAnimator;
                it.setCurrentPlayTime((long)(Math.max(0.0f, Math.min(1.0f, (float)frame / (float)drawable2.getVideoItem().getFrames())) * (float)it.getDuration()));
            }
        }
    }

    public final void stepToPercentage(double percentage, boolean andPlay) {
        Drawable drawable = this.getDrawable();
        if (!(drawable instanceof SVGADrawable)) {
            drawable = null;
        }
        SVGADrawable sVGADrawable = (SVGADrawable)drawable;
        if (sVGADrawable == null) {
            return;
        }
        SVGADrawable drawable2 = sVGADrawable;
        int frame = (int)((double)drawable2.getVideoItem().getFrames() * percentage);
        if (frame >= drawable2.getVideoItem().getFrames() && frame > 0) {
            frame = drawable2.getVideoItem().getFrames() - 1;
        }
        this.stepToFrame(frame, andPlay);
    }

    public final void setOnAnimKeyClickListener(@NotNull SVGAClickAreaListener clickListener) {
        Intrinsics.checkParameterIsNotNull((Object)clickListener, (String)"clickListener");
        this.mItemClickAreaListener = clickListener;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        MotionEvent motionEvent = event;
        if (motionEvent != null) {
            MotionEvent motionEvent2;
            MotionEvent it = motionEvent2 = motionEvent;
            if (event.getAction() == 0) {
                Drawable drawable = this.getDrawable();
                if (!(drawable instanceof SVGADrawable)) {
                    drawable = null;
                }
                SVGADrawable sVGADrawable = (SVGADrawable)drawable;
                if (sVGADrawable == null) {
                    return false;
                }
                SVGADrawable drawable2 = sVGADrawable;
                Map map = drawable2.getDynamicItem().getMClickMap$library_release();
                for (Map.Entry entry : map.entrySet()) {
                    Object object = entry;
                    String key = (String)object.getKey();
                    object = entry;
                    int[] value = (int[])object.getValue();
                    if (!(event.getX() >= (float)value[0]) || !(event.getX() <= (float)value[2]) || !(event.getY() >= (float)value[1]) || !(event.getY() <= (float)value[3])) continue;
                    SVGAClickAreaListener sVGAClickAreaListener = this.mItemClickAreaListener;
                    if (sVGAClickAreaListener == null) continue;
                    Object it2 = object = sVGAClickAreaListener;
                    it2.onClick(key);
                    return true;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public SVGAImageView(@Nullable Context context) {
        super(context);
        this.clearsAfterStop = true;
        this.fillMode = FillMode.Forward;
        this.setSoftwareLayerType();
    }

    public SVGAImageView(@Nullable Context context, @Nullable AttributeSet attrs) {
        block0: {
            AttributeSet attributeSet;
            super(context, attrs);
            this.clearsAfterStop = true;
            this.fillMode = FillMode.Forward;
            this.setSoftwareLayerType();
            AttributeSet attributeSet2 = attrs;
            if (attributeSet2 == null) break block0;
            AttributeSet it = attributeSet = attributeSet2;
            this.loadAttrs(it);
        }
    }

    public SVGAImageView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block0: {
            AttributeSet attributeSet;
            super(context, attrs, defStyleAttr);
            this.clearsAfterStop = true;
            this.fillMode = FillMode.Forward;
            this.setSoftwareLayerType();
            AttributeSet attributeSet2 = attrs;
            if (attributeSet2 == null) break block0;
            AttributeSet it = attributeSet = attributeSet2;
            this.loadAttrs(it);
        }
    }

    public SVGAImageView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        block0: {
            AttributeSet attributeSet;
            super(context, attrs, defStyleAttr, defStyleRes);
            this.clearsAfterStop = true;
            this.fillMode = FillMode.Forward;
            this.setSoftwareLayerType();
            AttributeSet attributeSet2 = attrs;
            if (attributeSet2 == null) break block0;
            AttributeSet it = attributeSet = attributeSet2;
            this.loadAttrs(it);
        }
    }

    public static final /* synthetic */ boolean access$isAnimating$p(SVGAImageView $this) {
        return $this.isAnimating;
    }

    public static final /* synthetic */ void access$setAnimating$p(SVGAImageView $this, boolean bl) {
        $this.isAnimating = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/opensource/svgaplayer/SVGAImageView$FillMode;", "", "(Ljava/lang/String;I)V", "Backward", "Forward", "library_release"})
    public static final class FillMode
    extends Enum<FillMode> {
        public static final /* enum */ FillMode Backward;
        public static final /* enum */ FillMode Forward;
        private static final /* synthetic */ FillMode[] $VALUES;

        static {
            FillMode[] fillModeArray = new FillMode[2];
            FillMode[] fillModeArray2 = fillModeArray;
            fillModeArray[0] = Backward = new FillMode();
            fillModeArray[1] = Forward = new FillMode();
            $VALUES = fillModeArray;
        }

        public static FillMode[] values() {
            return (FillMode[])$VALUES.clone();
        }

        public static FillMode valueOf(String string) {
            return Enum.valueOf(FillMode.class, string);
        }
    }
}

