/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer.drawer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.media.SoundPool;
import android.os.Build;
import android.text.BoringLayout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.ImageView;
import com.opensource.svgaplayer.IClickAreaListener;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.drawer.SGVADrawer;
import com.opensource.svgaplayer.entities.SVGAAudioEntity;
import com.opensource.svgaplayer.entities.SVGAPathEntity;
import com.opensource.svgaplayer.entities.SVGAVideoShapeEntity;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u000267B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010%\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J$\u0010&\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010'\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u000e2\n\u0010\u001b\u001a\u00060\u001cR\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0002J\"\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020 2\u0010\u0010-\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00010.H\u0002J\"\u0010/\u001a\u00020\t2\u0006\u0010,\u001a\u00020 2\u0010\u0010-\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00010.H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020*H\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*H\u0002R\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer;", "Lcom/opensource/svgaplayer/drawer/SGVADrawer;", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "(Lcom/opensource/svgaplayer/SVGAVideoEntity;Lcom/opensource/svgaplayer/SVGADynamicEntity;)V", "beginIndexList", "", "", "[Ljava/lang/Boolean;", "drawTextCache", "Ljava/util/HashMap;", "", "Landroid/graphics/Bitmap;", "Lkotlin/collections/HashMap;", "getDynamicItem", "()Lcom/opensource/svgaplayer/SVGADynamicEntity;", "endIndexList", "matrixScaleTempValues", "", "pathCache", "Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$PathCache;", "sharedValues", "Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$ShareValues;", "drawDynamic", "", "sprite", "Lcom/opensource/svgaplayer/drawer/SGVADrawer$SVGADrawerSprite;", "canvas", "Landroid/graphics/Canvas;", "frameIndex", "", "drawFrame", "scaleType", "Landroid/widget/ImageView$ScaleType;", "drawImage", "drawShape", "drawSprite", "drawTextOnBitmap", "drawingBitmap", "frameMatrix", "Landroid/graphics/Matrix;", "isMatteBegin", "spriteIndex", "sprites", "", "isMatteEnd", "matrixScale", "", "matrix", "playAudio", "shareFrameMatrix", "transform", "PathCache", "ShareValues", "library_release"})
public final class SVGACanvasDrawer
extends SGVADrawer {
    private final ShareValues sharedValues;
    private final HashMap<String, Bitmap> drawTextCache;
    private final PathCache pathCache;
    private Boolean[] beginIndexList;
    private Boolean[] endIndexList;
    private final float[] matrixScaleTempValues;
    @NotNull
    private final SVGADynamicEntity dynamicItem;

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawFrame(@NotNull Canvas canvas, int frameIndex, @NotNull ImageView.ScaleType scaleType) {
        String string;
        String it;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.drawFrame(canvas, frameIndex, scaleType);
        this.pathCache.onSizeChanged(canvas);
        List<SGVADrawer.SVGADrawerSprite> sprites = this.requestFrameSprites$library_release(frameIndex);
        Collection collection = sprites;
        if (collection.size() <= 0) {
            return;
        }
        Map matteSprites = new LinkedHashMap();
        int saveID = -1;
        this.beginIndexList = null;
        this.endIndexList = null;
        boolean hasMatteLayer = false;
        String string2 = sprites.get(0).getImageKey();
        if (string2 != null && StringsKt.endsWith$default((String)(it = (string = string2)), (String)".matte", (boolean)false, (int)2, null)) {
            hasMatteLayer = true;
        }
        Iterable $receiver$iv = sprites;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            Object it2;
            Object object;
            void svgaDrawerSprite;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            SGVADrawer.SVGADrawerSprite sVGADrawerSprite = (SGVADrawer.SVGADrawerSprite)item$iv;
            int index = n2;
            if (svgaDrawerSprite.getImageKey() != null) {
                it2 = object;
                if (!hasMatteLayer || Build.VERSION.SDK_INT < 21) {
                    this.drawSprite((SGVADrawer.SVGADrawerSprite)svgaDrawerSprite, canvas, frameIndex);
                    continue;
                }
                if (StringsKt.endsWith$default((String)it2, (String)".matte", (boolean)false, (int)2, null)) {
                    matteSprites.put(it2, svgaDrawerSprite);
                    continue;
                }
            }
            if (this.isMatteBegin(index, sprites)) {
                if (Build.VERSION.SDK_INT >= 21) {
                    saveID = canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null);
                } else {
                    canvas.save();
                }
            }
            this.drawSprite((SGVADrawer.SVGADrawerSprite)svgaDrawerSprite, canvas, frameIndex);
            if (!this.isMatteEnd(index, sprites)) continue;
            object = matteSprites;
            it2 = svgaDrawerSprite.getMatteKey();
            SGVADrawer.SVGADrawerSprite sVGADrawerSprite2 = (SGVADrawer.SVGADrawerSprite)object.get(it2);
            if (sVGADrawerSprite2 == null) continue;
            it2 = object = sVGADrawerSprite2;
            this.drawSprite((SGVADrawer.SVGADrawerSprite)it2, this.sharedValues.shareMatteCanvas(canvas.getWidth(), canvas.getHeight()), frameIndex);
            canvas.drawBitmap(this.sharedValues.sharedMatteBitmap(), 0.0f, 0.0f, this.sharedValues.shareMattePaint());
            if (saveID != -1) {
                canvas.restoreToCount(saveID);
                continue;
            }
            canvas.restore();
        }
        this.playAudio(frameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMatteBegin(int spriteIndex, List<SGVADrawer.SVGADrawerSprite> sprites) {
        if (this.beginIndexList == null) {
            int n;
            void size$iv;
            Collection collection = sprites;
            int n2 = collection.size();
            Boolean[] result$iv = new Boolean[size$iv];
            int n3 = 0;
            int n4 = result$iv.length;
            while (n3 < n4) {
                Boolean bl;
                void i$iv;
                n = i$iv;
                void var21_13 = i$iv++;
                Boolean[] booleanArray = result$iv;
                booleanArray[var21_13] = bl = Boolean.valueOf(false);
            }
            Boolean[] boolArray = result$iv;
            Iterable $receiver$iv = sprites;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                SGVADrawer.SVGADrawerSprite sVGADrawerSprite;
                String string;
                String it;
                void svgaDrawerSprite;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n5 = n;
                SGVADrawer.SVGADrawerSprite $i$f$Array = (SGVADrawer.SVGADrawerSprite)item$iv;
                int index = n5;
                if (svgaDrawerSprite.getImageKey() != null && StringsKt.endsWith$default((String)(it = string), (String)".matte", (boolean)false, (int)2, null)) continue;
                if (svgaDrawerSprite.getMatteKey() == null) continue;
                it = string;
                if (it.length() <= 0) continue;
                if (sprites.get(index - 1) == null) continue;
                SGVADrawer.SVGADrawerSprite lastSprite = sVGADrawerSprite;
                if (lastSprite.getMatteKey() == null || lastSprite.getMatteKey().length() == 0) {
                    boolArray[index] = true;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)lastSprite.getMatteKey(), (Object)svgaDrawerSprite.getMatteKey()) ^ true)) continue;
                boolArray[index] = true;
            }
            this.beginIndexList = boolArray;
        }
        Object object = this.beginIndexList;
        return this.beginIndexList != null && (object = object[spriteIndex]) != null ? (Boolean)object : false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMatteEnd(int spriteIndex, List<SGVADrawer.SVGADrawerSprite> sprites) {
        if (this.endIndexList == null) {
            int n;
            void size$iv;
            Collection collection = sprites;
            int n2 = collection.size();
            Boolean[] result$iv = new Boolean[size$iv];
            int n3 = 0;
            int n4 = result$iv.length;
            while (n3 < n4) {
                Boolean bl;
                void i$iv;
                n = i$iv;
                void var23_13 = i$iv++;
                Boolean[] booleanArray = result$iv;
                booleanArray[var23_13] = bl = Boolean.valueOf(false);
            }
            Boolean[] boolArray = result$iv;
            Iterable $receiver$iv = sprites;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                String string;
                String it;
                void svgaDrawerSprite;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n5 = n;
                SGVADrawer.SVGADrawerSprite $i$f$Array = (SGVADrawer.SVGADrawerSprite)item$iv;
                int index = n5;
                if (svgaDrawerSprite.getImageKey() != null && StringsKt.endsWith$default((String)(it = string), (String)".matte", (boolean)false, (int)2, null)) continue;
                if (svgaDrawerSprite.getMatteKey() == null) continue;
                it = string;
                if (it.length() <= 0) continue;
                int n6 = index;
                Object object = sprites;
                int n7 = object.size();
                if (n6 == n7 - 1) {
                    boolArray[index] = true;
                    continue;
                }
                SGVADrawer.SVGADrawerSprite sVGADrawerSprite = sprites.get(index + 1);
                if (sVGADrawerSprite == null) continue;
                object = sVGADrawerSprite;
                Object nextSprite = object;
                if (((SGVADrawer.SVGADrawerSprite)nextSprite).getMatteKey() == null || ((SGVADrawer.SVGADrawerSprite)nextSprite).getMatteKey().length() == 0) {
                    boolArray[index] = true;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)((SGVADrawer.SVGADrawerSprite)nextSprite).getMatteKey(), (Object)svgaDrawerSprite.getMatteKey()) ^ true)) continue;
                boolArray[index] = true;
            }
            this.endIndexList = boolArray;
        }
        Object object = this.endIndexList;
        return this.endIndexList != null && (object = object[spriteIndex]) != null ? (Boolean)object : false;
    }

    private final void playAudio(int frameIndex) {
        Iterable $receiver$iv = this.getVideoItem().getAudios$library_release();
        for (Object element$iv : $receiver$iv) {
            Object object;
            SVGAAudioEntity audio = (SVGAAudioEntity)element$iv;
            if (audio.getStartFrame() == frameIndex && this.getVideoItem().getSoundPool$library_release() != null) {
                SoundPool soundPool = object;
                if (audio.getSoundID() != null) {
                    Integer n;
                    int soundID = ((Number)n).intValue();
                    audio.setPlayID(soundPool.play(soundID, 1.0f, 1.0f, 1, 0, 1.0f));
                }
            }
            if (audio.getEndFrame() > frameIndex) continue;
            if (audio.getPlayID() != null) {
                int it = ((Number)object).intValue();
                SoundPool soundPool = this.getVideoItem().getSoundPool$library_release();
                if (soundPool != null) {
                    soundPool.stop(it);
                }
            }
            audio.setPlayID(null);
        }
    }

    private final Matrix shareFrameMatrix(Matrix transform) {
        Matrix matrix = this.sharedValues.sharedMatrix();
        matrix.postScale(this.getScaleInfo().getScaleFx(), this.getScaleInfo().getScaleFy());
        matrix.postTranslate(this.getScaleInfo().getTranFx(), this.getScaleInfo().getTranFy());
        matrix.preConcat(transform);
        return matrix;
    }

    private final void drawSprite(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        this.drawImage(sprite, canvas);
        this.drawShape(sprite, canvas);
        this.drawDynamic(sprite, canvas, frameIndex);
    }

    private final void drawImage(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        HashMap<String, IClickAreaListener> hashMap;
        String string = sprite.getImageKey();
        if (string == null) {
            return;
        }
        String imageKey = string;
        boolean isHidden = Intrinsics.areEqual((Object)this.dynamicItem.getDynamicHidden$library_release().get(imageKey), (Object)true);
        if (isHidden) {
            return;
        }
        String bitmapKey = StringsKt.replace$default((String)imageKey, (String)".matte", (String)"", (boolean)false, (int)4, null);
        Bitmap bitmap = this.dynamicItem.getDynamicImage$library_release().get(bitmapKey);
        if (bitmap == null) {
            bitmap = this.getVideoItem().getImages$library_release().get(bitmapKey);
        }
        if (bitmap == null) {
            return;
        }
        Bitmap drawingBitmap = bitmap;
        Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
        Paint paint = this.sharedValues.sharedPaint();
        paint.setAntiAlias(this.getVideoItem().getAntiAlias());
        paint.setFilterBitmap(this.getVideoItem().getAntiAlias());
        paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
        if (sprite.getFrameEntity().getMaskPath() != null) {
            SVGAPathEntity sVGAPathEntity = sprite.getFrameEntity().getMaskPath();
            if (sVGAPathEntity == null) {
                return;
            }
            SVGAPathEntity maskPath = sVGAPathEntity;
            canvas.save();
            Path path = this.sharedValues.sharedPath();
            maskPath.buildPath(path);
            path.transform(frameMatrix);
            canvas.clipPath(path);
            frameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()));
            canvas.drawBitmap(drawingBitmap, frameMatrix, paint);
            canvas.restore();
        } else {
            frameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()));
            canvas.drawBitmap(drawingBitmap, frameMatrix, paint);
        }
        HashMap<String, IClickAreaListener> it = hashMap = this.dynamicItem.getDynamicIClickArea$library_release();
        IClickAreaListener iClickAreaListener = it.get(imageKey);
        if (iClickAreaListener != null) {
            IClickAreaListener iClickAreaListener2;
            IClickAreaListener listener = iClickAreaListener2 = iClickAreaListener;
            float[] matrixArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            frameMatrix.getValues(matrixArray);
            listener.onResponseArea(imageKey, (int)matrixArray[2], (int)matrixArray[5], (int)((float)drawingBitmap.getWidth() * matrixArray[0] + matrixArray[2]), (int)((float)drawingBitmap.getHeight() * matrixArray[4] + matrixArray[5]));
        }
        this.drawTextOnBitmap(canvas, drawingBitmap, sprite, frameMatrix);
    }

    private final void drawTextOnBitmap(Canvas canvas, Bitmap drawingBitmap, SGVADrawer.SVGADrawerSprite sprite, Matrix frameMatrix) {
        block23: {
            Bitmap textCanvas;
            TextPaint it;
            String it2;
            Canvas textCanvas2;
            TextPaint textPaint;
            String string;
            if (this.dynamicItem.isTextDirty$library_release()) {
                this.drawTextCache.clear();
                this.dynamicItem.setTextDirty$library_release(false);
            }
            String string2 = sprite.getImageKey();
            if (string2 == null) {
                return;
            }
            String imageKey = string2;
            Bitmap textBitmap = null;
            String string3 = this.dynamicItem.getDynamicText$library_release().get(imageKey);
            if (string3 != null) {
                String drawingText = string = string3;
                TextPaint textPaint2 = this.dynamicItem.getDynamicTextPaint$library_release().get(imageKey);
                if (textPaint2 != null) {
                    TextPaint drawingTextPaint = textPaint = textPaint2;
                    Bitmap bitmap = this.drawTextCache.get(imageKey);
                    if (bitmap != null) {
                        Bitmap bitmap2;
                        Bitmap it3;
                        textBitmap = it3 = (bitmap2 = bitmap);
                    } else {
                        textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        textCanvas2 = new Canvas(textBitmap);
                        TextPaint textPaint3 = drawingTextPaint;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint3, (String)"drawingTextPaint");
                        textPaint3.setAntiAlias(true);
                        Rect bounds = new Rect();
                        drawingTextPaint.getTextBounds(drawingText, 0, drawingText.length(), bounds);
                        double x = (double)(drawingBitmap.getWidth() - bounds.width()) / 2.0;
                        int targetRectTop = 0;
                        int targetRectBottom = drawingBitmap.getHeight();
                        float y = ((float)(targetRectBottom + targetRectTop) - drawingTextPaint.getFontMetrics().bottom - drawingTextPaint.getFontMetrics().top) / (float)2;
                        textCanvas2.drawText(drawingText, (float)x, y, (Paint)drawingTextPaint);
                        Bitmap bitmap3 = textBitmap;
                        if (bitmap3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                        }
                        this.drawTextCache.put(imageKey, bitmap3);
                    }
                }
            }
            BoringLayout boringLayout = this.dynamicItem.getDynamicBoringLayoutText$library_release().get(imageKey);
            if (boringLayout != null) {
                it2 = string = boringLayout;
                Bitmap bitmap = this.drawTextCache.get(imageKey);
                if (bitmap != null) {
                    it = textPaint = bitmap;
                    textBitmap = it;
                } else {
                    String string4 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                    TextPaint textPaint4 = string4.getPaint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textPaint4, (String)"it.paint");
                    textPaint4.setAntiAlias(true);
                    textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    textCanvas = new Canvas(textBitmap);
                    textCanvas.translate(0.0f, (float)((drawingBitmap.getHeight() - it2.getHeight()) / 2));
                    it2.draw((Canvas)textCanvas);
                    Bitmap bitmap4 = textBitmap;
                    if (bitmap4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                    }
                    this.drawTextCache.put(imageKey, bitmap4);
                }
            }
            StaticLayout staticLayout = this.dynamicItem.getDynamicStaticLayoutText$library_release().get(imageKey);
            if (staticLayout != null) {
                it2 = string = staticLayout;
                Bitmap bitmap = this.drawTextCache.get(imageKey);
                if (bitmap != null) {
                    textCanvas = bitmap;
                    it = textCanvas;
                    textBitmap = it;
                } else {
                    StaticLayout staticLayout2;
                    String string5 = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it");
                    TextPaint textPaint5 = string5.getPaint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textPaint5, (String)"it.paint");
                    textPaint5.setAntiAlias(true);
                    if (Build.VERSION.SDK_INT >= 23) {
                        int field22;
                        try {
                            Field field22;
                            Field field = field22 = StaticLayout.class.getDeclaredField("mMaximumVisibleLineCount");
                            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"field");
                            field.setAccessible(true);
                            field22 = field22.getInt(it2);
                        }
                        catch (Exception e) {
                            field22 = Integer.MAX_VALUE;
                        }
                        int lineMax = field22;
                        staticLayout2 = StaticLayout.Builder.obtain((CharSequence)it2.getText(), (int)0, (int)it2.getText().length(), (TextPaint)it2.getPaint(), (int)drawingBitmap.getWidth()).setAlignment(it2.getAlignment()).setMaxLines(lineMax).setEllipsize(TextUtils.TruncateAt.END).build();
                    } else {
                        staticLayout2 = new StaticLayout(it2.getText(), 0, it2.getText().length(), it2.getPaint(), drawingBitmap.getWidth(), it2.getAlignment(), it2.getSpacingMultiplier(), it2.getSpacingAdd(), false);
                    }
                    StaticLayout layout = staticLayout2;
                    textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    textCanvas2 = new Canvas(textBitmap);
                    int n = drawingBitmap.getHeight();
                    StaticLayout staticLayout3 = layout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)staticLayout3, (String)"layout");
                    textCanvas2.translate(0.0f, (float)((n - staticLayout3.getHeight()) / 2));
                    layout.draw(textCanvas2);
                    Bitmap bitmap5 = textBitmap;
                    if (bitmap5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                    }
                    this.drawTextCache.put(imageKey, bitmap5);
                }
            }
            Bitmap bitmap = textBitmap;
            if (bitmap == null) break block23;
            String textBitmap2 = string = bitmap;
            Paint paint = this.sharedValues.sharedPaint();
            paint.setAntiAlias(this.getVideoItem().getAntiAlias());
            paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPathEntity sVGAPathEntity = sprite.getFrameEntity().getMaskPath();
                if (sVGAPathEntity == null) {
                } else {
                    SVGAPathEntity maskPath = sVGAPathEntity;
                    canvas.save();
                    canvas.concat(frameMatrix);
                    canvas.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                    BitmapShader bitmapShader = new BitmapShader((Bitmap)textBitmap2, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    paint.setShader((Shader)bitmapShader);
                    Path path = this.sharedValues.sharedPath();
                    maskPath.buildPath(path);
                    canvas.drawPath(path, paint);
                    canvas.restore();
                }
            } else {
                paint.setFilterBitmap(this.getVideoItem().getAntiAlias());
                canvas.drawBitmap((Bitmap)textBitmap2, frameMatrix, paint);
            }
        }
    }

    private final void drawShape(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
        Iterable $receiver$iv = sprite.getFrameEntity().getShapes();
        for (Object element$iv : $receiver$iv) {
            Object object;
            Object object2;
            Object object3;
            int n;
            int it;
            Path path;
            SVGAVideoShapeEntity shape = (SVGAVideoShapeEntity)element$iv;
            shape.buildPath();
            if (shape.getShapePath() == null) continue;
            Path it2 = path;
            Paint paint = this.sharedValues.sharedPaint();
            paint.reset();
            paint.setAntiAlias(this.getVideoItem().getAntiAlias());
            paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            Path path2 = this.sharedValues.sharedPath();
            path2.reset();
            path2.addPath(this.pathCache.buildPath(shape));
            Matrix shapeMatrix = this.sharedValues.sharedMatrix2();
            shapeMatrix.reset();
            if (shape.getTransform() != null) {
                Matrix matrix;
                Matrix it3 = matrix;
                shapeMatrix.postConcat(it3);
            }
            shapeMatrix.postConcat(frameMatrix);
            path2.transform(shapeMatrix);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null && (it = (n = styles.getFill())) != 0) {
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(it);
                paint.setAlpha(Math.min(255, Math.max(0, (int)(sprite.getFrameEntity().getAlpha() * (double)255))));
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas.save();
                }
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    SVGAPathEntity $i$a$1$let;
                    SVGAPathEntity maskPath = $i$a$1$let;
                    Path path22 = this.sharedValues.sharedPath2();
                    maskPath.buildPath(path22);
                    path22.transform(frameMatrix);
                    canvas.clipPath(path22);
                }
                canvas.drawPath(path2, paint);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas.restore();
                }
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 == null) continue;
            float f = styles2.getStrokeWidth();
            float it22 = f;
            if (!(it22 > 0.0f)) continue;
            paint.setStyle(Paint.Style.STROKE);
            SVGAVideoShapeEntity.Styles styles3 = shape.getStyles();
            if (styles3 != null) {
                int $i$a$1$let;
                int it4 = $i$a$1$let = styles3.getStroke();
                paint.setColor(it4);
                paint.setAlpha(Math.min(255, Math.max(0, (int)(sprite.getFrameEntity().getAlpha() * (double)255))));
            }
            float scale = this.matrixScale(frameMatrix);
            SVGAVideoShapeEntity.Styles styles4 = shape.getStyles();
            if (styles4 != null) {
                float f2;
                float it5 = f2 = styles4.getStrokeWidth();
                paint.setStrokeWidth(it5 * scale);
            }
            if ((object3 = shape.getStyles()) != null && (object3 = ((SVGAVideoShapeEntity.Styles)object3).getLineCap()) != null) {
                Object object4 = object3;
                Object it6 = object4;
                if (StringsKt.equals((String)it6, (String)"butt", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.BUTT);
                } else if (StringsKt.equals((String)it6, (String)"round", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.ROUND);
                } else if (StringsKt.equals((String)it6, (String)"square", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
            if ((object2 = shape.getStyles()) != null && (object2 = ((SVGAVideoShapeEntity.Styles)object2).getLineJoin()) != null) {
                Object object5 = object2;
                Object it7 = object5;
                if (StringsKt.equals((String)it7, (String)"miter", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.MITER);
                } else if (StringsKt.equals((String)it7, (String)"round", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.ROUND);
                } else if (StringsKt.equals((String)it7, (String)"bevel", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
            SVGAVideoShapeEntity.Styles styles5 = shape.getStyles();
            if (styles5 != null) {
                int n2;
                int it8 = n2 = styles5.getMiterLimit();
                paint.setStrokeMiter((float)it8 * scale);
            }
            if ((object = shape.getStyles()) != null) {
                Object object6;
                Object it9;
                float[] fArray = ((SVGAVideoShapeEntity.Styles)object).getLineDash();
                object = fArray;
                if (fArray != null && ((Object)(it9 = (object6 = object))).length == 3 && (it9[0] > 0.0f || it9[1] > 0.0f)) {
                    paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{(it9[0] < 1.0f ? 1.0f : (float)it9[0]) * scale, (it9[1] < 0.1f ? 0.1f : (float)it9[1]) * scale}, (float)(it9[2] * scale)));
                }
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                canvas.save();
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPathEntity sVGAPathEntity;
                SVGAPathEntity maskPath = sVGAPathEntity;
                Path path23 = this.sharedValues.sharedPath2();
                maskPath.buildPath(path23);
                path23.transform(frameMatrix);
                canvas.clipPath(path23);
            }
            canvas.drawPath(path2, paint);
            if (sprite.getFrameEntity().getMaskPath() == null) continue;
            canvas.restore();
        }
    }

    private final float matrixScale(Matrix matrix) {
        matrix.getValues(this.matrixScaleTempValues);
        if (this.matrixScaleTempValues[0] == 0.0f) {
            return 0.0f;
        }
        double A = this.matrixScaleTempValues[0];
        double D = this.matrixScaleTempValues[4];
        double B = this.matrixScaleTempValues[3];
        double C = this.matrixScaleTempValues[1];
        if (A * D == B * C) {
            return 0.0f;
        }
        double scaleX = Math.sqrt(A * A + B * B);
        double skew = (A /= scaleX) * C + (B /= scaleX) * D;
        double scaleY = Math.sqrt((C -= A * skew) * C + (D -= B * skew) * D);
        C /= scaleY;
        D /= scaleY;
        skew /= scaleY;
        if (A * D < B * C) {
            scaleX = -scaleX;
        }
        return this.getScaleInfo().getRatioX() ? Math.abs((float)scaleX) : Math.abs((float)scaleY);
    }

    private final void drawDynamic(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        block2: {
            Matrix frameMatrix;
            Function2<Canvas, Integer, Boolean> it;
            Function2<Canvas, Integer, Boolean> function2;
            String string = sprite.getImageKey();
            if (string == null) {
                return;
            }
            String imageKey = string;
            Function2<Canvas, Integer, Boolean> function22 = this.dynamicItem.getDynamicDrawer$library_release().get(imageKey);
            if (function22 != null) {
                it = function2 = function22;
                frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
                canvas.save();
                canvas.concat(frameMatrix);
                it.invoke((Object)canvas, (Object)frameIndex);
                canvas.restore();
            }
            Function4<Canvas, Integer, Integer, Integer, Boolean> function4 = this.dynamicItem.getDynamicDrawerSized$library_release().get(imageKey);
            if (function4 == null) break block2;
            it = function2 = function4;
            frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
            canvas.save();
            canvas.concat(frameMatrix);
            it.invoke((Object)canvas, (Object)frameIndex, (Object)((int)sprite.getFrameEntity().getLayout().getWidth()), (Object)((int)sprite.getFrameEntity().getLayout().getHeight()));
            canvas.restore();
        }
    }

    @NotNull
    public final SVGADynamicEntity getDynamicItem() {
        return this.dynamicItem;
    }

    public SVGACanvasDrawer(@NotNull SVGAVideoEntity videoItem, @NotNull SVGADynamicEntity dynamicItem) {
        Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
        Intrinsics.checkParameterIsNotNull((Object)dynamicItem, (String)"dynamicItem");
        super(videoItem);
        this.dynamicItem = dynamicItem;
        this.sharedValues = new ShareValues();
        SVGACanvasDrawer sVGACanvasDrawer = this;
        HashMap hashMap = new HashMap();
        sVGACanvasDrawer.drawTextCache = hashMap;
        this.pathCache = new PathCache();
        this.matrixScaleTempValues = new float[16];
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$ShareValues;", "", "()V", "shareMatteCanvas", "Landroid/graphics/Canvas;", "shareMattePaint", "Landroid/graphics/Paint;", "sharedMatrix", "Landroid/graphics/Matrix;", "sharedMatrix2", "sharedMatteBitmap", "Landroid/graphics/Bitmap;", "sharedPaint", "sharedPath", "Landroid/graphics/Path;", "sharedPath2", "width", "", "height", "library_release"})
    public static final class ShareValues {
        private final Paint sharedPaint = new Paint();
        private final Path sharedPath = new Path();
        private final Path sharedPath2 = new Path();
        private final Matrix sharedMatrix = new Matrix();
        private final Matrix sharedMatrix2 = new Matrix();
        private final Paint shareMattePaint = new Paint();
        private Canvas shareMatteCanvas;
        private Bitmap sharedMatteBitmap;

        @NotNull
        public final Paint sharedPaint() {
            this.sharedPaint.reset();
            return this.sharedPaint;
        }

        @NotNull
        public final Path sharedPath() {
            this.sharedPath.reset();
            return this.sharedPath;
        }

        @NotNull
        public final Path sharedPath2() {
            this.sharedPath2.reset();
            return this.sharedPath2;
        }

        @NotNull
        public final Matrix sharedMatrix() {
            this.sharedMatrix.reset();
            return this.sharedMatrix;
        }

        @NotNull
        public final Matrix sharedMatrix2() {
            this.sharedMatrix2.reset();
            return this.sharedMatrix2;
        }

        @NotNull
        public final Paint shareMattePaint() {
            this.shareMattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            return this.shareMattePaint;
        }

        @NotNull
        public final Bitmap sharedMatteBitmap() {
            Bitmap bitmap = this.sharedMatteBitmap;
            if (bitmap == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
            }
            return bitmap;
        }

        @NotNull
        public final Canvas shareMatteCanvas(int width, int height) {
            if (this.shareMatteCanvas == null) {
                this.sharedMatteBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            }
            return new Canvas(this.sharedMatteBitmap);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$PathCache;", "", "()V", "cache", "Ljava/util/HashMap;", "Lcom/opensource/svgaplayer/entities/SVGAVideoShapeEntity;", "Landroid/graphics/Path;", "Lkotlin/collections/HashMap;", "canvasHeight", "", "canvasWidth", "buildPath", "shape", "onSizeChanged", "", "canvas", "Landroid/graphics/Canvas;", "library_release"})
    public static final class PathCache {
        private int canvasWidth;
        private int canvasHeight;
        private final HashMap<SVGAVideoShapeEntity, Path> cache = new HashMap();

        public final void onSizeChanged(@NotNull Canvas canvas) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            if (this.canvasWidth != canvas.getWidth() || this.canvasHeight != canvas.getHeight()) {
                this.cache.clear();
            }
            this.canvasWidth = canvas.getWidth();
            this.canvasHeight = canvas.getHeight();
        }

        @NotNull
        public final Path buildPath(@NotNull SVGAVideoShapeEntity shape) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            if (!this.cache.containsKey(shape)) {
                Path path = new Path();
                path.set(shape.getShapePath());
                Map map = this.cache;
                Path path2 = path;
                map.put(shape, path2);
            }
            Path path = this.cache.get(shape);
            if (path == null) {
                Intrinsics.throwNpe();
            }
            return path;
        }
    }
}

