/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer.utils;

import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/opensource/svgaplayer/utils/Pools;", "", "()V", "Pool", "SimplePool", "com.opensource.svgaplayer"})
public final class Pools {
    private Pools() {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u000f\u0010\u0003\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/opensource/svgaplayer/utils/Pools$Pool;", "T", "", "acquire", "()Ljava/lang/Object;", "release", "", "instance", "(Ljava/lang/Object;)Z", "com.opensource.svgaplayer"})
    public static interface Pool<T> {
        @Nullable
        public T acquire();

        public boolean release(T var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u000b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/opensource/svgaplayer/utils/Pools$SimplePool;", "T", "Lcom/opensource/svgaplayer/utils/Pools$Pool;", "maxPoolSize", "", "(I)V", "mPool", "", "", "[Ljava/lang/Object;", "mPoolSize", "acquire", "()Ljava/lang/Object;", "isInPool", "", "instance", "(Ljava/lang/Object;)Z", "release", "com.opensource.svgaplayer"})
    public static class SimplePool<T>
    implements Pool<T> {
        private final Object[] mPool;
        private int mPoolSize;

        @Override
        @Nullable
        public T acquire() {
            if (this.mPoolSize > 0) {
                int lastPooledIndex = this.mPoolSize - 1;
                Object instance = this.mPool[lastPooledIndex];
                this.mPool[lastPooledIndex] = null;
                int n = this.mPoolSize;
                this.mPoolSize = n + -1;
                return (T)instance;
            }
            return null;
        }

        @Override
        public boolean release(T instance) {
            int n = !this.isInPool(instance) ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (n == 0) {
                boolean bl3 = false;
                String string = "Already in the pool!";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = instance;
                n = this.mPoolSize;
                this.mPoolSize = n + 1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isInPool(T instance) {
            int n = 0;
            int n2 = this.mPoolSize;
            while (n < n2) {
                void i;
                if (this.mPool[i] == instance) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public SimplePool(int maxPoolSize) {
            boolean bl = maxPoolSize > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The max pool size must be > 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.mPool = new Object[maxPoolSize];
        }
    }
}

