/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.media.SoundPool;
import android.os.Build;
import com.opensource.svgaplayer.SVGACache;
import com.opensource.svgaplayer.bitmap.SVGABitmapByteArrayDecoder;
import com.opensource.svgaplayer.bitmap.SVGABitmapFileDecoder;
import com.opensource.svgaplayer.entities.SVGAAudioEntity;
import com.opensource.svgaplayer.entities.SVGAVideoSpriteEntity;
import com.opensource.svgaplayer.proto.AudioEntity;
import com.opensource.svgaplayer.proto.MovieEntity;
import com.opensource.svgaplayer.proto.MovieParams;
import com.opensource.svgaplayer.proto.SpriteEntity;
import com.opensource.svgaplayer.utils.SVGARect;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB'\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010@\u001a\u00020AJ\u001a\u0010B\u001a\u0004\u0018\u00010%2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020$H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010%2\u0006\u0010E\u001a\u00020$H\u0002J$\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00050#H\u0002J\u0018\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020DH\u0002J\u001c\u0010M\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00050#2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010N\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020D0#2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010O\u001a\u00020$2\u0006\u0010P\u001a\u00020$2\u0006\u0010Q\u001a\u00020$H\u0002J\u0018\u0010R\u001a\n S*\u0004\u0018\u000103032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010T\u001a\u00020A2\u0006\u0010U\u001a\u00020\fH\u0002J\u0010\u0010T\u001a\u00020A2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001b\u0010V\u001a\u00020A2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020A0XH\u0000\u00a2\u0006\u0002\bYJ\u0010\u0010Z\u001a\u00020A2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010Z\u001a\u00020A2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010[\u001a\u00020A2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020A0XH\u0002J\u0010\u0010]\u001a\u00020A2\u0006\u0010^\u001a\u00020\u0003H\u0002J\u0010\u0010_\u001a\u00020A2\u0006\u0010`\u001a\u00020aH\u0002J\u001e\u0010b\u001a\u00020A2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020A0XH\u0002R\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012R&\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R \u00108\u001a\b\u0012\u0004\u0012\u0002090\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001d\"\u0004\b;\u0010\u001fR\u001e\u0010=\u001a\u00020<2\u0006\u0010\u000f\u001a\u00020<@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006c"}, d2={"Lcom/opensource/svgaplayer/SVGAVideoEntity;", "", "json", "Lorg/json/JSONObject;", "cacheDir", "Ljava/io/File;", "(Lorg/json/JSONObject;Ljava/io/File;)V", "frameWidth", "", "frameHeight", "(Lorg/json/JSONObject;Ljava/io/File;II)V", "entity", "Lcom/opensource/svgaplayer/proto/MovieEntity;", "(Lcom/opensource/svgaplayer/proto/MovieEntity;Ljava/io/File;)V", "(Lcom/opensource/svgaplayer/proto/MovieEntity;Ljava/io/File;II)V", "<set-?>", "FPS", "getFPS", "()I", "antiAlias", "", "getAntiAlias", "()Z", "setAntiAlias", "(Z)V", "audioList", "", "Lcom/opensource/svgaplayer/entities/SVGAAudioEntity;", "getAudioList$com_opensource_svgaplayer", "()Ljava/util/List;", "setAudioList$com_opensource_svgaplayer", "(Ljava/util/List;)V", "frames", "getFrames", "imageMap", "Ljava/util/HashMap;", "", "Landroid/graphics/Bitmap;", "getImageMap$com_opensource_svgaplayer", "()Ljava/util/HashMap;", "setImageMap$com_opensource_svgaplayer", "(Ljava/util/HashMap;)V", "mCacheDir", "mFrameHeight", "mFrameWidth", "movieItem", "getMovieItem", "()Lcom/opensource/svgaplayer/proto/MovieEntity;", "setMovieItem", "(Lcom/opensource/svgaplayer/proto/MovieEntity;)V", "soundPool", "Landroid/media/SoundPool;", "getSoundPool$com_opensource_svgaplayer", "()Landroid/media/SoundPool;", "setSoundPool$com_opensource_svgaplayer", "(Landroid/media/SoundPool;)V", "spriteList", "Lcom/opensource/svgaplayer/entities/SVGAVideoSpriteEntity;", "getSpriteList$com_opensource_svgaplayer", "setSpriteList$com_opensource_svgaplayer", "Lcom/opensource/svgaplayer/utils/SVGARect;", "videoSize", "getVideoSize", "()Lcom/opensource/svgaplayer/utils/SVGARect;", "clear", "", "createBitmap", "byteArray", "", "filePath", "createSvgaAudioEntity", "audio", "Lcom/opensource/svgaplayer/proto/AudioEntity;", "audiosFileMap", "generateAudioFile", "audioCache", "value", "generateAudioFileMap", "generateAudioMap", "generateBitmapFilePath", "imgName", "imgKey", "generateSoundPool", "kotlin.jvm.PlatformType", "parserImages", "obj", "prepare", "callback", "Lkotlin/Function0;", "prepare$com_opensource_svgaplayer", "resetSprites", "setupAudios", "completionBlock", "setupByJson", "movieObject", "setupByMovie", "movieParams", "Lcom/opensource/svgaplayer/proto/MovieParams;", "setupSoundPool", "com.opensource.svgaplayer"})
public final class SVGAVideoEntity {
    private boolean antiAlias;
    @Nullable
    private MovieEntity movieItem;
    @NotNull
    private SVGARect videoSize;
    private int FPS;
    private int frames;
    @NotNull
    private List<SVGAVideoSpriteEntity> spriteList;
    @NotNull
    private List<SVGAAudioEntity> audioList;
    @Nullable
    private SoundPool soundPool;
    @NotNull
    private HashMap<String, Bitmap> imageMap;
    private File mCacheDir;
    private int mFrameHeight;
    private int mFrameWidth;

    public final boolean getAntiAlias() {
        return this.antiAlias;
    }

    public final void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    @Nullable
    public final MovieEntity getMovieItem() {
        return this.movieItem;
    }

    public final void setMovieItem(@Nullable MovieEntity movieEntity) {
        this.movieItem = movieEntity;
    }

    @NotNull
    public final SVGARect getVideoSize() {
        return this.videoSize;
    }

    public final int getFPS() {
        return this.FPS;
    }

    public final int getFrames() {
        return this.frames;
    }

    @NotNull
    public final List<SVGAVideoSpriteEntity> getSpriteList$com_opensource_svgaplayer() {
        return this.spriteList;
    }

    public final void setSpriteList$com_opensource_svgaplayer(@NotNull List<SVGAVideoSpriteEntity> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.spriteList = list;
    }

    @NotNull
    public final List<SVGAAudioEntity> getAudioList$com_opensource_svgaplayer() {
        return this.audioList;
    }

    public final void setAudioList$com_opensource_svgaplayer(@NotNull List<SVGAAudioEntity> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.audioList = list;
    }

    @Nullable
    public final SoundPool getSoundPool$com_opensource_svgaplayer() {
        return this.soundPool;
    }

    public final void setSoundPool$com_opensource_svgaplayer(@Nullable SoundPool soundPool) {
        this.soundPool = soundPool;
    }

    @NotNull
    public final HashMap<String, Bitmap> getImageMap$com_opensource_svgaplayer() {
        return this.imageMap;
    }

    public final void setImageMap$com_opensource_svgaplayer(@NotNull HashMap<String, Bitmap> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.imageMap = hashMap;
    }

    private final void setupByJson(JSONObject movieObject) {
        JSONObject jSONObject = movieObject.optJSONObject("viewBox");
        if (jSONObject != null) {
            JSONObject jSONObject2 = jSONObject;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject viewBoxObject = jSONObject2;
            boolean bl3 = false;
            double width = viewBoxObject.optDouble("width", 0.0);
            double height = viewBoxObject.optDouble("height", 0.0);
            this.videoSize = new SVGARect(0.0, 0.0, width, height);
        }
        this.FPS = movieObject.optInt("fps", 20);
        this.frames = movieObject.optInt("frames", 0);
    }

    private final void setupByMovie(MovieParams movieParams) {
        Float f = movieParams.viewBoxWidth;
        double width = f != null ? f.floatValue() : 0.0f;
        Float f2 = movieParams.viewBoxHeight;
        double height = f2 != null ? f2.floatValue() : 0.0f;
        this.videoSize = new SVGARect(0.0, 0.0, width, height);
        Integer n = movieParams.fps;
        this.FPS = n != null ? n : 20;
        Integer n2 = movieParams.frames;
        this.frames = n2 != null ? n2 : 0;
    }

    public final void prepare$com_opensource_svgaplayer(@NotNull Function0<Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.movieItem == null) {
            callback.invoke();
        } else {
            MovieEntity movieEntity = this.movieItem;
            if (movieEntity == null) {
                Intrinsics.throwNpe();
            }
            this.setupAudios(movieEntity, (Function0<Unit>)((Function0)new Function0<Unit>(callback){
                final /* synthetic */ Function0 $callback;

                public final void invoke() {
                    this.$callback.invoke();
                }
                {
                    this.$callback = function0;
                    super(0);
                }
            }));
        }
    }

    private final void parserImages(JSONObject json) {
        JSONObject jSONObject = json.optJSONObject("images");
        if (jSONObject == null) {
            return;
        }
        JSONObject imgJson = jSONObject;
        Iterator iterator = imgJson.keys();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"imgJson.keys()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            String imgKey = (String)element$iv;
            boolean bl2 = false;
            String string = imgJson.get(imgKey).toString();
            String string2 = imgKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"imgKey");
            String filePath = this.generateBitmapFilePath(string, string2);
            CharSequence charSequence = filePath;
            boolean bl3 = false;
            if (charSequence.length() == 0) {
                return;
            }
            String bitmapKey = StringsKt.replace$default((String)imgKey, (String)".matte", (String)"", (boolean)false, (int)4, null);
            Bitmap bitmap = this.createBitmap(filePath);
            if (bitmap == null) continue;
            ((Map)this.imageMap).put(bitmapKey, bitmap);
        }
    }

    private final String generateBitmapFilePath(String imgName, String imgKey) {
        String path = this.mCacheDir.getAbsolutePath() + "/" + imgName;
        String path1 = path + ".png";
        String path2 = this.mCacheDir.getAbsolutePath() + "/" + imgKey + ".png";
        return new File(path).exists() ? path : (new File(path1).exists() ? path1 : (new File(path2).exists() ? path2 : ""));
    }

    private final Bitmap createBitmap(String filePath) {
        return SVGABitmapFileDecoder.INSTANCE.decodeBitmapFrom(filePath, this.mFrameWidth, this.mFrameHeight);
    }

    private final void parserImages(MovieEntity obj) {
        Map<String, ByteString> map = obj.images;
        if (map != null && (map = map.entrySet()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)map);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List fileTag;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                byte[] byteArray = ((ByteString)entry.getValue()).toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteArray, (String)"byteArray");
                byte[] byArray = byteArray;
                boolean bl2 = false;
                if (byArray.length < 4 || ((Number)(fileTag = ArraysKt.slice((byte[])byteArray, (IntRange)new IntRange(0, 3))).get(0)).byteValue() == 73 && ((Number)fileTag.get(1)).byteValue() == 68 && ((Number)fileTag.get(2)).byteValue() == 51) continue;
                String string = ((ByteString)entry.getValue()).utf8();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.value.utf8()");
                Object k = entry.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"entry.key");
                String filePath = this.generateBitmapFilePath(string, (String)k);
                if (this.createBitmap(byteArray, filePath) != null) {
                    Bitmap bitmap;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Bitmap bitmap2 = bitmap;
                    boolean bl5 = false;
                    Map map2 = this.imageMap;
                    Object k2 = entry.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k2, (String)"entry.key");
                    map2.put(k2, bitmap2);
                }
            }
        }
    }

    private final Bitmap createBitmap(byte[] byteArray, String filePath) {
        Bitmap bitmap = SVGABitmapByteArrayDecoder.INSTANCE.decodeBitmapFrom(byteArray, this.mFrameWidth, this.mFrameHeight);
        Bitmap bitmap2 = bitmap;
        if (bitmap2 == null) {
            bitmap2 = this.createBitmap(filePath);
        }
        return bitmap2;
    }

    /*
     * WARNING - void declaration
     */
    private final void resetSprites(JSONObject json) {
        boolean bl = false;
        List mutableList = new ArrayList();
        JSONArray jSONArray = json.optJSONArray("sprites");
        if (jSONArray != null) {
            JSONArray jSONArray2 = jSONArray;
            boolean bl2 = false;
            boolean bl3 = false;
            JSONArray item = jSONArray2;
            boolean bl4 = false;
            int n = 0;
            int n2 = item.length();
            while (n < n2) {
                void i;
                if (item.optJSONObject((int)i) != null) {
                    JSONObject jSONObject;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    JSONObject entryJson = jSONObject;
                    boolean bl7 = false;
                    mutableList.add(new SVGAVideoSpriteEntity(entryJson));
                }
                ++i;
            }
        }
        this.spriteList = CollectionsKt.toList((Iterable)mutableList);
    }

    /*
     * WARNING - void declaration
     */
    private final void resetSprites(MovieEntity entity) {
        List list;
        SVGAVideoEntity sVGAVideoEntity;
        SVGAVideoEntity sVGAVideoEntity2 = this;
        List<SpriteEntity> list2 = entity.sprites;
        if (list2 != null) {
            Collection<SVGAVideoSpriteEntity> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            SVGAVideoEntity sVGAVideoEntity3 = sVGAVideoEntity2;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SpriteEntity spriteEntity = (SpriteEntity)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                SVGAVideoSpriteEntity sVGAVideoSpriteEntity = new SVGAVideoSpriteEntity((SpriteEntity)v2);
                collection.add(sVGAVideoSpriteEntity);
            }
            collection = (List)destination$iv$iv;
            sVGAVideoEntity = sVGAVideoEntity3;
            list = collection;
        } else {
            SVGAVideoEntity sVGAVideoEntity4 = sVGAVideoEntity2;
            boolean bl = false;
            List list3 = CollectionsKt.emptyList();
            sVGAVideoEntity = sVGAVideoEntity4;
            list = list3;
        }
        sVGAVideoEntity.spriteList = list;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupAudios(MovieEntity entity, Function0<Unit> completionBlock) {
        Collection<SVGAAudioEntity> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (entity.audios == null || entity.audios.isEmpty()) {
            boolean bl = false;
            boolean bl2 = false;
            completionBlock.invoke();
            return;
        }
        this.setupSoundPool(entity, completionBlock);
        HashMap<String, File> audiosFileMap = this.generateAudioFileMap(entity);
        Iterable iterable = entity.audios;
        SVGAVideoEntity sVGAVideoEntity = this;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void audio;
            AudioEntity audioEntity = (AudioEntity)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = audio;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"audio");
            SVGAAudioEntity sVGAAudioEntity = this.createSvgaAudioEntity((AudioEntity)v0, audiosFileMap);
            collection.add(sVGAAudioEntity);
        }
        collection = (List)destination$iv$iv;
        sVGAVideoEntity.audioList = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SVGAAudioEntity createSvgaAudioEntity(AudioEntity audio, HashMap<String, File> audiosFileMap) {
        SVGAAudioEntity item = new SVGAAudioEntity(audio);
        Integer n = audio.startTime;
        double startTime = n != null ? n : 0;
        Integer n2 = audio.totalTime;
        double totalTime = n2 != null ? n2 : 0;
        if ((int)totalTime == 0) {
            return item;
        }
        File file = audiosFileMap.get(audio.audioKey);
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File file3 = file2;
            boolean bl3 = false;
            Closeable closeable = new FileInputStream(file3);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl5 = false;
                double length = it.available();
                long offset = (long)(startTime / totalTime * length);
                SoundPool soundPool = this.soundPool;
                item.setSoundID(soundPool != null ? Integer.valueOf(soundPool.load(it.getFD(), offset, (long)length, 1)) : null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return item;
    }

    private final File generateAudioFile(File audioCache, byte[] value) {
        audioCache.createNewFile();
        new FileOutputStream(audioCache).write(value);
        return audioCache;
    }

    private final HashMap<String, File> generateAudioFileMap(MovieEntity entity) {
        HashMap<String, byte[]> audiosDataMap = this.generateAudioMap(entity);
        HashMap<String, File> audiosFileMap = new HashMap<String, File>();
        Map map = audiosDataMap;
        boolean bl = false;
        if (map.size() > 0) {
            Map $this$forEach$iv = audiosDataMap;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                File audioCache;
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl3 = false;
                File file = audioCache = SVGACache.INSTANCE.buildAudioFile((String)it.getKey());
                Object k = it.getKey();
                Map map3 = audiosFileMap;
                boolean bl4 = false;
                boolean bl5 = false;
                File file2 = file;
                boolean bl6 = false;
                File file3 = file2.exists() ? file : null;
                File file4 = file3;
                if (file4 == null) {
                    file4 = this.generateAudioFile(audioCache, (byte[])it.getValue());
                }
                map3.put(k, file4);
            }
        }
        return audiosFileMap;
    }

    private final HashMap<String, byte[]> generateAudioMap(MovieEntity entity) {
        HashMap<String, byte[]> audiosDataMap = new HashMap<String, byte[]>();
        Map<String, ByteString> map = entity.images;
        if (map != null && (map = map.entrySet()) != null) {
            Iterable $this$forEach$iv = (Iterable)((Object)map);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List fileTag;
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                String imageKey = (String)it.getKey();
                byte[] byteArray = ((ByteString)it.getValue()).toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteArray, (String)"byteArray");
                byte[] byArray = byteArray;
                boolean bl2 = false;
                if (byArray.length < 4 || ((Number)(fileTag = ArraysKt.slice((byte[])byteArray, (IntRange)new IntRange(0, 3))).get(0)).byteValue() != 73 || ((Number)fileTag.get(1)).byteValue() != 68 || ((Number)fileTag.get(2)).byteValue() != 51) continue;
                Map map2 = audiosDataMap;
                String string = imageKey;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"imageKey");
                map2.put(string, byteArray);
            }
        }
        return audiosDataMap;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupSoundPool(MovieEntity entity, Function0<Unit> completionBlock) {
        block0: {
            void soundLoaded;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            SoundPool soundPool = this.soundPool = this.generateSoundPool(entity);
            if (soundPool == null) break block0;
            soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener((Ref.IntRef)soundLoaded, entity, completionBlock){
                final /* synthetic */ Ref.IntRef $soundLoaded;
                final /* synthetic */ MovieEntity $entity;
                final /* synthetic */ Function0 $completionBlock;

                public final void onLoadComplete(SoundPool $noName_0, int $noName_1, int $noName_2) {
                    int n = this.$soundLoaded.element;
                    int n2 = this.$soundLoaded.element = n + 1;
                    List<AudioEntity> list = this.$entity.audios;
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"entity.audios");
                    Collection collection = list;
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = collection.size();
                    if (n3 >= n4) {
                        this.$completionBlock.invoke();
                    }
                }
                {
                    this.$soundLoaded = intRef;
                    this.$entity = movieEntity;
                    this.$completionBlock = function0;
                }
            });
        }
    }

    private final SoundPool generateSoundPool(MovieEntity entity) {
        SoundPool soundPool;
        if (Build.VERSION.SDK_INT >= 21) {
            AudioAttributes attributes = new AudioAttributes.Builder().setUsage(1).build();
            SoundPool.Builder builder = new SoundPool.Builder().setAudioAttributes(attributes);
            List<AudioEntity> list = entity.audios;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"entity.audios");
            Collection collection = list;
            int n = 12;
            SoundPool.Builder builder2 = builder;
            boolean bl = false;
            int n2 = collection.size();
            soundPool = builder2.setMaxStreams(RangesKt.coerceAtMost((int)n, (int)n2)).build();
        } else {
            List<AudioEntity> list = entity.audios;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"entity.audios");
            Collection collection = list;
            int n = 12;
            boolean bl = false;
            int n3 = collection.size();
            int n4 = 0;
            int n5 = 3;
            int n6 = RangesKt.coerceAtMost((int)n, (int)n3);
            soundPool = new SoundPool(n6, n5, n4);
        }
        return soundPool;
    }

    public final void clear() {
        SoundPool soundPool = this.soundPool;
        if (soundPool != null) {
            soundPool.release();
        }
        this.soundPool = null;
        this.audioList = CollectionsKt.emptyList();
        this.spriteList = CollectionsKt.emptyList();
        this.imageMap.clear();
    }

    public SVGAVideoEntity(@NotNull JSONObject json, @NotNull File cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this(json, cacheDir, 0, 0);
    }

    public SVGAVideoEntity(@NotNull JSONObject json, @NotNull File cacheDir, int frameWidth, int frameHeight) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this.antiAlias = true;
        this.videoSize = new SVGARect(0.0, 0.0, 0.0, 0.0);
        this.FPS = 15;
        this.spriteList = CollectionsKt.emptyList();
        this.audioList = CollectionsKt.emptyList();
        this.imageMap = new HashMap();
        this.mFrameWidth = frameWidth;
        this.mFrameHeight = frameHeight;
        this.mCacheDir = cacheDir;
        JSONObject jSONObject = json.optJSONObject("movie");
        if (jSONObject == null) {
            return;
        }
        JSONObject movieJsonObject = jSONObject;
        this.setupByJson(movieJsonObject);
        try {
            this.parserImages(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        this.resetSprites(json);
    }

    public SVGAVideoEntity(@NotNull MovieEntity entity, @NotNull File cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this(entity, cacheDir, 0, 0);
    }

    public SVGAVideoEntity(@NotNull MovieEntity entity, @NotNull File cacheDir, int frameWidth, int frameHeight) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this.antiAlias = true;
        this.videoSize = new SVGARect(0.0, 0.0, 0.0, 0.0);
        this.FPS = 15;
        this.spriteList = CollectionsKt.emptyList();
        this.audioList = CollectionsKt.emptyList();
        this.imageMap = new HashMap();
        this.mFrameWidth = frameWidth;
        this.mFrameHeight = frameHeight;
        this.mCacheDir = cacheDir;
        this.movieItem = entity;
        MovieParams movieParams = entity.params;
        if (movieParams != null) {
            MovieParams movieParams2 = movieParams;
            SVGAVideoEntity sVGAVideoEntity = this;
            boolean bl = false;
            boolean bl2 = false;
            MovieParams p1 = movieParams2;
            boolean bl3 = false;
            sVGAVideoEntity.setupByMovie(p1);
        }
        try {
            this.parserImages(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        this.resetSprites(entity);
    }
}

