/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer.drawer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Shader;
import android.media.SoundPool;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.widget.ImageView;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.drawer.SGVADrawer;
import com.opensource.svgaplayer.entities.SVGAAudioEntity;
import com.opensource.svgaplayer.entities.SVGAPathEntity;
import com.opensource.svgaplayer.entities.SVGAVideoShapeEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0002,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010 \u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010!\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\"\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\n2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00012\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020%H\u0002R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer;", "Lcom/opensource/svgaplayer/drawer/SGVADrawer;", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "(Lcom/opensource/svgaplayer/SVGAVideoEntity;Lcom/opensource/svgaplayer/SVGADynamicEntity;)V", "drawTextCache", "Ljava/util/HashMap;", "", "Landroid/graphics/Bitmap;", "Lkotlin/collections/HashMap;", "getDynamicItem", "()Lcom/opensource/svgaplayer/SVGADynamicEntity;", "matrixScaleTempValues", "", "pathCache", "Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$PathCache;", "sharedValues", "Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$ShareValues;", "drawDynamic", "", "sprite", "Lcom/opensource/svgaplayer/drawer/SGVADrawer$SVGADrawerSprite;", "canvas", "Landroid/graphics/Canvas;", "frameIndex", "", "drawFrame", "scaleType", "Landroid/widget/ImageView$ScaleType;", "drawImage", "drawShape", "drawSprite", "drawTextOnBitmap", "drawingBitmap", "frameMatrix", "Landroid/graphics/Matrix;", "matrixScale", "", "matrix", "playAudio", "shareFrameMatrix", "transform", "PathCache", "ShareValues", "library_release"})
public final class SVGACanvasDrawer
extends SGVADrawer {
    private final ShareValues sharedValues;
    private final HashMap<String, Bitmap> drawTextCache;
    private final PathCache pathCache;
    private final float[] matrixScaleTempValues;
    @NotNull
    private final SVGADynamicEntity dynamicItem;

    @Override
    public void drawFrame(@NotNull Canvas canvas, int frameIndex, @NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.drawFrame(canvas, frameIndex, scaleType);
        this.pathCache.onSizeChanged(canvas);
        List<SGVADrawer.SVGADrawerSprite> sprites = this.requestFrameSprites$library_release(frameIndex);
        Iterable $receiver$iv = sprites;
        for (Object element$iv : $receiver$iv) {
            SGVADrawer.SVGADrawerSprite it = (SGVADrawer.SVGADrawerSprite)element$iv;
            this.drawSprite(it, canvas, frameIndex);
        }
        this.playAudio(frameIndex);
    }

    private final void playAudio(int frameIndex) {
        Iterable $receiver$iv = this.getVideoItem().getAudios$library_release();
        for (Object element$iv : $receiver$iv) {
            Object object;
            SVGAAudioEntity audio = (SVGAAudioEntity)element$iv;
            if (audio.getStartFrame() == frameIndex && this.getVideoItem().getSoundPool$library_release() != null) {
                SoundPool soundPool = object;
                if (audio.getSoundID() != null) {
                    Integer n;
                    int soundID = ((Number)n).intValue();
                    audio.setPlayID(soundPool.play(soundID, 1.0f, 1.0f, 1, 0, 1.0f));
                }
            }
            if (audio.getEndFrame() > frameIndex) continue;
            if (audio.getPlayID() != null) {
                int it = ((Number)object).intValue();
                SoundPool soundPool = this.getVideoItem().getSoundPool$library_release();
                if (soundPool != null) {
                    soundPool.stop(it);
                }
            }
            audio.setPlayID(null);
        }
    }

    private final Matrix shareFrameMatrix(Matrix transform) {
        Matrix matrix = this.sharedValues.sharedMatrix();
        matrix.postScale(this.getScaleInfo().getScaleFx(), this.getScaleInfo().getScaleFy());
        matrix.postTranslate(this.getScaleInfo().getTranFx(), this.getScaleInfo().getTranFy());
        matrix.preConcat(transform);
        return matrix;
    }

    private final void drawSprite(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        this.drawImage(sprite, canvas);
        this.drawShape(sprite, canvas);
        this.drawDynamic(sprite, canvas, frameIndex);
    }

    private final void drawImage(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        String string = sprite.getImageKey();
        if (string == null) {
            return;
        }
        String imageKey = string;
        boolean isHidden = Intrinsics.areEqual((Object)this.dynamicItem.getDynamicHidden$library_release().get(imageKey), (Object)true);
        if (isHidden) {
            return;
        }
        Bitmap bitmap = this.dynamicItem.getDynamicImage$library_release().get(imageKey);
        if (bitmap == null) {
            bitmap = this.getVideoItem().getImages$library_release().get(imageKey);
        }
        if (bitmap == null) {
            return;
        }
        Bitmap drawingBitmap = bitmap;
        Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
        Paint paint = this.sharedValues.sharedPaint();
        paint.setAntiAlias(this.getVideoItem().getAntiAlias());
        paint.setFilterBitmap(this.getVideoItem().getAntiAlias());
        paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
        if (sprite.getFrameEntity().getMaskPath() != null) {
            SVGAPathEntity sVGAPathEntity = sprite.getFrameEntity().getMaskPath();
            if (sVGAPathEntity == null) {
                return;
            }
            SVGAPathEntity maskPath = sVGAPathEntity;
            canvas.save();
            paint.reset();
            Path path = this.sharedValues.sharedPath();
            maskPath.buildPath(path);
            path.transform(frameMatrix);
            canvas.clipPath(path);
            frameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()));
            canvas.drawBitmap(drawingBitmap, frameMatrix, paint);
            canvas.restore();
        } else {
            frameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()));
            canvas.drawBitmap(drawingBitmap, frameMatrix, paint);
        }
        this.drawTextOnBitmap(canvas, drawingBitmap, sprite, frameMatrix);
    }

    private final void drawTextOnBitmap(Canvas canvas, Bitmap drawingBitmap, SGVADrawer.SVGADrawerSprite sprite, Matrix frameMatrix) {
        block15: {
            TextPaint textPaint;
            String string;
            if (this.dynamicItem.isTextDirty$library_release()) {
                this.drawTextCache.clear();
                this.dynamicItem.setTextDirty$library_release(false);
            }
            String string2 = sprite.getImageKey();
            if (string2 == null) {
                return;
            }
            String imageKey = string2;
            Bitmap textBitmap = null;
            String string3 = this.dynamicItem.getDynamicText$library_release().get(imageKey);
            if (string3 != null) {
                String drawingText = string = string3;
                TextPaint textPaint2 = this.dynamicItem.getDynamicTextPaint$library_release().get(imageKey);
                if (textPaint2 != null) {
                    TextPaint drawingTextPaint = textPaint = textPaint2;
                    Bitmap bitmap = this.drawTextCache.get(imageKey);
                    if (bitmap != null) {
                        Bitmap bitmap2;
                        Bitmap it;
                        textBitmap = it = (bitmap2 = bitmap);
                    } else {
                        textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas textCanvas = new Canvas(textBitmap);
                        TextPaint textPaint3 = drawingTextPaint;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint3, (String)"drawingTextPaint");
                        textPaint3.setAntiAlias(true);
                        Rect bounds = new Rect();
                        drawingTextPaint.getTextBounds(drawingText, 0, drawingText.length(), bounds);
                        double x = (double)(drawingBitmap.getWidth() - bounds.width()) / 2.0;
                        int targetRectTop = 0;
                        int targetRectBottom = drawingBitmap.getHeight();
                        float y = ((float)(targetRectBottom + targetRectTop) - drawingTextPaint.getFontMetrics().bottom - drawingTextPaint.getFontMetrics().top) / (float)2;
                        textCanvas.drawText(drawingText, (float)x, y, (Paint)drawingTextPaint);
                        Bitmap bitmap3 = textBitmap;
                        if (bitmap3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                        }
                        this.drawTextCache.put(imageKey, bitmap3);
                    }
                }
            }
            StaticLayout staticLayout = this.dynamicItem.getDynamicLayoutText$library_release().get(imageKey);
            if (staticLayout != null) {
                String it = string = staticLayout;
                Bitmap bitmap = this.drawTextCache.get(imageKey);
                if (bitmap != null) {
                    TextPaint it2 = textPaint = bitmap;
                    textBitmap = it2;
                } else {
                    String string4 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                    TextPaint textPaint4 = string4.getPaint();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textPaint4, (String)"it.paint");
                    textPaint4.setAntiAlias(true);
                    StaticLayout layout = new StaticLayout(it.getText(), 0, it.getText().length(), it.getPaint(), drawingBitmap.getWidth(), it.getAlignment(), it.getSpacingMultiplier(), it.getSpacingAdd(), false);
                    textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas textCanvas = new Canvas(textBitmap);
                    textCanvas.translate(0.0f, (float)((drawingBitmap.getHeight() - layout.getHeight()) / 2));
                    layout.draw(textCanvas);
                    Bitmap bitmap4 = textBitmap;
                    if (bitmap4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                    }
                    this.drawTextCache.put(imageKey, bitmap4);
                }
            }
            Bitmap bitmap = textBitmap;
            if (bitmap == null) break block15;
            String textBitmap2 = string = bitmap;
            Paint paint = this.sharedValues.sharedPaint();
            paint.setAntiAlias(this.getVideoItem().getAntiAlias());
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPathEntity sVGAPathEntity = sprite.getFrameEntity().getMaskPath();
                if (sVGAPathEntity == null) {
                } else {
                    SVGAPathEntity maskPath = sVGAPathEntity;
                    canvas.save();
                    canvas.concat(frameMatrix);
                    canvas.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                    BitmapShader bitmapShader = new BitmapShader((Bitmap)textBitmap2, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    paint.setShader((Shader)bitmapShader);
                    Path path = this.sharedValues.sharedPath();
                    maskPath.buildPath(path);
                    canvas.drawPath(path, paint);
                    canvas.restore();
                }
            } else {
                paint.setFilterBitmap(this.getVideoItem().getAntiAlias());
                canvas.drawBitmap((Bitmap)textBitmap2, frameMatrix, paint);
            }
        }
    }

    private final void drawShape(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
        Iterable $receiver$iv = sprite.getFrameEntity().getShapes();
        for (Object element$iv : $receiver$iv) {
            Object object;
            Object object2;
            Object object3;
            int n;
            int it;
            Path path;
            SVGAVideoShapeEntity shape = (SVGAVideoShapeEntity)element$iv;
            shape.buildPath();
            if (shape.getShapePath() == null) continue;
            Path it2 = path;
            Paint paint = this.sharedValues.sharedPaint();
            paint.reset();
            paint.setAntiAlias(this.getVideoItem().getAntiAlias());
            paint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            Path path2 = this.sharedValues.sharedPath();
            path2.reset();
            path2.addPath(this.pathCache.buildPath(shape));
            Matrix shapeMatrix = this.sharedValues.sharedMatrix2();
            shapeMatrix.reset();
            if (shape.getTransform() != null) {
                Matrix matrix;
                Matrix it3 = matrix;
                shapeMatrix.postConcat(it3);
            }
            shapeMatrix.postConcat(frameMatrix);
            path2.transform(shapeMatrix);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null && (it = (n = styles.getFill())) != 0) {
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(it);
                paint.setAlpha(Math.min(255, Math.max(0, (int)(sprite.getFrameEntity().getAlpha() * (double)255))));
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas.save();
                }
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    SVGAPathEntity $i$a$1$let;
                    SVGAPathEntity maskPath = $i$a$1$let;
                    Path path22 = this.sharedValues.sharedPath2();
                    maskPath.buildPath(path22);
                    path22.transform(frameMatrix);
                    canvas.clipPath(path22);
                }
                canvas.drawPath(path2, paint);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas.restore();
                }
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 == null) continue;
            float f = styles2.getStrokeWidth();
            float it22 = f;
            if (!(it22 > 0.0f)) continue;
            paint.setStyle(Paint.Style.STROKE);
            SVGAVideoShapeEntity.Styles styles3 = shape.getStyles();
            if (styles3 != null) {
                int $i$a$1$let;
                int it4 = $i$a$1$let = styles3.getStroke();
                paint.setColor(it4);
                paint.setAlpha(Math.min(255, Math.max(0, (int)(sprite.getFrameEntity().getAlpha() * (double)255))));
            }
            float scale = this.matrixScale(frameMatrix);
            SVGAVideoShapeEntity.Styles styles4 = shape.getStyles();
            if (styles4 != null) {
                float f2;
                float it5 = f2 = styles4.getStrokeWidth();
                paint.setStrokeWidth(it5 * scale);
            }
            if ((object3 = shape.getStyles()) != null && (object3 = ((SVGAVideoShapeEntity.Styles)object3).getLineCap()) != null) {
                Object object4 = object3;
                Object it6 = object4;
                if (StringsKt.equals((String)it6, (String)"butt", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.BUTT);
                } else if (StringsKt.equals((String)it6, (String)"round", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.ROUND);
                } else if (StringsKt.equals((String)it6, (String)"square", (boolean)true)) {
                    paint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
            if ((object2 = shape.getStyles()) != null && (object2 = ((SVGAVideoShapeEntity.Styles)object2).getLineJoin()) != null) {
                Object object5 = object2;
                Object it7 = object5;
                if (StringsKt.equals((String)it7, (String)"miter", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.MITER);
                } else if (StringsKt.equals((String)it7, (String)"round", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.ROUND);
                } else if (StringsKt.equals((String)it7, (String)"bevel", (boolean)true)) {
                    paint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
            SVGAVideoShapeEntity.Styles styles5 = shape.getStyles();
            if (styles5 != null) {
                int n2;
                int it8 = n2 = styles5.getMiterLimit();
                paint.setStrokeMiter((float)it8 * scale);
            }
            if ((object = shape.getStyles()) != null) {
                Object object6;
                Object it9;
                float[] fArray = ((SVGAVideoShapeEntity.Styles)object).getLineDash();
                object = fArray;
                if (fArray != null && ((Object)(it9 = (object6 = object))).length == 3 && (it9[0] > 0.0f || it9[1] > 0.0f)) {
                    paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{(it9[0] < 1.0f ? 1.0f : (float)it9[0]) * scale, (it9[1] < 0.1f ? 0.1f : (float)it9[1]) * scale}, (float)(it9[2] * scale)));
                }
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                canvas.save();
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPathEntity sVGAPathEntity;
                SVGAPathEntity maskPath = sVGAPathEntity;
                Path path23 = this.sharedValues.sharedPath2();
                maskPath.buildPath(path23);
                path23.transform(frameMatrix);
                canvas.clipPath(path23);
            }
            canvas.drawPath(path2, paint);
            if (sprite.getFrameEntity().getMaskPath() == null) continue;
            canvas.restore();
        }
    }

    private final float matrixScale(Matrix matrix) {
        matrix.getValues(this.matrixScaleTempValues);
        if (this.matrixScaleTempValues[0] == 0.0f) {
            return 0.0f;
        }
        double A = this.matrixScaleTempValues[0];
        double D = this.matrixScaleTempValues[4];
        double B = this.matrixScaleTempValues[3];
        double C = this.matrixScaleTempValues[1];
        if (A * D == B * C) {
            return 0.0f;
        }
        double scaleX = Math.sqrt(A * A + B * B);
        double skew = (A /= scaleX) * C + (B /= scaleX) * D;
        double scaleY = Math.sqrt((C -= A * skew) * C + (D -= B * skew) * D);
        C /= scaleY;
        D /= scaleY;
        skew /= scaleY;
        if (A * D < B * C) {
            scaleX = -scaleX;
        }
        return this.getScaleInfo().getRatioX() ? Math.abs((float)scaleX) : Math.abs((float)scaleY);
    }

    private final void drawDynamic(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        block1: {
            Function2<Canvas, Integer, Boolean> function2;
            String string = sprite.getImageKey();
            if (string == null) {
                return;
            }
            String imageKey = string;
            Function2<Canvas, Integer, Boolean> function22 = this.dynamicItem.getDynamicDrawer$library_release().get(imageKey);
            if (function22 == null) break block1;
            Function2<Canvas, Integer, Boolean> it = function2 = function22;
            Matrix frameMatrix = this.shareFrameMatrix(sprite.getFrameEntity().getTransform());
            canvas.save();
            canvas.concat(frameMatrix);
            it.invoke((Object)canvas, (Object)frameIndex);
            canvas.restore();
        }
    }

    @NotNull
    public final SVGADynamicEntity getDynamicItem() {
        return this.dynamicItem;
    }

    public SVGACanvasDrawer(@NotNull SVGAVideoEntity videoItem, @NotNull SVGADynamicEntity dynamicItem) {
        Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
        Intrinsics.checkParameterIsNotNull((Object)dynamicItem, (String)"dynamicItem");
        super(videoItem);
        this.dynamicItem = dynamicItem;
        this.sharedValues = new ShareValues();
        SVGACanvasDrawer sVGACanvasDrawer = this;
        HashMap hashMap = new HashMap();
        sVGACanvasDrawer.drawTextCache = hashMap;
        this.pathCache = new PathCache();
        this.matrixScaleTempValues = new float[16];
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$ShareValues;", "", "()V", "sharedMatrix", "Landroid/graphics/Matrix;", "sharedMatrix2", "sharedPaint", "Landroid/graphics/Paint;", "sharedPath", "Landroid/graphics/Path;", "sharedPath2", "library_release"})
    public static final class ShareValues {
        private final Paint sharedPaint = new Paint();
        private final Path sharedPath = new Path();
        private final Path sharedPath2 = new Path();
        private final Matrix sharedMatrix = new Matrix();
        private final Matrix sharedMatrix2 = new Matrix();

        @NotNull
        public final Paint sharedPaint() {
            this.sharedPaint.reset();
            return this.sharedPaint;
        }

        @NotNull
        public final Path sharedPath() {
            this.sharedPath.reset();
            return this.sharedPath;
        }

        @NotNull
        public final Path sharedPath2() {
            this.sharedPath2.reset();
            return this.sharedPath2;
        }

        @NotNull
        public final Matrix sharedMatrix() {
            this.sharedMatrix.reset();
            return this.sharedMatrix;
        }

        @NotNull
        public final Matrix sharedMatrix2() {
            this.sharedMatrix2.reset();
            return this.sharedMatrix2;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/opensource/svgaplayer/drawer/SVGACanvasDrawer$PathCache;", "", "()V", "cache", "Ljava/util/HashMap;", "Lcom/opensource/svgaplayer/entities/SVGAVideoShapeEntity;", "Landroid/graphics/Path;", "Lkotlin/collections/HashMap;", "canvasHeight", "", "canvasWidth", "buildPath", "shape", "onSizeChanged", "", "canvas", "Landroid/graphics/Canvas;", "library_release"})
    public static final class PathCache {
        private int canvasWidth;
        private int canvasHeight;
        private final HashMap<SVGAVideoShapeEntity, Path> cache = new HashMap();

        public final void onSizeChanged(@NotNull Canvas canvas) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            if (this.canvasWidth != canvas.getWidth() || this.canvasHeight != canvas.getHeight()) {
                this.cache.clear();
            }
            this.canvasWidth = canvas.getWidth();
            this.canvasHeight = canvas.getHeight();
        }

        @NotNull
        public final Path buildPath(@NotNull SVGAVideoShapeEntity shape) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            if (!this.cache.containsKey(shape)) {
                Path path = new Path();
                path.set(shape.getShapePath());
                Map map = this.cache;
                Path path2 = path;
                map.put(shape, path2);
            }
            Path path = this.cache.get(shape);
            if (path == null) {
                Intrinsics.throwNpe();
            }
            return path;
        }
    }
}

