/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer.entities;

import android.graphics.Path;
import com.opensource.svgaplayer.entities.SVGAPathEntityKt;
import com.opensource.svgaplayer.utils.SVGAPoint;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/opensource/svgaplayer/entities/SVGAPathEntity;", "", "originValue", "", "(Ljava/lang/String;)V", "cachedPath", "Landroid/graphics/Path;", "replacedValue", "buildPath", "", "toPath", "operate", "finalPath", "method", "args", "Ljava/util/StringTokenizer;", "library_release"})
public final class SVGAPathEntity {
    private final String replacedValue;
    private Path cachedPath;

    public final void buildPath(@NotNull Path toPath) {
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        Path path = this.cachedPath;
        if (path != null) {
            Path path2;
            Path it = path2 = path;
            toPath.set(it);
            return;
        }
        Path cachedPath = new Path();
        StringTokenizer segments = new StringTokenizer(this.replacedValue, "MLHVCSQRAZmlhvcsqraz", true);
        String currentMethod = "";
        while (segments.hasMoreTokens()) {
            String segment = segments.nextToken();
            CharSequence charSequence = segment;
            if (charSequence.length() == 0) continue;
            if (SVGAPathEntityKt.access$getVALID_METHODS$p().contains(segment)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)segment, (String)"segment");
                if (!Intrinsics.areEqual((Object)currentMethod, (Object)"Z") && !Intrinsics.areEqual((Object)currentMethod, (Object)"z")) continue;
                this.operate(cachedPath, currentMethod, new StringTokenizer("", ""));
                continue;
            }
            this.operate(cachedPath, currentMethod, new StringTokenizer(segment, " "));
        }
        this.cachedPath = cachedPath;
        toPath.set(cachedPath);
    }

    private final void operate(Path finalPath, String method, StringTokenizer args) {
        float x0 = 0.0f;
        float y0 = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        try {
            int index = 0;
            while (args.hasMoreTokens()) {
                String s = args.nextToken();
                CharSequence charSequence = s;
                if (charSequence.length() == 0) continue;
                if (index == 0) {
                    charSequence = s;
                    x0 = Float.parseFloat((String)charSequence);
                }
                if (index == 1) {
                    charSequence = s;
                    y0 = Float.parseFloat((String)charSequence);
                }
                if (index == 2) {
                    charSequence = s;
                    x1 = Float.parseFloat((String)charSequence);
                }
                if (index == 3) {
                    charSequence = s;
                    y1 = Float.parseFloat((String)charSequence);
                }
                if (index == 4) {
                    charSequence = s;
                    x2 = Float.parseFloat((String)charSequence);
                }
                if (index == 5) {
                    charSequence = s;
                    y2 = Float.parseFloat((String)charSequence);
                }
                ++index;
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        SVGAPoint currentPoint = new SVGAPoint(0.0f, 0.0f, 0.0f);
        if (Intrinsics.areEqual((Object)method, (Object)"M")) {
            finalPath.moveTo(x0, y0);
            currentPoint = new SVGAPoint(x0, y0, 0.0f);
        } else if (Intrinsics.areEqual((Object)method, (Object)"m")) {
            finalPath.rMoveTo(x0, y0);
            currentPoint = new SVGAPoint(currentPoint.getX() + x0, currentPoint.getY() + y0, 0.0f);
        }
        if (Intrinsics.areEqual((Object)method, (Object)"L")) {
            finalPath.lineTo(x0, y0);
        } else if (Intrinsics.areEqual((Object)method, (Object)"l")) {
            finalPath.rLineTo(x0, y0);
        }
        if (Intrinsics.areEqual((Object)method, (Object)"C")) {
            finalPath.cubicTo(x0, y0, x1, y1, x2, y2);
        } else if (Intrinsics.areEqual((Object)method, (Object)"c")) {
            finalPath.rCubicTo(x0, y0, x1, y1, x2, y2);
        }
        if (Intrinsics.areEqual((Object)method, (Object)"Q")) {
            finalPath.quadTo(x0, y0, x1, y1);
        } else if (Intrinsics.areEqual((Object)method, (Object)"q")) {
            finalPath.rQuadTo(x0, y0, x1, y1);
        }
        if (Intrinsics.areEqual((Object)method, (Object)"H")) {
            finalPath.lineTo(x0, currentPoint.getY());
        } else if (Intrinsics.areEqual((Object)method, (Object)"h")) {
            finalPath.rLineTo(x0, 0.0f);
        }
        if (Intrinsics.areEqual((Object)method, (Object)"V")) {
            finalPath.lineTo(currentPoint.getX(), x0);
        } else if (Intrinsics.areEqual((Object)method, (Object)"v")) {
            finalPath.rLineTo(0.0f, x0);
        }
        if (Intrinsics.areEqual((Object)method, (Object)"Z")) {
            finalPath.close();
        } else if (Intrinsics.areEqual((Object)method, (Object)"z")) {
            finalPath.close();
        }
    }

    public SVGAPathEntity(@NotNull String originValue) {
        Intrinsics.checkParameterIsNotNull((Object)originValue, (String)"originValue");
        this.replacedValue = StringsKt.contains$default((CharSequence)originValue, (CharSequence)",", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)originValue, (String)",", (String)" ", (boolean)false, (int)4, null) : originValue;
    }
}

