// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: svga.proto at 42:1
package com.opensource.svgaplayer.proto;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Float;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

public final class ShapeEntity extends Message<ShapeEntity, ShapeEntity.Builder> {
  public static final ProtoAdapter<ShapeEntity> ADAPTER = new ProtoAdapter_ShapeEntity();

  private static final long serialVersionUID = 0L;

  public static final ShapeType DEFAULT_TYPE = ShapeType.SHAPE;

  /**
   * 矢量类型
   */
  @WireField(
      tag = 1,
      adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeType#ADAPTER"
  )
  public final ShapeType type;

  /**
   * 矢量参数
   * 渲染参数
   */
  @WireField(
      tag = 10,
      adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeStyle#ADAPTER"
  )
  public final ShapeStyle styles;

  /**
   * 矢量图层 2D 变换矩阵
   */
  @WireField(
      tag = 11,
      adapter = "com.opensource.svgaplayer.proto.Transform#ADAPTER"
  )
  public final Transform transform;

  @WireField(
      tag = 2,
      adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeArgs#ADAPTER"
  )
  public final ShapeArgs shape;

  @WireField(
      tag = 3,
      adapter = "com.opensource.svgaplayer.proto.ShapeEntity$RectArgs#ADAPTER"
  )
  public final RectArgs rect;

  @WireField(
      tag = 4,
      adapter = "com.opensource.svgaplayer.proto.ShapeEntity$EllipseArgs#ADAPTER"
  )
  public final EllipseArgs ellipse;

  public ShapeEntity(ShapeType type, ShapeStyle styles, Transform transform, ShapeArgs shape, RectArgs rect, EllipseArgs ellipse) {
    this(type, styles, transform, shape, rect, ellipse, ByteString.EMPTY);
  }

  public ShapeEntity(ShapeType type, ShapeStyle styles, Transform transform, ShapeArgs shape, RectArgs rect, EllipseArgs ellipse, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (Internal.countNonNull(shape, rect, ellipse) > 1) {
      throw new IllegalArgumentException("at most one of shape, rect, ellipse may be non-null");
    }
    this.type = type;
    this.styles = styles;
    this.transform = transform;
    this.shape = shape;
    this.rect = rect;
    this.ellipse = ellipse;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.type = type;
    builder.styles = styles;
    builder.transform = transform;
    builder.shape = shape;
    builder.rect = rect;
    builder.ellipse = ellipse;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ShapeEntity)) return false;
    ShapeEntity o = (ShapeEntity) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(type, o.type)
        && Internal.equals(styles, o.styles)
        && Internal.equals(transform, o.transform)
        && Internal.equals(shape, o.shape)
        && Internal.equals(rect, o.rect)
        && Internal.equals(ellipse, o.ellipse);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (type != null ? type.hashCode() : 0);
      result = result * 37 + (styles != null ? styles.hashCode() : 0);
      result = result * 37 + (transform != null ? transform.hashCode() : 0);
      result = result * 37 + (shape != null ? shape.hashCode() : 0);
      result = result * 37 + (rect != null ? rect.hashCode() : 0);
      result = result * 37 + (ellipse != null ? ellipse.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (type != null) builder.append(", type=").append(type);
    if (styles != null) builder.append(", styles=").append(styles);
    if (transform != null) builder.append(", transform=").append(transform);
    if (shape != null) builder.append(", shape=").append(shape);
    if (rect != null) builder.append(", rect=").append(rect);
    if (ellipse != null) builder.append(", ellipse=").append(ellipse);
    return builder.replace(0, 2, "ShapeEntity{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ShapeEntity, Builder> {
    public ShapeType type;

    public ShapeStyle styles;

    public Transform transform;

    public ShapeArgs shape;

    public RectArgs rect;

    public EllipseArgs ellipse;

    public Builder() {
    }

    /**
     * 矢量类型
     */
    public Builder type(ShapeType type) {
      this.type = type;
      return this;
    }

    /**
     * 矢量参数
     * 渲染参数
     */
    public Builder styles(ShapeStyle styles) {
      this.styles = styles;
      return this;
    }

    /**
     * 矢量图层 2D 变换矩阵
     */
    public Builder transform(Transform transform) {
      this.transform = transform;
      return this;
    }

    public Builder shape(ShapeArgs shape) {
      this.shape = shape;
      this.rect = null;
      this.ellipse = null;
      return this;
    }

    public Builder rect(RectArgs rect) {
      this.rect = rect;
      this.shape = null;
      this.ellipse = null;
      return this;
    }

    public Builder ellipse(EllipseArgs ellipse) {
      this.ellipse = ellipse;
      this.shape = null;
      this.rect = null;
      return this;
    }

    @Override
    public ShapeEntity build() {
      return new ShapeEntity(type, styles, transform, shape, rect, ellipse, super.buildUnknownFields());
    }
  }

  public enum ShapeType implements WireEnum {
    /**
     * 路径
     */
    SHAPE(0),

    /**
     * 矩形
     */
    RECT(1),

    /**
     * 圆形
     */
    ELLIPSE(2),

    /**
     * 与前帧一致
     */
    KEEP(3);

    public static final ProtoAdapter<ShapeType> ADAPTER = ProtoAdapter.newEnumAdapter(ShapeType.class);

    private final int value;

    ShapeType(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static ShapeType fromValue(int value) {
      switch (value) {
        case 0: return SHAPE;
        case 1: return RECT;
        case 2: return ELLIPSE;
        case 3: return KEEP;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }
  }

  public static final class ShapeArgs extends Message<ShapeArgs, ShapeArgs.Builder> {
    public static final ProtoAdapter<ShapeArgs> ADAPTER = new ProtoAdapter_ShapeArgs();

    private static final long serialVersionUID = 0L;

    public static final String DEFAULT_D = "";

    /**
     * SVG 路径
     */
    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#STRING"
    )
    public final String d;

    public ShapeArgs(String d) {
      this(d, ByteString.EMPTY);
    }

    public ShapeArgs(String d, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.d = d;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.d = d;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof ShapeArgs)) return false;
      ShapeArgs o = (ShapeArgs) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(d, o.d);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + (d != null ? d.hashCode() : 0);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      if (d != null) builder.append(", d=").append(d);
      return builder.replace(0, 2, "ShapeArgs{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<ShapeArgs, Builder> {
      public String d;

      public Builder() {
      }

      /**
       * SVG 路径
       */
      public Builder d(String d) {
        this.d = d;
        return this;
      }

      @Override
      public ShapeArgs build() {
        return new ShapeArgs(d, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_ShapeArgs extends ProtoAdapter<ShapeArgs> {
      ProtoAdapter_ShapeArgs() {
        super(FieldEncoding.LENGTH_DELIMITED, ShapeArgs.class);
      }

      @Override
      public int encodedSize(ShapeArgs value) {
        return (value.d != null ? ProtoAdapter.STRING.encodedSizeWithTag(1, value.d) : 0)
            + value.unknownFields().size();
      }

      @Override
      public void encode(ProtoWriter writer, ShapeArgs value) throws IOException {
        if (value.d != null) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.d);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public ShapeArgs decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.d(ProtoAdapter.STRING.decode(reader)); break;
            default: {
              FieldEncoding fieldEncoding = reader.peekFieldEncoding();
              Object value = fieldEncoding.rawProtoAdapter().decode(reader);
              builder.addUnknownField(tag, fieldEncoding, value);
            }
          }
        }
        reader.endMessage(token);
        return builder.build();
      }

      @Override
      public ShapeArgs redact(ShapeArgs value) {
        Builder builder = value.newBuilder();
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  public static final class RectArgs extends Message<RectArgs, RectArgs.Builder> {
    public static final ProtoAdapter<RectArgs> ADAPTER = new ProtoAdapter_RectArgs();

    private static final long serialVersionUID = 0L;

    public static final Float DEFAULT_X = 0.0f;

    public static final Float DEFAULT_Y = 0.0f;

    public static final Float DEFAULT_WIDTH = 0.0f;

    public static final Float DEFAULT_HEIGHT = 0.0f;

    public static final Float DEFAULT_CORNERRADIUS = 0.0f;

    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float x;

    @WireField(
        tag = 2,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float y;

    @WireField(
        tag = 3,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float width;

    @WireField(
        tag = 4,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float height;

    /**
     * 圆角半径
     */
    @WireField(
        tag = 5,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float cornerRadius;

    public RectArgs(Float x, Float y, Float width, Float height, Float cornerRadius) {
      this(x, y, width, height, cornerRadius, ByteString.EMPTY);
    }

    public RectArgs(Float x, Float y, Float width, Float height, Float cornerRadius, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.x = x;
      this.y = y;
      this.width = width;
      this.height = height;
      this.cornerRadius = cornerRadius;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.x = x;
      builder.y = y;
      builder.width = width;
      builder.height = height;
      builder.cornerRadius = cornerRadius;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof RectArgs)) return false;
      RectArgs o = (RectArgs) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(x, o.x)
          && Internal.equals(y, o.y)
          && Internal.equals(width, o.width)
          && Internal.equals(height, o.height)
          && Internal.equals(cornerRadius, o.cornerRadius);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + (x != null ? x.hashCode() : 0);
        result = result * 37 + (y != null ? y.hashCode() : 0);
        result = result * 37 + (width != null ? width.hashCode() : 0);
        result = result * 37 + (height != null ? height.hashCode() : 0);
        result = result * 37 + (cornerRadius != null ? cornerRadius.hashCode() : 0);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      if (x != null) builder.append(", x=").append(x);
      if (y != null) builder.append(", y=").append(y);
      if (width != null) builder.append(", width=").append(width);
      if (height != null) builder.append(", height=").append(height);
      if (cornerRadius != null) builder.append(", cornerRadius=").append(cornerRadius);
      return builder.replace(0, 2, "RectArgs{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<RectArgs, Builder> {
      public Float x;

      public Float y;

      public Float width;

      public Float height;

      public Float cornerRadius;

      public Builder() {
      }

      public Builder x(Float x) {
        this.x = x;
        return this;
      }

      public Builder y(Float y) {
        this.y = y;
        return this;
      }

      public Builder width(Float width) {
        this.width = width;
        return this;
      }

      public Builder height(Float height) {
        this.height = height;
        return this;
      }

      /**
       * 圆角半径
       */
      public Builder cornerRadius(Float cornerRadius) {
        this.cornerRadius = cornerRadius;
        return this;
      }

      @Override
      public RectArgs build() {
        return new RectArgs(x, y, width, height, cornerRadius, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_RectArgs extends ProtoAdapter<RectArgs> {
      ProtoAdapter_RectArgs() {
        super(FieldEncoding.LENGTH_DELIMITED, RectArgs.class);
      }

      @Override
      public int encodedSize(RectArgs value) {
        return (value.x != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(1, value.x) : 0)
            + (value.y != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(2, value.y) : 0)
            + (value.width != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(3, value.width) : 0)
            + (value.height != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(4, value.height) : 0)
            + (value.cornerRadius != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(5, value.cornerRadius) : 0)
            + value.unknownFields().size();
      }

      @Override
      public void encode(ProtoWriter writer, RectArgs value) throws IOException {
        if (value.x != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 1, value.x);
        if (value.y != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 2, value.y);
        if (value.width != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 3, value.width);
        if (value.height != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 4, value.height);
        if (value.cornerRadius != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 5, value.cornerRadius);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public RectArgs decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.x(ProtoAdapter.FLOAT.decode(reader)); break;
            case 2: builder.y(ProtoAdapter.FLOAT.decode(reader)); break;
            case 3: builder.width(ProtoAdapter.FLOAT.decode(reader)); break;
            case 4: builder.height(ProtoAdapter.FLOAT.decode(reader)); break;
            case 5: builder.cornerRadius(ProtoAdapter.FLOAT.decode(reader)); break;
            default: {
              FieldEncoding fieldEncoding = reader.peekFieldEncoding();
              Object value = fieldEncoding.rawProtoAdapter().decode(reader);
              builder.addUnknownField(tag, fieldEncoding, value);
            }
          }
        }
        reader.endMessage(token);
        return builder.build();
      }

      @Override
      public RectArgs redact(RectArgs value) {
        Builder builder = value.newBuilder();
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  public static final class EllipseArgs extends Message<EllipseArgs, EllipseArgs.Builder> {
    public static final ProtoAdapter<EllipseArgs> ADAPTER = new ProtoAdapter_EllipseArgs();

    private static final long serialVersionUID = 0L;

    public static final Float DEFAULT_X = 0.0f;

    public static final Float DEFAULT_Y = 0.0f;

    public static final Float DEFAULT_RADIUSX = 0.0f;

    public static final Float DEFAULT_RADIUSY = 0.0f;

    /**
     * 圆中心点 X
     */
    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float x;

    /**
     * 圆中心点 Y
     */
    @WireField(
        tag = 2,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float y;

    /**
     * 横向半径
     */
    @WireField(
        tag = 3,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float radiusX;

    /**
     * 纵向半径
     */
    @WireField(
        tag = 4,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float radiusY;

    public EllipseArgs(Float x, Float y, Float radiusX, Float radiusY) {
      this(x, y, radiusX, radiusY, ByteString.EMPTY);
    }

    public EllipseArgs(Float x, Float y, Float radiusX, Float radiusY, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.x = x;
      this.y = y;
      this.radiusX = radiusX;
      this.radiusY = radiusY;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.x = x;
      builder.y = y;
      builder.radiusX = radiusX;
      builder.radiusY = radiusY;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof EllipseArgs)) return false;
      EllipseArgs o = (EllipseArgs) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(x, o.x)
          && Internal.equals(y, o.y)
          && Internal.equals(radiusX, o.radiusX)
          && Internal.equals(radiusY, o.radiusY);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + (x != null ? x.hashCode() : 0);
        result = result * 37 + (y != null ? y.hashCode() : 0);
        result = result * 37 + (radiusX != null ? radiusX.hashCode() : 0);
        result = result * 37 + (radiusY != null ? radiusY.hashCode() : 0);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      if (x != null) builder.append(", x=").append(x);
      if (y != null) builder.append(", y=").append(y);
      if (radiusX != null) builder.append(", radiusX=").append(radiusX);
      if (radiusY != null) builder.append(", radiusY=").append(radiusY);
      return builder.replace(0, 2, "EllipseArgs{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<EllipseArgs, Builder> {
      public Float x;

      public Float y;

      public Float radiusX;

      public Float radiusY;

      public Builder() {
      }

      /**
       * 圆中心点 X
       */
      public Builder x(Float x) {
        this.x = x;
        return this;
      }

      /**
       * 圆中心点 Y
       */
      public Builder y(Float y) {
        this.y = y;
        return this;
      }

      /**
       * 横向半径
       */
      public Builder radiusX(Float radiusX) {
        this.radiusX = radiusX;
        return this;
      }

      /**
       * 纵向半径
       */
      public Builder radiusY(Float radiusY) {
        this.radiusY = radiusY;
        return this;
      }

      @Override
      public EllipseArgs build() {
        return new EllipseArgs(x, y, radiusX, radiusY, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_EllipseArgs extends ProtoAdapter<EllipseArgs> {
      ProtoAdapter_EllipseArgs() {
        super(FieldEncoding.LENGTH_DELIMITED, EllipseArgs.class);
      }

      @Override
      public int encodedSize(EllipseArgs value) {
        return (value.x != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(1, value.x) : 0)
            + (value.y != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(2, value.y) : 0)
            + (value.radiusX != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(3, value.radiusX) : 0)
            + (value.radiusY != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(4, value.radiusY) : 0)
            + value.unknownFields().size();
      }

      @Override
      public void encode(ProtoWriter writer, EllipseArgs value) throws IOException {
        if (value.x != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 1, value.x);
        if (value.y != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 2, value.y);
        if (value.radiusX != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 3, value.radiusX);
        if (value.radiusY != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 4, value.radiusY);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public EllipseArgs decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.x(ProtoAdapter.FLOAT.decode(reader)); break;
            case 2: builder.y(ProtoAdapter.FLOAT.decode(reader)); break;
            case 3: builder.radiusX(ProtoAdapter.FLOAT.decode(reader)); break;
            case 4: builder.radiusY(ProtoAdapter.FLOAT.decode(reader)); break;
            default: {
              FieldEncoding fieldEncoding = reader.peekFieldEncoding();
              Object value = fieldEncoding.rawProtoAdapter().decode(reader);
              builder.addUnknownField(tag, fieldEncoding, value);
            }
          }
        }
        reader.endMessage(token);
        return builder.build();
      }

      @Override
      public EllipseArgs redact(EllipseArgs value) {
        Builder builder = value.newBuilder();
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  public static final class ShapeStyle extends Message<ShapeStyle, ShapeStyle.Builder> {
    public static final ProtoAdapter<ShapeStyle> ADAPTER = new ProtoAdapter_ShapeStyle();

    private static final long serialVersionUID = 0L;

    public static final Float DEFAULT_STROKEWIDTH = 0.0f;

    public static final LineCap DEFAULT_LINECAP = LineCap.LineCap_BUTT;

    public static final LineJoin DEFAULT_LINEJOIN = LineJoin.LineJoin_MITER;

    public static final Float DEFAULT_MITERLIMIT = 0.0f;

    public static final Float DEFAULT_LINEDASHI = 0.0f;

    public static final Float DEFAULT_LINEDASHII = 0.0f;

    public static final Float DEFAULT_LINEDASHIII = 0.0f;

    /**
     * 填充色
     */
    @WireField(
        tag = 1,
        adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeStyle$RGBAColor#ADAPTER"
    )
    public final RGBAColor fill;

    /**
     * 描边色
     */
    @WireField(
        tag = 2,
        adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeStyle$RGBAColor#ADAPTER"
    )
    public final RGBAColor stroke;

    /**
     * 描边宽
     */
    @WireField(
        tag = 3,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float strokeWidth;

    /**
     * 线段端点样式
     */
    @WireField(
        tag = 4,
        adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeStyle$LineCap#ADAPTER"
    )
    public final LineCap lineCap;

    /**
     * 线段连接样式
     */
    @WireField(
        tag = 5,
        adapter = "com.opensource.svgaplayer.proto.ShapeEntity$ShapeStyle$LineJoin#ADAPTER"
    )
    public final LineJoin lineJoin;

    /**
     * 尖角限制
     */
    @WireField(
        tag = 6,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float miterLimit;

    /**
     * 虚线参数 Dash
     */
    @WireField(
        tag = 7,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float lineDashI;

    /**
     * 虚线参数 Gap
     */
    @WireField(
        tag = 8,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float lineDashII;

    /**
     * 虚线参数 Offset
     */
    @WireField(
        tag = 9,
        adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
    )
    public final Float lineDashIII;

    public ShapeStyle(RGBAColor fill, RGBAColor stroke, Float strokeWidth, LineCap lineCap, LineJoin lineJoin, Float miterLimit, Float lineDashI, Float lineDashII, Float lineDashIII) {
      this(fill, stroke, strokeWidth, lineCap, lineJoin, miterLimit, lineDashI, lineDashII, lineDashIII, ByteString.EMPTY);
    }

    public ShapeStyle(RGBAColor fill, RGBAColor stroke, Float strokeWidth, LineCap lineCap, LineJoin lineJoin, Float miterLimit, Float lineDashI, Float lineDashII, Float lineDashIII, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.fill = fill;
      this.stroke = stroke;
      this.strokeWidth = strokeWidth;
      this.lineCap = lineCap;
      this.lineJoin = lineJoin;
      this.miterLimit = miterLimit;
      this.lineDashI = lineDashI;
      this.lineDashII = lineDashII;
      this.lineDashIII = lineDashIII;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.fill = fill;
      builder.stroke = stroke;
      builder.strokeWidth = strokeWidth;
      builder.lineCap = lineCap;
      builder.lineJoin = lineJoin;
      builder.miterLimit = miterLimit;
      builder.lineDashI = lineDashI;
      builder.lineDashII = lineDashII;
      builder.lineDashIII = lineDashIII;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof ShapeStyle)) return false;
      ShapeStyle o = (ShapeStyle) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(fill, o.fill)
          && Internal.equals(stroke, o.stroke)
          && Internal.equals(strokeWidth, o.strokeWidth)
          && Internal.equals(lineCap, o.lineCap)
          && Internal.equals(lineJoin, o.lineJoin)
          && Internal.equals(miterLimit, o.miterLimit)
          && Internal.equals(lineDashI, o.lineDashI)
          && Internal.equals(lineDashII, o.lineDashII)
          && Internal.equals(lineDashIII, o.lineDashIII);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + (fill != null ? fill.hashCode() : 0);
        result = result * 37 + (stroke != null ? stroke.hashCode() : 0);
        result = result * 37 + (strokeWidth != null ? strokeWidth.hashCode() : 0);
        result = result * 37 + (lineCap != null ? lineCap.hashCode() : 0);
        result = result * 37 + (lineJoin != null ? lineJoin.hashCode() : 0);
        result = result * 37 + (miterLimit != null ? miterLimit.hashCode() : 0);
        result = result * 37 + (lineDashI != null ? lineDashI.hashCode() : 0);
        result = result * 37 + (lineDashII != null ? lineDashII.hashCode() : 0);
        result = result * 37 + (lineDashIII != null ? lineDashIII.hashCode() : 0);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      if (fill != null) builder.append(", fill=").append(fill);
      if (stroke != null) builder.append(", stroke=").append(stroke);
      if (strokeWidth != null) builder.append(", strokeWidth=").append(strokeWidth);
      if (lineCap != null) builder.append(", lineCap=").append(lineCap);
      if (lineJoin != null) builder.append(", lineJoin=").append(lineJoin);
      if (miterLimit != null) builder.append(", miterLimit=").append(miterLimit);
      if (lineDashI != null) builder.append(", lineDashI=").append(lineDashI);
      if (lineDashII != null) builder.append(", lineDashII=").append(lineDashII);
      if (lineDashIII != null) builder.append(", lineDashIII=").append(lineDashIII);
      return builder.replace(0, 2, "ShapeStyle{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<ShapeStyle, Builder> {
      public RGBAColor fill;

      public RGBAColor stroke;

      public Float strokeWidth;

      public LineCap lineCap;

      public LineJoin lineJoin;

      public Float miterLimit;

      public Float lineDashI;

      public Float lineDashII;

      public Float lineDashIII;

      public Builder() {
      }

      /**
       * 填充色
       */
      public Builder fill(RGBAColor fill) {
        this.fill = fill;
        return this;
      }

      /**
       * 描边色
       */
      public Builder stroke(RGBAColor stroke) {
        this.stroke = stroke;
        return this;
      }

      /**
       * 描边宽
       */
      public Builder strokeWidth(Float strokeWidth) {
        this.strokeWidth = strokeWidth;
        return this;
      }

      /**
       * 线段端点样式
       */
      public Builder lineCap(LineCap lineCap) {
        this.lineCap = lineCap;
        return this;
      }

      /**
       * 线段连接样式
       */
      public Builder lineJoin(LineJoin lineJoin) {
        this.lineJoin = lineJoin;
        return this;
      }

      /**
       * 尖角限制
       */
      public Builder miterLimit(Float miterLimit) {
        this.miterLimit = miterLimit;
        return this;
      }

      /**
       * 虚线参数 Dash
       */
      public Builder lineDashI(Float lineDashI) {
        this.lineDashI = lineDashI;
        return this;
      }

      /**
       * 虚线参数 Gap
       */
      public Builder lineDashII(Float lineDashII) {
        this.lineDashII = lineDashII;
        return this;
      }

      /**
       * 虚线参数 Offset
       */
      public Builder lineDashIII(Float lineDashIII) {
        this.lineDashIII = lineDashIII;
        return this;
      }

      @Override
      public ShapeStyle build() {
        return new ShapeStyle(fill, stroke, strokeWidth, lineCap, lineJoin, miterLimit, lineDashI, lineDashII, lineDashIII, super.buildUnknownFields());
      }
    }

    public static final class RGBAColor extends Message<RGBAColor, RGBAColor.Builder> {
      public static final ProtoAdapter<RGBAColor> ADAPTER = new ProtoAdapter_RGBAColor();

      private static final long serialVersionUID = 0L;

      public static final Float DEFAULT_R = 0.0f;

      public static final Float DEFAULT_G = 0.0f;

      public static final Float DEFAULT_B = 0.0f;

      public static final Float DEFAULT_A = 0.0f;

      @WireField(
          tag = 1,
          adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
      )
      public final Float r;

      @WireField(
          tag = 2,
          adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
      )
      public final Float g;

      @WireField(
          tag = 3,
          adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
      )
      public final Float b;

      @WireField(
          tag = 4,
          adapter = "com.squareup.wire.ProtoAdapter#FLOAT"
      )
      public final Float a;

      public RGBAColor(Float r, Float g, Float b, Float a) {
        this(r, g, b, a, ByteString.EMPTY);
      }

      public RGBAColor(Float r, Float g, Float b, Float a, ByteString unknownFields) {
        super(ADAPTER, unknownFields);
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
      }

      @Override
      public Builder newBuilder() {
        Builder builder = new Builder();
        builder.r = r;
        builder.g = g;
        builder.b = b;
        builder.a = a;
        builder.addUnknownFields(unknownFields());
        return builder;
      }

      @Override
      public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof RGBAColor)) return false;
        RGBAColor o = (RGBAColor) other;
        return unknownFields().equals(o.unknownFields())
            && Internal.equals(r, o.r)
            && Internal.equals(g, o.g)
            && Internal.equals(b, o.b)
            && Internal.equals(a, o.a);
      }

      @Override
      public int hashCode() {
        int result = super.hashCode;
        if (result == 0) {
          result = unknownFields().hashCode();
          result = result * 37 + (r != null ? r.hashCode() : 0);
          result = result * 37 + (g != null ? g.hashCode() : 0);
          result = result * 37 + (b != null ? b.hashCode() : 0);
          result = result * 37 + (a != null ? a.hashCode() : 0);
          super.hashCode = result;
        }
        return result;
      }

      @Override
      public String toString() {
        StringBuilder builder = new StringBuilder();
        if (r != null) builder.append(", r=").append(r);
        if (g != null) builder.append(", g=").append(g);
        if (b != null) builder.append(", b=").append(b);
        if (a != null) builder.append(", a=").append(a);
        return builder.replace(0, 2, "RGBAColor{").append('}').toString();
      }

      public static final class Builder extends Message.Builder<RGBAColor, Builder> {
        public Float r;

        public Float g;

        public Float b;

        public Float a;

        public Builder() {
        }

        public Builder r(Float r) {
          this.r = r;
          return this;
        }

        public Builder g(Float g) {
          this.g = g;
          return this;
        }

        public Builder b(Float b) {
          this.b = b;
          return this;
        }

        public Builder a(Float a) {
          this.a = a;
          return this;
        }

        @Override
        public RGBAColor build() {
          return new RGBAColor(r, g, b, a, super.buildUnknownFields());
        }
      }

      private static final class ProtoAdapter_RGBAColor extends ProtoAdapter<RGBAColor> {
        ProtoAdapter_RGBAColor() {
          super(FieldEncoding.LENGTH_DELIMITED, RGBAColor.class);
        }

        @Override
        public int encodedSize(RGBAColor value) {
          return (value.r != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(1, value.r) : 0)
              + (value.g != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(2, value.g) : 0)
              + (value.b != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(3, value.b) : 0)
              + (value.a != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(4, value.a) : 0)
              + value.unknownFields().size();
        }

        @Override
        public void encode(ProtoWriter writer, RGBAColor value) throws IOException {
          if (value.r != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 1, value.r);
          if (value.g != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 2, value.g);
          if (value.b != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 3, value.b);
          if (value.a != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 4, value.a);
          writer.writeBytes(value.unknownFields());
        }

        @Override
        public RGBAColor decode(ProtoReader reader) throws IOException {
          Builder builder = new Builder();
          long token = reader.beginMessage();
          for (int tag; (tag = reader.nextTag()) != -1;) {
            switch (tag) {
              case 1: builder.r(ProtoAdapter.FLOAT.decode(reader)); break;
              case 2: builder.g(ProtoAdapter.FLOAT.decode(reader)); break;
              case 3: builder.b(ProtoAdapter.FLOAT.decode(reader)); break;
              case 4: builder.a(ProtoAdapter.FLOAT.decode(reader)); break;
              default: {
                FieldEncoding fieldEncoding = reader.peekFieldEncoding();
                Object value = fieldEncoding.rawProtoAdapter().decode(reader);
                builder.addUnknownField(tag, fieldEncoding, value);
              }
            }
          }
          reader.endMessage(token);
          return builder.build();
        }

        @Override
        public RGBAColor redact(RGBAColor value) {
          Builder builder = value.newBuilder();
          builder.clearUnknownFields();
          return builder.build();
        }
      }
    }

    public enum LineCap implements WireEnum {
      LineCap_BUTT(0),

      LineCap_ROUND(1),

      LineCap_SQUARE(2);

      public static final ProtoAdapter<LineCap> ADAPTER = ProtoAdapter.newEnumAdapter(LineCap.class);

      private final int value;

      LineCap(int value) {
        this.value = value;
      }

      /**
       * Return the constant for {@code value} or null.
       */
      public static LineCap fromValue(int value) {
        switch (value) {
          case 0: return LineCap_BUTT;
          case 1: return LineCap_ROUND;
          case 2: return LineCap_SQUARE;
          default: return null;
        }
      }

      @Override
      public int getValue() {
        return value;
      }
    }

    public enum LineJoin implements WireEnum {
      LineJoin_MITER(0),

      LineJoin_ROUND(1),

      LineJoin_BEVEL(2);

      public static final ProtoAdapter<LineJoin> ADAPTER = ProtoAdapter.newEnumAdapter(LineJoin.class);

      private final int value;

      LineJoin(int value) {
        this.value = value;
      }

      /**
       * Return the constant for {@code value} or null.
       */
      public static LineJoin fromValue(int value) {
        switch (value) {
          case 0: return LineJoin_MITER;
          case 1: return LineJoin_ROUND;
          case 2: return LineJoin_BEVEL;
          default: return null;
        }
      }

      @Override
      public int getValue() {
        return value;
      }
    }

    private static final class ProtoAdapter_ShapeStyle extends ProtoAdapter<ShapeStyle> {
      ProtoAdapter_ShapeStyle() {
        super(FieldEncoding.LENGTH_DELIMITED, ShapeStyle.class);
      }

      @Override
      public int encodedSize(ShapeStyle value) {
        return (value.fill != null ? RGBAColor.ADAPTER.encodedSizeWithTag(1, value.fill) : 0)
            + (value.stroke != null ? RGBAColor.ADAPTER.encodedSizeWithTag(2, value.stroke) : 0)
            + (value.strokeWidth != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(3, value.strokeWidth) : 0)
            + (value.lineCap != null ? LineCap.ADAPTER.encodedSizeWithTag(4, value.lineCap) : 0)
            + (value.lineJoin != null ? LineJoin.ADAPTER.encodedSizeWithTag(5, value.lineJoin) : 0)
            + (value.miterLimit != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(6, value.miterLimit) : 0)
            + (value.lineDashI != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(7, value.lineDashI) : 0)
            + (value.lineDashII != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(8, value.lineDashII) : 0)
            + (value.lineDashIII != null ? ProtoAdapter.FLOAT.encodedSizeWithTag(9, value.lineDashIII) : 0)
            + value.unknownFields().size();
      }

      @Override
      public void encode(ProtoWriter writer, ShapeStyle value) throws IOException {
        if (value.fill != null) RGBAColor.ADAPTER.encodeWithTag(writer, 1, value.fill);
        if (value.stroke != null) RGBAColor.ADAPTER.encodeWithTag(writer, 2, value.stroke);
        if (value.strokeWidth != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 3, value.strokeWidth);
        if (value.lineCap != null) LineCap.ADAPTER.encodeWithTag(writer, 4, value.lineCap);
        if (value.lineJoin != null) LineJoin.ADAPTER.encodeWithTag(writer, 5, value.lineJoin);
        if (value.miterLimit != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 6, value.miterLimit);
        if (value.lineDashI != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 7, value.lineDashI);
        if (value.lineDashII != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 8, value.lineDashII);
        if (value.lineDashIII != null) ProtoAdapter.FLOAT.encodeWithTag(writer, 9, value.lineDashIII);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public ShapeStyle decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.fill(RGBAColor.ADAPTER.decode(reader)); break;
            case 2: builder.stroke(RGBAColor.ADAPTER.decode(reader)); break;
            case 3: builder.strokeWidth(ProtoAdapter.FLOAT.decode(reader)); break;
            case 4: {
              try {
                builder.lineCap(LineCap.ADAPTER.decode(reader));
              } catch (ProtoAdapter.EnumConstantNotFoundException e) {
                builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
              }
              break;
            }
            case 5: {
              try {
                builder.lineJoin(LineJoin.ADAPTER.decode(reader));
              } catch (ProtoAdapter.EnumConstantNotFoundException e) {
                builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
              }
              break;
            }
            case 6: builder.miterLimit(ProtoAdapter.FLOAT.decode(reader)); break;
            case 7: builder.lineDashI(ProtoAdapter.FLOAT.decode(reader)); break;
            case 8: builder.lineDashII(ProtoAdapter.FLOAT.decode(reader)); break;
            case 9: builder.lineDashIII(ProtoAdapter.FLOAT.decode(reader)); break;
            default: {
              FieldEncoding fieldEncoding = reader.peekFieldEncoding();
              Object value = fieldEncoding.rawProtoAdapter().decode(reader);
              builder.addUnknownField(tag, fieldEncoding, value);
            }
          }
        }
        reader.endMessage(token);
        return builder.build();
      }

      @Override
      public ShapeStyle redact(ShapeStyle value) {
        Builder builder = value.newBuilder();
        if (builder.fill != null) builder.fill = RGBAColor.ADAPTER.redact(builder.fill);
        if (builder.stroke != null) builder.stroke = RGBAColor.ADAPTER.redact(builder.stroke);
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  private static final class ProtoAdapter_ShapeEntity extends ProtoAdapter<ShapeEntity> {
    ProtoAdapter_ShapeEntity() {
      super(FieldEncoding.LENGTH_DELIMITED, ShapeEntity.class);
    }

    @Override
    public int encodedSize(ShapeEntity value) {
      return (value.type != null ? ShapeType.ADAPTER.encodedSizeWithTag(1, value.type) : 0)
          + (value.styles != null ? ShapeStyle.ADAPTER.encodedSizeWithTag(10, value.styles) : 0)
          + (value.transform != null ? Transform.ADAPTER.encodedSizeWithTag(11, value.transform) : 0)
          + (value.shape != null ? ShapeArgs.ADAPTER.encodedSizeWithTag(2, value.shape) : 0)
          + (value.rect != null ? RectArgs.ADAPTER.encodedSizeWithTag(3, value.rect) : 0)
          + (value.ellipse != null ? EllipseArgs.ADAPTER.encodedSizeWithTag(4, value.ellipse) : 0)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, ShapeEntity value) throws IOException {
      if (value.type != null) ShapeType.ADAPTER.encodeWithTag(writer, 1, value.type);
      if (value.styles != null) ShapeStyle.ADAPTER.encodeWithTag(writer, 10, value.styles);
      if (value.transform != null) Transform.ADAPTER.encodeWithTag(writer, 11, value.transform);
      if (value.shape != null) ShapeArgs.ADAPTER.encodeWithTag(writer, 2, value.shape);
      if (value.rect != null) RectArgs.ADAPTER.encodeWithTag(writer, 3, value.rect);
      if (value.ellipse != null) EllipseArgs.ADAPTER.encodeWithTag(writer, 4, value.ellipse);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public ShapeEntity decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: {
            try {
              builder.type(ShapeType.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 10: builder.styles(ShapeStyle.ADAPTER.decode(reader)); break;
          case 11: builder.transform(Transform.ADAPTER.decode(reader)); break;
          case 2: builder.shape(ShapeArgs.ADAPTER.decode(reader)); break;
          case 3: builder.rect(RectArgs.ADAPTER.decode(reader)); break;
          case 4: builder.ellipse(EllipseArgs.ADAPTER.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public ShapeEntity redact(ShapeEntity value) {
      Builder builder = value.newBuilder();
      if (builder.styles != null) builder.styles = ShapeStyle.ADAPTER.redact(builder.styles);
      if (builder.transform != null) builder.transform = Transform.ADAPTER.redact(builder.transform);
      if (builder.shape != null) builder.shape = ShapeArgs.ADAPTER.redact(builder.shape);
      if (builder.rect != null) builder.rect = RectArgs.ADAPTER.redact(builder.rect);
      if (builder.ellipse != null) builder.ellipse = EllipseArgs.ADAPTER.redact(builder.ellipse);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
