/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Shader;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.widget.ImageView;
import com.opensource.svgaplayer.SGVADrawer;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAPath;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.SVGAVideoShapeEntity;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 R\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002J \u0010$\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0016J\u001c\u0010'\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 R\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010(\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 R\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0002J$\u0010)\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 R\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0002J$\u0010*\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00112\n\u0010\u001f\u001a\u00060 R\u00020\u0001H\u0002J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000bj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/opensource/svgaplayer/SVGACanvasDrawer;", "Lcom/opensource/svgaplayer/SGVADrawer;", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "(Lcom/opensource/svgaplayer/SVGAVideoEntity;Lcom/opensource/svgaplayer/SVGADynamicEntity;)V", "canvasH", "", "canvasW", "drawPathCache", "Ljava/util/HashMap;", "Lcom/opensource/svgaplayer/SVGAVideoShapeEntity;", "Landroid/graphics/Path;", "Lkotlin/collections/HashMap;", "drawTextCache", "", "Landroid/graphics/Bitmap;", "getDynamicItem", "()Lcom/opensource/svgaplayer/SVGADynamicEntity;", "sharedFrameMatrix", "Landroid/graphics/Matrix;", "sharedPaint", "Landroid/graphics/Paint;", "sharedPath", "sharedPath2", "sharedShapeMatrix", "tValues", "", "drawDynamic", "", "sprite", "Lcom/opensource/svgaplayer/SGVADrawer$SVGADrawerSprite;", "canvas", "Landroid/graphics/Canvas;", "frameIndex", "drawFrame", "scaleType", "Landroid/widget/ImageView$ScaleType;", "drawImage", "drawShape", "drawSprite", "drawText", "drawingBitmap", "requestScale", "", "resetCachePath", "resetShapeStrokePaint", "shape", "resetShareMatrix", "transform", "library_release"})
public final class SVGACanvasDrawer
extends SGVADrawer {
    private int canvasW;
    private int canvasH;
    private final Paint sharedPaint;
    private final Path sharedPath;
    private final Path sharedPath2;
    private final Matrix sharedShapeMatrix;
    private final Matrix sharedFrameMatrix;
    private final HashMap<String, Bitmap> drawTextCache;
    private final HashMap<SVGAVideoShapeEntity, Path> drawPathCache;
    private final float[] tValues;
    @NotNull
    private final SVGADynamicEntity dynamicItem;

    @Override
    public void drawFrame(@NotNull Canvas canvas, int frameIndex, @NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.drawFrame(canvas, frameIndex, scaleType);
        this.resetCachePath(canvas);
        List<SGVADrawer.SVGADrawerSprite> sprites = this.requestFrameSprites$library_release(frameIndex);
        Iterable $receiver$iv = sprites;
        for (Object element$iv : $receiver$iv) {
            SGVADrawer.SVGADrawerSprite it = (SGVADrawer.SVGADrawerSprite)element$iv;
            this.drawSprite(it, canvas, frameIndex);
        }
    }

    private final void resetCachePath(Canvas canvas) {
        if (this.canvasW != canvas.getWidth() || this.canvasH != canvas.getHeight()) {
            this.drawPathCache.clear();
        }
        this.canvasW = canvas.getWidth();
        this.canvasH = canvas.getHeight();
    }

    private final void resetShareMatrix(Matrix transform) {
        this.sharedFrameMatrix.reset();
        this.sharedFrameMatrix.postScale(this.getScaleEntity().getScaleFx(), this.getScaleEntity().getScaleFy());
        this.sharedFrameMatrix.postTranslate(this.getScaleEntity().getTranFx(), this.getScaleEntity().getTranFy());
        this.sharedFrameMatrix.preConcat(transform);
    }

    private final void drawSprite(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        this.drawImage(sprite, canvas);
        this.drawShape(sprite, canvas);
        this.drawDynamic(sprite, canvas, frameIndex);
    }

    private final void drawImage(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        block4: {
            Boolean it;
            block7: {
                block5: {
                    SVGAPath sVGAPath;
                    block6: {
                        Bitmap bitmap;
                        Boolean bl;
                        String string = sprite.getImageKey();
                        if (string == null) {
                            return;
                        }
                        String imageKey = string;
                        Boolean bl2 = this.dynamicItem.getDynamicHidden$library_release().get(imageKey);
                        if (bl2 != null) {
                            Boolean bl3 = it = (bl = bl2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"it");
                            bl2 = bl3 != false ? bl : null;
                            if (bl2 != null) {
                                it = bl = bl2;
                                return;
                            }
                        }
                        if ((bitmap = this.dynamicItem.getDynamicImage$library_release().get(imageKey)) == null) {
                            bitmap = this.getVideoItem().getImages().get(imageKey);
                        }
                        if (bitmap == null) break block4;
                        it = bl = bitmap;
                        this.resetShareMatrix(sprite.getFrameEntity().getTransform());
                        this.sharedPaint.reset();
                        this.sharedPaint.setAntiAlias(this.getVideoItem().getAntiAlias());
                        this.sharedPaint.setFilterBitmap(this.getVideoItem().getAntiAlias());
                        this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
                        if (sprite.getFrameEntity().getMaskPath() == null) break block5;
                        sVGAPath = sprite.getFrameEntity().getMaskPath();
                        if (sVGAPath != null) break block6;
                        break block4;
                    }
                    SVGAPath maskPath = sVGAPath;
                    canvas.save();
                    this.sharedPath.reset();
                    maskPath.buildPath(this.sharedPath);
                    this.sharedPath.transform(this.sharedFrameMatrix);
                    canvas.clipPath(this.sharedPath);
                    this.sharedFrameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()));
                    canvas.drawBitmap((Bitmap)it, this.sharedFrameMatrix, this.sharedPaint);
                    canvas.restore();
                    break block7;
                }
                this.sharedFrameMatrix.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()));
                canvas.drawBitmap((Bitmap)it, this.sharedFrameMatrix, this.sharedPaint);
            }
            this.drawText(canvas, (Bitmap)it, sprite);
        }
    }

    private final void drawText(Canvas canvas, Bitmap drawingBitmap, SGVADrawer.SVGADrawerSprite sprite) {
        block15: {
            TextPaint textPaint;
            String string;
            if (this.dynamicItem.isTextDirty$library_release()) {
                this.drawTextCache.clear();
                this.dynamicItem.setTextDirty$library_release(false);
            }
            String string2 = sprite.getImageKey();
            if (string2 == null) {
                return;
            }
            String imageKey = string2;
            Bitmap textBitmap = null;
            String string3 = this.dynamicItem.getDynamicText$library_release().get(imageKey);
            if (string3 != null) {
                String drawingText = string = string3;
                TextPaint textPaint2 = this.dynamicItem.getDynamicTextPaint$library_release().get(imageKey);
                if (textPaint2 != null) {
                    TextPaint drawingTextPaint = textPaint = textPaint2;
                    Bitmap bitmap = this.drawTextCache.get(imageKey);
                    if (bitmap != null) {
                        Bitmap bitmap2;
                        Bitmap it;
                        textBitmap = it = (bitmap2 = bitmap);
                    } else {
                        textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas textCanvas = new Canvas(textBitmap);
                        drawingTextPaint.setAntiAlias(true);
                        Rect bounds = new Rect();
                        drawingTextPaint.getTextBounds(drawingText, 0, drawingText.length(), bounds);
                        double x = (double)(drawingBitmap.getWidth() - bounds.width()) / 2.0;
                        int targetRectTop = 0;
                        int targetRectBottom = drawingBitmap.getHeight();
                        float y = ((float)(targetRectBottom + targetRectTop) - drawingTextPaint.getFontMetrics().bottom - drawingTextPaint.getFontMetrics().top) / (float)2;
                        textCanvas.drawText(drawingText, (float)x, y, (Paint)drawingTextPaint);
                        Bitmap bitmap3 = textBitmap;
                        if (bitmap3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                        }
                        this.drawTextCache.put(imageKey, bitmap3);
                    }
                }
            }
            StaticLayout staticLayout = this.dynamicItem.getDynamicLayoutText$library_release().get(imageKey);
            if (staticLayout != null) {
                String it = string = staticLayout;
                Bitmap bitmap = this.drawTextCache.get(imageKey);
                if (bitmap != null) {
                    TextPaint it2 = textPaint = bitmap;
                    textBitmap = it2;
                } else {
                    it.getPaint().setAntiAlias(true);
                    StaticLayout layout = new StaticLayout(it.getText(), 0, it.getText().length(), it.getPaint(), drawingBitmap.getWidth(), it.getAlignment(), it.getSpacingMultiplier(), it.getSpacingAdd(), false);
                    textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas textCanvas = new Canvas(textBitmap);
                    textCanvas.translate(0.0f, (float)((drawingBitmap.getHeight() - layout.getHeight()) / 2));
                    layout.draw(textCanvas);
                    Bitmap bitmap4 = textBitmap;
                    if (bitmap4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.graphics.Bitmap");
                    }
                    this.drawTextCache.put(imageKey, bitmap4);
                }
            }
            Bitmap bitmap = textBitmap;
            if (bitmap == null) break block15;
            String textBitmap2 = string = bitmap;
            this.sharedPaint.reset();
            this.sharedPaint.setAntiAlias(this.getVideoItem().getAntiAlias());
            if (sprite.getFrameEntity().getMaskPath() != null) {
                SVGAPath sVGAPath = sprite.getFrameEntity().getMaskPath();
                if (sVGAPath == null) {
                } else {
                    SVGAPath maskPath = sVGAPath;
                    canvas.save();
                    canvas.concat(this.sharedFrameMatrix);
                    canvas.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                    BitmapShader bitmapShader = new BitmapShader((Bitmap)textBitmap2, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    this.sharedPaint.setShader((Shader)bitmapShader);
                    this.sharedPath.reset();
                    maskPath.buildPath(this.sharedPath);
                    canvas.drawPath(this.sharedPath, this.sharedPaint);
                    canvas.restore();
                }
            } else {
                this.sharedPaint.setFilterBitmap(this.getVideoItem().getAntiAlias());
                canvas.drawBitmap((Bitmap)textBitmap2, this.sharedFrameMatrix, this.sharedPaint);
            }
        }
    }

    private final void drawShape(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas) {
        this.resetShareMatrix(sprite.getFrameEntity().getTransform());
        Iterable $receiver$iv = sprite.getFrameEntity().getShapes();
        for (Object element$iv : $receiver$iv) {
            SVGAPath maskPath;
            SVGAPath sVGAPath;
            int n;
            int it;
            Path path;
            SVGAVideoShapeEntity shape = (SVGAVideoShapeEntity)element$iv;
            shape.buildPath();
            if (shape.getShapePath() == null) continue;
            Path it2 = path;
            this.sharedPaint.reset();
            this.sharedPaint.setAntiAlias(this.getVideoItem().getAntiAlias());
            this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            if (!this.drawPathCache.containsKey(shape)) {
                this.sharedShapeMatrix.reset();
                if (shape.getTransform() != null) {
                    Matrix matrix;
                    Matrix it3 = matrix;
                    this.sharedShapeMatrix.postConcat(it3);
                }
                this.sharedShapeMatrix.postConcat(this.sharedFrameMatrix);
                Path path2 = new Path();
                path2.set(shape.getShapePath());
                path2.transform(this.sharedShapeMatrix);
                this.drawPathCache.put(shape, path2);
            }
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null && (it = (n = styles.getFill())) != 0) {
                this.sharedPaint.setColor(it);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas.save();
                }
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    maskPath = sVGAPath;
                    this.sharedPath2.reset();
                    maskPath.buildPath(this.sharedPath2);
                    this.sharedPath2.transform(this.sharedFrameMatrix);
                    canvas.clipPath(this.sharedPath2);
                }
                canvas.drawPath(this.drawPathCache.get(shape), this.sharedPaint);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas.restore();
                }
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 == null) continue;
            float f = styles2.getStrokeWidth();
            float it22 = f;
            if (!(it22 > 0.0f)) continue;
            this.resetShapeStrokePaint(shape);
            if (sprite.getFrameEntity().getMaskPath() != null) {
                canvas.save();
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                maskPath = sVGAPath;
                this.sharedPath2.reset();
                maskPath.buildPath(this.sharedPath2);
                this.sharedPath2.transform(this.sharedFrameMatrix);
                canvas.clipPath(this.sharedPath2);
            }
            canvas.drawPath(this.drawPathCache.get(shape), this.sharedPaint);
            if (sprite.getFrameEntity().getMaskPath() == null) continue;
            canvas.restore();
        }
    }

    private final float requestScale() {
        this.sharedFrameMatrix.getValues(this.tValues);
        if (this.tValues[0] == 0.0f) {
            return 0.0f;
        }
        double A = this.tValues[0];
        double D = this.tValues[4];
        double B = this.tValues[3];
        double C = this.tValues[1];
        if (A * D == B * C) {
            return 0.0f;
        }
        double scaleX = Math.sqrt(A * A + B * B);
        double skew = (A /= scaleX) * C + (B /= scaleX) * D;
        double scaleY = Math.sqrt((C -= A * skew) * C + (D -= B * skew) * D);
        C /= scaleY;
        D /= scaleY;
        skew /= scaleY;
        if (A * D < B * C) {
            scaleX = -scaleX;
        }
        return this.getScaleEntity().getRatioX() ? this.getScaleEntity().getRatio() / Math.abs((float)scaleX) : this.getScaleEntity().getRatio() / Math.abs((float)scaleY);
    }

    private final void resetShapeStrokePaint(SVGAVideoShapeEntity shape) {
        block16: {
            Object object;
            Object it;
            Object object2;
            Object object3;
            Object object4;
            this.sharedPaint.reset();
            this.sharedPaint.setAntiAlias(this.getVideoItem().getAntiAlias());
            this.sharedPaint.setStyle(Paint.Style.STROKE);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null) {
                int n;
                int it2 = n = styles.getStroke();
                this.sharedPaint.setColor(it2);
            }
            float scale = this.requestScale();
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 != null) {
                float f;
                float it3 = f = styles2.getStrokeWidth();
                this.sharedPaint.setStrokeWidth(it3 * scale);
            }
            if ((object4 = shape.getStyles()) != null && (object4 = ((SVGAVideoShapeEntity.Styles)object4).getLineCap()) != null) {
                Object object5 = object4;
                Object it4 = object5;
                if (StringsKt.equals((String)it4, (String)"butt", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.BUTT);
                } else if (StringsKt.equals((String)it4, (String)"round", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.ROUND);
                } else if (StringsKt.equals((String)it4, (String)"square", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
            if ((object3 = shape.getStyles()) != null && (object3 = ((SVGAVideoShapeEntity.Styles)object3).getLineJoin()) != null) {
                Object object6 = object3;
                Object it5 = object6;
                if (StringsKt.equals((String)it5, (String)"miter", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.MITER);
                } else if (StringsKt.equals((String)it5, (String)"round", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.ROUND);
                } else if (StringsKt.equals((String)it5, (String)"bevel", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
            SVGAVideoShapeEntity.Styles styles3 = shape.getStyles();
            if (styles3 != null) {
                int n;
                int it6 = n = styles3.getMiterLimit();
                this.sharedPaint.setStrokeMiter((float)it6 * scale);
            }
            if ((object2 = shape.getStyles()) == null) break block16;
            float[] fArray = ((SVGAVideoShapeEntity.Styles)object2).getLineDash();
            object2 = fArray;
            if (fArray != null && ((Object)(it = (object = object2))).length == 3 && (it[0] > 0.0f || it[1] > 0.0f)) {
                this.sharedPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{(it[0] < 1.0f ? 1.0f : (float)it[0]) * scale, (it[1] < 0.1f ? 0.1f : (float)it[1]) * scale}, (float)(it[2] * scale)));
            }
        }
    }

    private final void drawDynamic(SGVADrawer.SVGADrawerSprite sprite, Canvas canvas, int frameIndex) {
        block1: {
            Function2<Canvas, Integer, Boolean> function2;
            String string = sprite.getImageKey();
            if (string == null) {
                return;
            }
            String imageKey = string;
            Function2<Canvas, Integer, Boolean> function22 = this.dynamicItem.getDynamicDrawer$library_release().get(imageKey);
            if (function22 == null) break block1;
            Function2<Canvas, Integer, Boolean> it = function2 = function22;
            this.resetShareMatrix(sprite.getFrameEntity().getTransform());
            canvas.save();
            canvas.concat(this.sharedFrameMatrix);
            it.invoke((Object)canvas, (Object)frameIndex);
            canvas.restore();
        }
    }

    @NotNull
    public final SVGADynamicEntity getDynamicItem() {
        return this.dynamicItem;
    }

    public SVGACanvasDrawer(@NotNull SVGAVideoEntity videoItem2, @NotNull SVGADynamicEntity dynamicItem) {
        Intrinsics.checkParameterIsNotNull((Object)videoItem2, (String)"videoItem");
        Intrinsics.checkParameterIsNotNull((Object)dynamicItem, (String)"dynamicItem");
        super(videoItem2);
        this.dynamicItem = dynamicItem;
        this.sharedPaint = new Paint();
        this.sharedPath = new Path();
        this.sharedPath2 = new Path();
        this.sharedShapeMatrix = new Matrix();
        this.sharedFrameMatrix = new Matrix();
        SVGACanvasDrawer sVGACanvasDrawer = this;
        HashMap hashMap = new HashMap();
        sVGACanvasDrawer.drawTextCache = hashMap;
        this.drawPathCache = new HashMap();
        this.tValues = new float[16];
    }
}

