/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Shader;
import android.text.TextPaint;
import android.widget.ImageView;
import com.opensource.svgaplayer.SGVADrawer;
import com.opensource.svgaplayer.SVGACanvasDrawer$WhenMappings;
import com.opensource.svgaplayer.SVGACanvasDrawerKt;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAPath;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.SVGAVideoShapeEntity;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u00020\u001d2\n\u0010#\u001a\u00060$R\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010%\u001a\u00020\u001d2\n\u0010#\u001a\u00060$R\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010&\u001a\u00020\u001d2\n\u0010#\u001a\u00060$R\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\n\u0010#\u001a\u00060$R\u00020\u0001H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010+\u001a\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/opensource/svgaplayer/SVGACanvasDrawer;", "Lcom/opensource/svgaplayer/SGVADrawer;", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "(Lcom/opensource/svgaplayer/SVGAVideoEntity;Lcom/opensource/svgaplayer/SVGADynamicEntity;)V", "canvas", "Landroid/graphics/Canvas;", "getCanvas", "()Landroid/graphics/Canvas;", "setCanvas", "(Landroid/graphics/Canvas;)V", "getDynamicItem", "()Lcom/opensource/svgaplayer/SVGADynamicEntity;", "ratio", "", "ratioX", "", "sharedContentTransform", "Landroid/graphics/Matrix;", "sharedPaint", "Landroid/graphics/Paint;", "sharedPath", "Landroid/graphics/Path;", "sharedPath2", "tValues", "", "drawFrame", "", "frameIndex", "", "scaleType", "Landroid/widget/ImageView$ScaleType;", "drawImage", "sprite", "Lcom/opensource/svgaplayer/SGVADrawer$SVGADrawerSprite;", "drawShape", "drawSprite", "drawText", "drawingBitmap", "Landroid/graphics/Bitmap;", "performScaleType", "requestScale", "resetShapeStrokePaint", "shape", "Lcom/opensource/svgaplayer/SVGAVideoShapeEntity;", "library_release"})
public final class SVGACanvasDrawer
extends SGVADrawer {
    @Nullable
    private Canvas canvas;
    private float ratio;
    private boolean ratioX;
    private final Paint sharedPaint;
    private final Path sharedPath;
    private final Path sharedPath2;
    private final Matrix sharedContentTransform;
    private final float[] tValues;
    @NotNull
    private final SVGADynamicEntity dynamicItem;

    @Nullable
    public final Canvas getCanvas() {
        return this.canvas;
    }

    public final void setCanvas(@Nullable Canvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void drawFrame(int frameIndex, @NotNull ImageView.ScaleType scaleType) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
            super.drawFrame(frameIndex, scaleType);
            DrawFilter originalFilter = null;
            if (this.getVideoItem().getAntiAlias()) {
                Canvas canvas = this.canvas;
                originalFilter = canvas != null ? canvas.getDrawFilter() : null;
                Canvas canvas2 = this.canvas;
                if (canvas2 != null) {
                    canvas2.setDrawFilter((DrawFilter)SVGACanvasDrawerKt.access$getSharedDrawFilter$p());
                }
            }
            List<SGVADrawer.SVGADrawerSprite> sprites = this.requestFrameSprites$library_release(frameIndex);
            Iterable $receiver$iv = sprites;
            for (Object element$iv : $receiver$iv) {
                SGVADrawer.SVGADrawerSprite it = (SGVADrawer.SVGADrawerSprite)element$iv;
                this.drawSprite(it, scaleType);
            }
            if (!this.getVideoItem().getAntiAlias()) break block4;
            Canvas canvas = this.canvas;
            if (canvas != null) {
                canvas.setDrawFilter(originalFilter);
            }
        }
    }

    private final void performScaleType(ImageView.ScaleType scaleType) {
        Canvas canvas = this.canvas;
        if (canvas == null) {
            return;
        }
        Canvas canvas2 = canvas;
        if (canvas2.getWidth() == 0 || canvas2.getHeight() == 0 || this.getVideoItem().getVideoSize().getWidth() == 0.0 || this.getVideoItem().getVideoSize().getHeight() == 0.0) {
            return;
        }
        switch (SVGACanvasDrawer$WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: {
                this.sharedContentTransform.postTranslate((float)(((double)canvas2.getWidth() - this.getVideoItem().getVideoSize().getWidth()) / 2.0), (float)(((double)canvas2.getHeight() - this.getVideoItem().getVideoSize().getHeight()) / 2.0));
                break;
            }
            case 2: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)canvas2.getWidth() / (float)canvas2.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.ratio = (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight());
                    this.ratioX = false;
                    this.sharedContentTransform.postScale((float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                    this.sharedContentTransform.postTranslate((float)(((double)canvas2.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight())) / 2.0), 0.0f);
                    break;
                }
                this.ratio = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth());
                this.ratioX = true;
                this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                this.sharedContentTransform.postTranslate(0.0f, (float)(((double)canvas2.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth())) / 2.0));
                break;
            }
            case 3: {
                float canvasRatio;
                if (this.getVideoItem().getVideoSize().getWidth() < (double)canvas2.getWidth() && this.getVideoItem().getVideoSize().getHeight() < (double)canvas2.getHeight()) {
                    this.sharedContentTransform.postTranslate((float)(((double)canvas2.getWidth() - this.getVideoItem().getVideoSize().getWidth()) / 2.0), (float)(((double)canvas2.getHeight() - this.getVideoItem().getVideoSize().getHeight()) / 2.0));
                    break;
                }
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                if (videoRatio > (double)(canvasRatio = (float)canvas2.getWidth() / (float)canvas2.getHeight())) {
                    this.ratio = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth());
                    this.ratioX = true;
                    this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    this.sharedContentTransform.postTranslate(0.0f, (float)(((double)canvas2.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth())) / 2.0));
                    break;
                }
                this.ratio = (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight());
                this.ratioX = false;
                this.sharedContentTransform.postScale((float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.sharedContentTransform.postTranslate((float)(((double)canvas2.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight())) / 2.0), 0.0f);
                break;
            }
            case 4: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)canvas2.getWidth() / (float)canvas2.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.ratio = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth());
                    this.ratioX = true;
                    this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    this.sharedContentTransform.postTranslate(0.0f, (float)(((double)canvas2.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth())) / 2.0));
                    break;
                }
                this.ratio = (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight());
                this.ratioX = false;
                this.sharedContentTransform.postScale((float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.sharedContentTransform.postTranslate((float)(((double)canvas2.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight())) / 2.0), 0.0f);
                break;
            }
            case 5: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)canvas2.getWidth() / (float)canvas2.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.ratio = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth());
                    this.ratioX = true;
                    this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    break;
                }
                this.ratio = (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight());
                this.ratioX = false;
                this.sharedContentTransform.postScale((float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                break;
            }
            case 6: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)canvas2.getWidth() / (float)canvas2.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.ratio = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth());
                    this.ratioX = true;
                    this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    this.sharedContentTransform.postTranslate(0.0f, (float)((double)canvas2.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth())));
                    break;
                }
                this.ratio = (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight());
                this.ratioX = false;
                this.sharedContentTransform.postScale((float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.sharedContentTransform.postTranslate((float)((double)canvas2.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight())), 0.0f);
                break;
            }
            case 7: {
                this.ratio = Math.max((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.ratioX = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()) > (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight());
                this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                break;
            }
            default: {
                this.ratio = (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth());
                this.ratioX = true;
                this.sharedContentTransform.postScale((float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)canvas2.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
            }
        }
    }

    private final void drawSprite(SGVADrawer.SVGADrawerSprite sprite, ImageView.ScaleType scaleType) {
        this.drawImage(sprite, scaleType);
        this.drawShape(sprite, scaleType);
    }

    private final void drawImage(SGVADrawer.SVGADrawerSprite sprite, ImageView.ScaleType scaleType) {
        block4: {
            Map it;
            block7: {
                Canvas canvas;
                block5: {
                    SVGAPath sVGAPath;
                    block6: {
                        Canvas canvas2 = this.canvas;
                        if (canvas2 == null) {
                            return;
                        }
                        canvas = canvas2;
                        Map map = this.dynamicItem.getDynamicImage();
                        String string = sprite.getImageKey();
                        Map map2 = map;
                        if (map2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                        }
                        Bitmap bitmap = (Bitmap)map2.get(string);
                        if (bitmap == null) {
                            map = this.getVideoItem().getImages();
                            string = sprite.getImageKey();
                            Map map3 = map;
                            if (map3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                            }
                            bitmap = (Bitmap)map3.get(string);
                        }
                        if (bitmap == null) break block4;
                        it = map = bitmap;
                        this.sharedPaint.reset();
                        this.sharedContentTransform.reset();
                        this.sharedPaint.setAntiAlias(this.getVideoItem().getAntiAlias());
                        this.sharedPaint.setFilterBitmap(this.getVideoItem().getAntiAlias());
                        this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
                        this.performScaleType(scaleType);
                        this.sharedContentTransform.preConcat(sprite.getFrameEntity().getTransform());
                        if (sprite.getFrameEntity().getMaskPath() == null) break block5;
                        sVGAPath = sprite.getFrameEntity().getMaskPath();
                        if (sVGAPath != null) break block6;
                        break block4;
                    }
                    SVGAPath maskPath = sVGAPath;
                    canvas.save();
                    this.sharedPath.reset();
                    maskPath.buildPath(this.sharedPath);
                    this.sharedPath.transform(this.sharedContentTransform);
                    canvas.clipPath(this.sharedPath);
                    this.sharedContentTransform.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()));
                    canvas.drawBitmap((Bitmap)it, this.sharedContentTransform, this.sharedPaint);
                    canvas.restore();
                    break block7;
                }
                this.sharedContentTransform.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)it.getWidth()));
                canvas.drawBitmap((Bitmap)it, this.sharedContentTransform, this.sharedPaint);
            }
            this.drawText((Bitmap)it, sprite);
        }
    }

    private final void drawText(Bitmap drawingBitmap, SGVADrawer.SVGADrawerSprite sprite) {
        block8: {
            Canvas canvas = this.canvas;
            if (canvas == null) {
                return;
            }
            Canvas canvas2 = canvas;
            Object object = this.dynamicItem.getDynamicText();
            String string = sprite.getImageKey();
            Map map = object;
            if (map == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            String string2 = (String)map.get(string);
            if (string2 == null) break block8;
            Object drawingText = object = string2;
            Map map2 = this.dynamicItem.getDynamicTextPaint();
            String string3 = sprite.getImageKey();
            Map map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            TextPaint textPaint = (TextPaint)map3.get(string3);
            if (textPaint != null) {
                Map drawingTextPaint = map2 = textPaint;
                Bitmap textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas textCanvas = new Canvas(textBitmap);
                drawingTextPaint.setAntiAlias(true);
                Rect bounds = new Rect();
                drawingTextPaint.getTextBounds((String)drawingText, 0, ((String)drawingText).length(), bounds);
                double x = (double)(drawingBitmap.getWidth() - bounds.width()) / 2.0;
                int targetRectTop = 0;
                int targetRectBottom = drawingBitmap.getHeight();
                float y = ((float)(targetRectBottom + targetRectTop) - drawingTextPaint.getFontMetrics().bottom - drawingTextPaint.getFontMetrics().top) / (float)2;
                textCanvas.drawText((String)drawingText, (float)x, y, (Paint)drawingTextPaint);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    SVGAPath sVGAPath = sprite.getFrameEntity().getMaskPath();
                    if (sVGAPath == null) {
                    } else {
                        SVGAPath maskPath = sVGAPath;
                        canvas2.save();
                        canvas2.concat(this.sharedContentTransform);
                        canvas2.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                        BitmapShader bitmapShader = new BitmapShader(textBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                        this.sharedPaint.setShader((Shader)bitmapShader);
                        this.sharedPaint.setAntiAlias(true);
                        this.sharedPath.reset();
                        maskPath.buildPath(this.sharedPath);
                        canvas2.drawPath(this.sharedPath, this.sharedPaint);
                        canvas2.restore();
                    }
                } else {
                    canvas2.drawBitmap(textBitmap, this.sharedContentTransform, this.sharedPaint);
                }
            }
        }
    }

    private final void drawShape(SGVADrawer.SVGADrawerSprite sprite, ImageView.ScaleType scaleType) {
        Canvas canvas = this.canvas;
        if (canvas == null) {
            return;
        }
        Canvas canvas2 = canvas;
        this.sharedContentTransform.reset();
        this.performScaleType(scaleType);
        this.sharedContentTransform.preConcat(sprite.getFrameEntity().getTransform());
        Iterable $receiver$iv = sprite.getFrameEntity().getShapes();
        for (Object element$iv : $receiver$iv) {
            SVGAPath maskPath;
            SVGAPath sVGAPath;
            int n;
            int it;
            SVGAVideoShapeEntity shape = (SVGAVideoShapeEntity)element$iv;
            this.sharedPath.reset();
            shape.buildPath();
            if (shape.getShapePath() != null) {
                Path path;
                Path it2 = path;
                this.sharedPath.addPath(it2);
            }
            if (this.sharedPath.isEmpty()) continue;
            Matrix thisTransform = new Matrix();
            if (shape.getTransform() != null) {
                Matrix matrix;
                Matrix it3 = matrix;
                thisTransform.postConcat(it3);
            }
            thisTransform.postConcat(this.sharedContentTransform);
            this.sharedPath.transform(thisTransform);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null && (it = (n = styles.getFill())) != 0) {
                this.sharedPaint.reset();
                this.sharedPaint.setColor(it);
                this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
                this.sharedPaint.setAntiAlias(true);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas2.save();
                }
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    maskPath = sVGAPath;
                    this.sharedPath2.reset();
                    maskPath.buildPath(this.sharedPath2);
                    this.sharedPath2.transform(this.sharedContentTransform);
                    canvas2.clipPath(this.sharedPath2);
                }
                canvas2.drawPath(this.sharedPath, this.sharedPaint);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    canvas2.restore();
                }
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 == null) continue;
            float f = styles2.getStrokeWidth();
            float it2 = f;
            if (!(it2 > 0.0f)) continue;
            this.sharedPaint.reset();
            this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            this.resetShapeStrokePaint(shape);
            if (sprite.getFrameEntity().getMaskPath() != null) {
                canvas2.save();
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                maskPath = sVGAPath;
                this.sharedPath2.reset();
                maskPath.buildPath(this.sharedPath2);
                this.sharedPath2.transform(this.sharedContentTransform);
                canvas2.clipPath(this.sharedPath2);
            }
            canvas2.drawPath(this.sharedPath, this.sharedPaint);
            if (sprite.getFrameEntity().getMaskPath() == null) continue;
            canvas2.restore();
        }
    }

    private final float requestScale() {
        this.sharedContentTransform.getValues(this.tValues);
        if (this.tValues[0] == 0.0f) {
            return 0.0f;
        }
        double A = this.tValues[0];
        double D = this.tValues[4];
        double B = this.tValues[3];
        double C = this.tValues[1];
        if (A * D == B * C) {
            return 0.0f;
        }
        double scaleX = Math.sqrt(A * A + B * B);
        double skew = (A /= scaleX) * C + (B /= scaleX) * D;
        double scaleY = Math.sqrt((C -= A * skew) * C + (D -= B * skew) * D);
        C /= scaleY;
        D /= scaleY;
        skew /= scaleY;
        if (A * D < B * C) {
            scaleX = -scaleX;
        }
        return this.ratioX ? this.ratio / Math.abs((float)scaleX) : this.ratio / Math.abs((float)scaleY);
    }

    private final void resetShapeStrokePaint(SVGAVideoShapeEntity shape) {
        block16: {
            Object object;
            Object it;
            Object object2;
            Object object3;
            Object object4;
            this.sharedPaint.reset();
            this.sharedPaint.setAntiAlias(true);
            this.sharedPaint.setStyle(Paint.Style.STROKE);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null) {
                int n;
                int it2 = n = styles.getStroke();
                this.sharedPaint.setColor(it2);
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 != null) {
                float f;
                float it3 = f = styles2.getStrokeWidth();
                this.sharedPaint.setStrokeWidth(it3 * this.requestScale());
            }
            if ((object4 = shape.getStyles()) != null && (object4 = ((SVGAVideoShapeEntity.Styles)object4).getLineCap()) != null) {
                Object object5 = object4;
                Object it4 = object5;
                if (StringsKt.equals((String)it4, (String)"butt", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.BUTT);
                } else if (StringsKt.equals((String)it4, (String)"round", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.ROUND);
                } else if (StringsKt.equals((String)it4, (String)"square", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
            if ((object3 = shape.getStyles()) != null && (object3 = ((SVGAVideoShapeEntity.Styles)object3).getLineJoin()) != null) {
                Object object6 = object3;
                Object it5 = object6;
                if (StringsKt.equals((String)it5, (String)"miter", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.MITER);
                } else if (StringsKt.equals((String)it5, (String)"round", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.ROUND);
                } else if (StringsKt.equals((String)it5, (String)"bevel", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
            SVGAVideoShapeEntity.Styles styles3 = shape.getStyles();
            if (styles3 != null) {
                int n;
                int it6 = n = styles3.getMiterLimit();
                this.sharedPaint.setStrokeMiter((float)it6 * this.requestScale());
            }
            if ((object2 = shape.getStyles()) == null) break block16;
            float[] fArray = ((SVGAVideoShapeEntity.Styles)object2).getLineDash();
            object2 = fArray;
            if (fArray != null && ((Object)(it = (object = object2))).length == 3) {
                this.sharedPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{(it[0] < 1.0f ? 1.0f : (float)it[0]) * this.requestScale(), (it[1] < 0.1f ? 0.1f : (float)it[1]) * this.requestScale()}, (float)(it[2] * this.requestScale())));
            }
        }
    }

    @NotNull
    public final SVGADynamicEntity getDynamicItem() {
        return this.dynamicItem;
    }

    public SVGACanvasDrawer(@NotNull SVGAVideoEntity videoItem2, @NotNull SVGADynamicEntity dynamicItem) {
        Intrinsics.checkParameterIsNotNull((Object)videoItem2, (String)"videoItem");
        Intrinsics.checkParameterIsNotNull((Object)dynamicItem, (String)"dynamicItem");
        super(videoItem2);
        this.dynamicItem = dynamicItem;
        this.ratio = 1.0f;
        this.sharedPaint = new Paint();
        this.sharedPath = new Path();
        this.sharedPath2 = new Path();
        this.sharedContentTransform = new Matrix();
        this.tValues = new float[16];
    }
}

