/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Shader;
import android.text.TextPaint;
import android.widget.ImageView;
import com.opensource.svgaplayer.SGVADrawer;
import com.opensource.svgaplayer.SVGACanvasDrawer$WhenMappings;
import com.opensource.svgaplayer.SVGADynamicEntity;
import com.opensource.svgaplayer.SVGAPath;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.SVGAVideoShapeEntity;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u00020\u001c2\n\u0010\"\u001a\u00060#R\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010$\u001a\u00020\u001c2\n\u0010\"\u001a\u00060#R\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010%\u001a\u00020\u001c2\n\u0010\"\u001a\u00060#R\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\n\u0010\"\u001a\u00060#R\u00020\u0001H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006-"}, d2={"Lcom/opensource/svgaplayer/SVGACanvasDrawer;", "Lcom/opensource/svgaplayer/SGVADrawer;", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "dynamicItem", "Lcom/opensource/svgaplayer/SVGADynamicEntity;", "canvas", "Landroid/graphics/Canvas;", "(Lcom/opensource/svgaplayer/SVGAVideoEntity;Lcom/opensource/svgaplayer/SVGADynamicEntity;Landroid/graphics/Canvas;)V", "getCanvas", "()Landroid/graphics/Canvas;", "getDynamicItem", "()Lcom/opensource/svgaplayer/SVGADynamicEntity;", "sharedContentTransform", "Landroid/graphics/Matrix;", "getSharedContentTransform", "()Landroid/graphics/Matrix;", "sharedPaint", "Landroid/graphics/Paint;", "getSharedPaint", "()Landroid/graphics/Paint;", "sharedPath", "Landroid/graphics/Path;", "getSharedPath", "()Landroid/graphics/Path;", "sharedPath2", "getSharedPath2", "drawFrame", "", "frameIndex", "", "scaleType", "Landroid/widget/ImageView$ScaleType;", "drawImage", "sprite", "Lcom/opensource/svgaplayer/SGVADrawer$SVGADrawerSprite;", "drawShape", "drawSprite", "drawText", "drawingBitmap", "Landroid/graphics/Bitmap;", "performScaleType", "resetShapeStrokePaint", "shape", "Lcom/opensource/svgaplayer/SVGAVideoShapeEntity;", "library_release"})
public final class SVGACanvasDrawer
extends SGVADrawer {
    @NotNull
    private final Paint sharedPaint;
    @NotNull
    private final Path sharedPath;
    @NotNull
    private final Path sharedPath2;
    @NotNull
    private final Matrix sharedContentTransform;
    @NotNull
    private final SVGADynamicEntity dynamicItem;
    @NotNull
    private final Canvas canvas;

    @NotNull
    public final Paint getSharedPaint() {
        return this.sharedPaint;
    }

    @NotNull
    public final Path getSharedPath() {
        return this.sharedPath;
    }

    @NotNull
    public final Path getSharedPath2() {
        return this.sharedPath2;
    }

    @NotNull
    public final Matrix getSharedContentTransform() {
        return this.sharedContentTransform;
    }

    @Override
    public void drawFrame(int frameIndex, @NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        super.drawFrame(frameIndex, scaleType);
        List<SGVADrawer.SVGADrawerSprite> sprites = this.requestFrameSprites$library_release(frameIndex);
        Iterable $receiver$iv = sprites;
        for (Object element$iv : $receiver$iv) {
            SGVADrawer.SVGADrawerSprite it = (SGVADrawer.SVGADrawerSprite)element$iv;
            this.drawSprite(it, scaleType);
        }
    }

    private final void performScaleType(ImageView.ScaleType scaleType) {
        if (this.canvas.getWidth() == 0 || this.canvas.getHeight() == 0 || this.getVideoItem().getVideoSize().getWidth() == 0.0 || this.getVideoItem().getVideoSize().getHeight() == 0.0) {
            return;
        }
        switch (SVGACanvasDrawer$WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: {
                this.sharedContentTransform.postTranslate((float)(((double)this.canvas.getWidth() - this.getVideoItem().getVideoSize().getWidth()) / 2.0), (float)(((double)this.canvas.getHeight() - this.getVideoItem().getVideoSize().getHeight()) / 2.0));
                break;
            }
            case 2: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)this.canvas.getWidth() / (float)this.canvas.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.sharedContentTransform.postScale((float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                    this.sharedContentTransform.postTranslate((float)(((double)this.canvas.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight())) / 2.0), 0.0f);
                    break;
                }
                this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                this.sharedContentTransform.postTranslate(0.0f, (float)(((double)this.canvas.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth())) / 2.0));
                break;
            }
            case 3: {
                float canvasRatio;
                if (this.getVideoItem().getVideoSize().getWidth() < (double)this.canvas.getWidth() && this.getVideoItem().getVideoSize().getHeight() < (double)this.canvas.getHeight()) {
                    this.sharedContentTransform.postTranslate((float)(((double)this.canvas.getWidth() - this.getVideoItem().getVideoSize().getWidth()) / 2.0), (float)(((double)this.canvas.getHeight() - this.getVideoItem().getVideoSize().getHeight()) / 2.0));
                    break;
                }
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                if (videoRatio > (double)(canvasRatio = (float)this.canvas.getWidth() / (float)this.canvas.getHeight())) {
                    this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    this.sharedContentTransform.postTranslate(0.0f, (float)(((double)this.canvas.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth())) / 2.0));
                    break;
                }
                this.sharedContentTransform.postScale((float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.sharedContentTransform.postTranslate((float)(((double)this.canvas.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight())) / 2.0), 0.0f);
                break;
            }
            case 4: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)this.canvas.getWidth() / (float)this.canvas.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    this.sharedContentTransform.postTranslate(0.0f, (float)(((double)this.canvas.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth())) / 2.0));
                    break;
                }
                this.sharedContentTransform.postScale((float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.sharedContentTransform.postTranslate((float)(((double)this.canvas.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight())) / 2.0), 0.0f);
                break;
            }
            case 5: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)this.canvas.getWidth() / (float)this.canvas.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    break;
                }
                this.sharedContentTransform.postScale((float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                break;
            }
            case 6: {
                double videoRatio = this.getVideoItem().getVideoSize().getWidth() / this.getVideoItem().getVideoSize().getHeight();
                float canvasRatio = (float)this.canvas.getWidth() / (float)this.canvas.getHeight();
                if (videoRatio > (double)canvasRatio) {
                    this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
                    this.sharedContentTransform.postTranslate(0.0f, (float)((double)this.canvas.getHeight() - this.getVideoItem().getVideoSize().getHeight() * ((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth())));
                    break;
                }
                this.sharedContentTransform.postScale((float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()), (float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                this.sharedContentTransform.postTranslate((float)((double)this.canvas.getWidth() - this.getVideoItem().getVideoSize().getWidth() * ((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight())), 0.0f);
                break;
            }
            case 7: {
                this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getHeight() / this.getVideoItem().getVideoSize().getHeight()));
                break;
            }
            default: {
                this.sharedContentTransform.postScale((float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()), (float)((double)this.canvas.getWidth() / this.getVideoItem().getVideoSize().getWidth()));
            }
        }
    }

    private final void drawSprite(SGVADrawer.SVGADrawerSprite sprite, ImageView.ScaleType scaleType) {
        this.drawImage(sprite, scaleType);
        this.drawShape(sprite, scaleType);
    }

    private final void drawImage(SGVADrawer.SVGADrawerSprite sprite, ImageView.ScaleType scaleType) {
        block3: {
            Bitmap drawingBitmap;
            block6: {
                block4: {
                    SVGAPath sVGAPath;
                    block5: {
                        Bitmap it;
                        Map map = this.dynamicItem.getDynamicImage();
                        String string = sprite.getImageKey();
                        Map map2 = map;
                        if (map2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                        }
                        Bitmap bitmap = (Bitmap)map2.get(string);
                        if (bitmap == null) {
                            map = this.getVideoItem().getImages();
                            string = sprite.getImageKey();
                            Map map3 = map;
                            if (map3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                            }
                            bitmap = (Bitmap)map3.get(string);
                        }
                        if (bitmap == null) break block3;
                        map = bitmap;
                        drawingBitmap = it = (Bitmap)map;
                        this.sharedPaint.reset();
                        this.sharedContentTransform.reset();
                        this.sharedPaint.setAntiAlias(this.getVideoItem().getAntiAlias());
                        this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
                        this.performScaleType(scaleType);
                        this.sharedContentTransform.preConcat(sprite.getFrameEntity().getTransform());
                        this.sharedContentTransform.preScale((float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()), (float)(sprite.getFrameEntity().getLayout().getWidth() / (double)drawingBitmap.getWidth()));
                        if (sprite.getFrameEntity().getMaskPath() == null) break block4;
                        sVGAPath = sprite.getFrameEntity().getMaskPath();
                        if (sVGAPath != null) break block5;
                        break block3;
                    }
                    SVGAPath maskPath = sVGAPath;
                    this.canvas.save();
                    this.canvas.concat(this.sharedContentTransform);
                    this.canvas.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                    BitmapShader bitmapShader = new BitmapShader(drawingBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    this.sharedPaint.setShader((Shader)bitmapShader);
                    this.sharedPaint.setAntiAlias(true);
                    this.sharedPath.reset();
                    maskPath.buildPath(this.sharedPath);
                    this.canvas.drawPath(this.sharedPath, this.sharedPaint);
                    this.canvas.restore();
                    break block6;
                }
                this.canvas.drawBitmap(drawingBitmap, this.sharedContentTransform, this.sharedPaint);
            }
            this.drawText(drawingBitmap, sprite);
        }
    }

    private final void drawText(Bitmap drawingBitmap, SGVADrawer.SVGADrawerSprite sprite) {
        block8: {
            Unit unit;
            String it;
            Object object = this.dynamicItem.getDynamicText();
            String string = sprite.getImageKey();
            Map map = object;
            if (map == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            String string2 = (String)map.get(string);
            if (string2 == null) break block8;
            object = string2;
            String drawingText = it = (String)object;
            Map map2 = this.dynamicItem.getDynamicTextPaint();
            String string3 = sprite.getImageKey();
            Map map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            TextPaint textPaint = (TextPaint)map3.get(string3);
            if (textPaint != null) {
                TextPaint it2;
                map2 = textPaint;
                TextPaint drawingTextPaint = it2 = (TextPaint)map2;
                Bitmap textBitmap = Bitmap.createBitmap((int)drawingBitmap.getWidth(), (int)drawingBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas textCanvas = new Canvas(textBitmap);
                drawingTextPaint.setAntiAlias(true);
                Rect bounds = new Rect();
                drawingTextPaint.getTextBounds(drawingText, 0, drawingText.length(), bounds);
                double x = (double)(drawingBitmap.getWidth() - bounds.width()) / 2.0;
                int targetRectTop = 0;
                int targetRectBottom = drawingBitmap.getHeight();
                float y = ((float)(targetRectBottom + targetRectTop) - drawingTextPaint.getFontMetrics().bottom - drawingTextPaint.getFontMetrics().top) / (float)2;
                textCanvas.drawText(drawingText, (float)x, y, (Paint)drawingTextPaint);
                if (sprite.getFrameEntity().getMaskPath() != null) {
                    SVGAPath sVGAPath = sprite.getFrameEntity().getMaskPath();
                    if (sVGAPath == null) {
                    } else {
                        SVGAPath maskPath = sVGAPath;
                        this.canvas.save();
                        this.canvas.concat(this.sharedContentTransform);
                        this.canvas.clipRect(0, 0, drawingBitmap.getWidth(), drawingBitmap.getHeight());
                        BitmapShader bitmapShader = new BitmapShader(textBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                        this.sharedPaint.setShader((Shader)bitmapShader);
                        this.sharedPaint.setAntiAlias(true);
                        this.sharedPath.reset();
                        maskPath.buildPath(this.sharedPath);
                        this.canvas.drawPath(this.sharedPath, this.sharedPaint);
                        this.canvas.restore();
                    }
                } else {
                    this.canvas.drawBitmap(textBitmap, this.sharedContentTransform, this.sharedPaint);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    private final void drawShape(SGVADrawer.SVGADrawerSprite sprite, ImageView.ScaleType scaleType) {
        this.sharedContentTransform.reset();
        this.performScaleType(scaleType);
        this.sharedContentTransform.preConcat(sprite.getFrameEntity().getTransform());
        Iterable $receiver$iv = sprite.getFrameEntity().getShapes();
        for (Object element$iv : $receiver$iv) {
            SVGAPath maskPath;
            SVGAPath sVGAPath;
            SVGAVideoShapeEntity shape = (SVGAVideoShapeEntity)element$iv;
            this.sharedPath.reset();
            if (shape.getShapePath() != null) {
                Path path;
                Path it = path;
                this.sharedPath.addPath(it);
            }
            if (this.sharedPath.isEmpty()) continue;
            Matrix thisTransform = new Matrix();
            if (shape.getTransform() != null) {
                Matrix matrix;
                Matrix it = matrix;
                thisTransform.postConcat(it);
            }
            thisTransform.postConcat(this.sharedContentTransform);
            this.sharedPath.transform(thisTransform);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null) {
                int n = styles.getFill();
                int it = n;
                if (it != 0) {
                    this.sharedPaint.reset();
                    this.sharedPaint.setColor(it);
                    this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
                    this.sharedPaint.setAntiAlias(true);
                    if (sprite.getFrameEntity().getMaskPath() != null) {
                        this.canvas.save();
                    }
                    if (sprite.getFrameEntity().getMaskPath() != null) {
                        maskPath = sVGAPath;
                        this.sharedPath2.reset();
                        maskPath.buildPath(this.sharedPath2);
                        this.sharedPath2.transform(this.sharedContentTransform);
                        this.canvas.clipPath(this.sharedPath2);
                    }
                    this.canvas.drawPath(this.sharedPath, this.sharedPaint);
                    if (sprite.getFrameEntity().getMaskPath() != null) {
                        this.canvas.restore();
                    }
                }
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 == null) continue;
            float f = styles2.getStrokeWidth();
            float it = f;
            if (!(it > 0.0f)) continue;
            this.sharedPaint.reset();
            this.sharedPaint.setAlpha((int)(sprite.getFrameEntity().getAlpha() * (double)255));
            this.resetShapeStrokePaint(shape);
            if (sprite.getFrameEntity().getMaskPath() != null) {
                this.canvas.save();
            }
            if (sprite.getFrameEntity().getMaskPath() != null) {
                maskPath = sVGAPath;
                this.sharedPath2.reset();
                maskPath.buildPath(this.sharedPath2);
                this.sharedPath2.transform(this.sharedContentTransform);
                this.canvas.clipPath(this.sharedPath2);
            }
            this.canvas.drawPath(this.sharedPath, this.sharedPaint);
            if (sprite.getFrameEntity().getMaskPath() == null) continue;
            this.canvas.restore();
        }
    }

    private final void resetShapeStrokePaint(SVGAVideoShapeEntity shape) {
        block17: {
            Object object;
            Object object2;
            Object object3;
            this.sharedPaint.reset();
            this.sharedPaint.setAntiAlias(true);
            this.sharedPaint.setStyle(Paint.Style.STROKE);
            SVGAVideoShapeEntity.Styles styles = shape.getStyles();
            if (styles != null) {
                int n;
                int it = n = styles.getStroke();
                this.sharedPaint.setColor(it);
            }
            SVGAVideoShapeEntity.Styles styles2 = shape.getStyles();
            if (styles2 != null) {
                float f;
                float it = f = styles2.getStrokeWidth();
                this.sharedPaint.setStrokeWidth(it);
            }
            if ((object3 = shape.getStyles()) != null && (object3 = ((SVGAVideoShapeEntity.Styles)object3).getLineCap()) != null) {
                Object object4 = object3;
                String it = (String)object4;
                if (StringsKt.equals((String)it, (String)"butt", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.BUTT);
                } else if (StringsKt.equals((String)it, (String)"round", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.ROUND);
                } else if (StringsKt.equals((String)it, (String)"square", (boolean)true)) {
                    this.sharedPaint.setStrokeCap(Paint.Cap.SQUARE);
                }
            }
            if ((object2 = shape.getStyles()) != null && (object2 = ((SVGAVideoShapeEntity.Styles)object2).getLineJoin()) != null) {
                Object object5 = object2;
                String it = (String)object5;
                if (StringsKt.equals((String)it, (String)"miter", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.MITER);
                } else if (StringsKt.equals((String)it, (String)"round", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.ROUND);
                } else if (StringsKt.equals((String)it, (String)"bevel", (boolean)true)) {
                    this.sharedPaint.setStrokeJoin(Paint.Join.BEVEL);
                }
            }
            SVGAVideoShapeEntity.Styles styles3 = shape.getStyles();
            if (styles3 != null) {
                int n;
                int it = n = styles3.getMiterLimit();
                this.sharedPaint.setStrokeMiter((float)it);
            }
            if ((object = shape.getStyles()) == null) break block17;
            float[] fArray = ((SVGAVideoShapeEntity.Styles)object).getLineDash();
            object = fArray;
            if (fArray != null) {
                Object object6 = object;
                float[] it = (float[])object6;
                if (it.length == 3) {
                    this.sharedPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{it[0] < 1.0f ? 1.0f : it[0], it[1] < 0.1f ? 0.1f : it[1]}, it[2]));
                }
            }
        }
    }

    @NotNull
    public final SVGADynamicEntity getDynamicItem() {
        return this.dynamicItem;
    }

    @NotNull
    public final Canvas getCanvas() {
        return this.canvas;
    }

    public SVGACanvasDrawer(@NotNull SVGAVideoEntity videoItem, @NotNull SVGADynamicEntity dynamicItem, @NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)videoItem, (String)"videoItem");
        Intrinsics.checkParameterIsNotNull((Object)dynamicItem, (String)"dynamicItem");
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super(videoItem);
        this.dynamicItem = dynamicItem;
        this.canvas = canvas;
        this.sharedPaint = new Paint();
        this.sharedPath = new Path();
        this.sharedPath2 = new Path();
        this.sharedContentTransform = new Matrix();
    }
}

