/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.app.Activity;
import android.content.Context;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGAParser$parse$7$$special$;
import com.opensource.svgaplayer.SVGAVideoEntity;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nJ \u0010\u000e\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/opensource/svgaplayer/SVGAParser;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "cacheDir", "Ljava/io/File;", "cacheKey", "", "url", "Ljava/net/URL;", "str", "parse", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "inputStream", "Ljava/io/InputStream;", "", "callback", "Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "assetsName", "unzip", "Companion", "ParseCompletion", "library_release"})
public final class SVGAParser {
    @NotNull
    private final Context context;
    private static int sharedLock;
    public static final Companion Companion;

    @Nullable
    public final SVGAVideoEntity parse(@NotNull String assetsName) {
        Intrinsics.checkParameterIsNotNull((Object)assetsName, (String)"assetsName");
        try {
            InputStream inputStream = this.context.getAssets().open(assetsName);
            if (inputStream != null) {
                InputStream inputStream2;
                InputStream it = inputStream2 = inputStream;
                return this.parse(it, this.cacheKey("file:///assets/" + assetsName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final void parse(@NotNull String assetsName, @NotNull ParseCompletion callback) {
        Intrinsics.checkParameterIsNotNull((Object)assetsName, (String)"assetsName");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        try {
            InputStream inputStream = this.context.getAssets().open(assetsName);
            if (inputStream != null) {
                InputStream inputStream2;
                InputStream it = inputStream2 = inputStream;
                this.parse(it, this.cacheKey("file:///assets/" + assetsName), callback);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public final SVGAVideoEntity parse(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            if (this.cacheDir(this.cacheKey(url)).exists()) {
                return this.parse(null, this.cacheKey(url));
            }
            URLConnection uRLConnection = url.openConnection();
            if (!(uRLConnection instanceof HttpURLConnection)) {
                uRLConnection = null;
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            if (httpURLConnection != null) {
                HttpURLConnection httpURLConnection2;
                HttpURLConnection it = httpURLConnection2 = httpURLConnection;
                it.setConnectTimeout(20000);
                it.setRequestMethod("GET");
                it.connect();
                return this.parse(it.getInputStream(), this.cacheKey(url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final void parse(@NotNull URL url, @NotNull ParseCompletion callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        new Thread(new Runnable(this, url, callback){
            final /* synthetic */ SVGAParser this$0;
            final /* synthetic */ URL $url;
            final /* synthetic */ ParseCompletion $callback;

            public final void run() {
                int BUFFER_SIZE = 4096;
                try {
                    if (SVGAParser.access$cacheDir(this.this$0, SVGAParser.access$cacheKey(this.this$0, this.$url)).exists()) {
                        this.this$0.parse(null, SVGAParser.access$cacheKey(this.this$0, this.$url), this.$callback);
                    } else {
                        URLConnection uRLConnection = this.$url.openConnection();
                        if (!(uRLConnection instanceof HttpURLConnection)) {
                            uRLConnection = null;
                        }
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        if (httpURLConnection != null) {
                            int count;
                            HttpURLConnection httpURLConnection2;
                            HttpURLConnection it = httpURLConnection2 = httpURLConnection;
                            it.setConnectTimeout(20000);
                            it.setRequestMethod("GET");
                            it.connect();
                            InputStream inputStream = it.getInputStream();
                            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                            byte[] buffer = new byte[BUFFER_SIZE];
                            while ((count = inputStream.read(buffer, 0, BUFFER_SIZE)) != -1) {
                                outputStream.write(buffer, 0, count);
                            }
                            this.this$0.parse(new ByteArrayInputStream(outputStream.toByteArray()), SVGAParser.access$cacheKey(this.this$0, this.$url), this.$callback);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.print(e);
                }
            }
            {
                this.this$0 = sVGAParser;
                this.$url = uRL;
                this.$callback = parseCompletion;
            }
        }).start();
    }

    @Nullable
    public final SVGAVideoEntity parse(@Nullable InputStream inputStream, @NotNull String cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        InputStream inputStream2 = inputStream;
        if (inputStream2 != null) {
            InputStream inputStream3;
            InputStream it = inputStream3 = inputStream2;
            if (!this.cacheDir(cacheKey).exists()) {
                this.unzip(it, cacheKey);
            }
        }
        File cacheDir = new File(this.context.getCacheDir().getAbsolutePath() + "/" + cacheKey + "/");
        File jsonFile = new File(cacheDir, "movie.spec");
        try {
            int size;
            FileInputStream $i$a$5$let;
            FileInputStream it;
            FileInputStream fileInputStream = it = ($i$a$5$let = new FileInputStream(jsonFile));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((size = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                byteArrayOutputStream.write(buffer, 0, size);
            }
            String string = byteArrayOutputStream.toString();
            if (string != null) {
                JSONObject jSONObject;
                String string2;
                String it2 = string2 = string;
                JSONObject it3 = jSONObject = new JSONObject(it2);
                fileInputStream.close();
                return new SVGAVideoEntity(it3, cacheDir);
            }
            Object v2 = null;
            throw null;
        }
        catch (Exception e) {
            cacheDir.delete();
            jsonFile.delete();
            return null;
        }
    }

    public final void parse(@Nullable InputStream inputStream, @NotNull String cacheKey, @NotNull ParseCompletion callback) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        new Thread(new Runnable(this, inputStream, cacheKey, callback){
            final /* synthetic */ SVGAParser this$0;
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ String $cacheKey;
            final /* synthetic */ ParseCompletion $callback;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Integer n = com.opensource.svgaplayer.SVGAParser$Companion.access$getSharedLock$p(SVGAParser.Companion);
                synchronized (n) {
                    SVGAVideoEntity videoItem = this.this$0.parse(this.$inputStream, this.$cacheKey);
                    new Thread(new Runnable(videoItem, this){
                        final /* synthetic */ SVGAVideoEntity $videoItem;
                        final /* synthetic */ parse.7 this$0;
                        {
                            this.$videoItem = sVGAVideoEntity;
                            this.this$0 = var2_2;
                        }

                        public final void run() {
                            if (this.$videoItem != null) {
                                Context context = this.this$0.this$0.getContext();
                                if (!(context instanceof Activity)) {
                                    context = null;
                                }
                                if ((Activity)context != null) {
                                    Context context2 = this.this$0.this$0.getContext();
                                    if (!(context2 instanceof Activity)) {
                                        context2 = null;
                                    }
                                    Activity activity = (Activity)context2;
                                    if (activity != null) {
                                        activity.runOnUiThread(new Runnable(this){
                                            final /* synthetic */ parse$7$$special$$inlined$synchronized$lambda$1 this$0;
                                            {
                                                this.this$0 = var1_1;
                                            }

                                            public final void run() {
                                                this.this$0.this$0.$callback.onComplete(this.this$0.$videoItem);
                                            }
                                        });
                                    }
                                } else {
                                    this.this$0.$callback.onComplete(this.$videoItem);
                                }
                            } else {
                                Context context = this.this$0.this$0.getContext();
                                if (!(context instanceof Activity)) {
                                    context = null;
                                }
                                if ((Activity)context != null) {
                                    Context context3 = this.this$0.this$0.getContext();
                                    if (!(context3 instanceof Activity)) {
                                        context3 = null;
                                    }
                                    Activity activity = (Activity)context3;
                                    if (activity != null) {
                                        activity.runOnUiThread(new Runnable(this){
                                            final /* synthetic */ parse$7$$special$$inlined$synchronized$lambda$1 this$0;
                                            {
                                                this.this$0 = var1_1;
                                            }

                                            public final void run() {
                                                this.this$0.this$0.$callback.onError();
                                            }
                                        });
                                    }
                                } else {
                                    this.this$0.$callback.onError();
                                }
                            }
                        }
                    }).start();
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = sVGAParser;
                this.$inputStream = inputStream;
                this.$cacheKey = string;
                this.$callback = parseCompletion;
            }
        }).start();
    }

    private final String cacheKey(String str) {
        Object object;
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string = str;
        Object object2 = "UTF-8";
        Object object3 = messageDigest;
        Charset charset = Charset.forName((String)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object2 = object = charset;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        ((MessageDigest)object3).update((byte[])object);
        byte[] digest = messageDigest.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%02x";
            Object[] objectArray = new Object[]{b};
            object3 = sb;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            ((StringBuffer)object3).append((String)object);
        }
        String string4 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sb.toString()");
        return string4;
    }

    private final String cacheKey(URL url) {
        String string = url.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
        return this.cacheKey(string);
    }

    private final File cacheDir(String cacheKey) {
        return new File(this.context.getCacheDir().getAbsolutePath() + "/" + cacheKey + "/");
    }

    private final void unzip(InputStream inputStream, String cacheKey) {
        try {
            File cacheDir = this.cacheDir(cacheKey);
            cacheDir.mkdirs();
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            while (zipInputStream.getNextEntry() != null) {
                int readBytes;
                ZipEntry zipItem;
                File file = new File(cacheDir, zipItem.getName());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] buff = new byte[2048];
                while ((readBytes = zipInputStream.read(buff)) > 0) {
                    fileOutputStream.write(buff, 0, readBytes);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public SVGAParser(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public static final /* synthetic */ File access$cacheDir(SVGAParser $this, @NotNull String cacheKey) {
        return $this.cacheDir(cacheKey);
    }

    @NotNull
    public static final /* synthetic */ String access$cacheKey(SVGAParser $this, @NotNull URL url) {
        return $this.cacheKey(url);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "", "onComplete", "", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "onError", "library_release"})
    public static interface ParseCompletion {
        public void onComplete(@NotNull SVGAVideoEntity var1);

        public void onError();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/opensource/svgaplayer/SVGAParser$Companion;", "", "()V", "sharedLock", "", "getSharedLock", "()I", "setSharedLock", "(I)V", "library_release"})
    public static final class Companion {
        private final int getSharedLock() {
            return sharedLock;
        }

        private final void setSharedLock(int n) {
            sharedLock = n;
        }

        private Companion() {
        }

        public static final /* synthetic */ int access$getSharedLock$p(Companion $this) {
            return $this.getSharedLock();
        }

        public static final /* synthetic */ void access$setSharedLock$p(Companion $this, int n) {
            $this.setSharedLock(n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

