/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Matrix;
import android.graphics.Path;
import android.text.TextUtils;
import com.opensource.svgaplayer.SVGAPath;
import com.opensource.svgaplayer.SVGARect;
import com.opensource.svgaplayer.SVGAVideoShapeEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SVGAVideoSpriteFrameEntity {
    double alpha = 0.0;
    SVGARect layout = new SVGARect();
    Matrix transform = new Matrix();
    Path maskPath = null;
    SVGAVideoShapeEntity[] shapes = new SVGAVideoShapeEntity[0];

    public SVGAVideoSpriteFrameEntity() {
    }

    SVGAVideoSpriteFrameEntity(JSONObject obj) throws JSONException {
        JSONArray shapes;
        String clipPath;
        JSONObject layoutJO;
        this.alpha = obj.optDouble("alpha", 0.0);
        JSONObject transformJO = obj.optJSONObject("transform");
        if (transformJO != null) {
            float[] arr = new float[9];
            double a = transformJO.getDouble("a");
            double b = transformJO.getDouble("b");
            double c = transformJO.getDouble("c");
            double d = transformJO.getDouble("d");
            double tx = transformJO.getDouble("tx");
            double ty = transformJO.getDouble("ty");
            arr[0] = (float)a;
            arr[1] = (float)c;
            arr[2] = (float)tx;
            arr[3] = (float)b;
            arr[4] = (float)d;
            arr[5] = (float)ty;
            arr[6] = 0.0f;
            arr[7] = 0.0f;
            arr[8] = 1.0f;
            this.transform.setValues(arr);
        }
        if ((layoutJO = obj.optJSONObject("layout")) != null) {
            double x = layoutJO.getDouble("x");
            double y = layoutJO.getDouble("y");
            double width = layoutJO.getDouble("width");
            double height = layoutJO.getDouble("height");
            this.layout = new SVGARect(x, y, width, height);
        }
        if (!TextUtils.isEmpty((CharSequence)(clipPath = obj.optString("clipPath")))) {
            SVGAPath path = new SVGAPath();
            path.setValues(clipPath);
            this.maskPath = path.getPath();
        }
        if ((shapes = obj.optJSONArray("shapes")) != null) {
            this.shapes = new SVGAVideoShapeEntity[shapes.length()];
            for (int i = 0; i < shapes.length(); ++i) {
                this.shapes[i] = shapes.optJSONObject(i) != null ? new SVGAVideoShapeEntity(shapes.optJSONObject(i)) : new SVGAVideoShapeEntity();
            }
        }
    }
}

