/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Color;
import android.graphics.Matrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SVGAVideoShapeEntity {
    Type type = Type.shape;
    Map<String, Object> args = new HashMap<String, Object>();
    Styles styles = new Styles();
    Matrix transform = new Matrix();

    SVGAVideoShapeEntity() {
    }

    SVGAVideoShapeEntity(JSONObject object) {
        this.fetchType(object);
        this.fetchArgs(object);
        this.fetchStyles(object);
        this.fetchTransform(object);
    }

    boolean isKeep() {
        return this.type == Type.keep;
    }

    void fetchType(JSONObject object) {
        String value = object.optString("type");
        if (value.equalsIgnoreCase("shape")) {
            this.type = Type.shape;
        } else if (value.equalsIgnoreCase("rect")) {
            this.type = Type.rect;
        } else if (value.equalsIgnoreCase("ellipse")) {
            this.type = Type.ellipse;
        } else if (value.equalsIgnoreCase("keep")) {
            this.type = Type.keep;
        }
    }

    void fetchArgs(JSONObject object) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        JSONObject values = object.optJSONObject("args");
        if (values != null) {
            Iterator keys = values.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    Object value = values.get(key);
                    args.put(key, value);
                }
                catch (JSONException e) {}
            }
            this.args = args;
        }
    }

    void fetchStyles(JSONObject object) {
        JSONObject values = object.optJSONObject("styles");
        if (values != null) {
            JSONArray strokeArr;
            JSONArray fillArr = values.optJSONArray("fill");
            if (fillArr != null && fillArr.length() == 4) {
                this.styles.fill = Color.argb((int)((int)(fillArr.optDouble(3) * 255.0)), (int)((int)(fillArr.optDouble(0) * 255.0)), (int)((int)(fillArr.optDouble(1) * 255.0)), (int)((int)(fillArr.optDouble(2) * 255.0)));
            }
            if ((strokeArr = values.optJSONArray("stroke")) != null && strokeArr.length() == 4) {
                this.styles.stroke = Color.argb((int)((int)(strokeArr.optDouble(3) * 255.0)), (int)((int)(strokeArr.optDouble(0) * 255.0)), (int)((int)(strokeArr.optDouble(1) * 255.0)), (int)((int)(strokeArr.optDouble(2) * 255.0)));
            }
            this.styles.strokeWidth = (float)values.optDouble("strokeWidth", 0.0);
            JSONObject trimObj = values.optJSONObject("trim");
            if (trimObj != null) {
                this.styles.trimStart = (float)trimObj.optDouble("start", 0.0);
                this.styles.trimEnd = (float)trimObj.optDouble("end", 1.0);
            }
            this.styles.lineCap = values.optString("lineCap", "butt");
            this.styles.lineJoin = values.optString("lineJoin", "miter");
            this.styles.miterLimit = values.optInt("miterLimit", 0);
            JSONArray lineDashArr = values.optJSONArray("lineDash");
            if (lineDashArr != null) {
                this.styles.lineDash = new float[lineDashArr.length()];
                for (int i = 0; i < lineDashArr.length(); ++i) {
                    this.styles.lineDash[i] = (float)lineDashArr.optDouble(i, 0.0);
                }
            }
        }
    }

    void fetchTransform(JSONObject object) {
        JSONObject obj = object.optJSONObject("transform");
        if (obj != null) {
            float[] arr = new float[9];
            double a = obj.optDouble("a", 1.0);
            double b = obj.optDouble("b", 0.0);
            double c = obj.optDouble("c", 0.0);
            double d = obj.optDouble("d", 1.0);
            double tx = obj.optDouble("tx", 0.0);
            double ty = obj.optDouble("ty", 0.0);
            arr[0] = (float)a;
            arr[1] = (float)c;
            arr[2] = (float)tx;
            arr[3] = (float)b;
            arr[4] = (float)d;
            arr[5] = (float)ty;
            arr[6] = 0.0f;
            arr[7] = 0.0f;
            arr[8] = 1.0f;
            this.transform.setValues(arr);
        }
    }

    class Styles {
        int fill = 0;
        int stroke = 0;
        float strokeWidth = 0.0f;
        float trimStart = 0.0f;
        float trimEnd = 1.0f;
        String lineCap = "butt";
        String lineJoin = "miter";
        int miterLimit = 0;
        float[] lineDash = new float[0];

        Styles() {
        }
    }

    static enum Type {
        shape,
        rect,
        ellipse,
        keep;

    }
}

