/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.util.Log;
import com.opensource.svgaplayer.SVGARect;
import com.opensource.svgaplayer.SVGAVideoSpriteEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SVGAVideoEntity {
    private static final String TAG = "SVGAVideoEntity";
    SVGARect videoSize = new SVGARect(0.0, 0.0, 0.0, 0.0);
    int FPS = 15;
    int frames;
    HashMap<String, String> imagePathMap;
    ArrayList<SVGAVideoSpriteEntity> sprites;
    File cacheDir;
    final HashMap<String, BitmapDrawable> images = new HashMap();

    public SVGAVideoEntity(JSONObject obj, File cacheDir) throws JSONException {
        this.cacheDir = cacheDir;
        this.sprites = new ArrayList();
        JSONObject movie = obj.getJSONObject("movie");
        int width = movie.getJSONObject("viewBox").getInt("width");
        int height = movie.getJSONObject("viewBox").getInt("height");
        this.videoSize = new SVGARect(0.0, 0.0, width, height);
        this.FPS = movie.getInt("fps");
        this.frames = movie.getInt("frames");
    }

    void resetImages(JSONObject obj) {
        try {
            JSONObject imgObjects = obj.getJSONObject("images");
            Iterator keys = imgObjects.keys();
            this.imagePathMap = new HashMap();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    String path = this.cacheDir.getAbsolutePath() + "/" + imgObjects.getString(key) + ".png";
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(Resources.getSystem(), path);
                    this.images.put(key, bitmapDrawable);
                    this.imagePathMap.put(key, path);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void resetSprites(JSONObject obj) {
        try {
            JSONArray spriteObjects = obj.getJSONArray("sprites");
            for (int i = 0; i < spriteObjects.length(); ++i) {
                try {
                    JSONObject spriteObject = spriteObjects.getJSONObject(i);
                    this.sprites.add(new SVGAVideoSpriteEntity(spriteObject));
                    continue;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"create SVGAVideoSpriteEntity failed.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"resetSprites failed.", (Throwable)e);
        }
    }
}

