/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.TextureView;
import com.opensource.svgaplayer.SVGADrawer;
import com.opensource.svgaplayer.SVGAPlayerCallback;
import com.opensource.svgaplayer.SVGAVideoEntity;
import java.util.HashMap;

public class SVGAPlayer
extends TextureView
implements TextureView.SurfaceTextureListener {
    public int loops = 0;
    public boolean clearsAfterStop = true;
    private static final String TAG = "SVGAPlayer";
    protected HashMap<String, BitmapDrawable> dynamicImages = new HashMap();
    protected HashMap<String, String> dynamicTexts = new HashMap();
    protected HashMap<String, TextPaint> dynamicTextPaints = new HashMap();
    protected SVGAPlayerCallback callback;
    protected boolean animating = false;
    protected Thread drawerThread;
    protected SVGADrawer drawer;
    protected SVGAVideoEntity videoItem;
    protected Object drawerLock = new Object();

    public SVGAPlayer(Context context) {
        super(context);
        this.init();
    }

    public SVGAPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SVGAPlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setCallback(SVGAPlayerCallback callback) {
        this.callback = callback;
    }

    public void setVideoItem(SVGAVideoEntity videoItem) {
        this.videoItem = videoItem;
    }

    public boolean startAnimation() {
        this.stopAnimation(true);
        this.animating = true;
        if (this.videoItem != null && this.drawer == null) {
            this.createDrawer();
            this.startDrawing();
            return true;
        }
        return false;
    }

    public void pauseAnimation() {
        if (this.drawer != null) {
            this.drawer.pause();
        }
    }

    public void stopAnimation() {
        this.stopAnimation(this.clearsAfterStop);
    }

    public void stopAnimation(boolean clear) {
        this.animating = false;
        this.stopDrawing(clear);
        if (null != this.callback) {
            this.callback.onPause(this);
        }
        this.releaseDrawer();
    }

    public void stepToFrame(int frame, boolean andPlay) {
        if (frame >= this.videoItem.frames || frame < 0) {
            return;
        }
        this.pauseAnimation();
        if (this.drawer != null) {
            this.drawer.currentFrame = frame;
            this.drawer.draw();
        }
        if (andPlay) {
            if (this.drawer != null) {
                this.drawer.restore();
            } else {
                this.startAnimation();
            }
        }
    }

    public void stepToPercentage(float percentage, boolean andPlay) {
        int frame = (int)((float)this.videoItem.frames * percentage);
        if (frame >= this.videoItem.frames && frame > 0) {
            frame = this.videoItem.frames - 1;
        }
        this.stepToFrame(frame, andPlay);
    }

    public void setDynamicImage(BitmapDrawable drawable, String forKey) {
        if (null != drawable) {
            this.dynamicImages.put(forKey, drawable);
        }
    }

    public void setDynamicText(String text, TextPaint textPaint, String forKey) {
        if (null != text) {
            this.dynamicTexts.put(forKey, text);
        }
        if (null != textPaint) {
            textPaint.setTextSize(textPaint.getTextSize() * this.getResources().getDisplayMetrics().scaledDensity);
            this.dynamicTextPaints.put(forKey, textPaint);
        }
    }

    public void clearDynamicObjects() {
        this.dynamicImages.clear();
        this.dynamicTexts.clear();
        this.dynamicTextPaints.clear();
    }

    private void init() {
        this.createDrawer();
        this.setSurfaceTextureListener(this);
        this.setBackgroundColor(0);
        this.setOpaque(false);
    }

    protected void createDrawer() {
        if (null == this.videoItem) {
            return;
        }
        this.drawer = new SVGADrawer();
        this.drawer.videoItem = this.videoItem;
        this.drawer.textureView = this;
        this.drawer.videoWidth = (int)((float)this.getWidth() / this.getResources().getDisplayMetrics().scaledDensity);
        this.drawer.scaledDensity = this.getResources().getDisplayMetrics().scaledDensity;
    }

    protected void releaseDrawer() {
        if (null != this.drawer) {
            this.drawer.videoItem = null;
            this.drawer = null;
        }
    }

    protected void startDrawing() {
        if (null != this.drawer) {
            this.drawerThread = new Thread(this.drawer);
            this.drawerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopDrawing(boolean clear) {
        Object object = SVGADrawer.mLock;
        synchronized (object) {
            if (null != this.drawerThread) {
                this.drawerThread.interrupt();
                this.drawerThread = null;
            }
            if (null != this.drawer) {
                if (null != this.drawer.currentCanvas) {
                    if (clear) {
                        this.drawer.currentCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    }
                    this.unlockCanvasAndPost(this.drawer.currentCanvas);
                    this.drawer.currentCanvas = null;
                } else {
                    Canvas canvas = this.lockCanvas();
                    if (canvas != null) {
                        if (clear) {
                            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                        }
                        this.unlockCanvasAndPost(canvas);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Object object = this.drawerLock;
        synchronized (object) {
            if (null != this.drawer) {
                this.drawer.videoWidth = (int)((float)this.getWidth() / this.getResources().getDisplayMetrics().scaledDensity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Object object = this.drawerLock;
        synchronized (object) {
            if (null != this.drawer) {
                this.drawer.videoWidth = (int)((float)this.getWidth() / this.getResources().getDisplayMetrics().scaledDensity);
                this.drawer.scaledDensity = this.getResources().getDisplayMetrics().scaledDensity;
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

