/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Path;
import com.opensource.svgaplayer.SVGAPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class SVGAPath
implements Serializable {
    private final transient Path mPath = new Path();
    private transient boolean mPathBuilt = false;
    String[] items;
    static final List<String> VALID_METHODS = Collections.unmodifiableList(Arrays.asList("M", "L", "H", "V", "C", "S", "Q", "R", "A", "Z", "m", "l", "h", "v", "c", "s", "q", "r", "a", "z"));

    public Path getPath() {
        if (!this.mPathBuilt) {
            this.buildPath();
        }
        return this.mPath;
    }

    void setValues(String values) {
        this.items = values.split("[,\\s+]");
    }

    void buildPath() {
        String currentMethod = "";
        ArrayList<SVGAPoint> args = new ArrayList<SVGAPoint>();
        String argLast = null;
        for (String item : this.items) {
            if (item.length() < 1) continue;
            String firstLetter = item.substring(0, 1);
            if (VALID_METHODS.contains(firstLetter)) {
                if (null != argLast) {
                    try {
                        args.add(new SVGAPoint(Float.valueOf(argLast).floatValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.operate(currentMethod, args);
                args.clear();
                currentMethod = firstLetter;
                argLast = item.substring(1);
                continue;
            }
            if (null != argLast && argLast.trim().length() > 0) {
                try {
                    args.add(new SVGAPoint(Float.valueOf(argLast).floatValue(), Float.valueOf(item).floatValue()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                argLast = null;
                continue;
            }
            argLast = item;
        }
        this.operate(currentMethod, args);
    }

    private void operate(String method, List<SVGAPoint> args) {
        SVGAPoint currentPoint = new SVGAPoint(0.0f, 0.0f);
        if (method.equals("M") && args.size() == 1) {
            this.mPath.moveTo(args.get((int)0).x, args.get((int)0).y);
            currentPoint = new SVGAPoint(args.get((int)0).x, args.get((int)0).y);
        } else if (method.equals("m") && args.size() == 1) {
            this.mPath.rMoveTo(args.get((int)0).x, args.get((int)0).y);
            currentPoint = new SVGAPoint(currentPoint.x + args.get((int)0).x, currentPoint.y + args.get((int)0).y);
        }
        if (method.equals("L") && args.size() == 1) {
            this.mPath.lineTo(args.get((int)0).x, args.get((int)0).y);
        } else if (method.equals("l") && args.size() == 1) {
            this.mPath.rLineTo(args.get((int)0).x, args.get((int)0).y);
        }
        if (method.equals("C") && args.size() == 3) {
            this.mPath.cubicTo(args.get((int)0).x, args.get((int)0).y, args.get((int)1).x, args.get((int)1).y, args.get((int)2).x, args.get((int)2).y);
        } else if (method.equals("c") && args.size() == 3) {
            this.mPath.rCubicTo(args.get((int)0).x, args.get((int)0).y, args.get((int)1).x, args.get((int)1).y, args.get((int)2).x, args.get((int)2).y);
        }
        if (method.equals("Q") && args.size() == 2) {
            this.mPath.quadTo(args.get((int)0).x, args.get((int)0).y, args.get((int)1).x, args.get((int)1).y);
        } else if (method.equals("q") && args.size() == 2) {
            this.mPath.rQuadTo(args.get((int)0).x, args.get((int)0).y, args.get((int)1).x, args.get((int)1).y);
        }
        if (method.equals("H") && args.size() == 1) {
            this.mPath.lineTo(args.get((int)0).val, currentPoint.y);
        } else if (method.equals("h") && args.size() == 1) {
            this.mPath.rLineTo(args.get((int)0).val, 0.0f);
        }
        if (method.equals("V") && args.size() == 1) {
            this.mPath.lineTo(currentPoint.x, args.get((int)0).val);
        } else if (method.equals("v") && args.size() == 1) {
            this.mPath.rLineTo(0.0f, args.get((int)0).val);
        }
        if (method.equals("Z") && args.size() == 1) {
            this.mPath.close();
        } else if (method.equals("z") && args.size() == 1) {
            this.mPath.close();
        }
    }
}

