/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.content.Context;
import com.opensource.svgaplayer.SVGAVideoEntity;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONObject;

public class SVGAParser {
    private Context mContext;

    public SVGAParser(Context context) {
        this.mContext = context;
    }

    public SVGAVideoEntity parse(URL url) throws Exception {
        if (this.cacheDir(this.cacheKey(url)).exists()) {
            return this.parse(null, this.cacheKey(url));
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(20000);
        conn.setRequestMethod("GET");
        conn.connect();
        return this.parse(conn.getInputStream(), this.cacheKey(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGAVideoEntity parse(InputStream inputStream, String cacheKey) throws Exception {
        if (!this.cacheDir(cacheKey).exists()) {
            this.unzip(inputStream, cacheKey);
        }
        File cacheDir = new File(this.mContext.getCacheDir().getAbsolutePath() + "/" + cacheKey + "/");
        File jsonFile = new File(cacheDir, "movie.spec");
        SVGAVideoEntity videoItem = null;
        try (FileInputStream fileInputStream = new FileInputStream(jsonFile);){
            int size;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((size = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                byteArrayOutputStream.write(buffer, 0, size);
            }
            String JSONString = byteArrayOutputStream.toString();
            JSONObject obj = new JSONObject(JSONString);
            videoItem = new SVGAVideoEntity(obj, cacheDir);
            videoItem.resetImages(obj);
            videoItem.resetSprites(obj);
        }
        return videoItem;
    }

    private String cacheKey(URL url) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(url.toString().getBytes("UTF-8"));
        byte[] digest = messageDigest.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private File cacheDir(String cacheKey) {
        return new File(this.mContext.getCacheDir().getAbsolutePath() + "/" + cacheKey + "/");
    }

    private void unzip(InputStream inputStream, String cacheKey) throws Exception {
        ZipEntry zipItem;
        File cacheDir = this.cacheDir(cacheKey);
        cacheDir.mkdirs();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
        while ((zipItem = zipInputStream.getNextEntry()) != null) {
            int readBytes;
            File file = new File(cacheDir, zipItem.getName());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] buff = new byte[2048];
            while ((readBytes = zipInputStream.read(buff)) > 0) {
                fileOutputStream.write(buff, 0, readBytes);
            }
            fileOutputStream.close();
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }
}

